/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import java.util.Iterator;
import org.eclipse.birt.report.model.api.AccessControlHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ElementFactory;
import org.eclipse.birt.report.model.api.FilterConditionHandle;
import org.eclipse.birt.report.model.api.OdaLevelAttributeHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.RuleHandle;
import org.eclipse.birt.report.model.api.ValueAccessControlHandle;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.OdaLevelAttribute;
import org.eclipse.birt.report.model.api.elements.structures.Rule;
import org.eclipse.birt.report.model.api.olap.DimensionHandle;
import org.eclipse.birt.report.model.api.olap.HierarchyHandle;
import org.eclipse.birt.report.model.api.olap.LevelHandle;
import org.eclipse.birt.report.model.api.olap.MeasureGroupHandle;
import org.eclipse.birt.report.model.api.olap.MeasureHandle;
import org.eclipse.birt.report.model.api.olap.OdaCubeHandle;
import org.eclipse.birt.report.model.api.olap.OdaHierarchyHandle;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class OdaCubeParseTest
extends BaseTestCase {
    private final String FILE_NAME = "OdaCubeParserTest.xml";

    public void testParser() throws Exception {
        this.openDesign("OdaCubeParserTest.xml");
        OdaCubeParseTest.assertNotNull((Object)this.designHandle);
        OdaCubeHandle cube = (OdaCubeHandle)this.designHandle.findCube("testCube");
        Iterator iter = cube.filtersIterator();
        FilterConditionHandle filterConditionHandle = (FilterConditionHandle)iter.next();
        OdaCubeParseTest.assertEquals((String)"filter expression", (String)filterConditionHandle.getExpr());
        Iterator iter1 = cube.accessControlsIterator();
        AccessControlHandle accessControl = (AccessControlHandle)iter1.next();
        OdaCubeParseTest.assertEquals((String)"cube user1; cube user2", (String)accessControl.getPropertyHandle("userNames").getStringValue());
        OdaCubeParseTest.assertEquals((String)"cube role1; cube role2", (String)accessControl.getPropertyHandle("roles").getStringValue());
        OdaCubeParseTest.assertEquals((String)"disallow", (String)accessControl.getPermission());
        PropertyHandle propHandle = cube.getPropertyHandle("dimensions");
        OdaCubeParseTest.assertEquals((int)1, (int)propHandle.getContentCount());
        OdaCubeParseTest.assertEquals((int)1, (int)cube.getContentCount("dimensions"));
        DimensionHandle dimension = (DimensionHandle)propHandle.getContent(0);
        OdaCubeParseTest.assertEquals((Object)dimension, (Object)cube.getContent("dimensions", 0));
        OdaCubeParseTest.assertEquals((String)"testDimension", (String)dimension.getName());
        OdaCubeParseTest.assertTrue((boolean)dimension.isTimeType());
        propHandle = dimension.getPropertyHandle("hierarchies");
        OdaCubeParseTest.assertEquals((int)1, (int)propHandle.getContentCount());
        OdaCubeParseTest.assertEquals((int)1, (int)dimension.getContentCount("hierarchies"));
        OdaHierarchyHandle hierarchy = (OdaHierarchyHandle)propHandle.getContent(0);
        OdaCubeParseTest.assertEquals((Object)hierarchy, (Object)dimension.getContent("hierarchies", 0));
        OdaCubeParseTest.assertEquals((Object)hierarchy, (Object)dimension.getDefaultHierarchy());
        OdaCubeParseTest.assertEquals((String)"testHierarchy", (String)hierarchy.getName());
        iter1 = hierarchy.accessControlsIterator();
        accessControl = (AccessControlHandle)iter1.next();
        OdaCubeParseTest.assertEquals((String)"hierarchy user1; hierarchy user2", (String)accessControl.getPropertyHandle("userNames").getStringValue());
        OdaCubeParseTest.assertEquals((String)"hierarchy role1; hierarchy role2", (String)accessControl.getPropertyHandle("roles").getStringValue());
        OdaCubeParseTest.assertEquals((String)"allow", (String)accessControl.getPermission());
        propHandle = cube.getPropertyHandle("dimensions");
        OdaCubeParseTest.assertEquals((int)1, (int)propHandle.getContentCount());
        OdaCubeParseTest.assertEquals((int)1, (int)cube.getContentCount("dimensions"));
        iter = hierarchy.filtersIterator();
        filterConditionHandle = (FilterConditionHandle)iter.next();
        OdaCubeParseTest.assertEquals((String)"filter expression", (String)filterConditionHandle.getExpr());
        propHandle = hierarchy.getPropertyHandle("levels");
        OdaCubeParseTest.assertEquals((int)1, (int)propHandle.getContentCount());
        OdaCubeParseTest.assertEquals((int)1, (int)hierarchy.getContentCount("levels"));
        LevelHandle level = (LevelHandle)propHandle.getContent(0);
        OdaCubeParseTest.assertEquals((Object)level, (Object)hierarchy.getContent("levels", 0));
        OdaCubeParseTest.assertEquals((String)"testLevel", (String)level.getName());
        OdaCubeParseTest.assertEquals((String)"integer", (String)level.getDataType());
        OdaCubeParseTest.assertEquals((String)"none", (String)level.getInterval());
        OdaCubeParseTest.assertEquals((double)3.0, (double)level.getIntervalRange(), (double)0.0);
        OdaCubeParseTest.assertEquals((String)"Jan", (String)level.getIntervalBase());
        OdaCubeParseTest.assertEquals((String)"dynamic", (String)level.getLevelType());
        OdaCubeParseTest.assertEquals((String)"2", (String)level.getDefaultValue());
        iter = level.staticValuesIterator();
        RuleHandle rule = (RuleHandle)iter.next();
        OdaCubeParseTest.assertEquals((String)"rule expression", (String)rule.getRuleExpression());
        OdaCubeParseTest.assertEquals((String)"display expression", (String)rule.getDisplayExpression());
        rule = (RuleHandle)iter.next();
        OdaCubeParseTest.assertEquals((String)"rule expression2", (String)rule.getRuleExpression());
        OdaCubeParseTest.assertEquals((String)"display expression2", (String)rule.getDisplayExpression());
        iter = level.attributesIterator();
        OdaLevelAttributeHandle attribute = (OdaLevelAttributeHandle)iter.next();
        OdaCubeParseTest.assertEquals((String)"var1", (String)attribute.getName());
        OdaCubeParseTest.assertEquals((String)"string", (String)attribute.getDataType());
        OdaCubeParseTest.assertEquals((String)"native var1", (String)attribute.getNativeName());
        OdaCubeParseTest.assertEquals((int)10, (int)attribute.getNativeDataType());
        attribute = (OdaLevelAttributeHandle)iter.next();
        OdaCubeParseTest.assertEquals((String)"var2", (String)attribute.getName());
        OdaCubeParseTest.assertEquals((String)"integer", (String)attribute.getDataType());
        OdaCubeParseTest.assertEquals((String)"native var2", (String)attribute.getNativeName());
        OdaCubeParseTest.assertEquals((int)2, (int)attribute.getNativeDataType());
        iter1 = level.valueAccessControlsIterator();
        ValueAccessControlHandle valueAccessControl = (ValueAccessControlHandle)iter1.next();
        OdaCubeParseTest.assertEquals((String)"level user1; level user2", (String)valueAccessControl.getPropertyHandle("userNames").getStringValue());
        OdaCubeParseTest.assertEquals((String)"level role1; level role2", (String)valueAccessControl.getPropertyHandle("roles").getStringValue());
        OdaCubeParseTest.assertEquals((String)"level value1; level value2", (String)valueAccessControl.getPropertyHandle("values").getStringValue());
        OdaCubeParseTest.assertEquals((String)"disallow", (String)valueAccessControl.getPermission());
        propHandle = cube.getPropertyHandle("measureGroups");
        OdaCubeParseTest.assertEquals((int)1, (int)propHandle.getContentCount());
        OdaCubeParseTest.assertEquals((int)1, (int)cube.getContentCount("measureGroups"));
        MeasureGroupHandle measureGroup = (MeasureGroupHandle)propHandle.getContent(0);
        OdaCubeParseTest.assertEquals((Object)measureGroup, (Object)cube.getContent("measureGroups", 0));
        OdaCubeParseTest.assertEquals((String)"testMeasureGroup", (String)measureGroup.getName());
        OdaCubeParseTest.assertEquals((Object)measureGroup, (Object)cube.getDefaultMeasureGroup());
        propHandle = measureGroup.getPropertyHandle("measures");
        MeasureHandle measure = (MeasureHandle)propHandle.getContent(0);
        OdaCubeParseTest.assertEquals((String)"testMeasure", (String)measure.getName());
        OdaCubeParseTest.assertEquals((String)"column", (String)measure.getMeasureExpression());
        OdaCubeParseTest.assertEquals((String)"min", (String)measure.getFunction());
        OdaCubeParseTest.assertFalse((boolean)measure.isCalculated());
    }

    public void testWriter() throws Exception {
        this.openDesign("OdaCubeParserTest.xml");
        OdaCubeParseTest.assertNotNull((Object)this.designHandle);
        String namePrix = "new";
        String valuePrix = "updated ";
        ElementFactory factory = this.designHandle.getElementFactory();
        OdaCubeHandle cube = (OdaCubeHandle)this.designHandle.findCube("testCube");
        cube.setName(String.valueOf(namePrix) + cube.getName());
        cube.setDefaultMeasureGroup((MeasureGroupHandle)factory.newOdaMeasureGroup("testDefaultMeasureGroup"));
        AccessControlHandle accessControl = (AccessControlHandle)cube.accessControlsIterator().next();
        accessControl.addUserName("new cube user1");
        accessControl.addUserName("new cube user2");
        accessControl.addRole("new cube role1");
        accessControl.addRole("new cube role2");
        accessControl.setPermission("allow");
        PropertyHandle propHandle = cube.getPropertyHandle("accessControls");
        accessControl = this.designHandle.getElementFactory().newAccessControl();
        propHandle.add((DesignElementHandle)accessControl);
        cube.add("dimensions", (DesignElementHandle)factory.newOdaDimension(null));
        DimensionHandle dimension = (DimensionHandle)cube.getContent("dimensions", 0);
        dimension.setName(String.valueOf(namePrix) + dimension.getName());
        dimension.setTimeType(false);
        dimension.setDefaultHierarchy((HierarchyHandle)factory.newOdaHierarchy("testDefaultHierarchy"));
        dimension.add("hierarchies", (DesignElementHandle)factory.newOdaHierarchy(null));
        OdaHierarchyHandle hierarchy = (OdaHierarchyHandle)dimension.getContent("hierarchies", 0);
        hierarchy.setName(String.valueOf(namePrix) + hierarchy.getName());
        accessControl = (AccessControlHandle)hierarchy.accessControlsIterator().next();
        accessControl.addUserName("new hierarchy user1");
        accessControl.addUserName("new hierarchy user2");
        accessControl.addRole("new hierarchy role1");
        accessControl.addRole("new hierarchy role2");
        accessControl.setPermission("disallow");
        propHandle = hierarchy.getPropertyHandle("accessControls");
        accessControl = this.designHandle.getElementFactory().newAccessControl();
        propHandle.add((DesignElementHandle)accessControl);
        hierarchy.add("levels", (DesignElementHandle)factory.newOdaLevel(dimension, null));
        LevelHandle level = (LevelHandle)hierarchy.getContent("levels", 0);
        level.setName(String.valueOf(namePrix) + level.getName());
        level.setDataType("string");
        level.setIntervalRange(5.0);
        level.setDefaultValue("10");
        level.setIntervalBase(String.valueOf(valuePrix) + level.getIntervalBase());
        level.setLevelType("mirrored");
        propHandle = level.getPropertyHandle("staticValues");
        propHandle.removeItem(0);
        Rule rule = new Rule();
        rule.setProperty("displayExpre", (Object)"new display expression");
        rule.setProperty("ruleExpre", (Object)"new rule expression");
        propHandle.insertItem((IStructure)rule, 0);
        propHandle = level.getPropertyHandle("attributes");
        propHandle.removeItem(propHandle.get(1));
        OdaLevelAttribute attribute = new OdaLevelAttribute();
        attribute.setName("var3");
        attribute.setDataType("boolean");
        attribute.setNativeDataType(new Integer(100));
        attribute.setNativeName("new native name 3");
        propHandle.insertItem((IStructure)attribute, 0);
        ValueAccessControlHandle valueAccess = (ValueAccessControlHandle)level.valueAccessControlsIterator().next();
        valueAccess.addUserName("new level user1");
        valueAccess.addUserName("new level user2");
        valueAccess.addRole("new level role1");
        valueAccess.addRole("new level role2");
        valueAccess.addValue("new level value1");
        valueAccess.addValue("new level value2");
        valueAccess.setPermission("allow");
        propHandle = level.getPropertyHandle("valueAccessControls");
        valueAccess = this.designHandle.getElementFactory().newValueAccessControl();
        propHandle.add((DesignElementHandle)valueAccess);
        cube.add("measureGroups", (DesignElementHandle)factory.newOdaMeasureGroup(null));
        MeasureGroupHandle measureGroup = (MeasureGroupHandle)cube.getContent("measureGroups", 0);
        measureGroup.setName(String.valueOf(namePrix) + measureGroup.getName());
        measureGroup.add("measures", (DesignElementHandle)factory.newOdaMeasure(null));
        MeasureHandle measure = (MeasureHandle)measureGroup.getContent("measures", 0);
        measure.setName(String.valueOf(namePrix) + measure.getName());
        measure.setMeasureExpression(String.valueOf(valuePrix) + measure.getMeasureExpression());
        measure.setFunction("count");
        measure.setCalculated(true);
        this.save();
        OdaCubeParseTest.assertTrue((boolean)this.compareFile("OdaCubeParserTest_golden.xml"));
    }
}

