/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.api.ActionHandle;
import org.eclipse.birt.report.model.api.ColumnHintHandle;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.FilterConditionHandle;
import org.eclipse.birt.report.model.api.ImageHandle;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.OdaDataSetParameterHandle;
import org.eclipse.birt.report.model.api.OdaDataSourceHandle;
import org.eclipse.birt.report.model.api.ParamBindingHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.core.UserPropertyDefn;
import org.eclipse.birt.report.model.api.elements.structures.Action;
import org.eclipse.birt.report.model.api.elements.structures.ColumnHint;
import org.eclipse.birt.report.model.api.elements.structures.ComputedColumn;
import org.eclipse.birt.report.model.api.elements.structures.FilterCondition;
import org.eclipse.birt.report.model.api.elements.structures.OdaDataSetParameter;
import org.eclipse.birt.report.model.api.elements.structures.ParamBinding;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.OdaDataSource;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.PropertyType;
import org.eclipse.birt.report.model.metadata.StructureDefn;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class OdaDataSetParseTest
extends BaseTestCase {
    String fileName = "OdaDataSetParseTest.xml";
    String goldenFileName = "OdaDataSetParseTest_golden.xml";
    String queryTextInputFileName = "OdaDataSetParseTest_1.xml";
    String queryTextGoldenFileName = "OdaDataSetQueryTextParseTest_golden.xml";
    String obsoleteFileName = "OdaDataSetParseTest_obsolete.xml";
    String obsoleteGoldenFileName = "OdaDataSetParseTest_obsolete_golden.xml";
    String queryTextInputFileName2 = "OdaDataSetParseTest_3.xml";
    String queryTextGoldenFileName2 = "OdaDataSetParseTest_golden_3.xml";
    String extendedPropertyInput = "OdaDataSetParseTest_4.xml";

    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testParserDesignFile() throws Exception {
        this.openDesign(this.fileName);
        this.parse();
        OdaDataSetHandle dataSet = (OdaDataSetHandle)this.designHandle.findDataSet("MyDataSet");
        OdaDataSetParseTest.assertNotNull((Object)dataSet);
        ElementPropertyDefn propDefn = (ElementPropertyDefn)dataSet.getPropertyDefn("resultSetHints");
        OdaDataSetParseTest.assertEquals((String)"OdaResultSetColumn", (String)propDefn.getStructDefn().getName());
        propDefn = (ElementPropertyDefn)dataSet.getPropertyDefn("parameters");
        OdaDataSetParseTest.assertEquals((String)"OdaDataSetParam", (String)propDefn.getStructDefn().getName());
        OdaDataSetParseTest.assertEquals((String)"1.1", (String)dataSet.getDesigerStateVersion());
        OdaDataSetParseTest.assertEquals((String)"content as string", (String)dataSet.getDesigerStateContentAsString());
        OdaDataSetParseTest.assertEquals((String)"content as blob", (String)new String(dataSet.getDesigerStateContentAsBlob(), "8859_1"));
    }

    public void testWriterDesignFile() throws Exception {
        this.openDesign(this.fileName);
        this.write();
        OdaDataSetHandle dataSet = (OdaDataSetHandle)this.designHandle.findDataSet("MyDataSet");
        OdaDataSetParseTest.assertNotNull((Object)dataSet);
        dataSet.setDesigerStateVersion("2.1");
        dataSet.setDesigerStateContentAsString("new content as string");
        String strBlob = "new content as blob";
        dataSet.setDesigerStateContentAsBlob(strBlob.getBytes("8859_1"));
        dataSet.setDataSetRowLimit(888);
        OdaDataSetParseTest.assertEquals((int)888, (int)dataSet.getDataSetRowLimit());
        UserPropertyDefn prop = new UserPropertyDefn();
        prop.setName("hello");
        PropertyType typeDefn = MetaDataDictionary.getInstance().getPropertyType("string");
        prop.setType(typeDefn);
        dataSet.addUserPropertyDefn(prop);
        this.save();
        OdaDataSetParseTest.assertTrue((boolean)this.compareFile(this.goldenFileName));
    }

    public void testReadWriteObsoleteDesignFile() throws Exception {
        this.openDesign(this.obsoleteFileName);
        this.write();
        this.save();
        OdaDataSetParseTest.assertTrue((boolean)this.compareFile(this.obsoleteGoldenFileName));
    }

    private void parse() throws Exception {
        this.openDesign(this.fileName);
        OdaDataSourceHandle dataSource = (OdaDataSourceHandle)this.designHandle.findDataSource("extendedDataSource");
        OdaDataSetParseTest.assertNotNull((Object)dataSource);
        OdaDataSetHandle dataSet = (OdaDataSetHandle)this.designHandle.findDataSet("MyDataSet");
        OdaDataSetParseTest.assertNotNull((Object)dataSet);
        OdaDataSetParseTest.assertEquals((String)"select * from user", (String)dataSet.getQueryText());
        OdaDataSetParseTest.assertEquals((String)"userid", (String)dataSet.getResultSetName());
        OdaDataSetParseTest.assertEquals((int)2, (int)dataSet.getResultSetNumber());
        OdaDataSetParseTest.assertEquals((Object)dataSource, (Object)dataSet.getDataSource());
        List parameters = (List)dataSet.getProperty("parameters");
        OdaDataSetParseTest.assertEquals((int)5, (int)parameters.size());
        int i = 0;
        OdaDataSetParameter parameter = (OdaDataSetParameter)parameters.get(i++);
        OdaDataSetParseTest.assertEquals((int)1, (int)parameter.getPosition());
        OdaDataSetParseTest.assertEquals((String)"name", (String)parameter.getName());
        OdaDataSetParseTest.assertEquals((String)"string", (String)parameter.getDataType());
        OdaDataSetParseTest.assertTrue((boolean)parameter.isOptional());
        OdaDataSetParseTest.assertEquals((String)"default value 1", (String)parameter.getDefaultValue());
        OdaDataSetParseTest.assertEquals((boolean)true, (boolean)parameter.allowNull());
        OdaDataSetParseTest.assertEquals((int)-100, (int)parameter.getNativeDataType());
        parameter = (OdaDataSetParameter)parameters.get(i++);
        OdaDataSetParseTest.assertEquals((int)2, (int)parameter.getPosition());
        OdaDataSetParseTest.assertEquals((String)"date", (String)parameter.getName());
        OdaDataSetParseTest.assertEquals((String)"date-time", (String)parameter.getDataType());
        OdaDataSetParseTest.assertFalse((boolean)parameter.isOptional());
        parameter = (OdaDataSetParameter)parameters.get(i++);
        OdaDataSetParseTest.assertEquals((int)3, (int)parameter.getPosition());
        OdaDataSetParseTest.assertEquals((String)"id", (String)parameter.getName());
        OdaDataSetParseTest.assertEquals((String)"integer", (String)parameter.getDataType());
        OdaDataSetParseTest.assertTrue((boolean)parameter.isOptional());
        parameter = (OdaDataSetParameter)parameters.get(i++);
        OdaDataSetParseTest.assertEquals((String)"birth", (String)parameter.getName());
        OdaDataSetParseTest.assertEquals((String)"date-time", (String)parameter.getDataType());
        parameter = (OdaDataSetParameter)parameters.get(i++);
        OdaDataSetParseTest.assertEquals((String)"title", (String)parameter.getName());
        OdaDataSetParseTest.assertEquals((String)"string", (String)parameter.getDataType());
        List bindings = (List)dataSet.getProperty("paramBindings");
        OdaDataSetParseTest.assertEquals((int)2, (int)bindings.size());
        i = 0;
        ParamBinding binding = (ParamBinding)bindings.get(i++);
        OdaDataSetParseTest.assertEquals((String)"param1", (String)binding.getParamName());
        OdaDataSetParseTest.assertEquals((String)"value1", (String)binding.getExpression());
        binding = (ParamBinding)bindings.get(i++);
        OdaDataSetParseTest.assertEquals((String)"param2", (String)binding.getParamName());
        OdaDataSetParseTest.assertEquals((String)"value2", (String)binding.getExpression());
        List columns = (List)dataSet.getProperty("computedColumns");
        OdaDataSetParseTest.assertEquals((int)3, (int)columns.size());
        i = 0;
        ComputedColumn computedColumn = (ComputedColumn)columns.get(i++);
        OdaDataSetParseTest.assertEquals((String)"column1", (String)computedColumn.getName());
        OdaDataSetParseTest.assertEquals((String)"expression1", (String)computedColumn.getExpression());
        OdaDataSetParseTest.assertEquals((String)"integer", (String)computedColumn.getDataType());
        computedColumn = (ComputedColumn)columns.get(i++);
        OdaDataSetParseTest.assertEquals((String)"column2", (String)computedColumn.getName());
        OdaDataSetParseTest.assertEquals((String)"expression2", (String)computedColumn.getExpression());
        OdaDataSetParseTest.assertEquals((String)"date-time", (String)computedColumn.getDataType());
        computedColumn = (ComputedColumn)columns.get(i++);
        OdaDataSetParseTest.assertEquals((String)"column3", (String)computedColumn.getName());
        OdaDataSetParseTest.assertEquals((String)"expression3", (String)computedColumn.getExpression());
        List columnHints = (List)dataSet.getProperty("columnHints");
        OdaDataSetParseTest.assertEquals((int)1, (int)columnHints.size());
        i = 0;
        ColumnHint columnHint = (ColumnHint)columnHints.get(i++);
        PropertyDefn member = (PropertyDefn)columnHint.getDefn().getMember("columnName");
        OdaDataSetParseTest.assertEquals((Object)"username", (Object)columnHint.getProperty((Module)this.design, member));
        member = (PropertyDefn)columnHint.getDefn().getMember("alias");
        OdaDataSetParseTest.assertEquals((Object)"userid", (Object)columnHint.getProperty((Module)this.design, member));
        member = (PropertyDefn)columnHint.getDefn().getMember("searching");
        OdaDataSetParseTest.assertEquals((Object)"none", (Object)columnHint.getProperty((Module)this.design, member));
        member = (PropertyDefn)columnHint.getDefn().getMember("export");
        OdaDataSetParseTest.assertEquals((Object)"always", (Object)columnHint.getProperty((Module)this.design, member));
        member = (PropertyDefn)columnHint.getDefn().getMember("analysis");
        OdaDataSetParseTest.assertEquals((Object)"dimension", (Object)columnHint.getProperty((Module)this.design, member));
        member = (PropertyDefn)columnHint.getDefn().getMember("parentLevel");
        OdaDataSetParseTest.assertEquals((Object)"4", (Object)columnHint.getProperty((Module)this.design, member));
        member = (PropertyDefn)columnHint.getDefn().getMember("format");
        OdaDataSetParseTest.assertEquals((Object)"##.###", (Object)columnHint.getProperty((Module)this.design, member));
        member = (PropertyDefn)columnHint.getDefn().getMember("displayNameID");
        OdaDataSetParseTest.assertEquals((Object)"message.column-hint.username", (Object)columnHint.getProperty((Module)this.design, member));
        member = (PropertyDefn)columnHint.getDefn().getMember("displayName");
        OdaDataSetParseTest.assertEquals((Object)"User Name", (Object)columnHint.getProperty((Module)this.design, member));
        member = (PropertyDefn)columnHint.getDefn().getMember("helpTextID");
        OdaDataSetParseTest.assertEquals((Object)"message.column-hint.help", (Object)columnHint.getProperty((Module)this.design, member));
        member = (PropertyDefn)columnHint.getDefn().getMember("helpText");
        OdaDataSetParseTest.assertEquals((Object)"Help me!", (Object)columnHint.getProperty((Module)this.design, member));
        ArrayList filters = (ArrayList)dataSet.getProperty("filter");
        OdaDataSetParseTest.assertEquals((int)1, (int)filters.size());
        OdaDataSetParseTest.assertEquals((String)"lt", (String)((FilterCondition)filters.get(0)).getOperator());
        OdaDataSetParseTest.assertEquals((String)"filter expression", (String)((FilterCondition)filters.get(0)).getExpr());
        OdaDataSetParseTest.assertEquals((String)"value1 expression", (String)((FilterCondition)filters.get(0)).getValue1());
        OdaDataSetParseTest.assertEquals((String)"value2 expression", (String)((FilterCondition)filters.get(0)).getValue2());
        dataSet = (OdaDataSetHandle)this.designHandle.findDataSet("SecondDataSet");
        OdaDataSetParseTest.assertNotNull((Object)dataSet);
        OdaDataSetParseTest.assertEquals(null, (String)dataSet.getQueryScript());
        OdaDataSetParseTest.assertEquals((int)1, (int)dataSet.getResultSetNumber());
    }

    private void write() throws Exception {
        OdaDataSourceHandle dataSource = (OdaDataSourceHandle)this.designHandle.findDataSource("extendedDataSource");
        OdaDataSetParseTest.assertNotNull((Object)dataSource);
        OdaDataSetHandle dataSet = (OdaDataSetHandle)this.designHandle.findDataSet("MyDataSet");
        OdaDataSetParseTest.assertNotNull((Object)dataSet);
        dataSet.setQueryText("new text");
        dataSet.setResultSetName("new result set");
        dataSet.setResultSetNumber(3);
        dataSet.setCachedRowCount(20);
        OdaDataSetParseTest.assertEquals((int)20, (int)dataSet.getCachedRowCount());
        List parameters = (List)dataSet.getProperty("parameters");
        OdaDataSetParseTest.assertEquals((int)5, (int)parameters.size());
        PropertyDefn posDefn = (PropertyDefn)dataSet.getElement().getPropertyDefn("parameters").getStructDefn().getMember("position");
        PropertyDefn nameDefn = (PropertyDefn)dataSet.getElement().getPropertyDefn("parameters").getStructDefn().getMember("name");
        PropertyDefn dataTypeDefn = (PropertyDefn)dataSet.getElement().getPropertyDefn("parameters").getStructDefn().getMember("dataType");
        int i = 0;
        OdaDataSetParameter parameter = (OdaDataSetParameter)parameters.get(i++);
        parameter.setProperty(posDefn, (Object)Integer.valueOf("91"));
        parameter.setProperty(nameDefn, (Object)"new name");
        parameter.setProperty(dataTypeDefn, (Object)"float");
        parameter.setIsOptional(false);
        parameter.setDefaultValue("new default value 1");
        parameter.setAllowNull(true);
        parameter.setNativeDataType(Integer.valueOf("22"));
        parameter = (OdaDataSetParameter)parameters.get(i++);
        parameter.setProperty(posDefn, (Object)Integer.valueOf("92"));
        parameter.setProperty(nameDefn, (Object)"new date");
        parameter.setIsOptional(false);
        parameter.setAllowNull(true);
        parameter = (OdaDataSetParameter)parameters.get(i++);
        parameter.setProperty(posDefn, (Object)Integer.valueOf("93"));
        parameter.setProperty(nameDefn, (Object)"new id");
        parameter.setProperty(dataTypeDefn, (Object)"decimal");
        parameter.setIsOptional(false);
        parameter = (OdaDataSetParameter)parameters.get(i++);
        parameter.setProperty(nameDefn, (Object)"new name");
        parameter.setProperty(dataTypeDefn, (Object)"float");
        parameter = (OdaDataSetParameter)parameters.get(i++);
        parameter.setProperty(nameDefn, (Object)"new date");
        parameter = new OdaDataSetParameter();
        parameter.setProperty(nameDefn, (Object)"new id");
        parameter.setProperty(dataTypeDefn, (Object)"decimal");
        parameter.setIsOutput(true);
        dataSet.getPropertyHandle("parameters").addItem((IStructure)parameter);
        nameDefn = (PropertyDefn)dataSet.getElement().getPropertyDefn("paramBindings").getStructDefn().getMember("paramName");
        PropertyDefn valueDefn = (PropertyDefn)dataSet.getElement().getPropertyDefn("paramBindings").getStructDefn().getMember("expression");
        List bindings = (List)dataSet.getProperty("paramBindings");
        OdaDataSetParseTest.assertEquals((int)2, (int)bindings.size());
        i = 0;
        ParamBinding binding = (ParamBinding)bindings.get(i++);
        binding.setProperty(nameDefn, (Object)"new param1");
        binding.setProperty(valueDefn, (Object)"new value1");
        binding = (ParamBinding)bindings.get(i++);
        binding.setProperty(nameDefn, (Object)"new param2");
        binding.setProperty(valueDefn, (Object)"new value2");
        posDefn = (PropertyDefn)dataSet.getElement().getPropertyDefn("resultSet").getStructDefn().getMember("position");
        nameDefn = (PropertyDefn)dataSet.getElement().getPropertyDefn("resultSet").getStructDefn().getMember("name");
        dataTypeDefn = (PropertyDefn)dataSet.getElement().getPropertyDefn("resultSet").getStructDefn().getMember("dataType");
        nameDefn = (PropertyDefn)dataSet.getElement().getPropertyDefn("computedColumns").getStructDefn().getMember("name");
        PropertyDefn expressionDefn = (PropertyDefn)dataSet.getElement().getPropertyDefn("computedColumns").getStructDefn().getMember("expression");
        List columns = (List)dataSet.getElement().getProperty((Module)this.design, "computedColumns");
        OdaDataSetParseTest.assertEquals((int)3, (int)columns.size());
        i = 0;
        ComputedColumn computedColumn = (ComputedColumn)columns.get(i++);
        computedColumn.setProperty(nameDefn, (Object)"new column1");
        computedColumn.setProperty(expressionDefn, (Object)"new expression 1");
        computedColumn.setDataType("decimal");
        computedColumn = (ComputedColumn)columns.get(i++);
        computedColumn.setProperty(nameDefn, (Object)"new column2");
        computedColumn.setProperty(expressionDefn, (Object)"new expression 2");
        computedColumn.setDataType(null);
        computedColumn = (ComputedColumn)columns.get(i++);
        computedColumn.setProperty(nameDefn, (Object)"new column3");
        computedColumn.setProperty(expressionDefn, (Object)"new expression 3");
        List columnHints = (List)dataSet.getProperty("columnHints");
        OdaDataSetParseTest.assertEquals((int)1, (int)columnHints.size());
        i = 0;
        ColumnHint columnHint = (ColumnHint)columnHints.get(i++);
        StructureDefn structureDefn = (StructureDefn)dataSet.getElement().getPropertyDefn("columnHints").getStructDefn();
        columnHint.setProperty((PropertyDefn)structureDefn.getMember("columnName"), (Object)"new username");
        columnHint.setProperty((PropertyDefn)structureDefn.getMember("alias"), (Object)"new userid");
        columnHint.setProperty((PropertyDefn)structureDefn.getMember("searching"), (Object)"indexed");
        columnHint.setProperty((PropertyDefn)structureDefn.getMember("export"), (Object)"if-realized");
        columnHint.setProperty((PropertyDefn)structureDefn.getMember("analysis"), (Object)"detail");
        columnHint.setProperty((PropertyDefn)structureDefn.getMember("parentLevel"), (Object)"new level");
        columnHint.setProperty((PropertyDefn)structureDefn.getMember("format"), (Object)"new format");
        columnHint.setProperty((PropertyDefn)structureDefn.getMember("displayNameID"), (Object)"new display name id");
        columnHint.setProperty((PropertyDefn)structureDefn.getMember("displayName"), (Object)"new display name");
        columnHint.setProperty((PropertyDefn)structureDefn.getMember("helpTextID"), (Object)"new help text id");
        columnHint.setProperty((PropertyDefn)structureDefn.getMember("helpText"), (Object)"new help text");
    }

    public void testWriteEmptyQueryText() throws Exception {
        this.openDesign(this.queryTextInputFileName);
        OdaDataSetHandle odaHandle = (OdaDataSetHandle)this.designHandle.findDataSet("myDataSet2");
        OdaDataSetParseTest.assertEquals((String)"", (String)odaHandle.getQueryText());
        odaHandle = (OdaDataSetHandle)this.designHandle.findDataSet("myDataSet3");
        OdaDataSetParseTest.assertEquals((String)"  ", (String)odaHandle.getQueryText());
        this.save();
        OdaDataSetParseTest.assertTrue((boolean)this.compareFile(this.queryTextGoldenFileName));
    }

    public void testProperties() throws Exception {
        OdaDataSetHandle dataSet = this.getDataSet();
        OdaDataSetHandle emptyDsHandle = (OdaDataSetHandle)this.designHandle.findDataSet("Data Set");
        OdaDataSetParseTest.assertEquals((int)0, (int)emptyDsHandle.getDataSetRowLimit());
        emptyDsHandle.setDataSetRowLimit(100);
        OdaDataSetParseTest.assertEquals((int)100, (int)emptyDsHandle.getDataSetRowLimit());
        emptyDsHandle.setQueryText(" ");
        OdaDataSetParseTest.assertEquals((String)" ", (String)emptyDsHandle.getQueryText());
        emptyDsHandle.setQueryText("");
        OdaDataSetParseTest.assertEquals((String)"", (String)emptyDsHandle.getQueryText());
        OdaDataSetParseTest.assertEquals((String)"myDataSource", (String)dataSet.getDataSource().getName());
        OdaDataSetParseTest.assertEquals((String)"myDataSource", (String)dataSet.getDataSourceName());
        OdaDataSetParseTest.assertEquals((String)"script_beforeopen", (String)dataSet.getBeforeOpen());
        OdaDataSetParseTest.assertEquals((String)"script_beforeclose", (String)dataSet.getBeforeClose());
        OdaDataSetParseTest.assertEquals((String)"script_onfetch", (String)dataSet.getOnFetch());
        OdaDataSetParseTest.assertEquals((String)"script_afteropen", (String)dataSet.getAfterOpen());
        OdaDataSetParseTest.assertEquals((String)"script_afterclose", (String)dataSet.getAfterClose());
        Iterator parameters = dataSet.parametersIterator();
        OdaDataSetParameterHandle parameter = (OdaDataSetParameterHandle)parameters.next();
        OdaDataSetParseTest.assertEquals((int)1, (int)parameter.getPosition());
        OdaDataSetParseTest.assertEquals((String)"name", (String)parameter.getName());
        OdaDataSetParseTest.assertEquals((String)"string", (String)parameter.getDataType());
        OdaDataSetParseTest.assertTrue((boolean)parameter.isOptional());
        OdaDataSetParseTest.assertEquals((String)"default value 1", (String)parameter.getDefaultValue());
        OdaDataSetParseTest.assertTrue((boolean)parameter.isInput());
        OdaDataSetParseTest.assertFalse((boolean)parameter.isOutput());
        parameter.setDefaultValue("new default value 1");
        OdaDataSetParseTest.assertEquals((String)"new default value 1", (String)parameter.getDefaultValue());
        OdaDataSetParseTest.assertTrue((boolean)parameters.hasNext());
        parameters.next();
        OdaDataSetParseTest.assertTrue((boolean)parameters.hasNext());
        parameters.next();
        OdaDataSetParseTest.assertTrue((boolean)parameters.hasNext());
        parameter = (OdaDataSetParameterHandle)parameters.next();
        OdaDataSetParseTest.assertEquals((String)"birth", (String)parameter.getName());
        OdaDataSetParseTest.assertEquals((String)"date-time", (String)parameter.getDataType());
        OdaDataSetParseTest.assertTrue((boolean)parameter.isOutput());
        parameter = (OdaDataSetParameterHandle)parameters.next();
        OdaDataSetParseTest.assertEquals((String)"title", (String)parameter.getName());
        OdaDataSetParseTest.assertEquals((String)"string", (String)parameter.getDataType());
        parameter = (OdaDataSetParameterHandle)parameters.next();
        OdaDataSetParseTest.assertEquals((String)"startdate", (String)parameter.getName());
        OdaDataSetParseTest.assertEquals((String)"date", (String)parameter.getDataType());
        parameter = (OdaDataSetParameterHandle)parameters.next();
        OdaDataSetParseTest.assertEquals((String)"enddate", (String)parameter.getName());
        OdaDataSetParseTest.assertEquals((String)"time", (String)parameter.getDataType());
        OdaDataSetParseTest.assertFalse((boolean)parameters.hasNext());
        Iterator bindings = dataSet.paramBindingsIterator();
        ParamBindingHandle binding = (ParamBindingHandle)bindings.next();
        OdaDataSetParseTest.assertEquals((String)"param1", (String)binding.getParamName());
        OdaDataSetParseTest.assertEquals((String)"value1", (String)binding.getExpression());
        OdaDataSetParseTest.assertNotNull(bindings.next());
        OdaDataSetParseTest.assertNull(bindings.next());
        List resultSetProps = dataSet.getListProperty("resultSet");
        OdaDataSetParseTest.assertNotNull((Object)resultSetProps);
        OdaDataSetParseTest.assertEquals((int)3, (int)resultSetProps.size());
        Iterator columns = dataSet.computedColumnsIterator();
        ComputedColumnHandle computedColumn = (ComputedColumnHandle)columns.next();
        OdaDataSetParseTest.assertEquals((String)"column1", (String)computedColumn.getName());
        OdaDataSetParseTest.assertEquals((String)"expression1", (String)computedColumn.getExpression());
        OdaDataSetParseTest.assertEquals((String)"integer", (String)computedColumn.getDataType());
        computedColumn = (ComputedColumnHandle)columns.next();
        OdaDataSetParseTest.assertEquals((String)"column2", (String)computedColumn.getName());
        OdaDataSetParseTest.assertEquals((String)"expression2", (String)computedColumn.getExpression());
        OdaDataSetParseTest.assertEquals((String)"date-time", (String)computedColumn.getDataType());
        computedColumn = (ComputedColumnHandle)columns.next();
        OdaDataSetParseTest.assertEquals((String)"column3", (String)computedColumn.getName());
        OdaDataSetParseTest.assertEquals((String)"expression3", (String)computedColumn.getExpression());
        Iterator columnHints = dataSet.columnHintsIterator();
        ColumnHintHandle columnHint = (ColumnHintHandle)columnHints.next();
        OdaDataSetParseTest.assertEquals((String)"username", (String)columnHint.getColumnName());
        OdaDataSetParseTest.assertEquals((String)"userid", (String)columnHint.getAlias());
        OdaDataSetParseTest.assertEquals((String)"none", (String)columnHint.getSearching());
        OdaDataSetParseTest.assertEquals((String)"always", (String)columnHint.getExport());
        OdaDataSetParseTest.assertEquals((String)"dimension", (String)columnHint.getAnalysis());
        OdaDataSetParseTest.assertEquals((String)"4", (String)columnHint.getParentLevel());
        OdaDataSetParseTest.assertEquals((String)"##.###", (String)columnHint.getFormat());
        OdaDataSetParseTest.assertEquals((String)"message.column-hint.username", (String)columnHint.getDisplayNameKey());
        OdaDataSetParseTest.assertEquals((String)"User Name", (String)columnHint.getDisplayName());
        OdaDataSetParseTest.assertEquals((String)"message.column-hint.help", (String)columnHint.getHelpTextKey());
        OdaDataSetParseTest.assertEquals((String)"Help me!", (String)columnHint.getHelpText());
        Iterator filters = dataSet.filtersIterator();
        FilterConditionHandle filterHandle = (FilterConditionHandle)filters.next();
        OdaDataSetParseTest.assertEquals((String)"lt", (String)filterHandle.getOperator());
        OdaDataSetParseTest.assertEquals((String)"filter expression", (String)filterHandle.getExpr());
        OdaDataSetParseTest.assertEquals((String)"value1 expression", (String)filterHandle.getValue1());
        OdaDataSetParseTest.assertEquals((String)"value2 expression", (String)filterHandle.getValue2());
        OdaDataSetParseTest.assertNull(filters.next());
        FilterCondition fc = StructureFactory.createFilterCond();
        fc.setExpr("new filter expr");
        fc.setOperator("is-false");
        dataSet.addFilter(fc);
        OdaDataSetParseTest.assertEquals((int)2, (int)dataSet.getListProperty("filter").size());
        dataSet.removeFilter(fc);
        OdaDataSetParseTest.assertEquals((int)1, (int)dataSet.getListProperty("filter").size());
        OdaDataSource dataSource2 = (OdaDataSource)this.design.findDataSource("myDataSource2");
        dataSet.setDataSource(dataSource2.getName());
        dataSet.setBeforeOpen("New before open");
        dataSet.setBeforeClose("New before close");
        dataSet.setAfterOpen("New after open");
        dataSet.setAfterClose("New after open");
        dataSet.setOnFetch("New on fetch");
        parameters = dataSet.parametersIterator();
        parameter = (OdaDataSetParameterHandle)parameters.next();
        parameter = (OdaDataSetParameterHandle)parameters.next();
        parameter.setPosition(Integer.valueOf("91"));
        parameter.setName("new name");
        parameter.setDataType("float");
        parameter.setIsOptional(false);
        parameter = (OdaDataSetParameterHandle)parameters.next();
        parameter.setName("new name");
        parameter.setDataType("float");
        parameter.setPosition(Integer.valueOf("91"));
        bindings = dataSet.paramBindingsIterator();
        binding = (ParamBindingHandle)bindings.next();
        binding.setParamName("new param1");
        binding.setExpression("new value1");
        binding = (ParamBindingHandle)bindings.next();
        binding.setParamName("new param2");
        binding.setParamName("new value2");
        columns = dataSet.computedColumnsIterator();
        computedColumn = (ComputedColumnHandle)columns.next();
        computedColumn.setName("new column1");
        computedColumn.setExpression("new expression 1");
        computedColumn.setDataType("decimal");
        computedColumn = (ComputedColumnHandle)columns.next();
        computedColumn.setName("new column2");
        computedColumn.setExpression("new expression 2");
        columnHints = dataSet.columnHintsIterator();
        columnHint = (ColumnHintHandle)columnHints.next();
        columnHint.setColumnName("new username");
        columnHint.setAlias("new userid");
        columnHint.setSearching("indexed");
        columnHint.setExport("if-realized");
        columnHint.setAnalysis("detail");
        columnHint.setParentLevel("new level");
        columnHint.setFormat("new format");
        columnHint.setDisplayNameKey("new display name id");
        columnHint.setDisplayName("new display name");
        columnHint.setHelpTextKey("new help text id");
        columnHint.setHelpText("new help text");
    }

    public void testDataSetParameterSynchronization() throws Exception {
        this.designHandle = this.createDesign();
        OdaDataSetHandle dataSetHandle = this.designHandle.getElementFactory().newOdaDataSet("DataSet");
        this.designHandle.getDataSets().add((DesignElementHandle)dataSetHandle);
        OdaDataSetParameter parameter = StructureFactory.createOdaDataSetParameter();
        parameter.setName("param1");
        PropertyHandle parameterHandle = dataSetHandle.getPropertyHandle("parameters");
        parameterHandle.addItem((IStructure)parameter);
        ParamBinding dataSetBinding = StructureFactory.createParamBinding();
        dataSetBinding.setParamName("param1");
        PropertyHandle dataSetBindingHandle = dataSetHandle.getPropertyHandle("paramBindings");
        dataSetBindingHandle.addItem((IStructure)dataSetBinding);
        TableHandle tableHandle = this.designHandle.getElementFactory().newTableItem("Table");
        this.designHandle.getBody().add((DesignElementHandle)tableHandle);
        tableHandle.setDataSet((DataSetHandle)dataSetHandle);
        ParamBinding tableBinding = StructureFactory.createParamBinding();
        tableBinding.setParamName("param1");
        PropertyHandle tableBindingHandle = tableHandle.getPropertyHandle("paramBindings");
        tableBindingHandle.addItem((IStructure)tableBinding);
        ImageHandle imageHandle = this.designHandle.getElementFactory().newImage("Image");
        this.designHandle.getBody().add((DesignElementHandle)imageHandle);
        imageHandle.setDataSet((DataSetHandle)dataSetHandle);
        Action action = StructureFactory.createAction();
        imageHandle.setAction(action);
        ActionHandle actionHandle = imageHandle.getActionHandle();
        ParamBinding actionBinding = StructureFactory.createParamBinding();
        actionBinding.setParamName("param1");
        actionHandle.addParamBinding(actionBinding);
        parameterHandle.getAt(0).setProperty("name", (Object)"param2");
        OdaDataSetParseTest.assertEquals((String)"param2", (String)dataSetBinding.getParamName());
        OdaDataSetParseTest.assertEquals((String)"param2", (String)tableBinding.getParamName());
        OdaDataSetParseTest.assertEquals((String)"param2", (String)actionBinding.getParamName());
        parameterHandle.removeItem(0);
        OdaDataSetParseTest.assertEquals((int)0, (int)dataSetBindingHandle.getListValue().size());
        OdaDataSetParseTest.assertEquals((int)0, (int)tableBindingHandle.getListValue().size());
        OdaDataSetParseTest.assertEquals((int)0, (int)actionHandle.getMember("paramBindings").getListValue().size());
    }

    private OdaDataSetHandle getDataSet() throws Exception {
        this.openDesign("OdaDataSetParseTest_2.xml");
        OdaDataSetHandle dataSet = (OdaDataSetHandle)this.designHandle.findDataSet("firstDataSet");
        OdaDataSetParseTest.assertNotNull((Object)dataSet);
        return dataSet;
    }

    public void testQueryText() throws Exception {
        this.openDesign(this.queryTextInputFileName2);
        OdaDataSetHandle odaHandle = (OdaDataSetHandle)this.designHandle.findDataSet("myDataSet1");
        OdaDataSetParseTest.assertEquals((String)" test ]]> test  ", (String)odaHandle.getQueryText());
        odaHandle = (OdaDataSetHandle)this.designHandle.findDataSet("myDataSet2");
        OdaDataSetParseTest.assertEquals((String)"select * from CLASSICMODELS.CUSTOMERS", (String)odaHandle.getQueryText());
        odaHandle.setQueryText("  select * from CLASSICMODELS.CUSTOMERS test ]]> test  ");
        this.save();
        OdaDataSetParseTest.assertTrue((boolean)this.compareFile(this.queryTextGoldenFileName2));
    }

    public void testExtendedPropertyContext() throws Exception {
        this.openDesign(this.extendedPropertyInput);
        OdaDataSetHandle tmpSet = (OdaDataSetHandle)this.designHandle.findDataSet("DataSet");
        Iterator iter1 = tmpSet.privateDriverPropertiesIterator();
        OdaDataSetParseTest.assertNotNull(iter1.next());
    }
}

