/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import java.util.List;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.PropertyBinding;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class PropertyBindingTest
extends BaseTestCase {
    private static final String FILE_NAME = "PropertyBindingTest.xml";
    private static final String PROP_NAME = "pswd";

    public void testParser() throws Exception {
        this.openDesign(FILE_NAME);
        PropertyBindingTest.assertNotNull((Object)this.designHandle);
        this.testParser((ModuleHandle)this.designHandle);
    }

    private void testParser(ModuleHandle moduleHandle) {
        List bindingList = moduleHandle.getListProperty("propertyBindings");
        PropertyBindingTest.assertEquals((int)4, (int)bindingList.size());
        PropertyBinding binding = (PropertyBinding)bindingList.get(0);
        PropertyBindingTest.assertEquals((String)"text", (String)binding.getName());
        PropertyBindingTest.assertEquals((long)23L, (long)binding.getID().longValue());
        PropertyBindingTest.assertEquals((String)"params[p1]", (String)binding.getValue());
        binding = (PropertyBinding)bindingList.get(1);
        PropertyBindingTest.assertEquals((String)"column", (String)binding.getName());
        PropertyBindingTest.assertEquals((long)22L, (long)binding.getID().longValue());
        PropertyBindingTest.assertEquals((String)"params[p2]", (String)binding.getValue());
        binding = (PropertyBinding)bindingList.get(2);
        PropertyBindingTest.assertEquals((String)PROP_NAME, (String)binding.getName());
        PropertyBindingTest.assertEquals((long)30L, (long)binding.getID().longValue());
        PropertyBindingTest.assertEquals((String)"newPassword", (String)binding.getValue());
        binding = (PropertyBinding)bindingList.get(3);
        PropertyBindingTest.assertEquals((String)PROP_NAME, (String)binding.getName());
        PropertyBindingTest.assertEquals((long)32L, (long)binding.getID().longValue());
        PropertyBindingTest.assertEquals((String)"unencryptedPassword", (String)binding.getValue());
        DesignElementHandle tempHandle = moduleHandle.getElementByID(23L);
        PropertyBindingTest.assertNotNull((Object)tempHandle);
        PropertyBindingTest.assertTrue((boolean)(tempHandle instanceof LabelHandle));
        PropertyBindingTest.assertNotNull((Object)tempHandle.getPropertyDefn("text"));
        PropertyBindingTest.assertEquals((String)"params[p1]", (String)tempHandle.getPropertyBindingExpression("text").getStringExpression());
        PropertyBindingTest.assertEquals(bindingList.get(0), (Object)moduleHandle.getModule().findPropertyBinding(tempHandle.getElement(), "text"));
        tempHandle = moduleHandle.getElementByID(22L);
        PropertyBindingTest.assertNotNull((Object)tempHandle);
        PropertyBindingTest.assertTrue((boolean)(tempHandle instanceof CellHandle));
        PropertyBindingTest.assertNotNull((Object)tempHandle.getPropertyDefn("column"));
        PropertyBindingTest.assertEquals((String)"params[p2]", (String)tempHandle.getPropertyBinding("column"));
        PropertyBindingTest.assertEquals(bindingList.get(1), (Object)moduleHandle.getModule().findPropertyBinding(tempHandle.getElement(), "column"));
        tempHandle = moduleHandle.getElementByID(30L);
        PropertyBindingTest.assertNotNull((Object)tempHandle);
        PropertyBindingTest.assertTrue((boolean)(tempHandle instanceof ExtendedItemHandle));
        PropertyBindingTest.assertNotNull((Object)tempHandle.getPropertyDefn(PROP_NAME));
        PropertyBindingTest.assertEquals((String)"newPassword", (String)tempHandle.getPropertyBinding(PROP_NAME));
        PropertyBindingTest.assertEquals(bindingList.get(2), (Object)moduleHandle.getModule().findPropertyBinding(tempHandle.getElement(), PROP_NAME));
    }

    public void testWriter() throws Exception {
        this.openDesign(FILE_NAME);
        PropertyBindingTest.assertNotNull((Object)this.designHandle);
        TableHandle table = (TableHandle)this.designHandle.findElement("My table");
        PropertyBindingTest.assertNotNull((Object)table);
        table.setPropertyBinding("bookmark", "params[p]");
        CellHandle cell = (CellHandle)this.designHandle.getElementByID(22L);
        PropertyBindingTest.assertNotNull((Object)cell);
        cell.setPropertyBinding("column", null);
        LabelHandle label = (LabelHandle)this.designHandle.getElementByID(23L);
        PropertyBindingTest.assertNotNull((Object)label);
        label.setPropertyBinding("text", new Expression((Object)"params[p3]", null));
        label = (LabelHandle)this.designHandle.getElementByID(26L);
        PropertyBindingTest.assertNotNull((Object)label);
        label.setPropertyBinding("text", "params[p3]");
        ExtendedItemHandle extended = (ExtendedItemHandle)this.designHandle.getElementByID(30L);
        Expression expr = new Expression((Object)"setNewPassword", "constant");
        extended.setPropertyBinding(PROP_NAME, expr);
        extended = (ExtendedItemHandle)this.designHandle.getElementByID(31L);
        extended.setPropertyBinding(PROP_NAME, "createPassword");
        try {
            PropertyBinding binding = new PropertyBinding();
            binding.setName("text");
            binding.setID(26L);
            binding.setValue("params[p]");
            this.designHandle.getPropertyHandle("propertyBindings").addItem((IStructure)binding);
            PropertyBindingTest.fail();
        }
        catch (SemanticException e) {
            assert (e instanceof PropertyValueException);
            PropertyValueException exception = (PropertyValueException)((Object)e);
            PropertyBindingTest.assertEquals((String)"Error.PropertyValueException.VALUE_EXISTS", (String)exception.getErrorCode());
            PropertyBindingTest.assertEquals((Object)this.design, (Object)exception.getElement());
            PropertyBindingTest.assertEquals((String)"propertyBindings", (String)exception.getPropertyName());
        }
        this.save();
        PropertyBindingTest.assertTrue((boolean)this.compareFile("PropertyBindingTest_golden.xml"));
        table = this.designHandle.getElementFactory().newTableItem(null);
        try {
            table.setPropertyBinding("bookmark", "params[p]");
            PropertyBindingTest.fail();
        }
        catch (SemanticException e) {
            PropertyBindingTest.assertEquals((String)"Error.SemanticError.PROPERTY_BINDING_FORBIDDEN", (String)e.getErrorCode());
        }
        this.designHandle.getBody().add((DesignElementHandle)table);
        try {
            table.setPropertyBinding("action", "prams[p]");
            PropertyBindingTest.fail();
        }
        catch (SemanticException e) {
            PropertyBindingTest.assertEquals((String)"Error.SemanticError.INVALID_PROPERTY_NAME", (String)e.getErrorCode());
        }
    }

    public void testDelect() throws Exception {
        this.openDesign(FILE_NAME);
        PropertyBindingTest.assertNotNull((Object)this.designHandle);
        LabelHandle label = (LabelHandle)this.designHandle.getElementByID(23L);
        PropertyBindingTest.assertNotNull((Object)label);
        label.setPropertyBinding("bookmark", new Expression((Object)"params[p]", null));
        label.drop();
        this.save();
        PropertyBindingTest.assertTrue((boolean)this.compareFile("PropertyBindingTest_golden_1.xml"));
    }

    public void testClone() throws Exception {
        this.openDesign(FILE_NAME);
        PropertyBindingTest.assertNotNull((Object)this.designHandle);
        ReportDesignHandle copyHandle = (ReportDesignHandle)this.designHandle.copy().getHandle(null);
        PropertyBindingTest.assertNotNull((Object)copyHandle);
        PropertyBindingTest.assertNotNull((Object)copyHandle);
        this.testParser((ModuleHandle)copyHandle);
        this.save();
        PropertyBindingTest.assertTrue((boolean)this.compareFile("PropertyBindingTest_golden_2.xml"));
    }
}

