/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import com.ibm.icu.util.ULocale;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.EmbeddedImageHandle;
import org.eclipse.birt.report.model.api.ErrorDetail;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.IncludeScriptHandle;
import org.eclipse.birt.report.model.api.IncludedCssStyleSheetHandle;
import org.eclipse.birt.report.model.api.IncludedLibraryHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.ModuleOption;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ScriptLibHandle;
import org.eclipse.birt.report.model.api.SessionHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.ThemeHandle;
import org.eclipse.birt.report.model.api.VariableElementHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.structures.ConfigVariable;
import org.eclipse.birt.report.model.api.elements.structures.CustomColor;
import org.eclipse.birt.report.model.api.elements.structures.EmbeddedImage;
import org.eclipse.birt.report.model.api.elements.structures.ScriptLib;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class ReportDesignParseTest
extends BaseTestCase {
    String fileName = "ReportDesignParseTest.xml";
    String goldenFileName = "ReportDesignParseTest_golden.xml";
    String goldenFileName_2 = "ReportDesignParseTest_golden_2.xml";
    String semanticCheckFileName = "ReportDesignParseTest_1.xml";
    String datasourceBindingsFileName = "ReportDesignParseTest_2.xml";
    String scriptLibFileName = "ReportDesignScriptLibParseTest.xml";

    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testParser() throws Exception {
        this.openDesign(this.fileName, ULocale.ENGLISH);
        ReportDesignParseTest.assertEquals((long)1000L, (long)this.designHandle.getID());
        ReportDesignParseTest.assertEquals((String)"W.C. Fields", (String)this.designHandle.getStringProperty("author"));
        ReportDesignParseTest.assertEquals((String)"subject", (String)this.designHandle.getSubject());
        ReportDesignParseTest.assertEquals((String)"http://company.com/reportHelp.html", (String)this.design.getStringProperty((Module)this.design, "helpGuide"));
        ReportDesignParseTest.assertEquals((String)"Whiz-Bang Plus", (String)this.design.getStringProperty((Module)this.design, "createdBy"));
        ReportDesignParseTest.assertEquals((String)"30", (String)this.design.getStringProperty((Module)this.design, "refreshRate"));
        ReportDesignParseTest.assertEquals((String)"c:\\", (String)this.designHandle.getBase());
        ReportDesignParseTest.assertEquals((String)"library", (String)this.designHandle.getIncludeResource());
        ReportDesignParseTest.assertEquals((String)"TITLE_ID", (String)this.design.getStringProperty((Module)this.design, "titleID"));
        ReportDesignParseTest.assertEquals((String)"Sample Report", (String)this.design.getStringProperty((Module)this.design, "title"));
        ReportDesignParseTest.assertEquals((String)"First sample report.", (String)this.design.getStringProperty((Module)this.design, "comments"));
        ReportDesignParseTest.assertEquals((String)"DESCRIP_ID", (String)this.design.getStringProperty((Module)this.design, "descriptionID"));
        ReportDesignParseTest.assertEquals((String)"This is a first sample report.", (String)this.design.getStringProperty((Module)this.design, "description"));
        ReportDesignParseTest.assertEquals((String)"display name key", (String)this.design.getStringProperty((Module)this.design, "displayNameID"));
        ReportDesignParseTest.assertEquals((String)"display name", (String)this.design.getStringProperty((Module)this.design, "displayName"));
        ReportDesignParseTest.assertEquals((String)"iconFile", (String)this.design.getStringProperty((Module)this.design, "iconFile"));
        ReportDesignParseTest.assertEquals((String)"cheatSheet", (String)this.design.getStringProperty((Module)this.design, "cheatSheet"));
        ReportDesignParseTest.assertEquals((String)"on_Event", (String)this.design.getStringProperty((Module)this.design, "eventHandlerClass"));
        ReportDesignParseTest.assertTrue((boolean)this.designHandle.newHandlerOnEachEvent());
        ReportDesignParseTest.assertEquals((String)"fixed layout", (String)this.designHandle.getLayoutPreference());
        ReportDesignParseTest.assertEquals((String)"rtl", (String)this.designHandle.getBidiOrientation());
        ReportDesignParseTest.assertTrue((boolean)this.designHandle.isEnableACL());
        ReportDesignParseTest.assertEquals((String)"acl expression test", (String)this.designHandle.getACLExpression());
        ReportDesignParseTest.assertFalse((boolean)this.designHandle.cascadeACL());
        ReportDesignParseTest.assertEquals((int)30, (int)this.designHandle.getImageDPI());
        Iterator includeLibraries = this.designHandle.includeLibrariesIterator();
        IncludedLibraryHandle lib = (IncludedLibraryHandle)includeLibraries.next();
        ReportDesignParseTest.assertEquals((String)"LibraryA.xml", (String)lib.getFileName());
        ReportDesignParseTest.assertEquals((String)"LibA", (String)lib.getNamespace());
        lib = (IncludedLibraryHandle)includeLibraries.next();
        ReportDesignParseTest.assertEquals((String)"LibraryB.xml", (String)lib.getFileName());
        ReportDesignParseTest.assertEquals((String)"LibB", (String)lib.getNamespace());
        lib = (IncludedLibraryHandle)includeLibraries.next();
        ReportDesignParseTest.assertEquals((String)"LibraryC.xml", (String)lib.getFileName());
        ReportDesignParseTest.assertEquals((String)"LibC", (String)lib.getNamespace());
        Iterator scripts = this.designHandle.includeScriptsIterator();
        IncludeScriptHandle script = (IncludeScriptHandle)scripts.next();
        ReportDesignParseTest.assertEquals((String)"script first", (String)script.getFileName());
        script = (IncludeScriptHandle)scripts.next();
        ReportDesignParseTest.assertEquals((String)"script second", (String)script.getFileName());
        ReportDesignParseTest.assertNull(scripts.next());
        PropertyHandle colorPalette = this.designHandle.getPropertyHandle("colorPalette");
        ArrayList colors = colorPalette.getListValue();
        ReportDesignParseTest.assertEquals((int)2, (int)colors.size());
        CustomColor color = (CustomColor)colors.get(0);
        ReportDesignParseTest.assertEquals((String)"cus red", (String)color.getName());
        ReportDesignParseTest.assertEquals((int)111, (int)color.getRGB());
        ReportDesignParseTest.assertEquals((String)"cus red key", (String)color.getDisplayNameID());
        ReportDesignParseTest.assertEquals((String)"cus red display", (String)color.getDisplayName());
        color = (CustomColor)colors.get(1);
        ReportDesignParseTest.assertEquals((String)"cus blue", (String)color.getName());
        ReportDesignParseTest.assertEquals((int)222, (int)color.getRGB());
        ReportDesignParseTest.assertEquals((String)"cus blue key", (String)color.getDisplayNameID());
        PropertyHandle configVarHandle = this.designHandle.getPropertyHandle("configVars");
        ArrayList configVars = configVarHandle.getListValue();
        ReportDesignParseTest.assertEquals((int)4, (int)configVars.size());
        ConfigVariable var = (ConfigVariable)configVars.get(0);
        ReportDesignParseTest.assertEquals((String)"var1", (String)var.getName());
        ReportDesignParseTest.assertEquals((String)"mumble.jpg", (String)var.getValue());
        var = (ConfigVariable)configVars.get(1);
        ReportDesignParseTest.assertEquals((String)"var2", (String)var.getName());
        ReportDesignParseTest.assertEquals((String)"abcdefg", (String)var.getValue());
        var = (ConfigVariable)configVars.get(2);
        ReportDesignParseTest.assertEquals((String)"var3", (String)var.getName());
        ReportDesignParseTest.assertEquals((String)"", (String)var.getValue());
        var = (ConfigVariable)configVars.get(3);
        ReportDesignParseTest.assertEquals((String)"var4", (String)var.getName());
        ReportDesignParseTest.assertEquals(null, (String)var.getValue());
        PropertyHandle imageHandle = this.designHandle.getPropertyHandle("images");
        ArrayList images = imageHandle.getListValue();
        ReportDesignParseTest.assertEquals((int)3, (int)images.size());
        EmbeddedImage image = (EmbeddedImage)images.get(0);
        ReportDesignParseTest.assertEquals((String)"image1", (String)image.getName());
        ReportDesignParseTest.assertEquals((String)"image/bmp", (String)image.getType((Module)this.design));
        ReportDesignParseTest.assertEquals((String)"imagetesAAA", (String)new String(Base64.encodeBase64((byte[])image.getData((Module)this.design))).substring(0, 11));
        image = (EmbeddedImage)images.get(1);
        ReportDesignParseTest.assertEquals((String)"image2", (String)image.getName());
        ReportDesignParseTest.assertEquals((String)"image/gif", (String)image.getType((Module)this.design));
        ReportDesignParseTest.assertEquals((String)"/9j/4AAQSkZJRgA", (String)new String(Base64.encodeBase64((byte[])image.getData((Module)this.design))).substring(0, 15));
        image = (EmbeddedImage)images.get(2);
        ReportDesignParseTest.assertEquals((String)"image3", (String)image.getName());
        ReportDesignParseTest.assertEquals((String)"image/bmp", (String)image.getType((Module)this.design));
        ReportDesignParseTest.assertEquals((String)"AAAA", (String)new String(Base64.encodeBase64((byte[])image.getData((Module)this.design))));
        ReportDesignParseTest.assertTrue((boolean)new String(Base64.encodeBase64((byte[])this.designHandle.getThumbnail())).startsWith("thumbnailimage"));
        ReportDesignParseTest.assertEquals((String)"script of initialize", (String)this.designHandle.getInitialize());
        ReportDesignParseTest.assertEquals((String)"script of beforeFactory", (String)this.designHandle.getBeforeFactory());
        ReportDesignParseTest.assertEquals((String)"script of afterFactory", (String)this.designHandle.getAfterFactory());
        ReportDesignParseTest.assertEquals((String)"script of beforeRender", (String)this.designHandle.getBeforeRender());
        ReportDesignParseTest.assertEquals((String)"script of afterRender", (String)this.designHandle.getAfterRender());
        ReportDesignParseTest.assertEquals((String)"script of onPageStart", (String)this.designHandle.getOnPageStart());
        ReportDesignParseTest.assertEquals((String)"script of onPageEnd", (String)this.designHandle.getOnPageEnd());
        Iterator iterator = this.designHandle.includeCssesIterator();
        IncludedCssStyleSheetHandle css = (IncludedCssStyleSheetHandle)iterator.next();
        ReportDesignParseTest.assertEquals((String)"base.css", (String)css.getFileName());
        ReportDesignParseTest.assertEquals((String)"externalCss.css", (String)css.getExternalCssURI());
        IncludedCssStyleSheetHandle css1 = (IncludedCssStyleSheetHandle)iterator.next();
        ReportDesignParseTest.assertEquals((String)"base1.css", (String)css1.getFileName());
        ReportDesignParseTest.assertEquals(null, (String)css1.getExternalCssURI());
        List styles = this.designHandle.getAllStyles();
        ReportDesignParseTest.assertEquals((int)5, (int)styles.size());
        ReportDesignParseTest.assertEquals((String)"Code", (String)((StyleHandle)styles.get(0)).getName());
        ReportDesignParseTest.assertEquals((String)"CaptionFigColumn", (String)((StyleHandle)styles.get(1)).getName());
        ReportDesignParseTest.assertEquals((String)"Note", (String)((StyleHandle)styles.get(2)).getName());
        ReportDesignParseTest.assertEquals((String)"UILabel", (String)((StyleHandle)styles.get(3)).getName());
        ReportDesignParseTest.assertEquals((String)"CodeName", (String)((StyleHandle)styles.get(4)).getName());
        StyleHandle style = (StyleHandle)styles.get(0);
        ReportDesignParseTest.assertEquals((String)"left", (String)style.getTextAlign());
        List list = this.designHandle.getPageVariables();
        ReportDesignParseTest.assertEquals((int)2, (int)list.size());
        VariableElementHandle handle = (VariableElementHandle)list.get(0);
        ReportDesignParseTest.assertEquals((String)"variable1", (String)handle.getVariableName());
        handle = (VariableElementHandle)list.get(1);
        ReportDesignParseTest.assertEquals((String)"variable2", (String)handle.getVariableName());
        handle = this.designHandle.getPageVariable("variable2");
        ReportDesignParseTest.assertEquals((String)"variable2", (String)handle.getVariableName());
        handle = this.designHandle.getPageVariable("notFound");
        ReportDesignParseTest.assertNull((Object)handle);
    }

    public void testOpenBadCssFile() throws Exception {
        this.openDesign("ReportDesignParseTest_BadCss.xml");
        List errorList = this.design.getAllErrors();
        ReportDesignParseTest.assertEquals((int)1, (int)errorList.size());
        String errorCode = ((ErrorDetail)errorList.get(0)).getErrorCode();
        ReportDesignParseTest.assertEquals((String)errorCode, (String)"Error.CSSException.CSS_NOT_FOUND");
    }

    public void testWriter() throws Exception {
        this.openDesign(this.fileName, ULocale.ENGLISH);
        this.designHandle.setProperty("author", (Object)"Report Author");
        this.designHandle.setSubject("Report Subject");
        this.designHandle.setProperty("helpGuide", (Object)"Help guide");
        this.designHandle.setProperty("createdBy", (Object)"Report Creator");
        this.designHandle.setProperty("refreshRate", (Object)"90");
        this.designHandle.setBase("");
        this.designHandle.setIncludeResource("new_message");
        this.designHandle.setProperty("titleID", (Object)"New title id");
        this.designHandle.setProperty("title", (Object)"New title");
        this.designHandle.setProperty("comments", (Object)"New comments");
        this.designHandle.setProperty("descriptionID", (Object)"New description id");
        this.designHandle.setProperty("description", (Object)"New description");
        this.designHandle.setProperty("eventHandlerClass", (Object)"on event");
        this.designHandle.setNewHandlerOnEachEvent(false);
        this.designHandle.setInitialize("new initialize script");
        this.designHandle.setBeforeFactory("new beforeFactory script");
        this.designHandle.setAfterFactory("new afterFactory script");
        this.designHandle.setBeforeRender("new beforeRender script");
        this.designHandle.setAfterRender("new afterRender script");
        this.designHandle.setOnPageStart("new script of onPageStart");
        this.designHandle.setOnPageEnd("new script of onPageEnd");
        this.designHandle.setDisplayName("new display name");
        this.designHandle.setDisplayNameKey("new display name key");
        this.designHandle.setIconFile("new iconFile");
        this.designHandle.setCheatSheet("new cheetSheet");
        this.designHandle.setThumbnail(Base64.decodeBase64((byte[])new String("newthumbnailimageAAA").getBytes("8859_1")));
        this.designHandle.setLayoutPreference("auto layout");
        Iterator iterator = this.designHandle.includeCssesIterator();
        IncludedCssStyleSheetHandle css = (IncludedCssStyleSheetHandle)iterator.next();
        css.setExternalCssURI("externalCss1.css");
        css.setFileName("base2.css");
        this.designHandle.setBidiOrientation("ltr");
        this.designHandle.setEnableACL(false);
        this.designHandle.setACLExpression("new acl expression test");
        this.designHandle.setCascadeACL(true);
        try {
            this.designHandle.setImageDPI(-10);
            ReportDesignParseTest.fail();
        }
        catch (PropertyValueException e) {
            ReportDesignParseTest.assertEquals((String)"Error.PropertyValueException.NEGATIVE_VALUE", (String)e.getErrorCode());
        }
        this.designHandle.setImageDPI(10);
        Expression value = new Expression((Object)"testValue", "constant");
        this.designHandle.setPageVariable("variable2", value);
        value = new Expression((Object)"testValue10", "constant");
        this.designHandle.setPageVariable("variable10", value);
        this.save();
        ReportDesignParseTest.assertTrue((boolean)this.compareFile(this.goldenFileName));
    }

    public void testConfigVars() throws Exception {
        this.openDesign(this.fileName, ULocale.ENGLISH);
        ConfigVariable configVar = new ConfigVariable();
        configVar.setName("VarToAdd");
        configVar.setValue("ValueToAdd");
        ConfigVariable newConfigVar = new ConfigVariable();
        newConfigVar.setName("VarToReplace");
        newConfigVar.setValue("ValueToReplace");
        ConfigVariable var = null;
        this.designHandle.addConfigVariable(configVar);
        var = this.designHandle.findConfigVariable("VarToAdd");
        ReportDesignParseTest.assertNotNull((Object)var);
        ReportDesignParseTest.assertEquals((String)"ValueToAdd", (String)var.getValue());
        this.designHandle.replaceConfigVariable(configVar, newConfigVar);
        var = this.designHandle.findConfigVariable("VarToAdd");
        ReportDesignParseTest.assertNull((Object)var);
        var = this.designHandle.findConfigVariable("VarToReplace");
        ReportDesignParseTest.assertNotNull((Object)var);
        ReportDesignParseTest.assertEquals((String)"ValueToReplace", (String)var.getValue());
        this.designHandle.dropConfigVariable("VarToReplace");
        var = this.designHandle.findConfigVariable("ValueToReplace");
        ReportDesignParseTest.assertNull((Object)var);
        try {
            configVar = new ConfigVariable();
            configVar.setName("   ");
            configVar.setValue("value");
            this.designHandle.addConfigVariable(configVar);
            ReportDesignParseTest.fail();
        }
        catch (SemanticException e) {
            ReportDesignParseTest.assertEquals((String)"Error.PropertyValueException.INVALID_VALUE", (String)e.getErrorCode());
        }
        try {
            configVar = new ConfigVariable();
            configVar.setName("var1");
            configVar.setValue("value");
            this.designHandle.addConfigVariable(configVar);
            ReportDesignParseTest.fail();
        }
        catch (SemanticException e) {
            ReportDesignParseTest.assertEquals((String)"Error.PropertyValueException.VALUE_EXISTS", (String)e.getErrorCode());
        }
        try {
            this.designHandle.dropConfigVariable("NotExist");
            ReportDesignParseTest.fail();
        }
        catch (SemanticException e) {
            ReportDesignParseTest.assertEquals((String)"Error.PropertyValueException.ITEM_NOT_FOUND", (String)e.getErrorCode());
        }
        try {
            configVar = new ConfigVariable();
            configVar.setName("NotExist");
            configVar.setValue("value");
            this.designHandle.replaceConfigVariable(configVar, newConfigVar);
            ReportDesignParseTest.fail();
        }
        catch (SemanticException e) {
            ReportDesignParseTest.assertEquals((String)"Error.PropertyValueException.ITEM_NOT_FOUND", (String)e.getErrorCode());
        }
        configVar = this.designHandle.findConfigVariable("var1");
        this.designHandle.replaceConfigVariable(configVar, newConfigVar);
    }

    public void testScriptLibs() throws Exception {
        this.openDesign(this.scriptLibFileName, ULocale.ENGLISH);
        ScriptLib scriptLib = new ScriptLib();
        scriptLib.setName(null);
        try {
            this.designHandle.addScriptLib(scriptLib);
            ReportDesignParseTest.fail((String)"Not allowed set invalid value ");
        }
        catch (SemanticException e) {
            ReportDesignParseTest.assertEquals((String)"Error.PropertyValueException.VALUE_REQUIRED", (String)e.getErrorCode());
        }
        try {
            scriptLib.setName("a.jar");
            this.designHandle.addScriptLib(scriptLib);
            ReportDesignParseTest.fail((String)"Not allowed set invalid value ");
        }
        catch (SemanticException e) {
            ReportDesignParseTest.assertEquals((String)"Error.PropertyValueException.VALUE_EXISTS", (String)e.getErrorCode());
        }
        scriptLib.setName("x.jar");
        ReportDesignParseTest.assertEquals((int)3, (int)this.designHandle.getAllScriptLibs().size());
        this.designHandle.addScriptLib(scriptLib);
        ReportDesignParseTest.assertEquals((int)4, (int)this.designHandle.getAllScriptLibs().size());
        scriptLib = this.designHandle.findScriptLib("a.jar");
        ReportDesignParseTest.assertNotNull((Object)scriptLib);
        this.designHandle.dropScriptLib(scriptLib);
        ReportDesignParseTest.assertEquals((int)3, (int)this.designHandle.getAllScriptLibs().size());
        this.designHandle.shiftScriptLibs(0, 3);
        ReportDesignParseTest.assertEquals((String)"c.jar", (String)((ScriptLibHandle)this.designHandle.getAllScriptLibs().get(0)).getName());
        ReportDesignParseTest.assertEquals((String)"x.jar", (String)((ScriptLibHandle)this.designHandle.getAllScriptLibs().get(1)).getName());
        ReportDesignParseTest.assertEquals((String)"b.jar", (String)((ScriptLibHandle)this.designHandle.getAllScriptLibs().get(2)).getName());
        this.designHandle.dropAllScriptLibs();
        ReportDesignParseTest.assertEquals((int)0, (int)this.designHandle.getAllScriptLibs().size());
    }

    public void testImages() throws Exception {
        this.openDesign(this.fileName, ULocale.ENGLISH);
        EmbeddedImage add = new EmbeddedImage("VarToAdd", "image/bmp");
        EmbeddedImage replace = new EmbeddedImage("VarToReplace", "image/gif");
        EmbeddedImage image = null;
        add.setData("data".getBytes("8859_1"));
        replace.setData("data".getBytes("8859_1"));
        this.designHandle.addImage(add);
        image = this.designHandle.findImage("VarToAdd");
        ReportDesignParseTest.assertNotNull((Object)image);
        ReportDesignParseTest.assertEquals((String)"image/bmp", (String)image.getType((Module)this.design));
        this.designHandle.replaceImage(add, replace);
        image = this.designHandle.findImage("VarToAdd");
        ReportDesignParseTest.assertNull((Object)image);
        image = this.designHandle.findImage("VarToReplace");
        ReportDesignParseTest.assertNotNull((Object)image);
        ReportDesignParseTest.assertEquals((String)"image/gif", (String)image.getType((Module)this.design));
        this.designHandle.dropImage("VarToReplace");
        image = this.designHandle.findImage("ValToReplace");
        ReportDesignParseTest.assertNull((Object)image);
        try {
            add = new EmbeddedImage("  ", "value");
            this.designHandle.addImage(add);
            ReportDesignParseTest.fail();
        }
        catch (SemanticException e) {
            ReportDesignParseTest.assertEquals((String)"Error.PropertyValueException.INVALID_VALUE", (String)e.getErrorCode());
        }
        try {
            add = new EmbeddedImage(" test ", "value");
            this.designHandle.addImage(add);
            ReportDesignParseTest.fail();
        }
        catch (SemanticException e) {
            ReportDesignParseTest.assertEquals((String)"Error.PropertyValueException.CHOICE_NOT_FOUND", (String)e.getErrorCode());
        }
        try {
            add = new EmbeddedImage("image1", "image/bmp");
            add.setData("data".getBytes("8859_1"));
            this.designHandle.addImage(add);
            ReportDesignParseTest.fail();
        }
        catch (SemanticException e) {
            ReportDesignParseTest.assertEquals((String)"Error.PropertyValueException.VALUE_EXISTS", (String)e.getErrorCode());
        }
        try {
            this.designHandle.dropImage("NotExist");
            ReportDesignParseTest.fail();
        }
        catch (SemanticException e) {
            ReportDesignParseTest.assertEquals((String)"Error.PropertyValueException.ITEM_NOT_FOUND", (String)e.getErrorCode());
        }
        try {
            add = new EmbeddedImage("NotExist", "image/bmp");
            this.designHandle.replaceImage(add, replace);
            ReportDesignParseTest.fail();
        }
        catch (SemanticException e) {
            ReportDesignParseTest.assertEquals((String)"Error.PropertyValueException.ITEM_NOT_FOUND", (String)e.getErrorCode());
        }
        try {
            add = this.designHandle.findImage("image1");
            replace = new EmbeddedImage("replace", "wrong");
            this.designHandle.replaceImage(add, replace);
            ReportDesignParseTest.fail();
        }
        catch (SemanticException e) {
            ReportDesignParseTest.assertEquals((String)"Error.PropertyValueException.CHOICE_NOT_FOUND", (String)e.getErrorCode());
        }
        try {
            EmbeddedImage tmp = new EmbeddedImage("VarToAdd");
            tmp.setData("data".getBytes("8859_1"));
            this.designHandle.addImage(tmp);
            tmp = new EmbeddedImage("VarToAdd", "image/bmp");
            tmp.setData("data".getBytes("8859_1"));
            this.designHandle.addImage(tmp);
            ReportDesignParseTest.fail();
        }
        catch (SemanticException e) {
            ReportDesignParseTest.assertEquals((String)"Error.PropertyValueException.VALUE_EXISTS", (String)e.getErrorCode());
        }
    }

    public void testSemanticError() throws Exception {
        this.openDesign(this.semanticCheckFileName);
        List errors = this.design.getAllErrors();
        ReportDesignParseTest.assertEquals((int)5, (int)errors.size());
        int i = 0;
        ReportDesignParseTest.assertEquals((String)"Error.PropertyValueException.VALUE_REQUIRED", (String)((ErrorDetail)errors.get(i++)).getErrorCode());
        ReportDesignParseTest.assertEquals((String)"Error.PropertyValueException.VALUE_REQUIRED", (String)((ErrorDetail)errors.get(i++)).getErrorCode());
        ReportDesignParseTest.assertEquals((String)"Error.PropertyValueException.VALUE_EXISTS", (String)((ErrorDetail)errors.get(i++)).getErrorCode());
        ReportDesignParseTest.assertEquals((String)"Error.PropertyValueException.VALUE_REQUIRED", (String)((ErrorDetail)errors.get(i++)).getErrorCode());
        ReportDesignParseTest.assertEquals((String)"Error.SemanticError.MISSING_MASTER_PAGE", (String)((ErrorDetail)errors.get(i++)).getErrorCode());
    }

    public void testUnsupportedVersion() {
        try {
            this.openDesign("UnsupportedVersionTest.xml");
            ReportDesignParseTest.fail();
        }
        catch (DesignFileException e) {
            ReportDesignParseTest.assertEquals((String)"Error.DesignParserException.UNSUPPORTED_VERSION", (String)((ErrorDetail)e.getErrorList().get(0)).getErrorCode());
        }
        try {
            this.openDesign("InvalidVersionTest.xml");
            ReportDesignParseTest.fail();
        }
        catch (DesignFileException e) {
            ReportDesignParseTest.assertEquals((String)"Error.DesignParserException.INVALID_VERSION", (String)((ErrorDetail)e.getErrorList().get(0)).getErrorCode());
        }
    }

    public void testCompatibilityDatasourceParamBinding() throws Exception {
        this.openDesign(this.datasourceBindingsFileName, ULocale.ENGLISH);
        this.save();
        ReportDesignParseTest.assertTrue((boolean)this.compareFile(this.goldenFileName_2));
    }

    public void testParseDesignInJarFile() throws Exception {
        String jarFileName = this.copyContentToFile("input/testRead.jar");
        SessionHandle session = DesignEngine.newSession((ULocale)ULocale.getDefault());
        this.designHandle = session.openDesign("jar:file:" + jarFileName + "!/test/testRead.rptdesign");
        ReportDesignParseTest.assertNotNull((Object)this.designHandle);
        ReportDesignParseTest.assertNotNull((Object)this.designHandle.getSystemId());
        LabelHandle label = (LabelHandle)this.designHandle.findElement("labelfromLib");
        ReportDesignParseTest.assertNotNull((Object)label);
        ReportDesignParseTest.assertEquals((String)"a.labelfromLib", (String)label.getElement().getExtendsName());
        ReportDesignParseTest.assertEquals((Object)"blue", (Object)label.getProperty("color"));
    }

    public void testParseEmptyDesignFile() {
        try {
            this.openDesign("EmptyDesignFile.xml");
            ReportDesignParseTest.fail();
        }
        catch (DesignFileException e) {
            ReportDesignParseTest.assertEquals((String)"Error.DesignFileException.INVALID_XML", (String)e.getErrorCode());
        }
    }

    public void testParseReadingLineNumber() throws DesignFileException {
        this.openDesign("LineNumberParseTest.xml");
        TableHandle table = (TableHandle)this.designHandle.findElement("table1");
        ReportDesignParseTest.assertEquals((int)373, (int)this.designHandle.getLineNo((Object)table));
        CellHandle cell = (CellHandle)this.designHandle.getElementByID(45L);
        ReportDesignParseTest.assertEquals((int)395, (int)this.designHandle.getLineNo((Object)cell));
        ExtendedItemHandle chart = (ExtendedItemHandle)this.designHandle.getElementByID(34023L);
        ReportDesignParseTest.assertEquals((int)400, (int)this.designHandle.getLineNo((Object)chart));
        EmbeddedImageHandle image = (EmbeddedImageHandle)this.designHandle.getAllImages().get(0);
        ReportDesignParseTest.assertEquals((int)407, (int)this.designHandle.getLineNo((Object)image));
        LibraryHandle library = (LibraryHandle)this.designHandle.getLibraries().get(0);
        ReportDesignParseTest.assertEquals((int)8, (int)this.designHandle.getLineNo((Object)library));
        ThemeHandle theme = this.designHandle.getTheme();
        ReportDesignParseTest.assertEquals((int)6, (int)this.designHandle.getLineNo((Object)theme));
        SlotHandle footer = table.getFooter();
        ReportDesignParseTest.assertEquals((int)392, (int)this.designHandle.getLineNo((Object)footer));
        SlotHandle body = this.designHandle.getBody();
        ReportDesignParseTest.assertEquals((int)372, (int)this.designHandle.getLineNo((Object)body));
        SlotHandle pages = this.designHandle.getMasterPages();
        ReportDesignParseTest.assertEquals((int)362, (int)this.designHandle.getLineNo((Object)pages));
    }

    public void testWriterForCreatedBy() throws Exception {
        this.openDesign(this.fileName);
        this.designHandle.clearAllProperties();
        ModuleOption options = new ModuleOption();
        options.setProperty("createdBy", (Object)"createdByOption");
        this.design.setOptions(options);
        this.designHandle.setCreatedBy("created by Birt2.2");
        this.save();
        ReportDesignParseTest.assertTrue((boolean)this.compareFile("ReportDesignParseTest_golden_3.xml"));
    }

    public void testNotExistLibrary() throws Exception {
        this.openDesign("NotExistLibraryTest.xml");
        List errors = this.design.getAllErrors();
        ReportDesignParseTest.assertEquals((int)1, (int)errors.size());
        ReportDesignParseTest.assertEquals((String)"Error.LibraryException.LIBRARY_NOT_FOUND", (String)((ErrorDetail)errors.get(0)).getErrorCode());
    }
}

