/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.api.AccessControlHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DimensionConditionHandle;
import org.eclipse.birt.report.model.api.DimensionJoinConditionHandle;
import org.eclipse.birt.report.model.api.ElementFactory;
import org.eclipse.birt.report.model.api.FilterConditionHandle;
import org.eclipse.birt.report.model.api.LevelAttributeHandle;
import org.eclipse.birt.report.model.api.MemberHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.RuleHandle;
import org.eclipse.birt.report.model.api.ValueAccessControlHandle;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.command.NameException;
import org.eclipse.birt.report.model.api.command.PropertyEvent;
import org.eclipse.birt.report.model.api.core.IDesignElement;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.core.Listener;
import org.eclipse.birt.report.model.api.elements.structures.DimensionCondition;
import org.eclipse.birt.report.model.api.elements.structures.DimensionJoinCondition;
import org.eclipse.birt.report.model.api.elements.structures.LevelAttribute;
import org.eclipse.birt.report.model.api.elements.structures.Rule;
import org.eclipse.birt.report.model.api.olap.DimensionHandle;
import org.eclipse.birt.report.model.api.olap.HierarchyHandle;
import org.eclipse.birt.report.model.api.olap.LevelHandle;
import org.eclipse.birt.report.model.api.olap.MeasureGroupHandle;
import org.eclipse.birt.report.model.api.olap.MeasureHandle;
import org.eclipse.birt.report.model.api.olap.TabularCubeHandle;
import org.eclipse.birt.report.model.api.olap.TabularHierarchyHandle;
import org.eclipse.birt.report.model.api.olap.TabularLevelHandle;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class TabularCubeParserTest
extends BaseTestCase {
    private final String FILE_NAME = "CubeParserTest.xml";
    private final String FILE_NAME_EXTENDS = "CubeParserTest_3.xml";

    public void testParser() throws Exception {
        this.openDesign("CubeParserTest.xml");
        TabularCubeParserTest.assertNotNull((Object)this.designHandle);
        TabularCubeHandle cube = (TabularCubeHandle)this.designHandle.findCube("testCube");
        TabularCubeParserTest.assertEquals((Object)this.designHandle.findDataSet("firstDataSet"), (Object)cube.getDataSet());
        Iterator iter = cube.filtersIterator();
        FilterConditionHandle filterConditionHandle = (FilterConditionHandle)iter.next();
        TabularCubeParserTest.assertEquals((String)"filter expression", (String)filterConditionHandle.getExpr());
        iter = cube.joinConditionsIterator();
        DimensionConditionHandle cubeJoinConditionHandle = (DimensionConditionHandle)iter.next();
        TabularCubeParserTest.assertEquals((Object)this.design.findOLAPElement("testHierarchy"), (Object)cubeJoinConditionHandle.getHierarchy().getElement());
        MemberHandle conditionMemberHandle = cubeJoinConditionHandle.getJoinConditions();
        TabularCubeParserTest.assertEquals((int)3, (int)conditionMemberHandle.getListValue().size());
        DimensionJoinConditionHandle joinCondition = (DimensionJoinConditionHandle)conditionMemberHandle.getAt(0);
        TabularCubeParserTest.assertEquals((String)"cubeKey", (String)joinCondition.getCubeKey());
        TabularCubeParserTest.assertEquals((String)"key", (String)joinCondition.getHierarchyKey());
        TabularCubeParserTest.assertEquals((Object)this.designHandle.findLevel("testDimension/testLevel"), (Object)joinCondition.getLevel());
        joinCondition = (DimensionJoinConditionHandle)conditionMemberHandle.getAt(1);
        TabularCubeParserTest.assertEquals((String)"cubeKey2", (String)joinCondition.getCubeKey());
        TabularCubeParserTest.assertEquals((String)"key2", (String)joinCondition.getHierarchyKey());
        joinCondition = (DimensionJoinConditionHandle)conditionMemberHandle.getAt(2);
        TabularCubeParserTest.assertEquals((String)"cubeKey4", (String)joinCondition.getCubeKey());
        TabularCubeParserTest.assertEquals((String)"key4", (String)joinCondition.getHierarchyKey());
        cubeJoinConditionHandle = (DimensionConditionHandle)iter.next();
        TabularCubeParserTest.assertNull((Object)cubeJoinConditionHandle.getHierarchy());
        TabularCubeParserTest.assertEquals((String)"nonExistingHierarchy", (String)cubeJoinConditionHandle.getHierarchyName());
        conditionMemberHandle = cubeJoinConditionHandle.getJoinConditions();
        TabularCubeParserTest.assertEquals((int)1, (int)conditionMemberHandle.getListValue().size());
        Iterator iter1 = cube.accessControlsIterator();
        AccessControlHandle accessControl = (AccessControlHandle)iter1.next();
        TabularCubeParserTest.assertEquals((String)"cube user1; cube user2", (String)accessControl.getPropertyHandle("userNames").getStringValue());
        TabularCubeParserTest.assertEquals((String)"cube role1; cube role2", (String)accessControl.getPropertyHandle("roles").getStringValue());
        TabularCubeParserTest.assertEquals((String)"disallow", (String)accessControl.getPermission());
        PropertyHandle propHandle = cube.getPropertyHandle("dimensions");
        TabularCubeParserTest.assertEquals((int)1, (int)propHandle.getContentCount());
        TabularCubeParserTest.assertEquals((int)1, (int)cube.getContentCount("dimensions"));
        DimensionHandle dimension = (DimensionHandle)propHandle.getContent(0);
        TabularCubeParserTest.assertEquals((Object)dimension, (Object)cube.getContent("dimensions", 0));
        TabularCubeParserTest.assertEquals((String)"testDimension", (String)dimension.getName());
        TabularCubeParserTest.assertTrue((boolean)dimension.isTimeType());
        propHandle = dimension.getPropertyHandle("hierarchies");
        TabularCubeParserTest.assertEquals((int)1, (int)propHandle.getContentCount());
        TabularCubeParserTest.assertEquals((int)1, (int)dimension.getContentCount("hierarchies"));
        TabularHierarchyHandle hierarchy = (TabularHierarchyHandle)propHandle.getContent(0);
        TabularCubeParserTest.assertEquals((Object)hierarchy, (Object)dimension.getContent("hierarchies", 0));
        TabularCubeParserTest.assertEquals((Object)hierarchy, (Object)dimension.getDefaultHierarchy());
        TabularCubeParserTest.assertEquals((String)"testHierarchy", (String)hierarchy.getName());
        TabularCubeParserTest.assertEquals((Object)this.designHandle.findDataSet("secondDataSet"), (Object)hierarchy.getDataSet());
        TabularLevelHandle level = (TabularLevelHandle)hierarchy.getLevel("testLevel");
        TabularCubeParserTest.assertNotNull((Object)level);
        iter1 = hierarchy.accessControlsIterator();
        accessControl = (AccessControlHandle)iter1.next();
        TabularCubeParserTest.assertEquals((String)"hierarchy user1; hierarchy user2", (String)accessControl.getPropertyHandle("userNames").getStringValue());
        TabularCubeParserTest.assertEquals((String)"hierarchy role1; hierarchy role2", (String)accessControl.getPropertyHandle("roles").getStringValue());
        TabularCubeParserTest.assertEquals((String)"allow", (String)accessControl.getPermission());
        propHandle = cube.getPropertyHandle("dimensions");
        TabularCubeParserTest.assertEquals((int)1, (int)propHandle.getContentCount());
        TabularCubeParserTest.assertEquals((int)1, (int)cube.getContentCount("dimensions"));
        iter = hierarchy.filtersIterator();
        filterConditionHandle = (FilterConditionHandle)iter.next();
        TabularCubeParserTest.assertEquals((String)"filter expression", (String)filterConditionHandle.getExpr());
        List primaryKeys = hierarchy.getPrimaryKeys();
        TabularCubeParserTest.assertEquals((int)3, (int)primaryKeys.size());
        TabularCubeParserTest.assertEquals((Object)"key", primaryKeys.get(0));
        TabularCubeParserTest.assertEquals((Object)"key2", primaryKeys.get(1));
        TabularCubeParserTest.assertEquals((Object)"key4", primaryKeys.get(2));
        propHandle = hierarchy.getPropertyHandle("levels");
        TabularCubeParserTest.assertEquals((int)1, (int)propHandle.getContentCount());
        TabularCubeParserTest.assertEquals((int)1, (int)hierarchy.getContentCount("levels"));
        level = (TabularLevelHandle)propHandle.getContent(0);
        TabularCubeParserTest.assertEquals((Object)level, (Object)hierarchy.getContent("levels", 0));
        TabularCubeParserTest.assertEquals((String)"testLevel", (String)level.getName());
        TabularCubeParserTest.assertEquals((String)"column1", (String)level.getColumnName());
        TabularCubeParserTest.assertEquals((String)"integer", (String)level.getDataType());
        TabularCubeParserTest.assertEquals((String)"prefix", (String)level.getInterval());
        TabularCubeParserTest.assertEquals((String)"month", (String)level.getDateTimeLevelType());
        TabularCubeParserTest.assertEquals((String)"mmm", (String)level.getDateTimeFormat());
        TabularCubeParserTest.assertEquals((double)3.0, (double)level.getIntervalRange(), (double)0.0);
        TabularCubeParserTest.assertEquals((String)"Jan", (String)level.getIntervalBase());
        TabularCubeParserTest.assertEquals((String)"dynamic", (String)level.getLevelType());
        iter = level.staticValuesIterator();
        RuleHandle rule = (RuleHandle)iter.next();
        TabularCubeParserTest.assertEquals((String)"rule expression", (String)rule.getRuleExpression());
        TabularCubeParserTest.assertEquals((String)"display expression", (String)rule.getDisplayExpression());
        rule = (RuleHandle)iter.next();
        TabularCubeParserTest.assertEquals((String)"rule expression2", (String)rule.getRuleExpression());
        TabularCubeParserTest.assertEquals((String)"display expression2", (String)rule.getDisplayExpression());
        iter = level.attributesIterator();
        LevelAttributeHandle attribute = (LevelAttributeHandle)iter.next();
        TabularCubeParserTest.assertEquals((String)"var1", (String)attribute.getName());
        TabularCubeParserTest.assertEquals((String)"string", (String)attribute.getDataType());
        attribute = (LevelAttributeHandle)iter.next();
        TabularCubeParserTest.assertEquals((String)"var2", (String)attribute.getName());
        TabularCubeParserTest.assertEquals((String)"integer", (String)attribute.getDataType());
        iter1 = level.valueAccessControlsIterator();
        ValueAccessControlHandle valueAccessControl = (ValueAccessControlHandle)iter1.next();
        TabularCubeParserTest.assertEquals((String)"level user1; level user2", (String)valueAccessControl.getPropertyHandle("userNames").getStringValue());
        TabularCubeParserTest.assertEquals((String)"level role1; level role2", (String)valueAccessControl.getPropertyHandle("roles").getStringValue());
        TabularCubeParserTest.assertEquals((String)"level value1; level value2", (String)valueAccessControl.getPropertyHandle("values").getStringValue());
        TabularCubeParserTest.assertEquals((String)"disallow", (String)valueAccessControl.getPermission());
        propHandle = cube.getPropertyHandle("measureGroups");
        TabularCubeParserTest.assertEquals((int)1, (int)propHandle.getContentCount());
        TabularCubeParserTest.assertEquals((int)1, (int)cube.getContentCount("measureGroups"));
        MeasureGroupHandle measureGroup = (MeasureGroupHandle)propHandle.getContent(0);
        TabularCubeParserTest.assertEquals((Object)measureGroup, (Object)cube.getContent("measureGroups", 0));
        TabularCubeParserTest.assertEquals((String)"testMeasureGroup", (String)measureGroup.getName());
        TabularCubeParserTest.assertEquals((Object)measureGroup, (Object)cube.getDefaultMeasureGroup());
        propHandle = measureGroup.getPropertyHandle("measures");
        MeasureHandle measure = (MeasureHandle)propHandle.getContent(0);
        TabularCubeParserTest.assertEquals((String)"testMeasure", (String)measure.getName());
        TabularCubeParserTest.assertEquals((String)"column", (String)measure.getMeasureExpression());
        TabularCubeParserTest.assertEquals((String)"min", (String)measure.getFunction());
        TabularCubeParserTest.assertFalse((boolean)measure.isCalculated());
        TabularCubeParserTest.assertEquals((String)"string", (String)measure.getDataType());
    }

    public void testWriter() throws Exception {
        this.openDesign("CubeParserTest.xml");
        TabularCubeParserTest.assertNotNull((Object)this.designHandle);
        String namePrix = "new";
        String valuePrix = "updated ";
        ElementFactory factory = this.designHandle.getElementFactory();
        TabularCubeHandle cube = (TabularCubeHandle)this.designHandle.findCube("testCube");
        cube.setDataSet(this.designHandle.findDataSet("secondDataSet"));
        cube.setName(String.valueOf(namePrix) + cube.getName());
        cube.setDefaultMeasureGroup((MeasureGroupHandle)factory.newTabularMeasureGroup("testDefaultMeasureGroup"));
        PropertyHandle propHandle = cube.getPropertyHandle("dimensionConditions");
        propHandle.removeItem(1);
        DimensionCondition condition = new DimensionCondition();
        DimensionConditionHandle structHandle = cube.addDimensionCondition(condition);
        DimensionJoinConditionHandle joinConditionHandle = structHandle.addJoinCondition(new DimensionJoinCondition());
        joinConditionHandle.setCubeKey("addCubeKey");
        joinConditionHandle.setHierarchyKey("addHierarchyKey");
        joinConditionHandle.setLevel("testDimension/noLevel");
        structHandle = (DimensionConditionHandle)propHandle.get(0);
        MemberHandle memberHandle = structHandle.getMember("hierarchy");
        memberHandle.setValue((Object)(String.valueOf(valuePrix) + "hierarchy"));
        structHandle.removeJoinCondition(1);
        AccessControlHandle accessControl = (AccessControlHandle)cube.accessControlsIterator().next();
        accessControl.addUserName("new cube user1");
        accessControl.addUserName("new cube user2");
        accessControl.addRole("new cube role1");
        accessControl.addRole("new cube role2");
        accessControl.setPermission("allow");
        propHandle = cube.getPropertyHandle("accessControls");
        accessControl = this.designHandle.getElementFactory().newAccessControl();
        propHandle.add((DesignElementHandle)accessControl);
        cube.add("dimensions", (DesignElementHandle)factory.newTabularDimension(null));
        DimensionHandle dimension = (DimensionHandle)cube.getContent("dimensions", 0);
        dimension.setName(String.valueOf(namePrix) + dimension.getName());
        dimension.setTimeType(false);
        dimension.setDefaultHierarchy((HierarchyHandle)factory.newTabularHierarchy("testDefaultHierarchy"));
        dimension.add("hierarchies", (DesignElementHandle)factory.newTabularHierarchy(null));
        TabularHierarchyHandle hierarchy = (TabularHierarchyHandle)dimension.getContent("hierarchies", 0);
        hierarchy.setName(String.valueOf(namePrix) + hierarchy.getName());
        hierarchy.setDataSet(this.designHandle.findDataSet("firstDataSet"));
        propHandle = hierarchy.getPropertyHandle("primaryKeys");
        propHandle.removeItem((Object)"key2");
        propHandle.addItem((Object)(String.valueOf(valuePrix) + "key"));
        accessControl = (AccessControlHandle)hierarchy.accessControlsIterator().next();
        accessControl.addUserName("new hierarchy user1");
        accessControl.addUserName("new hierarchy user2");
        accessControl.addRole("new hierarchy role1");
        accessControl.addRole("new hierarchy role2");
        accessControl.setPermission("disallow");
        propHandle = hierarchy.getPropertyHandle("accessControls");
        accessControl = this.designHandle.getElementFactory().newAccessControl();
        propHandle.add((DesignElementHandle)accessControl);
        hierarchy.add("levels", (DesignElementHandle)factory.newTabularLevel(dimension, null));
        TabularLevelHandle level = (TabularLevelHandle)hierarchy.getContent("levels", 0);
        level.setName(String.valueOf(namePrix) + level.getName());
        level.setColumnName(String.valueOf(valuePrix) + level.getColumnName());
        level.setDataType("string");
        level.setDateTimeLevelType("quarter");
        level.setDateTimeFormat("mm");
        level.setIntervalRange(5.0);
        level.setIntervalBase(String.valueOf(valuePrix) + level.getIntervalBase());
        level.setLevelType("mirrored");
        propHandle = level.getPropertyHandle("staticValues");
        propHandle.removeItem(0);
        Rule rule = new Rule();
        rule.setProperty("displayExpre", (Object)"new display expression");
        rule.setProperty("ruleExpre", (Object)"new rule expression");
        propHandle.insertItem((IStructure)rule, 0);
        propHandle = level.getPropertyHandle("attributes");
        propHandle.removeItem(propHandle.get(1));
        LevelAttribute config = new LevelAttribute();
        config.setName("var3");
        config.setDataType("boolean");
        propHandle.insertItem((IStructure)config, 0);
        ValueAccessControlHandle valueAccess = (ValueAccessControlHandle)level.valueAccessControlsIterator().next();
        valueAccess.addUserName("new level user1");
        valueAccess.addUserName("new level user2");
        valueAccess.addRole("new level role1");
        valueAccess.addRole("new level role2");
        valueAccess.addValue("new level value1");
        valueAccess.addValue("new level value2");
        valueAccess.setPermission("allow");
        propHandle = level.getPropertyHandle("valueAccessControls");
        valueAccess = this.designHandle.getElementFactory().newValueAccessControl();
        propHandle.add((DesignElementHandle)valueAccess);
        cube.add("measureGroups", (DesignElementHandle)factory.newTabularMeasureGroup(null));
        MeasureGroupHandle measureGroup = (MeasureGroupHandle)cube.getContent("measureGroups", 0);
        measureGroup.setName(String.valueOf(namePrix) + measureGroup.getName());
        measureGroup.add("measures", (DesignElementHandle)factory.newTabularMeasure(null));
        MeasureHandle measure = (MeasureHandle)measureGroup.getContent("measures", 0);
        measure.setName(String.valueOf(namePrix) + measure.getName());
        measure.setMeasureExpression(String.valueOf(valuePrix) + measure.getMeasureExpression());
        measure.setFunction("count");
        measure.setCalculated(true);
        measure.setDataType("boolean");
        this.save();
        TabularCubeParserTest.assertTrue((boolean)this.compareFile("CubeParserTest_golden.xml"));
    }

    public void testCommand() throws Exception {
        this.openDesign("CubeParserTest.xml");
        TabularCubeParserTest.assertNotNull((Object)this.designHandle);
        TabularCubeHandle cube = (TabularCubeHandle)this.designHandle.findCube("testCube");
        try {
            cube.setName(null);
            TabularCubeParserTest.fail();
        }
        catch (NameException nameException) {}
        IDesignElement clonedCube = cube.copy();
        TabularCubeParserTest.assertNotNull((Object)clonedCube);
        this.designHandle.rename(clonedCube.getHandle((Module)this.design));
        this.designHandle.getSlot(9).add(clonedCube.getHandle((Module)this.design));
        this.save();
        TabularCubeParserTest.assertTrue((boolean)this.compareFile("CubeParserTest_golden_1.xml"));
    }

    public void testExtends() throws Exception {
        this.openDesign("CubeParserTest_3.xml");
        TabularCubeParserTest.assertNotNull((Object)this.designHandle);
        this.libraryHandle = this.designHandle.getLibrary("Lib1");
        TabularCubeHandle cube = (TabularCubeHandle)this.libraryHandle.findCube("testCube");
        TabularCubeHandle newCube = (TabularCubeHandle)this.designHandle.getElementFactory().newElementFrom((DesignElementHandle)cube, "Customer Cube");
        this.designHandle.getCubes().add((DesignElementHandle)newCube);
        this.save();
        TabularCubeParserTest.assertTrue((boolean)this.compareFile("TabularCubeParserTest_extends_golden_1.xml"));
        AccessControlHandle control = this.designHandle.getElementFactory().newAccessControl();
        control.addUserName("new user name 1");
        newCube.add("accessControls", (DesignElementHandle)control);
        this.save();
        TabularCubeParserTest.assertTrue((boolean)this.compareFile("TabularCubeParserTest_extends_golden_2.xml"));
        this.designHandle.getCommandStack().undo();
        LevelHandle level = this.designHandle.findLevel("testDimension1/testLevel");
        ValueAccessControlHandle valueAccess = this.designHandle.getElementFactory().newValueAccessControl();
        valueAccess.addValue("new value 1");
        level.add("valueAccessControls", (DesignElementHandle)valueAccess);
        this.save();
        TabularCubeParserTest.assertTrue((boolean)this.compareFile("TabularCubeParserTest_extends_golden_3.xml"));
        valueAccess.setPermission("allow");
    }

    public void testNotification() throws Exception {
        this.openDesign("CubeParserTest_2.xml");
        TabularCubeHandle cube = (TabularCubeHandle)this.designHandle.findCube("testCube");
        MyListener listener = new MyListener();
        cube.addListener((Listener)listener);
        PropertyHandle propHandle = cube.getPropertyHandle("accessControls");
        AccessControlHandle accessControl = this.designHandle.getElementFactory().newAccessControl();
        propHandle.add((DesignElementHandle)accessControl);
        accessControl.addUserName("new cube user1");
        TabularCubeParserTest.checkNotificationStatus(listener);
        propHandle = accessControl.getPropertyHandle("userNames");
        propHandle.addItem((Object)"new cube user2");
        TabularCubeParserTest.checkNotificationStatus(listener);
        propHandle.removeItem(1);
        TabularCubeParserTest.checkNotificationStatus(listener);
        TabularCubeParserTest.assertEquals((String)"new cube user1", (String)propHandle.getStringValue());
        this.designHandle.getCommandStack().undo();
        TabularCubeParserTest.checkNotificationStatus(listener);
        TabularCubeParserTest.assertEquals((String)"new cube user1; new cube user2", (String)propHandle.getStringValue());
        propHandle.removeItem((Object)"new cube user1");
        TabularCubeParserTest.checkNotificationStatus(listener);
        TabularCubeParserTest.assertEquals((String)"new cube user2", (String)propHandle.getStringValue());
        accessControl.addRole("new cube role1");
        TabularCubeParserTest.checkNotificationStatus(listener);
        accessControl.removeRole("new cube role1");
        TabularCubeParserTest.checkNotificationStatus(listener);
        accessControl.setPermission("allow");
        TabularCubeParserTest.checkNotificationStatus(listener);
        accessControl = this.designHandle.getElementFactory().newAccessControl();
        cube.add("accessControls", (DesignElementHandle)accessControl);
        TabularCubeParserTest.checkNotificationStatus(listener);
        propHandle = cube.getPropertyHandle("accessControls");
        propHandle.drop(0);
        TabularCubeParserTest.checkNotificationStatus(listener);
        TabularCubeParserTest.assertEquals((int)1, (int)cube.getListProperty("accessControls").size());
        this.openDesign("CubeParserTest_3.xml");
        cube = (TabularCubeHandle)this.designHandle.findCube("testCube1");
        cube.addListener((Listener)listener);
        Iterator cubeAccess = cube.accessControlsIterator();
        AccessControlHandle tmpAccess = (AccessControlHandle)cubeAccess.next();
        tmpAccess.setPermission("allow");
        TabularCubeParserTest.checkNotificationStatus(listener);
    }

    public void testContentElementCommandOnCube() throws Exception {
        this.openDesign("CubeParserTest_3.xml");
        TabularCubeHandle cube = (TabularCubeHandle)this.designHandle.findCube("testCube1");
        Iterator cubeAccess = cube.accessControlsIterator();
        AccessControlHandle tmpAccess = (AccessControlHandle)cubeAccess.next();
        tmpAccess.setPermission("allow");
        this.save();
        TabularCubeParserTest.assertTrue((boolean)this.compareFile("TabularCubeAccessControl_golden_1.xml"));
        this.designHandle.getCommandStack().undo();
        this.save();
        TabularCubeParserTest.assertTrue((boolean)this.compareFile("TabularCubeAccessControl_golden_2.xml"));
        tmpAccess.addRole("new 2nd role");
        this.save();
        TabularCubeParserTest.assertTrue((boolean)this.compareFile("TabularCubeAccessControl_golden_3.xml"));
        this.designHandle.getCommandStack().undo();
        tmpAccess.removeRole("cube role1");
        this.save();
        TabularCubeParserTest.assertTrue((boolean)this.compareFile("TabularCubeAccessControl_golden_4.xml"));
        this.designHandle.getCommandStack().undo();
        tmpAccess.removeRole("cube role1");
        tmpAccess.setPermission("allow");
        this.save();
        TabularCubeParserTest.assertTrue((boolean)this.compareFile("TabularCubeAccessControl_golden_5.xml"));
    }

    public void testContentElementCommandOnLevel() throws Exception {
        this.openDesign("CubeParserTest_3.xml");
        TabularLevelHandle cube = (TabularLevelHandle)this.designHandle.findLevel("testDimension/testLevel");
        Iterator cubeAccess = cube.valueAccessControlsIterator();
        ValueAccessControlHandle tmpAccess = (ValueAccessControlHandle)cubeAccess.next();
        tmpAccess.setPermission("allow");
        this.save();
        TabularCubeParserTest.assertTrue((boolean)this.compareFile("TabularLevelAccessControl_golden_1.xml"));
        this.designHandle.getCommandStack().undo();
        this.save();
        TabularCubeParserTest.assertTrue((boolean)this.compareFile("TabularLevelAccessControl_golden_2.xml"));
        tmpAccess.addRole("new 2nd role");
        this.save();
        TabularCubeParserTest.assertTrue((boolean)this.compareFile("TabularLevelAccessControl_golden_3.xml"));
        this.designHandle.getCommandStack().undo();
        tmpAccess.removeRole("level role1");
        this.save();
        TabularCubeParserTest.assertTrue((boolean)this.compareFile("TabularLevelAccessControl_golden_4.xml"));
    }

    public void testMergeDimensionConditions() throws Exception {
        this.openDesign("CubeParserTest_4.xml");
        TabularCubeHandle cube = (TabularCubeHandle)this.designHandle.findCube("testCube");
        TabularCubeParserTest.assertNotNull((Object)cube.findDimensionCondition("testHierarchy"));
        TabularCubeParserTest.assertEquals((Object)cube.findDimensionCondition("testHierarchy").getStructure(), (Object)cube.findDimensionCondition((HierarchyHandle)this.design.findOLAPElement("testHierarchy").getHandle((Module)this.design)).getStructure());
        this.save();
        TabularCubeParserTest.assertTrue((boolean)this.compareFile("CubeParserTest_golden_3.xml"));
    }

    public void testClearStructureForElementRemove() throws Exception {
        this.openDesign("CubeParserTest.xml");
        LevelHandle levelHandle = this.designHandle.findLevel("testDimension/testLevel");
        levelHandle.dropAndClear();
        this.save();
        TabularCubeParserTest.assertTrue((boolean)this.compareFile("CubeParserTest_golden_4.xml"));
    }

    private static void checkNotificationStatus(MyListener listener) {
        TabularCubeParserTest.assertEquals((int)5, (int)listener.getEventType());
        TabularCubeParserTest.assertEquals((String)"accessControls", (String)listener.getPropName());
        listener.reset();
    }

    private static class MyListener
    implements Listener {
        private String propName = null;
        private int eventType = -1;

        public void elementChanged(DesignElementHandle focus, NotificationEvent ev) {
            this.eventType = ev.getEventType();
            assert (this.eventType == 5);
            this.propName = ((PropertyEvent)ev).getPropertyName();
        }

        MyListener() {
        }

        String getPropName() {
            return this.propName;
        }

        int getEventType() {
            return this.eventType;
        }

        void reset() {
            this.propName = null;
            this.eventType = -1;
        }
    }
}

