/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import java.util.List;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.ErrorDetail;
import org.eclipse.birt.report.model.api.ListHandle;
import org.eclipse.birt.report.model.api.command.UserPropertyException;
import org.eclipse.birt.report.model.api.core.UserPropertyDefn;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.birt.report.model.api.metadata.IStructureDefn;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.MultiElementSlot;
import org.eclipse.birt.report.model.elements.ListItem;
import org.eclipse.birt.report.model.metadata.ElementRefPropertyType;
import org.eclipse.birt.report.model.metadata.ExtendsPropertyType;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.PropertyType;
import org.eclipse.birt.report.model.metadata.StructPropertyDefn;
import org.eclipse.birt.report.model.metadata.StructPropertyType;
import org.eclipse.birt.report.model.metadata.StructRefPropertyType;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class UserPropertyTest
extends BaseTestCase {
    protected void setUp() throws Exception {
        super.setUp();
        this.openDesign("UserPropertyTest.xml");
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testHandlerError() {
        try {
            this.openDesign("UserPropertyTest_1.xml");
        }
        catch (DesignFileException e) {
            UserPropertyTest.assertEquals((int)4, (int)e.getErrorList().size());
            int i = 0;
            UserPropertyTest.assertEquals((String)"Error.UserPropertyException.DUPLICATE_NAME", (String)((ErrorDetail)e.getErrorList().get(i++)).getErrorCode());
            UserPropertyTest.assertEquals((String)"Error.UserPropertyException.CHOICE_VALUE_REQUIRED", (String)((ErrorDetail)e.getErrorList().get(i++)).getErrorCode());
            UserPropertyTest.assertEquals((String)"Error.DesignParserException.UNDEFINED_PROPERTY", (String)((ErrorDetail)e.getErrorList().get(i++)).getErrorCode());
            UserPropertyTest.assertEquals((String)"Error.DesignParserException.UNDEFINED_PROPERTY", (String)((ErrorDetail)e.getErrorList().get(i++)).getErrorCode());
        }
    }

    public void testWrite() throws Exception {
        this.openDesign("UserPropertyTest.xml");
        ListHandle listHandle = (ListHandle)this.designHandle.getComponents().get(0);
        List properties = listHandle.getUserProperties();
        UserPropertyDefn userPropDefn = (UserPropertyDefn)properties.get(0);
        UserPropertyTest.assertTrue((boolean)userPropDefn.isVisible());
        userPropDefn.setVisible(false);
        UserPropertyTest.assertFalse((boolean)userPropDefn.isVisible());
        this.save();
        UserPropertyTest.assertTrue((boolean)this.compareFile("UserPropertyTest_golden.xml"));
    }

    public void testParserIsVisible() throws Exception {
        this.openDesign("UserPropertyTest_2.xml");
        ListHandle listHandle = (ListHandle)this.designHandle.getComponents().get(0);
        List properties = listHandle.getUserProperties();
        UserPropertyDefn userPropDefn = (UserPropertyDefn)properties.get(0);
        UserPropertyTest.assertFalse((boolean)userPropDefn.isVisible());
    }

    public void testProperties() throws Exception {
        UserPropertyDefn prop = new UserPropertyDefn();
        IStructureDefn structDefn = prop.getStructDefn();
        StructPropertyDefn memberDefn = (StructPropertyDefn)structDefn.getMember("name");
        prop.setProperty((PropertyDefn)memberDefn, (Object)"new name");
        UserPropertyTest.assertEquals((Object)"new name", (Object)prop.getProperty(null, (PropertyDefn)memberDefn));
        memberDefn = (StructPropertyDefn)structDefn.getMember("type");
        prop.setProperty((PropertyDefn)memberDefn, (Object)"boolean");
        UserPropertyTest.assertEquals((Object)"boolean", (Object)prop.getProperty(null, (PropertyDefn)memberDefn));
        memberDefn = (StructPropertyDefn)structDefn.getMember("displayName");
        prop.setProperty((PropertyDefn)memberDefn, (Object)"new display name");
        UserPropertyTest.assertEquals((Object)"new display name", (Object)prop.getProperty(null, (PropertyDefn)memberDefn));
        memberDefn = (StructPropertyDefn)structDefn.getMember("displayNameID");
        prop.setProperty((PropertyDefn)memberDefn, (Object)"new display name id");
        UserPropertyTest.assertEquals((Object)"new display name id", (Object)prop.getProperty(null, (PropertyDefn)memberDefn));
    }

    public void testHandler() throws Exception {
        this.openDesign("UserPropertyTest.xml");
        MultiElementSlot lists = (MultiElementSlot)this.design.getSlot(5);
        UserPropertyTest.assertEquals((int)2, (int)lists.getCount());
        ListItem list = (ListItem)this.design.findElement("My List");
        UserPropertyTest.assertNotNull((Object)list);
        UserPropertyTest.assertEquals((int)7, (int)list.getUserProperties().size());
        List userProperties = list.getUserProperties();
        UserPropertyTest.assertEquals((String)"myProp", (String)((UserPropertyDefn)userProperties.get(0)).getName());
        UserPropertyTest.assertEquals((String)"myProp1", (String)((UserPropertyDefn)userProperties.get(1)).getName());
        UserPropertyTest.assertEquals((String)"myProp5", (String)((UserPropertyDefn)userProperties.get(2)).getName());
        UserPropertyTest.assertEquals((String)"myProp6", (String)((UserPropertyDefn)userProperties.get(3)).getName());
        UserPropertyTest.assertEquals((String)"myProp3", (String)((UserPropertyDefn)userProperties.get(4)).getName());
        UserPropertyTest.assertEquals((String)"myProp2", (String)((UserPropertyDefn)userProperties.get(5)).getName());
        UserPropertyTest.assertEquals((String)"parentProp", (String)((UserPropertyDefn)userProperties.get(6)).getName());
        UserPropertyDefn propDefn = list.getUserPropertyDefn("myProp1");
        UserPropertyTest.assertNotNull((Object)propDefn);
        UserPropertyTest.assertEquals((String)"string", (String)propDefn.getType().getName());
        UserPropertyTest.assertEquals((String)"abcde", (String)propDefn.getDisplayNameID());
        propDefn = list.getUserPropertyDefn("myProp2");
        UserPropertyTest.assertNotNull((Object)propDefn);
        UserPropertyTest.assertEquals((String)"choice", (String)propDefn.getType().getName());
        UserPropertyTest.assertEquals((String)"abc", (String)propDefn.getDisplayNameID());
        IChoiceSet choiceSet = propDefn.getChoices();
        UserPropertyTest.assertNotNull((Object)choiceSet);
        IChoice[] choices = choiceSet.getChoices();
        UserPropertyTest.assertEquals((int)3, (int)choices.length);
        UserPropertyDefn prop = new UserPropertyDefn();
        prop.setName("test");
        PropertyType typeDefn = MetaDataDictionary.getInstance().getPropertyType("elementRef");
        prop.setType(typeDefn);
        try {
            list.getHandle((Module)this.design).addUserPropertyDefn(prop);
        }
        catch (UserPropertyException e) {
            UserPropertyTest.assertEquals((String)"Error.UserPropertyException.INVALID_TYPE", (String)e.getErrorCode());
        }
    }

    public void testGetAllowedType() throws Exception {
        UserPropertyTest.assertTrue((!UserPropertyDefn.getAllowedTypes().contains(new StructRefPropertyType()) ? 1 : 0) != 0);
        UserPropertyTest.assertTrue((!UserPropertyDefn.getAllowedTypes().contains(new ElementRefPropertyType()) ? 1 : 0) != 0);
        UserPropertyTest.assertTrue((!UserPropertyDefn.getAllowedTypes().contains(new StructPropertyType()) ? 1 : 0) != 0);
        UserPropertyTest.assertTrue((!UserPropertyDefn.getAllowedTypes().contains(new ExtendsPropertyType()) ? 1 : 0) != 0);
    }
}

