/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.model.activity.EventFilter;
import org.eclipse.birt.report.model.activity.FilterConditionFactory;
import org.eclipse.birt.report.model.activity.IFilterCondition;
import org.eclipse.birt.report.model.activity.NotificationRecordTask;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.command.ContentEvent;
import org.eclipse.birt.report.model.api.command.ElementDeletedEvent;
import org.eclipse.birt.report.model.api.command.PropertyEvent;
import org.eclipse.birt.report.model.core.CoreTestUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.elements.Cell;
import org.eclipse.birt.report.model.elements.GridItem;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.elements.TableRow;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class EventFilterTest
extends BaseTestCase {
    EventFilter filter = null;
    ReportDesign design = null;
    GridItem grid = null;
    TableRow row = null;
    Cell cell1 = null;
    Cell cell2 = null;

    protected void setUp() throws Exception {
        ArrayList<IFilterCondition> conds = new ArrayList<IFilterCondition>();
        conds.add(FilterConditionFactory.createFilterCondition((int)1));
        conds.add(FilterConditionFactory.createFilterCondition((int)0));
        conds.add(FilterConditionFactory.createFilterCondition((int)2));
        this.filter = new EventFilter(conds);
        this.design = new ReportDesign(null);
        this.grid = new GridItem();
        this.row = new TableRow();
        CoreTestUtil.setContainer((DesignElement)this.row, (DesignElement)this.grid, (int)1);
        this.cell1 = new Cell();
        CoreTestUtil.setContainer((DesignElement)this.cell1, (DesignElement)this.row, (int)0);
        this.cell2 = new Cell();
        CoreTestUtil.setContainer((DesignElement)this.cell2, (DesignElement)this.row, (int)0);
    }

    public void testFilter_ElementDeleted() {
        ArrayList<NotificationRecordTask> chain = new ArrayList<NotificationRecordTask>();
        chain.add(new NotificationRecordTask((DesignElement)this.cell1, (NotificationEvent)new ElementDeletedEvent((DesignElement)this.row, (DesignElement)this.cell1)));
        chain.add(new NotificationRecordTask((DesignElement)this.cell2, (NotificationEvent)new ElementDeletedEvent((DesignElement)this.row, (DesignElement)this.cell2)));
        chain.add(new NotificationRecordTask((DesignElement)this.row, (NotificationEvent)new ElementDeletedEvent((DesignElement)this.grid, (DesignElement)this.row)));
        chain.add(new NotificationRecordTask((DesignElement)this.grid, (NotificationEvent)new ElementDeletedEvent((DesignElement)this.design, (DesignElement)this.grid)));
        chain.add(new NotificationRecordTask((DesignElement)this.row, (NotificationEvent)new ContentEvent((DesignElement)this.row, (DesignElement)this.cell1, 0, 2)));
        chain.add(new NotificationRecordTask((DesignElement)this.row, (NotificationEvent)new ContentEvent((DesignElement)this.row, (DesignElement)this.cell2, 0, 2)));
        chain.add(new NotificationRecordTask((DesignElement)this.grid, (NotificationEvent)new ContentEvent((DesignElement)this.grid, (DesignElement)this.row, 1, 2)));
        chain.add(new NotificationRecordTask((DesignElement)this.design, (NotificationEvent)new ContentEvent((DesignElement)this.design, (DesignElement)this.grid, 6, 2)));
        chain.add(new NotificationRecordTask((DesignElement)this.cell1, (NotificationEvent)new PropertyEvent((DesignElement)this.cell1, "height")));
        chain.add(new NotificationRecordTask((DesignElement)this.cell2, (NotificationEvent)new PropertyEvent((DesignElement)this.cell2, "height")));
        chain.add(new NotificationRecordTask((DesignElement)this.row, (NotificationEvent)new PropertyEvent((DesignElement)this.row, "bookmark")));
        chain.add(new NotificationRecordTask((DesignElement)this.grid, (NotificationEvent)new PropertyEvent((DesignElement)this.grid, "dataSet")));
        EventFilterTest.assertEquals((int)12, (int)chain.size());
        List filteredEvents = this.filterTasks(this.filter.filter(chain));
        EventFilterTest.assertEquals((int)2, (int)filteredEvents.size());
        NotificationEvent ev1 = ((NotificationRecordTask)filteredEvents.get(0)).getEvent();
        EventFilterTest.assertTrue((boolean)(ev1 instanceof ElementDeletedEvent));
        EventFilterTest.assertEquals((Object)this.grid, (Object)ev1.getTarget());
        NotificationEvent ev2 = ((NotificationRecordTask)filteredEvents.get(1)).getEvent();
        EventFilterTest.assertTrue((boolean)(ev2 instanceof ContentEvent));
        EventFilterTest.assertEquals((Object)this.design, (Object)ev2.getTarget());
        EventFilterTest.assertEquals((Object)this.grid, (Object)((ContentEvent)ev2).getContent());
    }

    public void testFilter_ElementAdded() {
        ReportDesign design = new ReportDesign(null);
        GridItem grid = new GridItem();
        TableRow row = new TableRow();
        CoreTestUtil.setContainer((DesignElement)row, (DesignElement)grid, (int)1);
        Cell cell1 = new Cell();
        CoreTestUtil.setContainer((DesignElement)cell1, (DesignElement)row, (int)0);
        Cell cell2 = new Cell();
        CoreTestUtil.setContainer((DesignElement)cell2, (DesignElement)row, (int)0);
        ArrayList<NotificationRecordTask> chain = new ArrayList<NotificationRecordTask>();
        chain.add(new NotificationRecordTask((DesignElement)row, (NotificationEvent)new ContentEvent((DesignElement)row, (DesignElement)cell1, 0, 1)));
        chain.add(new NotificationRecordTask((DesignElement)row, (NotificationEvent)new ContentEvent((DesignElement)row, (DesignElement)cell2, 0, 1)));
        chain.add(new NotificationRecordTask((DesignElement)grid, (NotificationEvent)new ContentEvent((DesignElement)grid, (DesignElement)row, 1, 1)));
        chain.add(new NotificationRecordTask((DesignElement)design, (NotificationEvent)new ContentEvent((DesignElement)design, (DesignElement)grid, 6, 1)));
        chain.add(new NotificationRecordTask((DesignElement)cell1, (NotificationEvent)new PropertyEvent((DesignElement)cell1, "height")));
        chain.add(new NotificationRecordTask((DesignElement)cell2, (NotificationEvent)new PropertyEvent((DesignElement)cell2, "height")));
        chain.add(new NotificationRecordTask((DesignElement)row, (NotificationEvent)new PropertyEvent((DesignElement)row, "bookmark")));
        chain.add(new NotificationRecordTask((DesignElement)grid, (NotificationEvent)new PropertyEvent((DesignElement)grid, "dataSet")));
        EventFilterTest.assertEquals((int)8, (int)chain.size());
        List filteredEvents = this.filterTasks(this.filter.filter(chain));
        EventFilterTest.assertEquals((int)1, (int)filteredEvents.size());
        NotificationEvent ev1 = ((NotificationRecordTask)filteredEvents.get(0)).getEvent();
        EventFilterTest.assertTrue((boolean)(ev1 instanceof ContentEvent));
        EventFilterTest.assertEquals((Object)design, (Object)ev1.getTarget());
        EventFilterTest.assertEquals((Object)grid, (Object)((ContentEvent)ev1).getContent());
    }

    private List filterTasks(List chain) {
        ArrayList<NotificationRecordTask> filteredEvents = new ArrayList<NotificationRecordTask>();
        int i = 0;
        while (i < chain.size()) {
            NotificationRecordTask task = (NotificationRecordTask)chain.get(i);
            if (!task.isFiltered()) {
                filteredEvents.add(task);
            }
            ++i;
        }
        return filteredEvents;
    }
}

