/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.validators;

import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DimensionHandle;
import org.eclipse.birt.report.model.api.SimpleMasterPageHandle;
import org.eclipse.birt.report.model.api.validators.IValidationListener;
import org.eclipse.birt.report.model.api.validators.MasterPageSizeValidator;
import org.eclipse.birt.report.model.api.validators.MasterPageTypeValidator;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.validators.ValidatorTestCase;

public class MasterPageSizeValidatorTest
extends ValidatorTestCase {
    ValidatorTestCase.MyListener listener = new ValidatorTestCase.MyListener(this);

    public void testTriggers() throws Exception {
        this.createDesign();
        MetaDataDictionary.getInstance().setUseValidationTrigger(true);
        SimpleMasterPageHandle pageHandle = this.designHandle.getElementFactory().newSimpleMasterPage("masterPage1");
        this.designHandle.getMasterPages().add((DesignElementHandle)pageHandle);
        this.designHandle.addValidationListener((IValidationListener)this.listener);
        DimensionHandle marginLeft = pageHandle.getLeftMargin();
        marginLeft.setStringValue("10in");
        MasterPageSizeValidatorTest.assertTrue((boolean)this.listener.hasError((DesignElementHandle)pageHandle, MasterPageSizeValidator.getInstance().getName(), "Error.SemanticError.INVALID_PAGE_MARGINS"));
        marginLeft.setStringValue("1in");
        MasterPageSizeValidatorTest.assertFalse((boolean)this.listener.hasError((DesignElementHandle)pageHandle, MasterPageSizeValidator.getInstance().getName(), "Error.SemanticError.INVALID_PAGE_MARGINS"));
        pageHandle.setPageType("custom");
        MasterPageSizeValidatorTest.assertTrue((boolean)this.listener.hasError((DesignElementHandle)pageHandle, MasterPageTypeValidator.getInstance().getName(), "Error.SemanticError.MISSING_PAGE_SIZE"));
        DimensionHandle height = pageHandle.getHeight();
        height.setStringValue("15in");
        MasterPageSizeValidatorTest.assertTrue((boolean)this.listener.hasError((DesignElementHandle)pageHandle, MasterPageTypeValidator.getInstance().getName(), "Error.SemanticError.MISSING_PAGE_SIZE"));
        DimensionHandle width = pageHandle.getWidth();
        width.setStringValue("10in");
        MasterPageSizeValidatorTest.assertFalse((boolean)this.listener.hasError((DesignElementHandle)pageHandle, MasterPageTypeValidator.getInstance().getName(), "Error.SemanticError.MISSING_PAGE_SIZE"));
        DimensionHandle marginBottom = pageHandle.getBottomMargin();
        marginBottom.setStringValue("15in");
        MasterPageSizeValidatorTest.assertTrue((boolean)this.listener.hasError((DesignElementHandle)pageHandle, MasterPageSizeValidator.getInstance().getName(), "Error.SemanticError.INVALID_PAGE_MARGINS"));
    }
}

