/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.validators;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ErrorDetail;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.api.validators.IValidationListener;
import org.eclipse.birt.report.model.api.validators.ValidationEvent;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.util.BaseTestCase;

public abstract class ValidatorTestCase
extends BaseTestCase {

    class ErrorPool {
        private List errors = new ArrayList();

        ErrorPool() {
        }

        void updateErrorStatus(ValidationEvent event) {
            int i = this.errors.size() - 1;
            while (i >= 0) {
                ErrorDetail detail = (ErrorDetail)this.errors.get(i);
                if (event.getTarget() == detail.getElement() && detail.getValidationID().equalsIgnoreCase(event.getValidationID())) {
                    this.errors.remove(i);
                }
                --i;
            }
            for (ErrorDetail detail : event.getErrors()) {
                this.errors.add(detail);
            }
        }

        private boolean hasErrorFromValidation(DesignElement element, String validationID, String errorCode) {
            for (ErrorDetail detail : this.errors) {
                if (detail.getElement() != element || !detail.getValidationID().equalsIgnoreCase(validationID) || !detail.getErrorCode().equalsIgnoreCase(errorCode)) continue;
                return true;
            }
            return false;
        }
    }

    class MyListener
    implements IValidationListener {
        ErrorPool pool;

        MyListener() {
            this.pool = new ErrorPool();
        }

        public void elementValidated(DesignElementHandle focus, ValidationEvent ev) {
            this.pool.updateErrorStatus(ev);
        }

        protected boolean hasError(DesignElementHandle element, String validatorName, String errorCode) {
            return this.pool.hasErrorFromValidation(element.getElement(), validatorName, errorCode);
        }

        protected boolean hasError(DesignElementHandle element, String validatorName, String propName, String errorCode) {
            String validationID = validatorName;
            if (!StringUtil.isBlank((String)propName)) {
                validationID = String.valueOf(validatorName) + "." + propName;
            }
            return this.pool.hasErrorFromValidation(element.getElement(), validationID, errorCode);
        }
    }
}

