/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.writer;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.FilterConditionElementHandle;
import org.eclipse.birt.report.model.api.GroupHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.css.CssStyleSheetHandle;
import org.eclipse.birt.report.model.api.util.DocumentUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.ElementVisitor;
import org.eclipse.birt.report.model.elements.ExtendedItem;
import org.eclipse.birt.report.model.util.BaseTestCase;
import org.eclipse.birt.report.model.util.ReportDesignSerializer;

public class DocumentUtilTest
extends BaseTestCase {
    private static final String DESIGN_WITH_ELEMENT_EXTENDS = "DocumentUtilTest.xml";
    private static final String DESIGN_WITH_STRUCTURE_REFERENCE = "DocumentUtilTest_1.xml";
    private static final String DESIGN_WITH_INDIRECT_REFERENCE = "DocumentUtilTest_2.xml";
    private static final String DESIGN_WITH_SHARED_STYLE = "DocumentUtilTest_3.xml";
    private static final String DESIGN_WITH_EXTERNAL_SELECTORS = "DocumentUtilTest_4.xml";
    private static final String DESIGN_WITH_CUBE_EXTENDS = "DocumentUtilTest_5.xml";
    private static final String DESIGN_WITH_TESTING_TABLE_EXTENDS = "DocumentUtilTest_6.xml";
    private static final String DESIGN_WITH_FILTER_ELEMENT = "DocumentUtilTest_7.xml";
    private static final String DESIGN_WITH_CSS_STYLES = "DocumentUtilTest_8.xml";

    public void testSerializeWithElementExtends() throws Exception {
        this.openDesign(DESIGN_WITH_ELEMENT_EXTENDS);
        DocumentUtilTest.assertNotNull((Object)this.designHandle);
        this.serializeDocument();
        DocumentUtilTest.assertTrue((boolean)this.compareFile("DocumentUtilTest_golden.xml"));
    }

    public void testSerializeWithLibReference() throws Exception {
        this.openDesign(DESIGN_WITH_STRUCTURE_REFERENCE);
        DocumentUtilTest.assertNotNull((Object)this.designHandle);
        this.serializeDocument();
        DocumentUtilTest.assertTrue((boolean)this.compareFile("DocumentUtilTest_golden_1.xml"));
    }

    public void testSerializeWithIndirectRef() throws Exception {
        this.openDesign(DESIGN_WITH_INDIRECT_REFERENCE);
        DocumentUtilTest.assertNotNull((Object)this.designHandle);
        this.serializeDocument();
        DocumentUtilTest.assertTrue((boolean)this.compareFile("DocumentUtilTest_golden_2.xml"));
    }

    public void testTemplate() throws Exception {
        this.openDesign("TemplateElementParserTest.xml");
        DocumentUtilTest.assertNotNull((Object)this.designHandle);
        this.serializeDocument();
        DocumentUtilTest.assertTrue((boolean)this.compareFile("DocumentUtilTest_golden_3.xml"));
    }

    public void testSerializeWithEmbeddedImage() throws Exception {
        String string = "TestSerializeEmbeddeImage.xml";
        this.openDesign(string);
        DocumentUtilTest.assertNotNull((Object)this.designHandle);
        this.serializeDocument();
        DocumentUtilTest.assertTrue((boolean)this.compareFile("DocumentUtilTest_golden_4.xml"));
    }

    public void testSerializeExternalString() throws Exception {
        this.openDesign("DocumnetUtilTest_ExternalResource.xml");
        DocumentUtilTest.assertNotNull((Object)this.designHandle);
        this.serializeDocument();
        DocumentUtilTest.assertTrue((boolean)this.compareFile("DocumentUtilTest_golden_5.xml"));
    }

    public void testExtendedItem() throws Exception {
        this.openDesign("DocumentUtilTest_ExtendedItem.xml");
        DocumentUtilTest.assertNotNull((Object)this.designHandle);
        this.serializeDocument();
        ExtendedItemHandle matrix1 = (ExtendedItemHandle)this.designHandle.findElement("matrix1");
        DocumentUtilTest.assertNotNull((Object)((ExtendedItem)matrix1.getElement()).getExtDefn());
        DocumentUtilTest.assertTrue((boolean)this.compareFile("DocumentUtilTest_golden_6.xml"));
    }

    public void testGroup() throws Exception {
        this.openDesign("DocumentUtilTest_Group.xml");
        this.serializeDocument();
        TableHandle tableHandle = (TableHandle)this.designHandle.getBody().get(0);
        GroupHandle groupHandle = (GroupHandle)tableHandle.getGroups().get(0);
        DocumentUtilTest.assertEquals((String)"Year", (String)groupHandle.getName());
        groupHandle = (GroupHandle)tableHandle.getGroups().get(1);
        DocumentUtilTest.assertEquals((String)"Month", (String)groupHandle.getName());
    }

    public void testUserProperty() throws Exception {
        this.openDesign("DocumentUtilTest_UserProperty.xml");
        this.serializeDocument();
        DocumentUtilTest.assertEquals((Object)"1.0", (Object)this.designHandle.getProperty("version"));
        LabelHandle labelHandle = (LabelHandle)this.designHandle.getBody().get(0);
        DocumentUtilTest.assertEquals((Object)"label 1.0", (Object)labelHandle.getProperty("version"));
        LabelHandle labelHandle1 = (LabelHandle)this.designHandle.getBody().get(1);
        DocumentUtilTest.assertEquals((Object)"2.0", (Object)labelHandle1.getProperty("version"));
        this.openDesign("DocumentUtilTest_UserProperty1.xml");
        this.serializeDocument();
        DocumentUtilTest.assertTrue((boolean)this.compareFile("DocumentUtilTest_UserProperty1_golden.xml"));
    }

    private void serializeDocument() throws Exception {
        this.os = new ByteArrayOutputStream();
        ReportDesignSerializer visitor = new ReportDesignSerializer();
        this.designHandle.getModule().apply((ElementVisitor)visitor);
        this.design = visitor.getTarget();
        this.designHandle = (ReportDesignHandle)this.design.getHandle((Module)this.design);
        this.designHandle.serialize((OutputStream)this.os);
    }

    private void serializeNonLineBreakDocument() throws Exception {
        this.os = new ByteArrayOutputStream();
        DocumentUtil.serialize((ReportDesignHandle)this.designHandle, (OutputStream)this.os);
    }

    public void testSerializeWithSharedStyle() throws Exception {
        this.openDesign(DESIGN_WITH_SHARED_STYLE);
        DocumentUtilTest.assertNotNull((Object)this.designHandle);
        this.serializeDocument();
        DocumentUtilTest.assertTrue((boolean)this.compareFile("DocumentUtilTest_shared_style_golden.xml"));
    }

    public void testSerializeWithElementProps() throws Exception {
        this.openDesign("DocumentUtilTest_ElementProps.xml");
        DocumentUtilTest.assertNotNull((Object)this.designHandle);
        this.serializeDocument();
        DocumentUtilTest.assertTrue((boolean)this.compareFile("DocumentUtilTest_ElementProps_golden.xml"));
    }

    public void testParserForSerializer() throws Exception {
        this.openDesign("DocumentUtilTest_parser.xml");
        DocumentUtilTest.assertNotNull((Object)this.designHandle);
    }

    public void testSerializeExternalSelectors() throws Exception {
        this.openDesign(DESIGN_WITH_EXTERNAL_SELECTORS);
        DocumentUtilTest.assertNotNull((Object)this.designHandle);
        this.serializeDocument();
        DesignElement localizedStyle = this.design.getNameHelper().getNameSpace(0).getElement("table-footer");
        DocumentUtilTest.assertNotNull((Object)localizedStyle);
        DocumentUtilTest.assertTrue((boolean)this.compareFile("DocumentUtilTest_external_selectors_golden.xml"));
    }

    public void testCubeAndCrosstable() throws Exception {
        this.openDesign(DESIGN_WITH_CUBE_EXTENDS);
        this.serializeDocument();
        DocumentUtilTest.assertTrue((boolean)this.compareFile("DocumentUtilTest_extends_cube_golden.xml"));
    }

    public void testCubeAndCrosstable1() throws Exception {
        this.openDesign(DESIGN_WITH_TESTING_TABLE_EXTENDS);
        this.serializeDocument();
        DocumentUtilTest.assertTrue((boolean)this.compareFile("DocumentUtilTest_extends_testingtable_golden.xml"));
    }

    public void testFilterElement() throws Exception {
        this.openDesign(DESIGN_WITH_FILTER_ELEMENT);
        this.serializeDocument();
        DocumentUtilTest.assertTrue((boolean)this.compareFile("DocumentUtilTest_filter_element_golden.xml"));
    }

    public void testLocalCssStyles() throws Exception {
        this.openDesign(DESIGN_WITH_CSS_STYLES);
        this.serializeDocument();
        List sheets = this.designHandle.getAllCssStyleSheets();
        DocumentUtilTest.assertEquals((int)1, (int)sheets.size());
        CssStyleSheetHandle sheet = (CssStyleSheetHandle)sheets.get(0);
        Iterator styles = sheet.getStyleIterator();
        int count = 0;
        while (styles.hasNext()) {
            styles.next();
            ++count;
        }
        DocumentUtilTest.assertEquals((int)5, (int)count);
        DocumentUtilTest.assertNotNull((Object)this.designHandle.getSystemId());
        DocumentUtilTest.assertNotNull((Object)this.designHandle.getFileName());
    }

    public void testSerializeWithElementRefer() throws Exception {
        this.openDesign("DocumentUtilTest_9.xml");
        this.serializeDocument();
        DocumentUtilTest.assertTrue((boolean)this.compareFile("DocumentUtilTest_golden_7.xml"));
    }

    public void testSerializeExternalPropertyBindings() throws Exception {
        this.openDesign("DocumentUtilTest_PropBindings.xml");
        this.serializeDocument();
        DocumentUtilTest.assertTrue((boolean)this.compareFile("DocumentUtilTest_propBindings_golden.xml"));
    }

    public void testLocalTranslationTable() throws Exception {
        this.openDesign("DocumentUtilTest_10.xml");
        this.serializeDocument();
        DocumentUtilTest.assertTrue((boolean)this.compareFile("DocumentUtilTest_golden_8.xml"));
    }

    public void testFlattenReportWithoutScriptLib() throws Exception {
        this.openDesign("DocumentUtilTest_11.xml");
        this.serializeDocument();
        DocumentUtilTest.assertTrue((boolean)this.compareFile("DocumentUtilTest_golden_11.xml"));
    }

    public void testFlattenReportWithScriptLib() throws Exception {
        this.openDesign("DocumentUtilTest_12.xml");
        this.serializeDocument();
        DocumentUtilTest.assertTrue((boolean)this.compareFile("DocumentUtilTest_golden_12.xml"));
    }

    public void testFlattenReportWithIncludedResource() throws Exception {
        this.openDesign("DocumentUtilTest_13.xml");
        this.serializeDocument();
        DocumentUtilTest.assertTrue((boolean)this.compareFile("DocumentUtilTest_golden_13.xml"));
        this.openDesign("DocumentUtilTest_14.xml");
        this.serializeDocument();
        DocumentUtilTest.assertTrue((boolean)this.compareFile("DocumentUtilTest_golden_14.xml"));
    }

    public void testFlattenReport() throws Exception {
        this.openDesign("DocumentUtilTest_15.xml");
        this.designHandle = (ReportDesignHandle)this.designHandle.copy().getHandle(null);
        this.serializeDocument();
        DesignElementHandle handle = this.designHandle.getElementByID(19L);
        List list = (List)handle.getProperty("filter");
        FilterConditionElementHandle elementHandle = (FilterConditionElementHandle)list.get(0);
        DocumentUtilTest.assertTrue((elementHandle.getElement().getContainer() != null ? 1 : 0) != 0);
        DocumentUtilTest.assertTrue((boolean)this.compareFile("DocumentUtilTest_golden_15.xml"));
    }

    public void testUpdateOLAPElementNames() throws Exception {
        this.openDesign("DocumentUtilTest_OLAPBindings.xml");
        this.serializeDocument();
        DocumentUtilTest.assertTrue((boolean)this.compareFile("DocumentUtilTest_OLAPBindings_golden.xml"));
    }

    public void testExternalHostElements() throws Exception {
        this.openDesign("DocumentUtilTest_hostElements.xml");
        this.serializeDocument();
        DocumentUtilTest.assertTrue((boolean)this.compareFile("DocumentUtilTest_hostElements_golden.xml"));
    }

    public void testFlattenPageBreakInterval() throws Exception {
        this.openDesign("DocumentUtilTest_PageBreakInterval.xml");
        this.serializeDocument();
        DocumentUtilTest.assertTrue((boolean)this.compareFile("DocumentUtilTest_PageBreakInterval_golden.xml"));
        this.openDesign("DocumentUtilTest_PageBreakInterval_1.xml");
        this.serializeDocument();
        DocumentUtilTest.assertTrue((boolean)this.compareFile("DocumentUtilTest_PageBreakInterval_golden_1.xml"));
    }

    public void testVariableElements() throws Exception {
        this.openDesign("DocumentUtilTest_16.xml");
        this.serializeDocument();
        this.saveOutputFile("DocumentUtilTest_golden_16.xml");
    }

    protected void tearDown() throws Exception {
        this.designHandle = null;
        super.tearDown();
    }
}

