/*
 * Decompiled with CFR 0.152.
 */
package utility;

import java.io.File;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;

public class BaseTestCase
extends TestCase {
    protected static final String TEST_FOLDER = "src/";

    protected String getTestFolder() {
        return TEST_FOLDER;
    }

    protected String getClassFolder() {
        CodeSource source;
        String pathBase = null;
        ProtectionDomain domain = ((Object)((Object)this)).getClass().getProtectionDomain();
        if (domain != null && (source = domain.getCodeSource()) != null) {
            URL url = source.getLocation();
            pathBase = url.getPath();
            if (pathBase.endsWith("bin/")) {
                pathBase = pathBase.substring(0, pathBase.length() - 4);
            }
            if (pathBase.endsWith("bin")) {
                pathBase = pathBase.substring(0, pathBase.length() - 3);
            }
        }
        pathBase = String.valueOf(pathBase) + this.getTestFolder();
        String className = ((Object)((Object)this)).getClass().getName();
        int lastDotIndex = className.lastIndexOf(".");
        className = className.substring(0, lastDotIndex);
        className = String.valueOf(pathBase) + className.replace('.', '/');
        return className;
    }

    protected List getClasses(String packageName) {
        ArrayList<String> classes = new ArrayList<String>();
        String pkgFolder = String.valueOf(this.getClassFolder()) + "/" + packageName.substring(packageName.lastIndexOf(46) + 1);
        File directory = new File(pkgFolder);
        if (directory.exists()) {
            String[] files = directory.list();
            int i = 0;
            while (i < files.length) {
                if (files[i].endsWith(".java")) {
                    classes.add(String.valueOf(packageName) + "." + files[i].substring(0, files[i].length() - 5));
                }
                ++i;
            }
        }
        return classes;
    }
}

