/*
 * Decompiled with CFR 0.152.
 */
package utility;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Method;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import utility.ParserWrapper;

public class DomWriter {
    protected static final String NAMESPACES_FEATURE_ID = "http://xml.org/sax/features/namespaces";
    protected static final String VALIDATION_FEATURE_ID = "http://xml.org/sax/features/validation";
    protected static final String SCHEMA_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/schema";
    protected static final String SCHEMA_FULL_CHECKING_FEATURE_ID = "http://apache.org/xml/features/validation/schema-full-checking";
    protected static final String HONOUR_ALL_SCHEMA_LOCATIONS_ID = "http://apache.org/xml/features/honour-all-schemaLocations";
    protected static final String VALIDATE_ANNOTATIONS_ID = "http://apache.org/xml/features/validate-annotations";
    protected static final String GENERATE_SYNTHETIC_ANNOTATIONS_ID = "http://apache.org/xml/features/generate-synthetic-annotations";
    protected static final String DYNAMIC_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/dynamic";
    protected static final String LOAD_EXTERNAL_DTD_FEATURE_ID = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
    protected static final String XINCLUDE_FEATURE_ID = "http://apache.org/xml/features/xinclude";
    protected static final String XINCLUDE_FIXUP_BASE_URIS_FEATURE_ID = "http://apache.org/xml/features/xinclude/fixup-base-uris";
    protected static final String XINCLUDE_FIXUP_LANGUAGE_FEATURE_ID = "http://apache.org/xml/features/xinclude/fixup-language";
    protected static final String DEFAULT_PARSER_NAME = "dom.wrappers.Xerces";
    protected static final boolean DEFAULT_NAMESPACES = true;
    protected static final boolean DEFAULT_VALIDATION = false;
    protected static final boolean DEFAULT_LOAD_EXTERNAL_DTD = true;
    protected static final boolean DEFAULT_SCHEMA_VALIDATION = false;
    protected static final boolean DEFAULT_SCHEMA_FULL_CHECKING = false;
    protected static final boolean DEFAULT_HONOUR_ALL_SCHEMA_LOCATIONS = false;
    protected static final boolean DEFAULT_VALIDATE_ANNOTATIONS = false;
    protected static final boolean DEFAULT_GENERATE_SYNTHETIC_ANNOTATIONS = false;
    protected static final boolean DEFAULT_DYNAMIC_VALIDATION = false;
    protected static final boolean DEFAULT_XINCLUDE = false;
    protected static final boolean DEFAULT_XINCLUDE_FIXUP_BASE_URIS = true;
    protected static final boolean DEFAULT_XINCLUDE_FIXUP_LANGUAGE = true;
    protected static final boolean DEFAULT_CANONICAL = false;
    protected PrintWriter fOut;
    protected boolean fCanonical;
    protected boolean fXML11;

    public DomWriter() {
    }

    public DomWriter(boolean canonical) {
        this.fCanonical = canonical;
    }

    public void setCanonical(boolean canonical) {
        this.fCanonical = canonical;
    }

    public void setOutput(OutputStream stream, String encoding) throws UnsupportedEncodingException {
        if (encoding == null) {
            encoding = "UTF8";
        }
        OutputStreamWriter writer = new OutputStreamWriter(stream, encoding);
        this.fOut = new PrintWriter(writer);
    }

    public void setOutput(Writer writer) {
        this.fOut = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
    }

    public void write(Node node) {
        if (node == null) {
            return;
        }
        short type = node.getNodeType();
        switch (type) {
            case 9: {
                Document document = (Document)node;
                this.fXML11 = "1.1".equals(this.getVersion(document));
                if (!this.fCanonical) {
                    if (this.fXML11) {
                        this.fOut.println("<?xml version=\"1.1\" encoding=\"UTF-8\"?>");
                    } else {
                        this.fOut.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                    }
                    this.fOut.flush();
                    this.write(document.getDoctype());
                }
                this.write(document.getDocumentElement());
                break;
            }
            case 10: {
                DocumentType doctype = (DocumentType)node;
                this.fOut.print("<!DOCTYPE ");
                this.fOut.print(doctype.getName());
                String publicId = doctype.getPublicId();
                String systemId = doctype.getSystemId();
                if (publicId != null) {
                    this.fOut.print(" PUBLIC '");
                    this.fOut.print(publicId);
                    this.fOut.print("' '");
                    this.fOut.print(systemId);
                    this.fOut.print('\'');
                } else if (systemId != null) {
                    this.fOut.print(" SYSTEM '");
                    this.fOut.print(systemId);
                    this.fOut.print('\'');
                }
                String internalSubset = doctype.getInternalSubset();
                if (internalSubset != null) {
                    this.fOut.println(" [");
                    this.fOut.print(internalSubset);
                    this.fOut.print(']');
                }
                this.fOut.println('>');
                break;
            }
            case 1: {
                this.fOut.print('<');
                this.fOut.print(node.getNodeName());
                Attr[] attrs = this.sortAttributes(node.getAttributes());
                int i = 0;
                while (i < attrs.length) {
                    Attr attr = attrs[i];
                    this.fOut.print(' ');
                    this.fOut.print(attr.getNodeName());
                    this.fOut.print("=\"");
                    this.normalizeAndPrint(attr.getNodeValue(), true);
                    this.fOut.print('\"');
                    ++i;
                }
                this.fOut.print('>');
                this.fOut.flush();
                Node child = node.getFirstChild();
                while (child != null) {
                    this.write(child);
                    child = child.getNextSibling();
                }
                break;
            }
            case 5: {
                if (this.fCanonical) {
                    Node child = node.getFirstChild();
                    while (child != null) {
                        this.write(child);
                        child = child.getNextSibling();
                    }
                    break;
                }
                this.fOut.print('&');
                this.fOut.print(node.getNodeName());
                this.fOut.print(';');
                this.fOut.flush();
                break;
            }
            case 4: {
                if (this.fCanonical) {
                    this.normalizeAndPrint(node.getNodeValue(), false);
                } else {
                    this.fOut.print("<![CDATA[");
                    this.fOut.print(node.getNodeValue());
                    this.fOut.print("]]>");
                }
                this.fOut.flush();
                break;
            }
            case 3: {
                this.normalizeAndPrint(node.getNodeValue(), false);
                this.fOut.flush();
                break;
            }
            case 7: {
                this.fOut.print("<?");
                this.fOut.print(node.getNodeName());
                String data = node.getNodeValue();
                if (data != null && data.length() > 0) {
                    this.fOut.print(' ');
                    this.fOut.print(data);
                }
                this.fOut.print("?>");
                this.fOut.flush();
                break;
            }
            case 8: {
                if (this.fCanonical) break;
                this.fOut.print("<!--");
                String comment = node.getNodeValue();
                if (comment != null && comment.length() > 0) {
                    this.fOut.print(comment);
                }
                this.fOut.print("-->");
                this.fOut.flush();
            }
        }
        if (type == 1) {
            this.fOut.print("</");
            this.fOut.print(node.getNodeName());
            this.fOut.print('>');
            this.fOut.flush();
        }
    }

    protected Attr[] sortAttributes(NamedNodeMap attrs) {
        int len = attrs != null ? attrs.getLength() : 0;
        Attr[] array = new Attr[len];
        int i = 0;
        while (i < len) {
            array[i] = (Attr)attrs.item(i);
            ++i;
        }
        i = 0;
        while (i < len - 1) {
            String name = array[i].getNodeName();
            int index = i;
            int j = i + 1;
            while (j < len) {
                String curName = array[j].getNodeName();
                if (curName.compareTo(name) < 0) {
                    name = curName;
                    index = j;
                }
                ++j;
            }
            if (index != i) {
                Attr temp = array[i];
                array[i] = array[index];
                array[index] = temp;
            }
            ++i;
        }
        return array;
    }

    protected void normalizeAndPrint(String s, boolean isAttValue) {
        int len = s != null ? s.length() : 0;
        int i = 0;
        while (i < len) {
            char c = s.charAt(i);
            this.normalizeAndPrint(c, isAttValue);
            ++i;
        }
    }

    protected void normalizeAndPrint(char c, boolean isAttValue) {
        switch (c) {
            case '<': {
                this.fOut.print("&lt;");
                break;
            }
            case '>': {
                this.fOut.print("&gt;");
                break;
            }
            case '&': {
                this.fOut.print("&amp;");
                break;
            }
            case '\"': {
                if (isAttValue) {
                    this.fOut.print("&quot;");
                    break;
                }
                this.fOut.print("\"");
                break;
            }
            case '\r': {
                this.fOut.print("&#xD;");
                break;
            }
            case '\n': {
                if (this.fCanonical) {
                    this.fOut.print("&#xA;");
                    break;
                }
            }
            default: {
                if (this.fXML11 && (c >= '\u0001' && c <= '\u001f' && c != '\t' && c != '\n' || c >= '\u007f' && c <= '\u009f' || c == '\u2028') || isAttValue && (c == '\t' || c == '\n')) {
                    this.fOut.print("&#x");
                    this.fOut.print(Integer.toHexString(c).toUpperCase());
                    this.fOut.print(";");
                    break;
                }
                this.fOut.print(c);
            }
        }
    }

    protected String getVersion(Document document) {
        if (document == null) {
            return null;
        }
        String version = null;
        Method getXMLVersion = null;
        try {
            getXMLVersion = document.getClass().getMethod("getXmlVersion", new Class[0]);
            if (getXMLVersion != null) {
                version = (String)getXMLVersion.invoke((Object)document, null);
            }
        }
        catch (Exception exception) {}
        return version;
    }

    /*
     * Unable to fully structure code
     */
    public static void main(String[] argv) {
        if (argv.length == 0) {
            DomWriter.printUsage();
            System.exit(1);
        }
        writer = null;
        parser = null;
        namespaces = true;
        validation = false;
        externalDTD = true;
        schemaValidation = false;
        schemaFullChecking = false;
        honourAllSchemaLocations = false;
        validateAnnotations = false;
        generateSyntheticAnnotations = false;
        dynamicValidation = false;
        xincludeProcessing = false;
        xincludeFixupBaseURIs = true;
        xincludeFixupLanguage = true;
        canonical = false;
        i = 0;
        while (i < argv.length) {
            block69: {
                arg = argv[i];
                if (!arg.startsWith("-")) ** GOTO lbl-1000
                option = arg.substring(1);
                if (option.equals("p")) {
                    if (++i == argv.length) {
                        System.err.println("error: Missing argument to -p option.");
                    }
                    parserName = argv[i];
                    try {
                        parser = (ParserWrapper)Class.forName(parserName).newInstance();
                    }
                    catch (Exception v0) {
                        parser = null;
                        System.err.println("error: Unable to instantiate parser (" + parserName + ")");
                    }
                } else if (option.equalsIgnoreCase("n")) {
                    namespaces = option.equals("n");
                } else if (option.equalsIgnoreCase("v")) {
                    validation = option.equals("v");
                } else if (option.equalsIgnoreCase("xd")) {
                    externalDTD = option.equals("xd");
                } else if (option.equalsIgnoreCase("s")) {
                    schemaValidation = option.equals("s");
                } else if (option.equalsIgnoreCase("f")) {
                    schemaFullChecking = option.equals("f");
                } else if (option.equalsIgnoreCase("hs")) {
                    honourAllSchemaLocations = option.equals("hs");
                } else if (option.equalsIgnoreCase("va")) {
                    validateAnnotations = option.equals("va");
                } else if (option.equalsIgnoreCase("ga")) {
                    generateSyntheticAnnotations = option.equals("ga");
                } else if (option.equalsIgnoreCase("dv")) {
                    dynamicValidation = option.equals("dv");
                } else if (option.equalsIgnoreCase("xi")) {
                    xincludeProcessing = option.equals("xi");
                } else if (option.equalsIgnoreCase("xb")) {
                    xincludeFixupBaseURIs = option.equals("xb");
                } else if (option.equalsIgnoreCase("xl")) {
                    xincludeFixupLanguage = option.equals("xl");
                } else if (option.equalsIgnoreCase("c")) {
                    canonical = option.equals("c");
                } else if (option.equals("h")) {
                    DomWriter.printUsage();
                } else lbl-1000:
                // 2 sources

                {
                    if (parser == null) {
                        try {
                            parser = (ParserWrapper)Class.forName("dom.wrappers.Xerces").newInstance();
                        }
                        catch (Exception v1) {
                            System.err.println("error: Unable to instantiate parser (dom.wrappers.Xerces)");
                            break block69;
                        }
                    }
                    try {
                        parser.setFeature("http://xml.org/sax/features/namespaces", namespaces);
                    }
                    catch (SAXException v2) {
                        System.err.println("warning: Parser does not support feature (http://xml.org/sax/features/namespaces)");
                    }
                    try {
                        parser.setFeature("http://xml.org/sax/features/validation", validation);
                    }
                    catch (SAXException v3) {
                        System.err.println("warning: Parser does not support feature (http://xml.org/sax/features/validation)");
                    }
                    try {
                        parser.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", externalDTD);
                    }
                    catch (SAXException v4) {
                        System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/nonvalidating/load-external-dtd)");
                    }
                    try {
                        parser.setFeature("http://apache.org/xml/features/validation/schema", schemaValidation);
                    }
                    catch (SAXException v5) {
                        System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/validation/schema)");
                    }
                    try {
                        parser.setFeature("http://apache.org/xml/features/validation/schema-full-checking", schemaFullChecking);
                    }
                    catch (SAXException v6) {
                        System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/validation/schema-full-checking)");
                    }
                    try {
                        parser.setFeature("http://apache.org/xml/features/honour-all-schemaLocations", honourAllSchemaLocations);
                    }
                    catch (SAXException v7) {
                        System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/honour-all-schemaLocations)");
                    }
                    try {
                        parser.setFeature("http://apache.org/xml/features/validate-annotations", validateAnnotations);
                    }
                    catch (SAXException v8) {
                        System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/validate-annotations)");
                    }
                    try {
                        parser.setFeature("http://apache.org/xml/features/generate-synthetic-annotations", generateSyntheticAnnotations);
                    }
                    catch (SAXException v9) {
                        System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/generate-synthetic-annotations)");
                    }
                    try {
                        parser.setFeature("http://apache.org/xml/features/validation/dynamic", dynamicValidation);
                    }
                    catch (SAXException v10) {
                        System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/validation/dynamic)");
                    }
                    try {
                        parser.setFeature("http://apache.org/xml/features/xinclude", xincludeProcessing);
                    }
                    catch (SAXException v11) {
                        System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/xinclude)");
                    }
                    try {
                        parser.setFeature("http://apache.org/xml/features/xinclude/fixup-base-uris", xincludeFixupBaseURIs);
                    }
                    catch (SAXException v12) {
                        System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/xinclude/fixup-base-uris)");
                    }
                    try {
                        parser.setFeature("http://apache.org/xml/features/xinclude/fixup-language", xincludeFixupLanguage);
                    }
                    catch (SAXException v13) {
                        System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/xinclude/fixup-language)");
                    }
                    if (writer == null) {
                        writer = new DomWriter();
                        try {
                            writer.setOutput(System.out, "UTF8");
                        }
                        catch (UnsupportedEncodingException v14) {
                            System.err.println("error: Unable to set output. Exiting.");
                            System.exit(1);
                        }
                    }
                    writer.setCanonical(canonical);
                    try {
                        document = parser.parse(arg);
                        writer.write(document);
                    }
                    catch (SAXParseException v15) {
                    }
                    catch (Exception e) {
                        System.err.println("error: Parse error occurred - " + e.getMessage());
                        if (e instanceof SAXException && (nested = ((SAXException)e).getException()) != null) {
                            e = nested;
                        }
                        e.printStackTrace(System.err);
                    }
                }
            }
            ++i;
        }
    }

    private static void printUsage() {
        System.err.println("usage: java dom.Writer (options) uri ...");
        System.err.println();
        System.err.println("options:");
        System.err.println("  -p name     Select parser by name.");
        System.err.println("  -n | -N     Turn on/off namespace processing.");
        System.err.println("  -v | -V     Turn on/off validation.");
        System.err.println("  -xd | -XD   Turn on/off loading of external DTDs.");
        System.err.println("              NOTE: Always on when -v in use and not supported by all parsers.");
        System.err.println("  -s | -S     Turn on/off Schema validation support.");
        System.err.println("              NOTE: Not supported by all parsers.");
        System.err.println("  -f  | -F    Turn on/off Schema full checking.");
        System.err.println("              NOTE: Requires use of -s and not supported by all parsers.");
        System.err.println("  -hs | -HS   Turn on/off honouring of all schema locations.");
        System.err.println("              NOTE: Requires use of -s and not supported by all parsers.");
        System.err.println("  -va | -VA   Turn on/off validation of schema annotations.");
        System.err.println("              NOTE: Requires use of -s and not supported by all parsers.");
        System.err.println("  -ga | -GA   Turn on/off generation of synthetic schema annotations.");
        System.err.println("              NOTE: Requires use of -s and not supported by all parsers.");
        System.err.println("  -dv | -DV   Turn on/off dynamic validation.");
        System.err.println("              NOTE: Not supported by all parsers.");
        System.err.println("  -xi | -XI   Turn on/off XInclude processing.");
        System.err.println("              NOTE: Not supported by all parsers.");
        System.err.println("  -xb | -XB   Turn on/off base URI fixup during XInclude processing.");
        System.err.println("              NOTE: Requires use of -xi and not supported by all parsers.");
        System.err.println("  -xl | -XL   Turn on/off language fixup during XInclude processing.");
        System.err.println("              NOTE: Requires use of -xi and not supported by all parsers.");
        System.err.println("  -c | -C     Turn on/off Canonical XML output.");
        System.err.println("              NOTE: This is not W3C canonical output.");
        System.err.println("  -h          This help screen.");
        System.err.println();
        System.err.println("defaults:");
        System.err.println("  Parser:     dom.wrappers.Xerces");
        System.err.print("  Namespaces: ");
        System.err.println("on");
        System.err.print("  Validation: ");
        System.err.println("off");
        System.err.print("  Load External DTD: ");
        System.err.println("on");
        System.err.print("  Schema:     ");
        System.err.println("off");
        System.err.print("  Schema full checking:     ");
        System.err.println("off");
        System.err.print("  Dynamic:    ");
        System.err.println("off");
        System.err.print("  Canonical:  ");
        System.err.println("off");
        System.err.print("  Honour all schema locations:       ");
        System.err.println("off");
        System.err.print("  Validate Annotations:              ");
        System.err.println("off");
        System.err.print("  Generate Synthetic Annotations:    ");
        System.err.println("off");
        System.err.print("  XInclude:   ");
        System.err.println("off");
        System.err.print("  XInclude base URI fixup:  ");
        System.err.println("on");
        System.err.print("  XInclude language fixup:  ");
        System.err.println("on");
    }
}

