/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.engine.api;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunAndRenderTask;
import org.eclipse.birt.report.engine.api.RenderOption;
import org.eclipse.birt.report.tests.engine.EngineCase;

public class CancelOnErrorTest
extends EngineCase {
    private String inputName = "cancel-on-error.rptdesign";

    public void setUp() throws Exception {
        super.setUp();
        this.removeResource();
        this.copyResource_INPUT(this.inputName, this.inputName);
    }

    public void tearDown() {
        this.removeResource();
    }

    public void testRunRenderCancelOnError() {
        String input = this.genInputFile(this.inputName);
        int cancelSize = 0;
        int continueSize = 0;
        try {
            IReportRunnable runnable = this.engine.openReportDesign((InputStream)new FileInputStream(new File(input)));
            IRunAndRenderTask task = this.engine.createRunAndRenderTask(runnable);
            RenderOption options = new RenderOption();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            options.setOutputStream((OutputStream)baos);
            task.setRenderOption((IRenderOption)options);
            task.setErrorHandlingOption(0);
            task.run();
            task.close();
            continueSize = baos.size();
            baos.reset();
            task = this.engine.createRunAndRenderTask(runnable);
            task.setRenderOption((IRenderOption)options);
            task.setErrorHandlingOption(1);
            task.run();
            task.close();
            cancelSize = baos.size();
            baos.reset();
            baos.close();
            CancelOnErrorTest.assertTrue((continueSize > cancelSize ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            CancelOnErrorTest.fail();
        }
    }
}

