/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.engine.api;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.birt.report.engine.api.DataSetID;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.HTMLRenderOption;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunAndRenderTask;
import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.tests.engine.EngineCase;

public class DataSetIDTest
extends EngineCase {
    static final String INPUT = "dataSetID.rptdesign";

    public void setUp() throws Exception {
        super.setUp();
        this.removeResource();
        this.copyResource_INPUT(INPUT, INPUT);
    }

    public void tearDown() {
        this.removeResource();
    }

    public void testDataSetIDFromReport() throws EngineException, IOException {
        String tmp_type;
        String inputFile = this.genInputFile(INPUT);
        IReportRunnable reportRunnable = this.engine.openReportDesign(inputFile);
        HTMLRenderOption options = new HTMLRenderOption();
        options.setOutputFormat("html");
        ByteArrayOutputStream ostream = new ByteArrayOutputStream();
        options.setOutputStream((OutputStream)ostream);
        options.setEnableMetadata(true);
        IRunAndRenderTask task = this.engine.createRunAndRenderTask(reportRunnable);
        task.setRenderOption((IRenderOption)options);
        task.run();
        DataSetIDTest.assertTrue((task.getErrors().size() <= 0 ? 1 : 0) != 0);
        task.close();
        ArrayList<String> iids = new ArrayList<String>();
        String content = ostream.toString("utf-8");
        ostream.close();
        Pattern typePattern = Pattern.compile("(element_type=\"TABLE\".*iid=\".*\")");
        Matcher matcher = typePattern.matcher(content);
        String strIid = null;
        while (matcher.find()) {
            tmp_type = null;
            tmp_type = matcher.group(0);
            strIid = tmp_type.substring(tmp_type.indexOf("iid"));
            strIid = strIid.substring(5, strIid.indexOf("\"", 6));
            iids.add(strIid);
        }
        typePattern = Pattern.compile("(element_type=\"LIST\".*iid=\".*\")");
        matcher = typePattern.matcher(content);
        while (matcher.find()) {
            tmp_type = null;
            tmp_type = matcher.group(0);
            strIid = tmp_type.substring(tmp_type.indexOf("iid"));
            strIid = strIid.substring(5, strIid.indexOf("\"", 6));
            iids.add(strIid);
        }
        InstanceID iid = InstanceID.parse((String)iids.get(1).toString());
        iid = iid.getParentID().getParentID().getParentID();
        DataSetID dsID = iid.getDataID().getDataSetID();
        String dsName = iid.toString().substring(iid.toString().indexOf("(") + 1, iid.toString().indexOf(":"));
        DataSetIDTest.assertEquals((String)dsName, (String)dsID.getDataSetName());
        DataSetIDTest.assertEquals((long)0L, (long)dsID.getRowID());
        DataSetIDTest.assertNull((Object)dsID.getParentID());
        DataSetIDTest.assertNull((Object)dsID.getQueryName());
        iid = iid.getParentID();
        dsID = iid.getDataID().getDataSetID();
        dsName = iid.toString().substring(iid.toString().indexOf("(") + 1, iid.toString().indexOf(":"));
        DataSetIDTest.assertEquals((String)dsName, (String)dsID.getDataSetName());
        DataSetIDTest.assertEquals((long)0L, (long)dsID.getRowID());
        DataSetIDTest.assertNull((Object)dsID.getParentID());
        DataSetIDTest.assertNull((Object)dsID.getQueryName());
        iid = InstanceID.parse((String)iids.get(2).toString());
        iid = iid.getParentID().getParentID().getParentID();
        dsID = iid.getDataID().getDataSetID();
        DataSetIDTest.assertNull((Object)dsID.getDataSetName());
        DataSetIDTest.assertEquals((long)0L, (long)dsID.getRowID());
        DataSetIDTest.assertNotNull((Object)dsID.getParentID());
        DataSetIDTest.assertEquals((String)dsName, (String)dsID.getParentID().getDataSetName());
        DataSetIDTest.assertEquals((String)"52", (String)dsID.getQueryName());
    }

    public void testGetParentID() {
        DataSetID dsID = new DataSetID(new DataSetID("parent"), 1L, "query");
        DataSetIDTest.assertNotNull((Object)dsID.getParentID());
        DataSetIDTest.assertEquals((String)"parent", (String)dsID.getParentID().getDataSetName());
        dsID = new DataSetID("dataset");
        DataSetIDTest.assertNull((Object)dsID.getParentID());
    }

    public void testGetDataSetName() {
        DataSetID dsID = new DataSetID("ds");
        DataSetIDTest.assertEquals((String)"ds", (String)dsID.getDataSetName());
    }

    public void testGetQueryName() {
        DataSetID parent = new DataSetID("parent");
        DataSetID dsID = new DataSetID(parent, 0L, "query");
        DataSetIDTest.assertEquals((String)"query", (String)dsID.getQueryName());
        dsID = new DataSetID(parent, 0L, "\ufffd\ufffd\u046f");
        DataSetIDTest.assertEquals((String)"\ufffd\ufffd\u046f", (String)dsID.getQueryName());
        dsID = new DataSetID(parent, 0L, "~!@#$%^&*()_+?>:");
        DataSetIDTest.assertEquals((String)"~!@#$%^&*()_+?>:", (String)dsID.getQueryName());
        dsID = new DataSetID(parent, 0L, "~!@#$%^&*()_+?>:");
        DataSetIDTest.assertEquals((String)"~!@#$%^&*()_+?>:", (String)dsID.getQueryName());
    }

    public void testGetRowID() {
        DataSetID parent = new DataSetID("parent");
        String query = "query";
        DataSetID dsID = new DataSetID(parent, 0L, query);
        DataSetIDTest.assertEquals((long)0L, (long)dsID.getRowID());
        dsID = new DataSetID(parent, 1L, query);
        DataSetIDTest.assertEquals((long)1L, (long)dsID.getRowID());
        dsID = new DataSetID(parent, -1L, query);
        DataSetIDTest.assertEquals((long)-1L, (long)dsID.getRowID());
        dsID = new DataSetID(parent, Long.MIN_VALUE, query);
        DataSetIDTest.assertEquals((long)Long.MIN_VALUE, (long)dsID.getRowID());
        dsID = new DataSetID(parent, Long.MAX_VALUE, query);
        DataSetIDTest.assertEquals((long)Long.MAX_VALUE, (long)dsID.getRowID());
    }

    public void testToString() {
        DataSetID dsID = new DataSetID("ds");
        DataSetIDTest.assertEquals((String)"ds", (String)dsID.toString());
        dsID = new DataSetID(new DataSetID("parent"), 1L, "query");
        DataSetIDTest.assertEquals((String)"{parent}.1.query", (String)dsID.toString());
        dsID = new DataSetID(new DataSetID(new DataSetID("grandpa"), 0L, " "), 1L, "query");
        DataSetIDTest.assertEquals((String)"{{grandpa}.0. }.1.query", (String)dsID.toString());
        dsID = new DataSetID(new DataSetID("parent"), 1L, "");
        DataSetIDTest.assertEquals((String)"{parent}.1.", (String)dsID.toString());
    }
}

