/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.engine.api;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.birt.report.engine.api.HTMLCompleteImageHandler;
import org.eclipse.birt.report.engine.api.HTMLRenderContext;
import org.eclipse.birt.report.engine.api.IImage;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.RenderOptionBase;
import org.eclipse.birt.report.engine.api.impl.Image;
import org.eclipse.birt.report.tests.engine.EngineCase;

public class HTMLCompleteImageHandlerTest
extends EngineCase {
    static final String INPUT = "EmbedImage.txt";

    public void setUp() throws Exception {
        super.setUp();
        this.removeResource();
        this.copyResource_INPUT(INPUT, INPUT);
    }

    public void tearDown() {
        this.removeResource();
    }

    public void testOnDesignImage() {
        try {
            String fp;
            String input = this.genInputFile(INPUT);
            File imageFile = new File(input);
            long size = imageFile.length();
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(imageFile));
            byte[] imageBytes = new byte[(int)size];
            ((InputStream)is).read(imageBytes);
            HTMLCompleteImageHandlerTest.assertNotNull((Object)imageBytes);
            HTMLRenderContext context = new HTMLRenderContext();
            context.setImageDirectory(this.genOutputFile("image"));
            HTMLCompleteImageHandler imageHandler = new HTMLCompleteImageHandler();
            Image image = new Image(imageBytes, "image1");
            RenderOptionBase option = new RenderOptionBase();
            image.setRenderOption((IRenderOption)option);
            File f = null;
            int count = 0;
            while ((f = new File(fp = String.valueOf(this.genOutputFolder()) + "/image/" + "design" + String.valueOf(++count))).exists()) {
                f.delete();
            }
            String str = imageHandler.onDesignImage((IImage)image, (Object)context);
            URL url = new URL(str);
            HTMLCompleteImageHandlerTest.assertTrue((String)("Failed to get design image in " + str), (boolean)new File(url.getFile()).exists());
            this.removeFile(str);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void testOnURLImage() {
        String url = "http://image";
        Image image = new Image(url);
        RenderOptionBase option = new RenderOptionBase();
        image.setRenderOption((IRenderOption)option);
        HTMLRenderContext context = new HTMLRenderContext();
        HTMLCompleteImageHandler handler = new HTMLCompleteImageHandler();
        String urlGet = handler.onURLImage((IImage)image, (Object)context);
        HTMLCompleteImageHandlerTest.assertEquals((String)"OnURLImage() fail", (String)url, (String)urlGet);
    }

    public void testOnCustomImage() {
        try {
            String fp;
            String input = this.genInputFile(INPUT);
            File imageFile = new File(input);
            long size = imageFile.length();
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(imageFile));
            byte[] imageBytes = new byte[(int)size];
            ((InputStream)is).read(imageBytes);
            HTMLRenderContext context = new HTMLRenderContext();
            context.setImageDirectory(this.genOutputFile("image"));
            HTMLCompleteImageHandler imageHandler = new HTMLCompleteImageHandler();
            Image image = new Image(imageBytes, "image1");
            RenderOptionBase option = new RenderOptionBase();
            image.setRenderOption((IRenderOption)option);
            File f = null;
            int count = 1;
            while ((f = new File(fp = String.valueOf(this.genOutputFolder()) + "/image/" + "custom" + String.valueOf(++count))).exists()) {
                f.delete();
            }
            String str = imageHandler.onCustomImage((IImage)image, (Object)context);
            URL url = new URL(str);
            HTMLCompleteImageHandlerTest.assertTrue((String)("Failed to get custom image in " + str), (boolean)new File(url.getFile()).exists());
            this.removeFile(str);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void testOnDocImage() {
        String url = "http://image";
        Image image = new Image(url);
        RenderOptionBase option = new RenderOptionBase();
        image.setRenderOption((IRenderOption)option);
        HTMLRenderContext context = new HTMLRenderContext();
        HTMLCompleteImageHandler handler = new HTMLCompleteImageHandler();
        String urlGet = handler.onDocImage((IImage)image, (Object)context);
        HTMLCompleteImageHandlerTest.assertNull((String)"OnDocImage() fail", (Object)urlGet);
    }
}

