/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.engine.api;

import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.birt.report.engine.api.HTMLActionHandler;
import org.eclipse.birt.report.engine.api.HTMLRenderOption;
import org.eclipse.birt.report.engine.api.IGetParameterDefinitionTask;
import org.eclipse.birt.report.engine.api.IHTMLActionHandler;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.tests.engine.EngineCase;

public class HTMLRenderOptionTest
extends EngineCase {
    private String name = "case1";
    static final String INPUT = "case1.rptdesign";
    private String rptdesign = this.genInputFile("case1.rptdesign");
    private IGetParameterDefinitionTask task = null;

    public HTMLRenderOptionTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(HTMLRenderOptionTest.class);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.removeResource();
        this.copyResource_INPUT(INPUT, INPUT);
        IReportRunnable reportRunnable = this.engine.openReportDesign(this.rptdesign);
        this.task = this.engine.createGetParameterDefinitionTask(reportRunnable);
        HTMLRenderOptionTest.assertTrue((this.task.getErrors().size() == 0 ? 1 : 0) != 0);
    }

    protected void tearDown() throws Exception {
        this.task.close();
        this.removeResource();
        super.tearDown();
    }

    public void testGetEmbeddable() throws Exception {
        HTMLRenderOption option = new HTMLRenderOption();
        boolean bEmbed = true;
        option.setEmbeddable(bEmbed);
        boolean bEmbedGet = option.getEmbeddable();
        HTMLRenderOptionTest.assertEquals((String)"set/getEmbeddable() fail", (boolean)bEmbed, (boolean)bEmbedGet);
    }

    public void testGetUserAgent() {
        String agent = "agent";
        HTMLRenderOption option = new HTMLRenderOption();
        option.setUserAgent(agent);
        String agentGet = option.getUserAgent();
        HTMLRenderOptionTest.assertEquals((String)"set/getUserAgent() fail", (String)agent, (String)agentGet);
    }

    public void testGetActionHandle() {
        HTMLActionHandler htmlAction = new HTMLActionHandler();
        HTMLRenderOption option = new HTMLRenderOption();
        option.setActionHandle((IHTMLActionHandler)htmlAction);
        HTMLRenderOptionTest.assertNotNull((Object)option.getActionHandle());
    }

    public void testGetDisplayFilterIcon() {
        HTMLRenderOption option = new HTMLRenderOption();
        option.setDisplayFilterIcon(true);
        HTMLRenderOptionTest.assertTrue((boolean)option.getDisplayFilterIcon());
    }

    public void testGetDisplayGroupIcon() {
        HTMLRenderOption option = new HTMLRenderOption();
        option.setDisplayGroupIcon(false);
        HTMLRenderOptionTest.assertFalse((boolean)option.getDisplayGroupIcon());
    }

    public void testGetEnableMetadata() {
        HTMLRenderOption option = new HTMLRenderOption();
        option.setEnableMetadata(false);
        HTMLRenderOptionTest.assertFalse((boolean)option.getEnableMetadata());
    }

    public void testGetHtmlPagination() {
        HTMLRenderOption option = new HTMLRenderOption();
        option.setHtmlPagination(true);
        HTMLRenderOptionTest.assertTrue((boolean)option.getHtmlPagination());
    }

    public void testGetHtmlRtLFlag() {
        HTMLRenderOption option = new HTMLRenderOption();
        option.setHtmlRtLFlag(true);
        HTMLRenderOptionTest.assertTrue((boolean)option.getHtmlRtLFlag());
    }

    public void testGetHtmlTitle() {
        HTMLRenderOption option = new HTMLRenderOption();
        option.setHtmlTitle("HTMLTITLE");
        HTMLRenderOptionTest.assertEquals((String)"HTMLTITLE", (String)option.getHtmlTitle());
    }

    public void testGetInstanceIDs() {
        ArrayList ins = new ArrayList();
        HTMLRenderOption option = new HTMLRenderOption();
        option.setInstanceIDs(ins);
        HTMLRenderOptionTest.assertNotNull((Object)option.getInstanceIDs());
    }

    public void testGetMasterPageContent() {
        HTMLRenderOption option = new HTMLRenderOption();
        option.setMasterPageContent(true);
        HTMLRenderOptionTest.assertTrue((boolean)option.getMasterPageContent());
    }

    public void testGetPageFooterFloatFlag() {
        HTMLRenderOption option = new HTMLRenderOption();
        option.setPageFooterFloatFlag(true);
        HTMLRenderOptionTest.assertTrue((boolean)option.getPageFooterFloatFlag());
    }
}

