/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.engine.api;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.birt.report.engine.api.HTMLRenderContext;
import org.eclipse.birt.report.engine.api.HTMLServerImageHandler;
import org.eclipse.birt.report.engine.api.IImage;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.RenderOptionBase;
import org.eclipse.birt.report.engine.api.impl.Image;
import org.eclipse.birt.report.tests.engine.EngineCase;

public class HTMLServerImageHandlerTest
extends EngineCase {
    static final String INPUT = "EmbedImage.txt";

    public HTMLServerImageHandlerTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.removeResource();
        this.copyResource_INPUT(INPUT, INPUT);
    }

    public void tearDown() {
        this.removeResource();
    }

    public static Test suite() {
        return new TestSuite(HTMLServerImageHandlerTest.class);
    }

    public void testOnDesignImage() {
        try {
            String fp;
            String path = String.valueOf(this.getFullQualifiedClassName()) + "/" + "input" + "/" + INPUT;
            File imageFile = new File(path);
            long size = imageFile.length();
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(imageFile));
            byte[] imageBytes = new byte[(int)size];
            ((InputStream)is).read(imageBytes);
            HTMLServerImageHandlerTest.assertNotNull((Object)imageBytes);
            HTMLRenderContext context = new HTMLRenderContext();
            context.setBaseImageURL(".");
            context.setImageDirectory(".");
            HTMLServerImageHandler imageHandler = new HTMLServerImageHandler();
            Image image = new Image(imageBytes, "image1");
            RenderOptionBase option = new RenderOptionBase();
            image.setRenderOption((IRenderOption)option);
            File f = null;
            int count = 0;
            String fPath = System.getProperty("user.dir");
            while ((f = new File(fp = String.valueOf(fPath) + System.getProperty("file.separator") + "design" + String.valueOf(++count))).exists()) {
                f.delete();
            }
            String str = imageHandler.onDesignImage((IImage)image, (Object)context);
            String strGet = "./design1";
            HTMLServerImageHandlerTest.assertEquals((String)"", (String)str, (String)strGet);
            this.removeFile(str);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void testOnURLImage() {
        String url = "http://image";
        Image image = new Image(url);
        RenderOptionBase option = new RenderOptionBase();
        image.setRenderOption((IRenderOption)option);
        HTMLRenderContext context = new HTMLRenderContext();
        HTMLServerImageHandler handler = new HTMLServerImageHandler();
        String urlGet = handler.onURLImage((IImage)image, (Object)context);
        HTMLServerImageHandlerTest.assertEquals((String)"OnURLImage() fail", (String)url, (String)urlGet);
    }

    public void testOnCustomImage() {
        try {
            String fp;
            String path = String.valueOf(this.getClassFolder()) + System.getProperty("file.separator") + "input" + System.getProperty("file.separator") + INPUT;
            File imageFile = new File(path);
            long size = imageFile.length();
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(imageFile));
            byte[] imageBytes = new byte[(int)size];
            ((InputStream)is).read(imageBytes);
            HTMLRenderContext context = new HTMLRenderContext();
            context.setBaseImageURL(".");
            context.setImageDirectory(".");
            HTMLServerImageHandler imageHandler = new HTMLServerImageHandler();
            Image image = new Image(imageBytes, "image1");
            RenderOptionBase option = new RenderOptionBase();
            image.setRenderOption((IRenderOption)option);
            File f = null;
            int count = 1;
            String fPath = System.getProperty("user.dir");
            while ((f = new File(fp = String.valueOf(fPath) + System.getProperty("file.separator") + "custom" + String.valueOf(++count))).exists()) {
                f.delete();
            }
            String str = imageHandler.onCustomImage((IImage)image, (Object)context);
            String strGet = "./custom2";
            HTMLServerImageHandlerTest.assertEquals((String)"", (String)str, (String)strGet);
            this.removeFile(str);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void testOnDocImage() {
        String url = "http://image";
        Image image = new Image(url);
        RenderOptionBase option = new RenderOptionBase();
        image.setRenderOption((IRenderOption)option);
        HTMLRenderContext context = new HTMLRenderContext();
        HTMLServerImageHandler handler = new HTMLServerImageHandler();
        String urlGet = handler.onDocImage((IImage)image, (Object)context);
        HTMLServerImageHandlerTest.assertNull((String)"OnDocImage() fail", (Object)urlGet);
    }
}

