/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.engine.api;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IGetParameterDefinitionTask;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IScalarParameterDefn;
import org.eclipse.birt.report.tests.engine.EngineCase;

public class IScalarParameterDefnTest
extends EngineCase {
    private String INPUT = "scalarparameters.rptdesign";
    private IGetParameterDefinitionTask paramTask = null;
    private IScalarParameterDefn scalarDefn = null;
    private String report = this.genInputFile(this.INPUT);

    public IScalarParameterDefnTest(String name) throws EngineException {
        super(name);
    }

    public static Test Suite() {
        return new TestSuite(IScalarParameterDefnTest.class);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.removeResource();
        this.copyResource_INPUT(this.INPUT, this.INPUT);
        IReportRunnable runnable = this.engine.openReportDesign(this.report);
        this.paramTask = this.engine.createGetParameterDefinitionTask(runnable);
    }

    protected void tearDown() throws Exception {
        this.paramTask.close();
        this.engine.shutdown();
        this.removeResource();
        super.tearDown();
    }

    public void testallowNull() {
        this.scalarDefn = (IScalarParameterDefn)this.paramTask.getParameterDefn("p_allowbn");
        IScalarParameterDefnTest.assertTrue((String)"AllowNull method failed", (boolean)this.scalarDefn.allowNull());
        this.scalarDefn = (IScalarParameterDefn)this.paramTask.getParameterDefn("p_string");
        IScalarParameterDefnTest.assertFalse((String)"AllowNull method failed", (boolean)this.scalarDefn.allowNull());
    }

    public void testallowBlank() {
        this.scalarDefn = (IScalarParameterDefn)this.paramTask.getParameterDefn("p_allowbn");
        IScalarParameterDefnTest.assertTrue((String)"AllowBlank method failed", (boolean)this.scalarDefn.allowBlank());
        this.scalarDefn = (IScalarParameterDefn)this.paramTask.getParameterDefn("p_string");
        IScalarParameterDefnTest.assertFalse((String)"AllowBlank method failed", (boolean)this.scalarDefn.allowBlank());
    }

    public void testGetSelectionListType_none() {
        this.scalarDefn = (IScalarParameterDefn)this.paramTask.getParameterDefn("p_string");
        IScalarParameterDefnTest.assertEquals((String)"GetSelectionListType method failed to get none type", (int)0, (int)this.scalarDefn.getSelectionListType());
    }
}

