/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.engine.api;

import java.io.File;
import java.util.HashMap;
import java.util.Locale;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.HTMLRenderOption;
import org.eclipse.birt.report.engine.api.IPageHandler;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IRenderTask;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.IReportDocumentInfo;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunTask;
import org.eclipse.birt.report.tests.engine.EngineCase;

public class RenderUnfinishedReportDoc
extends EngineCase {
    private static final String INPUT = "RenderUnfinishedReportDoc.xml";
    private static final String REPORT_DOCUMENT_OUTPUT = "/RenderUnfinishedReportDoc/";
    private static final String HTML_OUTPUT = "RenderUnfinishedReportDoc.html";
    private String docfolder = this.genOutputFile("/RenderUnfinishedReportDoc/");
    private String outputHtml = this.genOutputFile("RenderUnfinishedReportDoc.html");

    public void setUp() throws Exception {
        super.setUp();
        this.removeResource();
        this.copyResource_INPUT(INPUT, INPUT);
    }

    public void tearDown() {
        this.removeResource();
    }

    public void testRender_unfinished_Document() {
        try {
            String inputFile = String.valueOf(this.getFullQualifiedClassName()) + "/" + "input" + "/" + INPUT;
            String outputDoc = this.genOutputFile(REPORT_DOCUMENT_OUTPUT);
            IReportRunnable report = this.engine.openReportDesign(inputFile);
            IRunTask task = this.engine.createRunTask(report);
            task.setAppContext(new HashMap());
            task.setPageHandler((IPageHandler)new PageHandler());
            task.run(outputDoc);
            task.close();
            File html = new File(this.outputHtml);
            RenderUnfinishedReportDoc.assertTrue((boolean)html.exists());
        }
        catch (EngineException e) {
            e.printStackTrace();
        }
    }

    class PageHandler
    implements IPageHandler {
        IRenderTask renderTask;

        PageHandler() {
        }

        public void onPage(int pageNumber, boolean checkpoint, IReportDocumentInfo doc) {
            if (pageNumber == 1) {
                try {
                    IReportDocument document = RenderUnfinishedReportDoc.this.engine.openReportDocument(RenderUnfinishedReportDoc.this.docfolder);
                    IRenderTask task = RenderUnfinishedReportDoc.this.engine.createRenderTask(document);
                    task.setLocale(Locale.ENGLISH);
                    HTMLRenderOption options = new HTMLRenderOption();
                    options.setOutputFileName(RenderUnfinishedReportDoc.this.outputHtml);
                    options.setOutputFormat("html");
                    options.getOutputSetting().put("url-encoding", "UTF-8");
                    task.setRenderOption((IRenderOption)options);
                    task.setPageRange("All");
                    task.render();
                    task.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

