/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.core.commands;

import org.eclipse.birt.report.designer.core.commands.CmdBaseTestCase;
import org.eclipse.birt.report.designer.core.commands.PasteCommand;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.core.IDesignElement;

public class PasteCommandTest
extends CmdBaseTestCase {
    private CellHandle newCell = null;

    protected void setUp() throws Exception {
        super.setUp();
        this.createFirstRow();
        this.createSecondRow();
        this.createFirstCell();
        this.createSecondCell();
    }

    private void createNewCellInSecondRow() {
        this.newCell = this.getElementFactory().newCell();
        try {
            this.secondRow.getSlot(0).add((DesignElementHandle)this.newCell);
        }
        catch (Exception e) {
            e.printStackTrace();
            PasteCommandTest.fail((String)"Add Cell to secondRow");
        }
    }

    public void testPasteCell() {
        PasteCommandTest.assertEquals((int)2, (int)this.firstRow.getCells().getCount());
        PasteCommandTest.assertEquals((int)0, (int)this.secondRow.getCells().getCount());
        PasteCommand pasteCmd = new PasteCommand((DesignElementHandle)this.firstCell, (Object)this.secondRow, null, false);
        PasteCommandTest.assertTrue((boolean)pasteCmd.canExecute());
        pasteCmd.execute();
        PasteCommandTest.assertEquals((int)1, (int)this.secondRow.getCells().getCount());
        PasteCommandTest.assertEquals((Object)this.firstCell, (Object)this.firstRow.getCells().get(1));
    }

    public void testPasteCutCell() {
        PasteCommandTest.assertEquals((int)2, (int)this.firstRow.getCells().getCount());
        PasteCommandTest.assertEquals((int)0, (int)this.secondRow.getCells().getCount());
        PasteCommand pasteCmd = new PasteCommand((DesignElementHandle)this.firstCell, (Object)this.secondRow, null, true);
        PasteCommandTest.assertTrue((boolean)pasteCmd.canExecute());
        pasteCmd.execute();
        PasteCommandTest.assertEquals((int)1, (int)this.secondRow.getCells().getCount());
        PasteCommandTest.assertEquals((int)1, (int)this.firstRow.getCells().getCount());
        PasteCommandTest.assertEquals((Object)this.secondCell, (Object)this.firstRow.getCells().get(0));
    }

    public void testPasteAfterCell() {
        PasteCommandTest.assertEquals((int)2, (int)this.firstRow.getCells().getCount());
        PasteCommand pasteCmd = new PasteCommand((DesignElementHandle)this.secondCell, (Object)this.firstRow, (DesignElementHandle)this.firstCell, false);
        PasteCommandTest.assertTrue((boolean)pasteCmd.canExecute());
        pasteCmd.execute();
        PasteCommandTest.assertEquals((int)3, (int)this.firstRow.getCells().getCount());
        PasteCommandTest.assertEquals((Object)this.secondCell, (Object)this.firstRow.getCells().get(0));
        PasteCommandTest.assertEquals((Object)this.firstCell, (Object)this.firstRow.getCells().get(2));
    }

    public void testPasteCutAfterCellInOwnRow() {
        CellHandle cell3 = this.getElementFactory().newCell();
        try {
            this.firstRow.getSlot(0).add((DesignElementHandle)cell3);
        }
        catch (Exception e) {
            e.printStackTrace();
            PasteCommandTest.fail((String)"add the third cell");
        }
        CellHandle cell1 = this.secondCell;
        CellHandle cell2 = this.firstCell;
        PasteCommandTest.assertEquals((int)3, (int)this.firstRow.getCells().getCount());
        PasteCommandTest.assertEquals((Object)cell1, (Object)this.firstRow.getCells().get(0));
        PasteCommandTest.assertEquals((Object)cell2, (Object)this.firstRow.getCells().get(1));
        PasteCommandTest.assertEquals((Object)cell3, (Object)this.firstRow.getCells().get(2));
        PasteCommand pasteCmd = new PasteCommand((DesignElementHandle)cell1, (Object)this.firstRow, (DesignElementHandle)cell3, true);
        PasteCommandTest.assertTrue((boolean)pasteCmd.canExecute());
        pasteCmd.execute();
        PasteCommandTest.assertEquals((int)3, (int)this.firstRow.getCells().getCount());
        PasteCommandTest.assertEquals((Object)cell2, (Object)this.firstRow.getCells().get(0));
        PasteCommandTest.assertEquals((Object)cell3, (Object)this.firstRow.getCells().get(1));
    }

    public void testPasteCutAfterCellInOtherRow() {
        this.createNewCellInSecondRow();
        PasteCommandTest.assertEquals((int)2, (int)this.firstRow.getCells().getCount());
        PasteCommandTest.assertEquals((Object)this.secondCell, (Object)this.firstRow.getCells().get(0));
        PasteCommandTest.assertEquals((int)1, (int)this.secondRow.getCells().getCount());
        PasteCommand pasteCmd = new PasteCommand((DesignElementHandle)this.secondCell, (Object)this.secondRow, (DesignElementHandle)this.newCell, true);
        PasteCommandTest.assertTrue((boolean)pasteCmd.canExecute());
        pasteCmd.execute();
        PasteCommandTest.assertEquals((int)1, (int)this.firstRow.getCells().getCount());
        PasteCommandTest.assertEquals((int)2, (int)this.secondRow.getCells().getCount());
        PasteCommandTest.assertEquals((Object)this.newCell, (Object)this.secondRow.getCells().get(1));
    }

    public void testPasteCellinPosition() {
        this.createNewCellInSecondRow();
        PasteCommandTest.assertEquals((int)2, (int)this.firstRow.getCells().getCount());
        PasteCommandTest.assertEquals((Object)this.secondCell, (Object)this.firstRow.getCells().get(0));
        PasteCommandTest.assertEquals((int)1, (int)this.secondRow.getCells().getCount());
        PasteCommandTest.assertEquals((Object)this.newCell, (Object)this.secondRow.getCells().get(0));
        PasteCommand pasteCmd = new PasteCommand((DesignElementHandle)this.secondCell, (Object)this.secondRow, 0, false);
        PasteCommandTest.assertTrue((boolean)pasteCmd.canExecute());
        pasteCmd.execute();
        PasteCommandTest.assertEquals((int)2, (int)this.firstRow.getCells().getCount());
        PasteCommandTest.assertEquals((Object)this.secondCell, (Object)this.firstRow.getCells().get(0));
        PasteCommandTest.assertEquals((int)2, (int)this.secondRow.getCells().getCount());
        if (this.newCell == this.secondRow.getCells().get(0)) {
            PasteCommandTest.assertTrue((boolean)false);
        }
        PasteCommandTest.assertEquals((Object)this.newCell, (Object)this.secondRow.getCells().get(1));
    }

    public void testPasteCutCellinPosition() {
        this.createNewCellInSecondRow();
        PasteCommandTest.assertEquals((int)2, (int)this.firstRow.getCells().getCount());
        PasteCommandTest.assertEquals((Object)this.secondCell, (Object)this.firstRow.getCells().get(0));
        PasteCommandTest.assertEquals((int)1, (int)this.secondRow.getCells().getCount());
        PasteCommandTest.assertEquals((Object)this.newCell, (Object)this.secondRow.getCells().get(0));
        PasteCommand pasteCmd = new PasteCommand((DesignElementHandle)this.secondCell, (Object)this.secondRow, 1, true);
        PasteCommandTest.assertTrue((boolean)pasteCmd.canExecute());
        pasteCmd.execute();
        PasteCommandTest.assertEquals((int)1, (int)this.firstRow.getCells().getCount());
        PasteCommandTest.assertEquals((Object)this.firstCell, (Object)this.firstRow.getCells().get(0));
        PasteCommandTest.assertEquals((int)2, (int)this.secondRow.getCells().getCount());
        PasteCommandTest.assertEquals((Object)this.newCell, (Object)this.secondRow.getCells().get(0));
    }

    public void testCloneCellInNullRow() {
        IDesignElement cloned = this.firstCell.copy();
        PasteCommandTest.assertEquals((int)2, (int)this.firstRow.getCells().getCount());
        PasteCommandTest.assertEquals((int)0, (int)this.secondRow.getCells().getCount());
        PasteCommand pasteCmd = new PasteCommand(cloned, (Object)this.secondRow, null);
        PasteCommandTest.assertTrue((boolean)pasteCmd.canExecute());
        pasteCmd.execute();
        PasteCommandTest.assertEquals((int)2, (int)this.firstRow.getCells().getCount());
        PasteCommandTest.assertEquals((int)1, (int)this.secondRow.getCells().getCount());
    }

    public void testCloneCellInOwnRow() {
        IDesignElement cloned = this.secondCell.copy();
        PasteCommandTest.assertEquals((int)2, (int)this.firstRow.getCells().getCount());
        PasteCommandTest.assertEquals((Object)this.secondCell, (Object)this.firstRow.getCells().get(0));
        PasteCommandTest.assertEquals((Object)this.firstCell, (Object)this.firstRow.getCells().get(1));
        PasteCommand pasteCmd = new PasteCommand(cloned, (Object)this.firstRow, null);
        PasteCommandTest.assertTrue((boolean)pasteCmd.canExecute());
        pasteCmd.execute();
        PasteCommandTest.assertEquals((int)3, (int)this.firstRow.getCells().getCount());
        PasteCommandTest.assertEquals((Object)this.secondCell, (Object)this.firstRow.getCells().get(0));
        PasteCommandTest.assertEquals((Object)this.firstCell, (Object)this.firstRow.getCells().get(1));
    }

    public void testCloneCellAfterInOwnRow() {
        IDesignElement cloned = this.secondCell.copy();
        PasteCommandTest.assertEquals((int)2, (int)this.firstRow.getCells().getCount());
        PasteCommandTest.assertEquals((Object)this.secondCell, (Object)this.firstRow.getCells().get(0));
        PasteCommandTest.assertEquals((Object)this.firstCell, (Object)this.firstRow.getCells().get(1));
        PasteCommand pasteCmd = new PasteCommand(cloned, (Object)this.firstRow, (DesignElementHandle)this.firstCell);
        PasteCommandTest.assertTrue((boolean)pasteCmd.canExecute());
        pasteCmd.execute();
        PasteCommandTest.assertEquals((int)3, (int)this.firstRow.getCells().getCount());
        PasteCommandTest.assertEquals((Object)this.secondCell, (Object)this.firstRow.getCells().get(0));
        PasteCommandTest.assertEquals((Object)this.firstCell, (Object)this.firstRow.getCells().get(2));
    }

    public void testCloneCellAfterInOtherRow() {
        this.createNewCellInSecondRow();
        IDesignElement cloned = this.firstCell.copy();
        PasteCommandTest.assertEquals((int)2, (int)this.firstRow.getCells().getCount());
        PasteCommandTest.assertEquals((int)1, (int)this.secondRow.getCells().getCount());
        PasteCommandTest.assertEquals((Object)this.newCell, (Object)this.secondRow.getCells().get(0));
        PasteCommand pasteCmd = new PasteCommand(cloned, (Object)this.secondRow, (DesignElementHandle)this.newCell);
        PasteCommandTest.assertTrue((boolean)pasteCmd.canExecute());
        pasteCmd.execute();
        PasteCommandTest.assertEquals((int)2, (int)this.firstRow.getCells().getCount());
        PasteCommandTest.assertEquals((int)2, (int)this.secondRow.getCells().getCount());
        PasteCommandTest.assertEquals((Object)this.newCell, (Object)this.secondRow.getCells().get(1));
    }

    public void testCloneCellInHeadPosition() {
        IDesignElement cloned = this.secondCell.copy();
        PasteCommandTest.assertEquals((int)2, (int)this.firstRow.getCells().getCount());
        PasteCommandTest.assertEquals((Object)this.secondCell, (Object)this.firstRow.getCells().get(0));
        PasteCommandTest.assertEquals((Object)this.firstCell, (Object)this.firstRow.getCells().get(1));
        PasteCommand pasteCmd = new PasteCommand(cloned, (Object)this.firstRow, 0);
        PasteCommandTest.assertTrue((boolean)pasteCmd.canExecute());
        pasteCmd.execute();
        PasteCommandTest.assertEquals((int)3, (int)this.firstRow.getCells().getCount());
        PasteCommandTest.assertEquals((Object)this.secondCell, (Object)this.firstRow.getCells().get(1));
        PasteCommandTest.assertEquals((Object)this.firstCell, (Object)this.firstRow.getCells().get(2));
    }

    public void testCloneCellInMiddlePosition() {
        IDesignElement cloned = this.secondCell.copy();
        PasteCommandTest.assertEquals((int)2, (int)this.firstRow.getCells().getCount());
        PasteCommandTest.assertEquals((Object)this.secondCell, (Object)this.firstRow.getCells().get(0));
        PasteCommandTest.assertEquals((Object)this.firstCell, (Object)this.firstRow.getCells().get(1));
        PasteCommand pasteCmd = new PasteCommand(cloned, (Object)this.firstRow, 1);
        PasteCommandTest.assertTrue((boolean)pasteCmd.canExecute());
        pasteCmd.execute();
        PasteCommandTest.assertEquals((int)3, (int)this.firstRow.getCells().getCount());
        PasteCommandTest.assertEquals((Object)this.secondCell, (Object)this.firstRow.getCells().get(0));
        PasteCommandTest.assertEquals((Object)this.firstCell, (Object)this.firstRow.getCells().get(2));
    }

    public void testCloneCellInTailPosition() {
        IDesignElement cloned = this.secondCell.copy();
        PasteCommandTest.assertEquals((int)2, (int)this.firstRow.getCells().getCount());
        PasteCommandTest.assertEquals((Object)this.secondCell, (Object)this.firstRow.getCells().get(0));
        PasteCommandTest.assertEquals((Object)this.firstCell, (Object)this.firstRow.getCells().get(1));
        PasteCommand pasteCmd = new PasteCommand(cloned, (Object)this.firstRow, 2);
        PasteCommandTest.assertTrue((boolean)pasteCmd.canExecute());
        pasteCmd.execute();
        PasteCommandTest.assertEquals((int)3, (int)this.firstRow.getCells().getCount());
        PasteCommandTest.assertEquals((Object)this.secondCell, (Object)this.firstRow.getCells().get(0));
        PasteCommandTest.assertEquals((Object)this.firstCell, (Object)this.firstRow.getCells().get(1));
    }

    public void testCloneCellInOtherPosition() {
        IDesignElement cloned = this.secondCell.copy();
        PasteCommandTest.assertEquals((int)2, (int)this.firstRow.getCells().getCount());
        PasteCommandTest.assertEquals((Object)this.secondCell, (Object)this.firstRow.getCells().get(0));
        PasteCommandTest.assertEquals((Object)this.firstCell, (Object)this.firstRow.getCells().get(1));
        PasteCommand pasteCmd = new PasteCommand(cloned, (Object)this.firstRow, 3);
        PasteCommandTest.assertTrue((boolean)pasteCmd.canExecute());
        pasteCmd.execute();
        PasteCommandTest.assertEquals((int)3, (int)this.firstRow.getCells().getCount());
        PasteCommandTest.assertEquals((Object)this.secondCell, (Object)this.firstRow.getCells().get(0));
        PasteCommandTest.assertEquals((Object)this.firstCell, (Object)this.firstRow.getCells().get(1));
        PasteCommandTest.assertNotNull((Object)this.firstRow.getCells().get(2));
    }
}

