/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.core.model.schematic;

import java.util.Iterator;
import org.eclipse.birt.report.designer.core.model.schematic.TableHandleAdapter;
import org.eclipse.birt.report.designer.testutil.BaseTestCase;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.ColumnHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ElementFactory;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.TableGroupHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.core.StyleElement;
import org.eclipse.birt.report.model.core.StyledElement;

public class TableHandleAdapterTest
extends BaseTestCase {
    private TableHandle table;
    private TableHandleAdapter adapter;
    private static final String TEST_TABLE_NAME = "Table";

    protected void setUp() throws Exception {
        super.setUp();
        this.table = this.getElementFactory().newTableItem(TEST_TABLE_NAME);
        this.adapter = new TableHandleAdapter((ReportItemHandle)this.table, null);
    }

    private void createTestTable() {
        RowHandle row = this.getElementFactory().newTableRow();
        CellHandle cell = this.getElementFactory().newCell();
        try {
            cell.setColumn(1);
            row.getSlot(0).add((DesignElementHandle)cell);
            this.table.getHeader().add((DesignElementHandle)row);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            TableHandleAdapterTest.fail((String)"error add cell to table");
        }
        TableGroupHandle group = this.getElementFactory().newTableGroup();
        try {
            row = this.getElementFactory().newTableRow();
            cell = this.getElementFactory().newCell();
            cell.setColumn(1);
            row.getSlot(0).add((DesignElementHandle)cell);
            cell = this.getElementFactory().newCell();
            cell.setColumn(1);
            row.getSlot(0).add((DesignElementHandle)cell);
            group.getFooter().add((DesignElementHandle)row);
            this.table.getGroups().add((DesignElementHandle)group);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            TableHandleAdapterTest.fail((String)"error add cell to table");
        }
        ColumnHandle column = this.getElementFactory().newTableColumn();
        row = this.getElementFactory().newTableRow();
        cell = this.getElementFactory().newCell();
        try {
            this.table.getColumns().add((DesignElementHandle)column);
            cell.setColumn(1);
            row.getSlot(0).add((DesignElementHandle)cell);
            this.table.getDetail().add((DesignElementHandle)row);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            TableHandleAdapterTest.fail((String)"error add cell to table");
        }
        row = this.getElementFactory().newTableRow();
        cell = this.getElementFactory().newCell();
        try {
            cell.setColumn(1);
            row.getSlot(0).add((DesignElementHandle)cell);
            this.table.getFooter().add((DesignElementHandle)row);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            TableHandleAdapterTest.fail((String)"error add cell to table");
        }
    }

    public void testGetBackGroundColor() {
        SharedStyleHandle styleHandle = this.getElementFactory().newStyle(null);
        ((StyledElement)this.table.getElement()).setStyle((StyleElement)styleHandle.getElement());
        styleHandle = this.table.getStyle();
        TableHandleAdapter adapter = new TableHandleAdapter((ReportItemHandle)this.table, null);
        int color = adapter.getBackgroundColor(adapter.getHandle());
        TableHandleAdapterTest.assertEquals((int)25, (int)color);
        try {
            styleHandle.setProperty("backgroundColor", (Object)"0xff1234");
        }
        catch (SemanticException e) {
            TableHandleAdapterTest.fail((String)"error set background color");
            e.printStackTrace();
        }
        color = adapter.getBackgroundColor(adapter.getHandle());
        TableHandleAdapterTest.assertEquals((int)16716340, (int)color);
    }

    public void testGetForeGroundColor() {
        SharedStyleHandle styleHandle = this.getElementFactory().newStyle(null);
        ((StyledElement)this.table.getElement()).setStyle((StyleElement)styleHandle.getElement());
        styleHandle = this.table.getStyle();
        TableHandleAdapter adapter = new TableHandleAdapter((ReportItemHandle)this.table, null);
        int color = adapter.getForegroundColor(adapter.getHandle());
        TableHandleAdapterTest.assertEquals((int)0, (int)color);
        try {
            styleHandle.setProperty("color", (Object)"0xff1234");
        }
        catch (SemanticException e) {
            TableHandleAdapterTest.fail((String)"error set  color");
            e.printStackTrace();
        }
        adapter = new TableHandleAdapter((ReportItemHandle)this.table, null);
        color = adapter.getForegroundColor(adapter.getHandle());
        TableHandleAdapterTest.assertEquals((int)16716340, (int)color);
    }

    public void testGetChildren() {
        this.createTestTable();
        TableHandleAdapterTest.assertFalse((boolean)this.adapter.getChildren().isEmpty());
        Iterator it = this.adapter.getChildren().iterator();
        while (it.hasNext()) {
            TableHandleAdapterTest.assertTrue((boolean)(it.next() instanceof CellHandle));
        }
    }

    public void testGetRows() {
        this.createTestTable();
        TableHandleAdapterTest.assertFalse((boolean)this.adapter.getRows().isEmpty());
        Iterator it = this.adapter.getRows().iterator();
        while (it.hasNext()) {
            TableHandleAdapterTest.assertTrue((boolean)(it.next() instanceof RowHandle));
        }
    }

    public void testGetRow() {
        this.createTestTable();
        TableHandleAdapterTest.assertNotNull((Object)this.adapter.getRow(2));
        TableHandleAdapterTest.assertNull((String)"how can you get row?", (Object)this.adapter.getRow(100));
    }

    public void testGetColumns() {
        this.createTestTable();
        TableHandleAdapterTest.assertFalse((boolean)this.adapter.getColumns().isEmpty());
        for (Object obj : this.adapter.getColumns()) {
            TableHandleAdapterTest.assertTrue((boolean)(obj instanceof ColumnHandle));
        }
    }

    public void testGetColumn() {
        this.createTestTable();
        TableHandleAdapterTest.assertNotNull((Object)this.adapter.getColumn(1));
        TableHandleAdapterTest.assertNull((String)"how can you get this column", (Object)this.adapter.getColumn(2));
    }

    public void testGetCell() {
        this.createTestTable();
        TableHandleAdapterTest.assertNotNull((Object)this.adapter.getCell(1, 1));
        TableHandleAdapterTest.assertNotNull((Object)this.adapter.getCell(2, 1));
        TableHandleAdapterTest.assertNull((String)"how can you get this cell", (Object)this.adapter.getCell(1, 0));
        TableHandleAdapterTest.assertNull((String)"how can you get this cell", (Object)this.adapter.getCell(1, 2));
        TableHandleAdapterTest.assertNull((String)"how can you get this cell", (Object)this.adapter.getCell(100, 1));
    }

    private ElementFactory getElementFactory() {
        return this.getReportDesignHandle().getElementFactory();
    }
}

