/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.tests.example.matrix;

import org.eclipse.birt.report.designer.tests.example.matrix.ExtendedElement;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.extension.IElementCommand;

public class ExtendedElementCommand
implements IElementCommand {
    private ExtendedElement element = null;
    private String propName = null;
    public static String commandTag = "initial";
    public static final String EXECUTE_TAG = "execute";
    public static final String REDO_TAG = "redo";
    public static final String UNDO_TAG = "undo";
    private Object oldValue = null;
    private Object newValue = null;
    private DesignElementHandle handle;

    public ExtendedElementCommand(DesignElementHandle handle, ExtendedElement propertyOwner, String name, Object value) {
        assert (propertyOwner != null);
        this.element = propertyOwner;
        assert (name != null);
        this.handle = handle;
        this.propName = name;
        this.newValue = value;
        this.oldValue = propertyOwner.getProperty(name);
    }

    protected void perform(boolean undo) {
        Object value;
        Object object = value = undo ? this.oldValue : this.newValue;
        if (this.propName.equals("company") && value != null) {
            this.element.doSetProperty(this.propName, String.valueOf(value.toString()) + commandTag);
        } else if (this.propName.equals("company") && value == null) {
            this.element.doSetProperty(this.propName, commandTag);
        } else {
            this.element.doSetProperty(this.propName, value);
        }
    }

    public void execute() {
        commandTag = EXECUTE_TAG;
        this.perform(false);
    }

    public void undo() {
        commandTag = UNDO_TAG;
        this.perform(true);
    }

    public void redo() {
        commandTag = REDO_TAG;
        this.perform(false);
    }

    public boolean canUndo() {
        return true;
    }

    public boolean canRedo() {
        return true;
    }

    public String getLabel() {
        return "Command";
    }

    public DesignElementHandle getElementHandle() {
        return this.handle;
    }
}

