/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.util;

import org.eclipse.birt.report.designer.testutil.BaseTestCase;
import org.eclipse.birt.report.designer.util.CSSUtil;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.metadata.DimensionValue;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;

public class CSSUtilTest
extends BaseTestCase {
    private static final double CM_PER_INCH = 2.54;
    private static final double POINTS_PER_INCH = 72.0;
    private static final double POINTS_PER_CM = 28.346456692913385;

    public CSSUtilTest(String name) {
        super(name);
    }

    public void testGetFontSize() {
        ReportDesignHandle handle = this.getReportDesignHandle();
        int baseSize = 10;
        Object obj = null;
        int sizeValue = CSSUtil.getFontSize(obj);
        CSSUtilTest.assertEquals((int)baseSize, (int)sizeValue);
        String fontSize = CSSUtil.getFontSize((DesignElementHandle)handle);
        CSSUtilTest.assertEquals((int)baseSize, (int)CSSUtil.getFontSizeIntValue((String)fontSize));
        fontSize = "xx-large";
        fontSize = CSSUtil.getLargerFontSize((String)fontSize);
        sizeValue = CSSUtil.getFontSizeIntValue((String)fontSize);
        CSSUtilTest.assertEquals((int)sizeValue, (int)13);
        fontSize = "medium";
        sizeValue = CSSUtil.getFontSizeIntValue((String)fontSize);
        CSSUtilTest.assertEquals((int)sizeValue, (int)10);
        fontSize = CSSUtil.getLargerFontSize((String)fontSize);
        sizeValue = CSSUtil.getFontSizeIntValue((String)fontSize);
        CSSUtilTest.assertEquals((int)sizeValue, (int)11);
        CSSUtilTest.assertEquals((String)fontSize, (String)"large");
        fontSize = CSSUtil.getLargerFontSize((String)fontSize);
        sizeValue = CSSUtil.getFontSizeIntValue((String)fontSize);
        CSSUtilTest.assertEquals((int)sizeValue, (int)12);
        CSSUtilTest.assertEquals((String)fontSize, (String)"x-large");
        fontSize = CSSUtil.getLargerFontSize((String)fontSize);
        sizeValue = CSSUtil.getFontSizeIntValue((String)fontSize);
        CSSUtilTest.assertEquals((int)sizeValue, (int)13);
        CSSUtilTest.assertEquals((String)fontSize, (String)"xx-large");
        fontSize = CSSUtil.getLargerFontSize((String)fontSize);
        sizeValue = CSSUtil.getFontSizeIntValue((String)fontSize);
        CSSUtilTest.assertEquals((int)sizeValue, (int)13);
        CSSUtilTest.assertEquals((String)fontSize, (String)"xx-large");
        fontSize = CSSUtil.getSmallerFontSize((String)fontSize);
        sizeValue = CSSUtil.getFontSizeIntValue((String)fontSize);
        CSSUtilTest.assertEquals((int)sizeValue, (int)12);
        CSSUtilTest.assertEquals((String)fontSize, (String)"x-large");
        fontSize = CSSUtil.getSmallerFontSize((String)fontSize);
        sizeValue = CSSUtil.getFontSizeIntValue((String)fontSize);
        CSSUtilTest.assertEquals((int)sizeValue, (int)11);
        CSSUtilTest.assertEquals((String)fontSize, (String)"large");
        fontSize = CSSUtil.getSmallerFontSize((String)fontSize);
        sizeValue = CSSUtil.getFontSizeIntValue((String)fontSize);
        CSSUtilTest.assertEquals((int)sizeValue, (int)10);
        CSSUtilTest.assertEquals((String)fontSize, (String)"medium");
        fontSize = CSSUtil.getSmallerFontSize((String)fontSize);
        sizeValue = CSSUtil.getFontSizeIntValue((String)fontSize);
        CSSUtilTest.assertEquals((int)sizeValue, (int)9);
        CSSUtilTest.assertEquals((String)fontSize, (String)"small");
        fontSize = CSSUtil.getSmallerFontSize((String)fontSize);
        sizeValue = CSSUtil.getFontSizeIntValue((String)fontSize);
        CSSUtilTest.assertEquals((int)sizeValue, (int)8);
        CSSUtilTest.assertEquals((String)fontSize, (String)"x-small");
        fontSize = CSSUtil.getSmallerFontSize((String)fontSize);
        sizeValue = CSSUtil.getFontSizeIntValue((String)fontSize);
        CSSUtilTest.assertEquals((int)sizeValue, (int)7);
        CSSUtilTest.assertEquals((String)fontSize, (String)"xx-small");
        fontSize = CSSUtil.getSmallerFontSize((String)fontSize);
        sizeValue = CSSUtil.getFontSizeIntValue((String)fontSize);
        CSSUtilTest.assertEquals((int)sizeValue, (int)7);
        CSSUtilTest.assertEquals((String)fontSize, (String)"xx-small");
    }

    public void testConvertTos() {
        int baseSize = 10;
        double pxValue = 0.0;
        double inchValue = 0.0;
        double ptValue = 0.0;
        Object obj = null;
        inchValue = CSSUtil.convertToInch(obj);
        CSSUtilTest.assertEquals((double)0.0, (double)inchValue, (double)0.01);
        DimensionValue dim = new DimensionValue(36.0, "cm");
        inchValue = CSSUtil.convertToInch((Object)dim);
        CSSUtilTest.assertEquals((double)(inchValue * 2.54), (double)dim.getMeasure(), (double)0.01);
        pxValue = CSSUtil.convertToPixel((Object)dim);
        double px = CSSUtil.inchToPixel((double)(dim.getMeasure() / 2.54));
        CSSUtilTest.assertEquals((double)pxValue, (double)px, (double)0.01);
        ptValue = CSSUtil.convertToPoint((Object)dim);
        CSSUtilTest.assertEquals((double)(dim.getMeasure() * 28.346456692913385), (double)ptValue, (double)0.01);
        dim = new DimensionValue(307.0, "mm");
        inchValue = CSSUtil.convertToInch((Object)dim);
        CSSUtilTest.assertEquals((double)(inchValue * 2.54 * 10.0), (double)dim.getMeasure(), (double)0.01);
        pxValue = CSSUtil.convertToPixel((Object)dim);
        px = CSSUtil.inchToPixel((double)(dim.getMeasure() / 2.54 / 10.0));
        CSSUtilTest.assertEquals((double)pxValue, (double)px, (double)0.01);
        ptValue = CSSUtil.convertToPoint((Object)dim);
        CSSUtilTest.assertEquals((double)(dim.getMeasure() * 28.346456692913385 / 10.0), (double)ptValue, (double)0.01);
        dim = new DimensionValue(222.0, "pt");
        inchValue = CSSUtil.convertToInch((Object)dim);
        double in = CSSUtil.pointToInch((double)dim.getMeasure());
        CSSUtilTest.assertEquals((double)in, (double)inchValue, (double)0.01);
        pxValue = CSSUtil.convertToPixel((Object)dim);
        px = CSSUtil.pointToPixel((double)dim.getMeasure());
        CSSUtilTest.assertEquals((double)pxValue, (double)px, (double)0.01);
        dim = new DimensionValue(302.0, "em");
        inchValue = CSSUtil.convertToInch((Object)dim, (int)baseSize);
        CSSUtilTest.assertEquals((double)(dim.getMeasure() * (double)baseSize / 72.0), (double)inchValue, (double)0.01);
        ptValue = CSSUtil.convertToPoint((Object)dim, (int)baseSize);
        CSSUtilTest.assertEquals((double)(dim.getMeasure() * (double)baseSize), (double)ptValue, (double)0.01);
        pxValue = CSSUtil.convertToPixel((Object)dim, (int)baseSize);
        px = CSSUtil.inchToPixel((double)inchValue);
        CSSUtilTest.assertEquals((double)px, (double)pxValue, (double)0.01);
        dim = new DimensionValue(301.0, "ex");
        inchValue = CSSUtil.convertToInch((Object)dim, (int)baseSize);
        CSSUtilTest.assertEquals((double)(dim.getMeasure() * (double)baseSize / 72.0 / 3.0), (double)inchValue, (double)0.01);
        ptValue = CSSUtil.convertToPoint((Object)dim, (int)baseSize);
        CSSUtilTest.assertEquals((double)(dim.getMeasure() * (double)baseSize / 3.0), (double)ptValue, (double)0.01);
        pxValue = CSSUtil.convertToPixel((Object)dim, (int)baseSize);
        px = CSSUtil.inchToPixel((double)inchValue);
        CSSUtilTest.assertEquals((double)px, (double)pxValue, (double)0.01);
        dim = new DimensionValue(303.0, "%");
        ptValue = CSSUtil.convertToPoint((Object)dim, (int)baseSize);
        CSSUtilTest.assertEquals((double)(dim.getMeasure() * (double)baseSize / 100.0), (double)ptValue, (double)0.01);
        inchValue = CSSUtil.convertToInch((Object)dim, (int)baseSize);
        CSSUtilTest.assertEquals((double)(dim.getMeasure() * (double)baseSize / 72.0 / 100.0), (double)inchValue, (double)0.01);
        pxValue = CSSUtil.convertToPixel((Object)dim, (int)baseSize);
        px = CSSUtil.inchToPixel((double)inchValue);
        CSSUtilTest.assertEquals((double)px, (double)pxValue, (double)0.01);
        dim = new DimensionValue(100.0, "px");
        inchValue = CSSUtil.convertToInch((Object)dim, (int)baseSize);
        in = CSSUtil.pixelToInch((double)dim.getMeasure());
        CSSUtilTest.assertEquals((double)in, (double)inchValue, (double)0.01);
        ptValue = CSSUtil.convertToPoint((Object)dim, (int)baseSize);
        double pt = CSSUtil.pixelToPoint((double)dim.getMeasure());
        CSSUtilTest.assertEquals((double)pt, (double)ptValue, (double)0.01);
    }

    public void testUnitsConversion() {
        DimensionValue dim1 = new DimensionValue(100.0, "in");
        DimensionValue dim3 = new DimensionValue(7200.0, "pt");
        DimensionValue dim4 = new DimensionValue(254.0, "cm");
        DimensionValue dim5 = new DimensionValue(2540.0, "mm");
        DimensionValue dim6 = new DimensionValue(600.0, "pc");
        DimensionValue target = CSSUtil.convertTo((double)dim1.getMeasure(), (String)dim1.getUnits(), (String)dim3.getUnits());
        CSSUtilTest.assertEquals((Object)target, (Object)dim3);
        target = CSSUtil.convertTo((double)dim3.getMeasure(), (String)dim3.getUnits(), (String)dim4.getUnits());
        CSSUtilTest.assertEquals((double)target.getMeasure(), (double)dim4.getMeasure(), (double)0.01);
        CSSUtilTest.assertTrue((boolean)target.equals((Object)dim4));
        target = CSSUtil.convertTo((double)dim1.getMeasure(), (String)dim1.getUnits(), (String)dim5.getUnits());
        CSSUtilTest.assertEquals((Object)target, (Object)dim5);
        target = CSSUtil.convertTo((double)dim1.getMeasure(), (String)dim1.getUnits(), (String)dim6.getUnits());
        CSSUtilTest.assertEquals((Object)target, (Object)dim6);
        target = CSSUtil.convertTo((DimensionValue)dim1, null, (String)dim3.getUnits());
        CSSUtilTest.assertEquals((Object)target, (Object)dim3);
        target = CSSUtil.convertTo((DimensionValue)dim1, null, (String)dim4.getUnits());
        CSSUtilTest.assertEquals((Object)target, (Object)dim4);
        target = CSSUtil.convertTo((DimensionValue)dim1, null, (String)dim5.getUnits());
        CSSUtilTest.assertEquals((Object)target, (Object)dim5);
        target = CSSUtil.convertTo((DimensionValue)dim1, null, (String)dim4.getUnits());
        CSSUtilTest.assertEquals((Object)target, (Object)dim4);
        String dimDesp = dim1.toString();
        try {
            target = CSSUtil.convertTo((String)dimDesp, null, (String)dim3.getUnits());
        }
        catch (PropertyValueException e) {
            e.printStackTrace();
        }
        CSSUtilTest.assertEquals((Object)target, (Object)dim3);
        String[] absoluteUnits = new String[]{"in", "cm", "mm", "pt", "pc"};
        String[] relativeUnits = new String[]{"em", "ex", "%", "px"};
        int i = 0;
        while (i < absoluteUnits.length) {
            CSSUtilTest.assertEquals((boolean)true, (boolean)CSSUtil.isAbsoluteUnits((String)absoluteUnits[i]));
            CSSUtilTest.assertEquals((boolean)false, (boolean)CSSUtil.isRelativeUnits((String)absoluteUnits[i]));
            ++i;
        }
        int j = 0;
        while (j < relativeUnits.length) {
            CSSUtilTest.assertEquals((boolean)true, (boolean)CSSUtil.isRelativeUnits((String)relativeUnits[j]));
            CSSUtilTest.assertEquals((boolean)false, (boolean)CSSUtil.isAbsoluteUnits((String)relativeUnits[j]));
            ++j;
        }
    }

    public void testFontWeight() {
        ReportDesignHandle handle = this.getReportDesignHandle();
        int baseWeight = 400;
        int target = CSSUtil.getFontWeight((DesignElementHandle)handle);
        CSSUtilTest.assertEquals((double)baseWeight, (double)target, (double)0.01);
        target = CSSUtil.getFontWeight((String)"normal");
        CSSUtilTest.assertEquals((double)baseWeight, (double)target, (double)0.01);
        target = CSSUtil.getBolderFontWeight((int)target);
        CSSUtilTest.assertEquals((double)500.0, (double)target, (double)0.01);
        target = CSSUtil.getBolderFontWeight((int)target);
        CSSUtilTest.assertEquals((int)600, (int)target);
        target = CSSUtil.getBolderFontWeight((int)target);
        CSSUtilTest.assertEquals((int)700, (int)target);
        target = CSSUtil.getBolderFontWeight((int)target);
        CSSUtilTest.assertEquals((int)800, (int)target);
        target = CSSUtil.getBolderFontWeight((int)target);
        CSSUtilTest.assertEquals((int)900, (int)target);
        target = CSSUtil.getBolderFontWeight((int)target);
        CSSUtilTest.assertEquals((int)900, (int)target);
        target = CSSUtil.getLighterFontWeight((int)target);
        CSSUtilTest.assertEquals((int)800, (int)target);
        target = CSSUtil.getLighterFontWeight((int)target);
        CSSUtilTest.assertEquals((int)700, (int)target);
        target = CSSUtil.getLighterFontWeight((int)target);
        CSSUtilTest.assertEquals((int)600, (int)target);
        target = CSSUtil.getLighterFontWeight((int)target);
        CSSUtilTest.assertEquals((int)500, (int)target);
        target = CSSUtil.getLighterFontWeight((int)target);
        CSSUtilTest.assertEquals((int)400, (int)target);
        target = CSSUtil.getLighterFontWeight((int)target);
        CSSUtilTest.assertEquals((int)300, (int)target);
        target = CSSUtil.getLighterFontWeight((int)target);
        CSSUtilTest.assertEquals((int)200, (int)target);
        target = CSSUtil.getLighterFontWeight((int)target);
        CSSUtilTest.assertEquals((int)100, (int)target);
        target = CSSUtil.getLighterFontWeight((int)target);
        CSSUtilTest.assertEquals((int)100, (int)target);
        target = CSSUtil.getFontWeight((String)"900");
        CSSUtilTest.assertEquals((int)900, (int)target);
        target = CSSUtil.getLighterFontWeight((int)target);
        CSSUtilTest.assertEquals((int)800, (int)target);
        target = CSSUtil.getLighterFontWeight((int)target);
        CSSUtilTest.assertEquals((int)700, (int)target);
        target = CSSUtil.getBolderFontWeight((String)"100");
        CSSUtilTest.assertEquals((int)200, (int)target);
        target = CSSUtil.getBolderFontWeight((String)"200");
        CSSUtilTest.assertEquals((int)300, (int)target);
        target = CSSUtil.getBolderFontWeight((String)"300");
        CSSUtilTest.assertEquals((int)400, (int)target);
        target = CSSUtil.getBolderFontWeight((String)"400");
        CSSUtilTest.assertEquals((int)500, (int)target);
        target = CSSUtil.getBolderFontWeight((String)"500");
        CSSUtilTest.assertEquals((int)600, (int)target);
        target = CSSUtil.getBolderFontWeight((String)"600");
        CSSUtilTest.assertEquals((int)700, (int)target);
        target = CSSUtil.getBolderFontWeight((String)"700");
        CSSUtilTest.assertEquals((int)800, (int)target);
        target = CSSUtil.getBolderFontWeight((String)"800");
        CSSUtilTest.assertEquals((int)900, (int)target);
        target = CSSUtil.getBolderFontWeight((String)"900");
        CSSUtilTest.assertEquals((int)900, (int)target);
        target = CSSUtil.getLighterFontWeight((String)"900");
        CSSUtilTest.assertEquals((int)800, (int)target);
        target = CSSUtil.getLighterFontWeight((String)"800");
        CSSUtilTest.assertEquals((int)700, (int)target);
        target = CSSUtil.getLighterFontWeight((String)"700");
        CSSUtilTest.assertEquals((int)600, (int)target);
        target = CSSUtil.getLighterFontWeight((String)"600");
        CSSUtilTest.assertEquals((int)500, (int)target);
        target = CSSUtil.getLighterFontWeight((String)"500");
        CSSUtilTest.assertEquals((int)400, (int)target);
        target = CSSUtil.getLighterFontWeight((String)"400");
        CSSUtilTest.assertEquals((int)300, (int)target);
        target = CSSUtil.getLighterFontWeight((String)"300");
        CSSUtilTest.assertEquals((int)200, (int)target);
        target = CSSUtil.getLighterFontWeight((String)"200");
        CSSUtilTest.assertEquals((int)100, (int)target);
        target = CSSUtil.getLighterFontWeight((String)"100");
        CSSUtilTest.assertEquals((int)100, (int)target);
    }
}

