/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive;

import java.io.File;
import java.io.IOException;
import junit.framework.TestCase;
import org.eclipse.birt.core.archive.ArchiveUtil;
import org.eclipse.birt.core.archive.FileArchiveReader;
import org.eclipse.birt.core.archive.FileArchiveWriter;
import org.eclipse.birt.core.archive.FolderArchiveReader;
import org.eclipse.birt.core.archive.FolderArchiveWriter;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.core.archive.RAOutputStream;

public class ArchiveUtilTest
extends TestCase {
    static final String ARCHIVE_FILE = "./utest/test.file";
    static final String ARCHIVE_FOLDER = "./utest/test.folder";

    protected void removeFile(File file) {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            int i = 0;
            while (i < files.length) {
                this.removeFile(files[i]);
                ++i;
            }
        }
        file.delete();
    }

    public void testArchive() throws IOException {
        this.removeFile(new File(ARCHIVE_FOLDER));
        this.removeFile(new File(ARCHIVE_FILE));
        FolderArchiveWriter writer = new FolderArchiveWriter(ARCHIVE_FOLDER);
        writer.initialize();
        this.createArchive((IDocArchiveWriter)writer);
        writer.finish();
        ArchiveUtil.archive((String)ARCHIVE_FOLDER, (String)ARCHIVE_FILE);
        FileArchiveReader reader = new FileArchiveReader(ARCHIVE_FILE);
        reader.open();
        this.checkArchive((IDocArchiveReader)reader);
        reader.close();
    }

    public void testExpand() throws IOException {
        this.removeFile(new File(ARCHIVE_FOLDER));
        this.removeFile(new File(ARCHIVE_FILE));
        FileArchiveWriter writer = new FileArchiveWriter(ARCHIVE_FILE);
        writer.initialize();
        this.createArchive((IDocArchiveWriter)writer);
        writer.finish();
        ArchiveUtil.expand((String)ARCHIVE_FILE, (String)ARCHIVE_FOLDER);
        FolderArchiveReader reader = new FolderArchiveReader(ARCHIVE_FOLDER);
        reader.open();
        this.checkArchive((IDocArchiveReader)reader);
        reader.close();
    }

    protected void createArchive(IDocArchiveWriter writer) throws IOException {
        RAOutputStream out = writer.createRandomAccessStream("/core.txt");
        out.writeLong(100L);
        out.seek(0x100000L);
        out.writeLong(100L);
        out.close();
        out = writer.createRandomAccessStream("/folder/core.txt");
        out.seek(100L);
        out.writeLong(100L);
        out.close();
    }

    protected void checkArchive(IDocArchiveReader reader) throws IOException {
        RAInputStream in = reader.getStream("/core.txt");
        ArchiveUtilTest.assertTrue((in != null ? 1 : 0) != 0);
        ArchiveUtilTest.assertEquals((long)100L, (long)in.readLong());
        in.seek(0x100000L);
        ArchiveUtilTest.assertEquals((long)100L, (long)in.readLong());
        in.close();
        in = reader.getStream("/folder/core.txt");
        ArchiveUtilTest.assertTrue((in != null ? 1 : 0) != 0);
        in.seek(100L);
        ArchiveUtilTest.assertEquals((long)100L, (long)in.readLong());
        in.close();
    }
}

