/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive;

import java.io.File;
import junit.framework.TestCase;
import org.eclipse.birt.core.archive.ArchiveLockManager;
import org.eclipse.birt.core.archive.IArchiveLockManager;

public class DocArchiveLockManagerTest
extends TestCase {
    static final String LOCK_FILE_NAME = "./utest/lock.lck";
    static final int THREAD_COUNT = 20;

    public void testThread() {
        TestTask task = new TestTask();
        task.doTest();
        DocArchiveLockManagerTest.assertTrue((task.errorThreads == 0 ? 1 : 0) != 0);
        DocArchiveLockManagerTest.assertTrue((!new File(LOCK_FILE_NAME).exists() ? 1 : 0) != 0);
    }

    static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (Exception exception) {}
    }

    public static void main(String[] args) throws Exception {
        TestTask task = new TestTask();
        task.doTest();
    }

    static class LockRunnable
    implements Runnable {
        static long threadId = 0L;
        IArchiveLockManager lockManager = ArchiveLockManager.getInstance();
        int status;
        long lockTime = -1L;
        long unlockTime = -1L;
        long id = threadId++;

        LockRunnable() {
        }

        public void run() {
            try {
                Object lock = this.lockManager.lock(DocArchiveLockManagerTest.LOCK_FILE_NAME);
                this.lockTime = System.currentTimeMillis();
                try {
                    Thread.sleep((long)(Math.random() * 1000.0));
                }
                catch (Exception exception) {}
                this.lockManager.unlock(lock);
                this.unlockTime = System.currentTimeMillis();
                System.out.println(String.valueOf(this.id) + " lock for " + (this.unlockTime - this.lockTime));
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
            this.status = 1;
        }
    }

    static class TestTask {
        int errorThreads;
        int terminateThreads;

        TestTask() {
        }

        public void doTest() {
            LockRunnable[] runnables = new LockRunnable[20];
            int i = 0;
            while (i < 20) {
                runnables[i] = new LockRunnable();
                new Thread(runnables[i]).start();
                ++i;
            }
            while (this.terminateThreads != 20) {
                this.terminateThreads = 0;
                this.errorThreads = 0;
                i = 0;
                while (i < 20) {
                    if (runnables[i].status == 1) {
                        ++this.terminateThreads;
                        if (runnables[i].lockTime == -1L || runnables[i].unlockTime == -1L) {
                            ++this.errorThreads;
                        }
                    }
                    ++i;
                }
                if (this.terminateThreads == 20) continue;
                DocArchiveLockManagerTest.sleep(1000L);
            }
        }
    }
}

