/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import junit.framework.TestCase;
import org.eclipse.birt.core.archive.FileArchiveReader;
import org.eclipse.birt.core.archive.FileArchiveWriter;
import org.eclipse.birt.core.archive.FolderArchiveReader;
import org.eclipse.birt.core.archive.FolderArchiveWriter;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.archive.RAFolderInputStream;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.core.archive.RAOutputStream;

public class DocumentArchiveTest
extends TestCase {
    static final String ARCHIVE_DOCUMENT_NAME = "org.eclipse.birt.core.archive.archive.zip";
    static final String ARCHIVE_FOLDER_NAME = "org.eclipse.birt.core.archive.archive_folder";
    static final String fileArchiveName = "./FileArchive";
    static final String folderArchiveName = "./FolderArchive";
    static final String coreStream = "/Core.txt";
    static final String designStream = "/Design.txt";
    static final String random1Stream = "/Random1.txt";
    static final String random2Stream = "/Random2.txt";
    static final String contentStream = "/Folder1/Folder2/Content.txt";
    static final String CoreStreamContent = "This is string for testing core stream.";
    static final String DesignStreamContent = "This is string for testing design stream.";
    static final String Random1StreamContent = "This is string for testing random stream 1.";
    static final String Random2StreamContent = "This is string for testing random stream 2.";
    static final String ContentStreamContent = "This is string for testing nested folder.";
    int runningThread;
    int THREAD_COUNT = 5;
    int VALUE_COUNT = 10000;

    public DocumentArchiveTest(String name) {
        super(name);
        this.delete(new File(ARCHIVE_DOCUMENT_NAME));
    }

    public void tearDown() {
        File file = new File(ARCHIVE_DOCUMENT_NAME);
        if (file.exists()) {
            this.delete(file);
        }
        if ((file = new File(ARCHIVE_FOLDER_NAME)).exists()) {
            this.delete(file);
        }
        if ((file = new File(fileArchiveName)).exists()) {
            this.delete(file);
        }
        if ((file = new File(folderArchiveName)).exists()) {
            this.delete(file);
        }
    }

    private void delete(File dir) {
        if (dir.isFile()) {
            dir.delete();
        }
        if (dir.isDirectory()) {
            File[] files = dir.listFiles();
            int i = 0;
            while (i < files.length) {
                this.delete(files[i]);
                ++i;
            }
            dir.delete();
        }
    }

    public void testArchiveWriterAndArchiveReader() throws Exception {
        FileArchiveWriter compoundWriter = new FileArchiveWriter(fileArchiveName);
        compoundWriter.initialize();
        RAOutputStream out = null;
        DocumentArchiveTest.assertTrue((!compoundWriter.exists(coreStream) ? 1 : 0) != 0);
        out = compoundWriter.createRandomAccessStream(coreStream);
        out.write(CoreStreamContent.getBytes());
        out.close();
        DocumentArchiveTest.assertTrue((boolean)compoundWriter.exists(coreStream));
        out = compoundWriter.createRandomAccessStream(designStream);
        out.write(DesignStreamContent.getBytes());
        out.close();
        out = compoundWriter.createRandomAccessStream(random1Stream);
        out.write(Random1StreamContent.getBytes());
        out.close();
        out = compoundWriter.createRandomAccessStream(random2Stream);
        out.write(Random2StreamContent.getBytes());
        out.close();
        DocumentArchiveTest.assertTrue((!compoundWriter.exists(contentStream) ? 1 : 0) != 0);
        out = compoundWriter.createRandomAccessStream(contentStream);
        out.write(ContentStreamContent.getBytes());
        out.close();
        DocumentArchiveTest.assertTrue((boolean)compoundWriter.exists(contentStream));
        compoundWriter.finish();
        FileArchiveReader compoundReader = new FileArchiveReader(fileArchiveName);
        compoundReader.open();
        RAInputStream in = null;
        String contentFromString = "";
        DocumentArchiveTest.assertTrue((boolean)compoundReader.exists(coreStream));
        DocumentArchiveTest.assertTrue((boolean)compoundReader.exists(random1Stream));
        DocumentArchiveTest.assertTrue((boolean)compoundReader.exists(contentStream));
        in = compoundReader.getStream(coreStream);
        contentFromString = this.readStreamContent(in);
        DocumentArchiveTest.assertTrue((boolean)CoreStreamContent.equals(contentFromString));
        in = compoundReader.getStream(contentStream);
        contentFromString = this.readStreamContent(in);
        DocumentArchiveTest.assertTrue((boolean)ContentStreamContent.equals(contentFromString));
        in = compoundReader.getStream(random1Stream);
        DocumentArchiveTest.assertTrue((in.read() != -1 ? 1 : 0) != 0);
        DocumentArchiveTest.assertTrue((in.skip(2L) == 2L ? 1 : 0) != 0);
        in.close();
        DocumentArchiveTest.assertTrue((compoundReader.listStreams("/").size() == 4 ? 1 : 0) != 0);
        DocumentArchiveTest.assertTrue((compoundReader.listStreams("/Folder1").size() == 0 ? 1 : 0) != 0);
        DocumentArchiveTest.assertTrue((compoundReader.listStreams("/Folder1/Folder2").size() == 1 ? 1 : 0) != 0);
        DocumentArchiveTest.assertTrue((compoundReader.listStreams(contentStream).size() == 0 ? 1 : 0) != 0);
        compoundReader.expandFileArchive(folderArchiveName);
        compoundReader.close();
        FolderArchiveReader folderReader = new FolderArchiveReader(folderArchiveName);
        folderReader.open();
        DocumentArchiveTest.assertTrue((boolean)folderReader.exists(coreStream));
        DocumentArchiveTest.assertTrue((boolean)folderReader.exists(random1Stream));
        DocumentArchiveTest.assertTrue((boolean)folderReader.exists(contentStream));
        in = folderReader.getStream(coreStream);
        contentFromString = this.readStreamContent(in);
        DocumentArchiveTest.assertTrue((boolean)CoreStreamContent.equals(contentFromString));
        in = (RAFolderInputStream)folderReader.getStream(contentStream);
        contentFromString = this.readStreamContent(in);
        DocumentArchiveTest.assertTrue((boolean)ContentStreamContent.equals(contentFromString));
        in = (RAFolderInputStream)folderReader.getStream(random1Stream);
        DocumentArchiveTest.assertTrue((in.read() != -1 ? 1 : 0) != 0);
        DocumentArchiveTest.assertTrue((in.skip(2L) == 2L ? 1 : 0) != 0);
        in.close();
        DocumentArchiveTest.assertTrue((folderReader.listStreams("/").size() == 4 ? 1 : 0) != 0);
        DocumentArchiveTest.assertTrue((folderReader.listStreams("/Folder1").size() == 0 ? 1 : 0) != 0);
        DocumentArchiveTest.assertTrue((folderReader.listStreams("/Folder1/Folder2").size() == 1 ? 1 : 0) != 0);
        DocumentArchiveTest.assertTrue((folderReader.listStreams(contentStream).size() == 0 ? 1 : 0) != 0);
        folderReader.close();
        FolderArchiveWriter folderWriter = new FolderArchiveWriter(folderArchiveName);
        folderWriter.initialize();
        folderWriter.dropStream(coreStream);
        DocumentArchiveTest.assertTrue((!folderWriter.exists(coreStream) ? 1 : 0) != 0);
        folderWriter.dropStream(contentStream);
        DocumentArchiveTest.assertTrue((!folderReader.exists(contentStream) ? 1 : 0) != 0);
        out = folderWriter.createRandomAccessStream(coreStream);
        out.write(CoreStreamContent.getBytes());
        out.close();
        DocumentArchiveTest.assertTrue((boolean)folderWriter.exists(coreStream));
        out = folderWriter.createRandomAccessStream(contentStream);
        out.write(ContentStreamContent.getBytes());
        out.close();
        DocumentArchiveTest.assertTrue((boolean)folderWriter.exists(contentStream));
        folderWriter.finish();
    }

    private String readStreamContent(RAInputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int i = 0;
        byte[] buf = new byte[512];
        while ((i = in.read(buf)) != -1) {
            out.write(buf, 0, i);
        }
        in.close();
        out.close();
        return out.toString();
    }

    public void testReadMutipleThreads() throws IOException {
        FileArchiveWriter writer = new FileArchiveWriter(fileArchiveName);
        writer.initialize();
        int i = 0;
        while (i < this.THREAD_COUNT) {
            RAOutputStream out = writer.createRandomAccessStream("STREAM_" + i);
            int j = 0;
            while (j < this.VALUE_COUNT) {
                out.writeInt(i);
                ++j;
            }
            out.close();
            ++i;
        }
        writer.finish();
        FileArchiveReader reader = new FileArchiveReader(fileArchiveName);
        reader.open();
        int i2 = 0;
        while (i2 < this.THREAD_COUNT) {
            new Thread(new ReadThread((IDocArchiveReader)reader, "STREAM_" + i2, i2)).start();
            ++i2;
        }
        long waitTime = 0L;
        while (this.runningThread > 0) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
            if ((waitTime += 100L) <= 5000L) continue;
            DocumentArchiveTest.fail();
        }
        reader.close();
    }

    private class ReadThread
    implements Runnable {
        IDocArchiveReader reader;
        String name;
        int value;

        ReadThread(IDocArchiveReader reader, String name, int value) {
            this.reader = reader;
            this.name = name;
            this.value = value;
            ++DocumentArchiveTest.this.runningThread;
        }

        public void run() {
            try {
                try {
                    RAInputStream in = this.reader.getStream(this.name);
                    int i = 0;
                    while (i < DocumentArchiveTest.this.VALUE_COUNT) {
                        int readValue = in.readInt();
                        DocumentArchiveTest.assertEquals((int)this.value, (int)readValue);
                        ++i;
                    }
                    in.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    --DocumentArchiveTest.this.runningThread;
                }
            }
            finally {
                --DocumentArchiveTest.this.runningThread;
            }
        }
    }
}

