/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive.compound;

import java.io.File;
import java.io.IOException;
import junit.framework.TestCase;
import org.eclipse.birt.core.archive.compound.ArchiveEntry;
import org.eclipse.birt.core.archive.compound.ArchiveFile;

public class ArchiveFileTest
extends TestCase {
    static final String ARCHIVE_FOLDER = "./utest/";
    static final String ARCHIVE_FILE = "./utest/archive.rptdocument";
    static final String TRANSIENT_ARCHIVE_FILE = "./utest/t_archive.rptdocument";

    public void setUp() {
        new File(ARCHIVE_FOLDER).mkdirs();
    }

    public void tearDown() {
        new File(TRANSIENT_ARCHIVE_FILE).delete();
        new File(ARCHIVE_FILE).delete();
        new File(ARCHIVE_FOLDER).delete();
    }

    public void testArchiveFile() throws IOException {
        ArchiveFile archive = new ArchiveFile(ARCHIVE_FILE, "rw");
        archive.setCacheSize(0);
        archive.setCacheSize(65536);
        this.createArchive(archive);
        this.checkArchive(archive);
        ArchiveFileTest.assertTrue((archive.getUsedCache() > 0 ? 1 : 0) != 0);
        ArchiveFileTest.assertTrue((archive.getUsedCache() <= 65536 ? 1 : 0) != 0);
        archive.close();
        ArchiveFileTest.assertTrue((archive.getUsedCache() == 0 ? 1 : 0) != 0);
        archive = new ArchiveFile(ARCHIVE_FILE, "r");
        this.checkArchive(archive);
        archive.close();
    }

    public void testArchiveFileNoCache() throws IOException {
        ArchiveFile archive = new ArchiveFile(ARCHIVE_FILE, "rw");
        archive.setCacheSize(0);
        this.createArchive(archive);
        this.checkArchive(archive);
        ArchiveFileTest.assertEquals((int)archive.getUsedCache(), (int)0);
        archive.close();
        ArchiveFileTest.assertTrue((archive.getUsedCache() == 0 ? 1 : 0) != 0);
        archive = new ArchiveFile(ARCHIVE_FILE, "rw");
        archive.setCacheSize(65536);
        this.createArchive(archive);
        this.checkArchive(archive);
        ArchiveFileTest.assertTrue((archive.getUsedCache() > 0 ? 1 : 0) != 0);
        archive.setCacheSize(0);
        this.createArchive(archive);
        this.checkArchive(archive);
        ArchiveFileTest.assertEquals((int)archive.getUsedCache(), (int)0);
        archive.close();
        ArchiveFileTest.assertTrue((archive.getUsedCache() == 0 ? 1 : 0) != 0);
    }

    public void testTransient() throws IOException {
        ArchiveFile archive = new ArchiveFile(TRANSIENT_ARCHIVE_FILE, "rwt");
        this.createArchive(archive);
        this.checkArchive(archive);
        archive.close();
        ArchiveFileTest.assertTrue((!new File(TRANSIENT_ARCHIVE_FILE).exists() ? 1 : 0) != 0);
    }

    public void testAppend() throws IOException {
        ArchiveFile archive = new ArchiveFile(ARCHIVE_FILE, "rw");
        this.createArchive(archive);
        archive.close();
        archive = new ArchiveFile(ARCHIVE_FILE, "rw+");
        ArchiveEntry entry = archive.createEntry("/append");
        entry.write(0L, new byte[1], 0, 1);
        this.checkArchive(archive);
        entry = archive.getEntry("/append");
        ArchiveFileTest.assertTrue((entry != null ? 1 : 0) != 0);
        ArchiveFileTest.assertEquals((long)1L, (long)entry.getLength());
        archive.close();
        archive = new ArchiveFile(ARCHIVE_FILE, "r");
        this.checkArchive(archive);
        entry = archive.getEntry("/append");
        ArchiveFileTest.assertTrue((entry != null ? 1 : 0) != 0);
        ArchiveFileTest.assertEquals((long)1L, (long)entry.getLength());
        archive.close();
    }

    public void testSaveAs() throws IOException {
        ArchiveFile archive = new ArchiveFile(TRANSIENT_ARCHIVE_FILE, "rwt");
        this.createArchive(archive);
        archive.saveAs(ARCHIVE_FILE);
        archive.close();
        archive = new ArchiveFile(ARCHIVE_FILE, "r");
        this.checkArchive(archive);
        archive.close();
    }

    void createArchive(ArchiveFile archive) throws IOException {
        int entryCount = 1024;
        byte[] b = new byte[entryCount];
        int i = 0;
        while (i < entryCount) {
            ArchiveEntry entry = archive.createEntry("/entry/" + i);
            entry.write(0L, b, 0, i);
            ++i;
        }
    }

    void checkArchive(ArchiveFile archive) throws IOException {
        int entryCount = 1024;
        int i = 0;
        while (i < entryCount) {
            ArchiveEntry entry = archive.getEntry("/entry/" + i);
            ArchiveFileTest.assertTrue((entry != null ? 1 : 0) != 0);
            ArchiveFileTest.assertEquals((long)i, (long)entry.getLength());
            ++i;
        }
    }
}

