/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive.compound;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import junit.framework.TestCase;
import org.eclipse.birt.core.archive.compound.Block;
import org.eclipse.birt.core.archive.compound.BlockManager;
import org.eclipse.birt.core.archive.compound.BlockManagerEventAdapter;
import org.eclipse.birt.core.util.IOUtil;

public class BlockManagerTest
extends TestCase {
    public void testBlockManager() throws IOException {
        new File("test.rf").delete();
        RandomAccessFile rf = new RandomAccessFile("test.rf", "rw");
        BlockManager manager = new BlockManager((BlockManagerEventAdapter)new CacheManagerEventAdapter(rf));
        manager.setCacheSize(53248);
        int TEST_COUNT = 1000;
        int BLOCK_COUNT = 100;
        byte[] b = new byte[4];
        int i = 0;
        while (i < BLOCK_COUNT) {
            Block block = manager.getBlock(i);
            int v = i++;
            IOUtil.integerToBytes((int)v, (byte[])b);
            block.write(0, b, 0, 4);
        }
        i = 0;
        while (i < TEST_COUNT) {
            int id = (int)(Math.random() * (double)BLOCK_COUNT);
            Block block = manager.getBlock(id);
            block.read(0, b, 0, 4);
            int v = IOUtil.bytesToInteger((byte[])b);
            BlockManagerTest.assertEquals((int)id, (int)v);
            ++i;
        }
        manager.flush();
        rf.close();
        rf = new RandomAccessFile("test.rf", "r");
        i = 0;
        while (i < BLOCK_COUNT) {
            rf.seek(i * 4096);
            int v = rf.readInt();
            BlockManagerTest.assertEquals((int)v, (int)i);
            ++i;
        }
        rf.close();
        new File("test.rf").delete();
    }

    class CacheManagerEventAdapter
    extends BlockManagerEventAdapter {
        RandomAccessFile rf;

        CacheManagerEventAdapter(RandomAccessFile rf) {
            this.rf = rf;
        }

        public void flush(Block block) throws IOException {
            block.flush(this.rf);
        }

        public void refresh(Block block) throws IOException {
            block.refresh(this.rf);
        }
    }
}

