/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive.compound;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import junit.framework.TestCase;
import org.eclipse.birt.core.archive.ArchiveUtil;
import org.eclipse.birt.core.archive.compound.ArchiveEntry;
import org.eclipse.birt.core.archive.compound.ArchiveFile;

public class UpgradeArchiveTest
extends TestCase {
    public void setUp() {
        new File("./utest/").mkdir();
    }

    public void tearDown() {
        new File("./utest/").delete();
    }

    public void testUpgrade() throws IOException {
        InputStream in = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org/eclipse/birt/core/archive/compound/V2_1_1.rptarchive");
        FileOutputStream out = new FileOutputStream("./utest/test.rptarchive");
        byte[] buffer = new byte[4096];
        int size = in.read(buffer);
        do {
            ((OutputStream)out).write(buffer, 0, size);
        } while ((size = in.read(buffer)) != -1);
        ((OutputStream)out).close();
        in.close();
        ArchiveFile af = new ArchiveFile("./utest/test.rptarchive", "rw+");
        int i = 0;
        while (i < 128) {
            ArchiveEntry entry = af.getEntry("/" + i);
            UpgradeArchiveTest.assertEquals((long)(i * 4), (long)entry.getLength());
            int j = 0;
            while (j < i) {
                entry.read((long)(j * 4), buffer, 0, 4);
                int v = ArchiveUtil.bytesToInteger((byte[])buffer);
                UpgradeArchiveTest.assertEquals((int)j, (int)v);
                ++j;
            }
            ++i;
        }
        af.close();
        new File("./utest/test.rptarchive").delete();
    }
}

