/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.btree;

import java.io.File;
import junit.framework.TestCase;
import org.eclipse.birt.core.btree.BTree;
import org.eclipse.birt.core.btree.BTreeCursor;
import org.eclipse.birt.core.btree.BTreeFile;
import org.eclipse.birt.core.btree.BTreeOption;
import org.eclipse.birt.core.btree.FileBTreeFile;

public class BTreeCursorTest
extends TestCase {
    public void testCursor() throws Exception {
        new File("./utest/btree.dat").delete();
        FileBTreeFile file = new FileBTreeFile("./utest/btree.dat");
        try {
            BTreeOption option = new BTreeOption();
            option.setFile((BTreeFile)file);
            BTree btree = new BTree(option);
            BTreeCursor cursor = btree.createCursor();
            int i = 9999;
            while (i >= 0) {
                cursor.insert((Object)new Integer(i), (Object)String.valueOf(i));
                BTreeCursorTest.assertEquals((String)String.valueOf(i), (String)((String)cursor.getValue()));
                --i;
            }
            cursor.close();
            btree.close();
            btree = new BTree(option);
            cursor = btree.createCursor();
            boolean hasKey = cursor.moveTo((Object)new Integer(999));
            int v = 999;
            while (hasKey) {
                BTreeCursorTest.assertEquals((Object)new Integer(v), (Object)cursor.getKey());
                BTreeCursorTest.assertEquals((String)String.valueOf(v), (String)((String)cursor.getValue()));
                hasKey = cursor.previous();
                --v;
            }
            hasKey = cursor.moveTo((Object)new Integer(0));
            v = 0;
            while (hasKey) {
                BTreeCursorTest.assertEquals((Object)new Integer(v), (Object)cursor.getKey());
                BTreeCursorTest.assertEquals((String)String.valueOf(v), (String)((String)cursor.getValue()));
                hasKey = cursor.next();
                ++v;
            }
            cursor.close();
            btree.close();
        }
        finally {
            file.close();
        }
    }
}

