/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.btree;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import org.eclipse.birt.core.btree.BTree;
import org.eclipse.birt.core.btree.BTreeFile;
import org.eclipse.birt.core.btree.BTreeOption;
import org.eclipse.birt.core.btree.BTreeSerializer;
import org.eclipse.birt.core.btree.BTreeTestCase;
import org.eclipse.birt.core.btree.FileBTreeFile;
import org.eclipse.birt.core.btree.RAMBTreeFile;

public class BTreeTest
extends BTreeTestCase {
    public void testBTree() throws Exception {
        RAMBTreeFile file = new RAMBTreeFile();
        BTreeOption option = new BTreeOption();
        option.setHasValue(false);
        option.setKeySize(4);
        option.setKeySerializer((BTreeSerializer)new BTreeTestCase.IntegerSerializer(this));
        option.setFile((BTreeFile)file);
        BTree btree = new BTree(option);
        int i = 0;
        while (i < 10000) {
            if (!btree.exist((Object)i)) {
                btree.insert((Object)i, null);
            }
            ++i;
        }
        BTreeTest.assertEquals((int)10000, (int)btree.getTotalKeys());
        BTreeTest.assertEquals((int)0, (int)btree.getTotalValues());
        i = 0;
        while (i < 10000) {
            BTreeTest.assertTrue((boolean)btree.exist((Object)i));
            ++i;
        }
        BTreeTest.assertTrue((!btree.exist((Object)10001) ? 1 : 0) != 0);
        BTreeTest.assertTrue((!btree.exist((Object)-1) ? 1 : 0) != 0);
        btree.close();
        btree = new BTree(option);
        BTreeTest.assertEquals((int)10000, (int)btree.getTotalKeys());
        BTreeTest.assertEquals((int)0, (int)btree.getTotalValues());
        i = 0;
        while (i < 10000) {
            BTreeTest.assertTrue((boolean)btree.exist((Object)i));
            ++i;
        }
        BTreeTest.assertTrue((!btree.exist((Object)10001) ? 1 : 0) != 0);
        BTreeTest.assertTrue((!btree.exist((Object)-1) ? 1 : 0) != 0);
        btree.close();
    }

    public void testFixKey() throws Exception {
        RAMBTreeFile file = new RAMBTreeFile();
        BTreeOption option = new BTreeOption();
        option.setHasValue(false);
        option.setKeySize(4);
        option.setKeySerializer((BTreeSerializer)new BTreeTestCase.IntegerSerializer(this));
        option.setFile((BTreeFile)file);
        BTree btree = new BTree(option);
        Collection<String> input = this.createSampleInput();
        HashSet<String> keys = new HashSet<String>();
        for (String key : input) {
            keys.add(key);
            btree.insert((Object)Integer.valueOf(key), null);
        }
        BTreeTest.assertEquals((int)keys.size(), (int)btree.getTotalKeys());
        for (String key : keys) {
            BTreeTest.assertTrue((boolean)btree.exist((Object)Integer.valueOf(key)));
        }
        btree.close();
        btree = new BTree(option);
        BTreeTest.assertEquals((int)keys.size(), (int)btree.getTotalKeys());
        for (String key : keys) {
            BTreeTest.assertTrue((boolean)btree.exist((Object)Integer.valueOf(key)));
        }
        btree.close();
    }

    public void testFixValue() throws Exception {
        Integer value;
        RAMBTreeFile file = new RAMBTreeFile();
        BTreeOption option = new BTreeOption();
        option.setHasValue(true);
        option.setValueSize(4);
        option.setValueSerializer((BTreeSerializer)new BTreeTestCase.IntegerSerializer(this));
        option.setFile((BTreeFile)file);
        BTree btree = new BTree(option);
        Collection<String> input = this.createSampleInput();
        HashMap<String, Integer> values = new HashMap<String, Integer>();
        for (String string : input) {
            value = Integer.valueOf(string);
            values.put(string, value);
            btree.insert((Object)string, (Object)value);
        }
        BTreeTest.assertEquals((int)values.size(), (int)btree.getTotalKeys());
        BTreeTest.assertEquals((int)values.size(), (int)btree.getTotalValues());
        for (Map.Entry entry : values.entrySet()) {
            value = (Integer)btree.getValue((Object)((String)entry.getKey()));
            BTreeTest.assertEquals(entry.getValue(), (Object)value);
        }
        btree.close();
        btree = new BTree(option);
        BTreeTest.assertEquals((int)values.size(), (int)btree.getTotalKeys());
        BTreeTest.assertEquals((int)values.size(), (int)btree.getTotalValues());
        for (Map.Entry entry : values.entrySet()) {
            value = (Integer)btree.getValue((Object)((String)entry.getKey()));
            BTreeTest.assertEquals(entry.getValue(), (Object)value);
        }
        btree.close();
    }

    public void testDuplicate() throws Exception {
        new File("./utest/btree.dat").delete();
        FileBTreeFile file = new FileBTreeFile("./utest/btree.dat");
        try {
            Collection values2;
            Collection values1;
            BTreeOption option = new BTreeOption();
            option.setHasValue(true);
            option.setAllowDuplicate(true);
            option.setFile((BTreeFile)file);
            BTree btree = new BTree(option);
            Collection<String> input = this.createSampleInput();
            HashMap<String, ArrayList<Integer>> map = new HashMap<String, ArrayList<Integer>>();
            int totalValues = 0;
            for (String string : input) {
                Integer value = totalValues;
                ArrayList<Integer> values = (ArrayList<Integer>)map.get(string);
                if (values == null) {
                    values = new ArrayList<Integer>();
                    map.put(string, values);
                }
                values.add(value);
                btree.insert((Object)string, (Object)value);
                ++totalValues;
            }
            BTreeTest.assertEquals((int)map.size(), (int)btree.getTotalKeys());
            BTreeTest.assertEquals((int)totalValues, (int)btree.getTotalValues());
            for (Map.Entry entry : map.entrySet()) {
                values1 = btree.getValues((Object)((String)entry.getKey()));
                values2 = (Collection)entry.getValue();
                BTreeTest.assertEquals((int)values2.size(), (int)values1.size());
                BTreeTest.assertTrue((boolean)values1.containsAll(values2));
            }
            btree.close();
            btree = new BTree(option);
            BTreeTest.assertEquals((int)map.size(), (int)btree.getTotalKeys());
            BTreeTest.assertEquals((int)totalValues, (int)btree.getTotalValues());
            for (Map.Entry entry : map.entrySet()) {
                values1 = btree.getValues((Object)((String)entry.getKey()));
                values2 = (Collection)entry.getValue();
                BTreeTest.assertEquals((int)values2.size(), (int)values1.size());
                BTreeTest.assertTrue((boolean)values1.containsAll(values2));
            }
            btree.close();
        }
        finally {
            file.close();
        }
    }

    public void testHugeKey() throws Exception {
        new File("./utest/btree.dat").delete();
        FileBTreeFile file = new FileBTreeFile("./utest/btree.dat");
        try {
            String key;
            char[] chars;
            BTreeOption option = new BTreeOption();
            option.setHasValue(false);
            option.setFile((BTreeFile)file);
            BTree btree = new BTree(option);
            Random random = new Random();
            ArrayList<Integer> input = new ArrayList<Integer>();
            int i = 0;
            while (i < 10000) {
                int value = random.nextInt(40) + 1;
                chars = new char[value * 1024];
                Arrays.fill(chars, 'a');
                key = new String(chars);
                if (!btree.exist((Object)key)) {
                    btree.insert((Object)key, null);
                    input.add(value);
                }
                ++i;
            }
            BTreeTest.assertEquals((int)input.size(), (int)btree.getTotalKeys());
            for (Integer value : input) {
                chars = new char[value * 1024];
                Arrays.fill(chars, 'a');
                key = new String(chars);
                BTreeTest.assertTrue((boolean)btree.exist((Object)key));
            }
            btree.close();
            btree = new BTree(option);
            BTreeTest.assertEquals((int)input.size(), (int)btree.getTotalKeys());
            for (Integer value : input) {
                chars = new char[value * 1024];
                Arrays.fill(chars, 'a');
                key = new String(chars);
                BTreeTest.assertTrue((boolean)btree.exist((Object)key));
            }
        }
        finally {
            file.close();
        }
    }

    public void testHugeValue() throws Exception {
        new File("./utest/btree.dat").delete();
        FileBTreeFile file = new FileBTreeFile("./utest/btree.dat");
        try {
            char[] value;
            BTreeOption option = new BTreeOption();
            option.setHasValue(true);
            option.setAllowDuplicate(false);
            option.setFile((BTreeFile)file);
            BTree btree = new BTree(option);
            Random random = new Random();
            ArrayList<Integer> input = new ArrayList<Integer>();
            int i = 0;
            while (i < 10000) {
                int v = random.nextInt(40) + 1;
                Integer key = v;
                if (!btree.exist((Object)key)) {
                    char[] value2 = new char[v * 1023];
                    Arrays.fill(value2, 'a');
                    btree.insert((Object)key, (Object)value2);
                    input.add(v);
                }
                ++i;
            }
            BTreeTest.assertEquals((int)input.size(), (int)btree.getTotalKeys());
            BTreeTest.assertEquals((int)input.size(), (int)btree.getTotalValues());
            for (Integer key : input) {
                value = (char[])btree.getValue((Object)key);
                BTreeTest.assertEquals((Object)key, (Object)(value.length / 1023));
            }
            btree.close();
            btree = new BTree(option);
            BTreeTest.assertEquals((int)input.size(), (int)btree.getTotalKeys());
            BTreeTest.assertEquals((int)input.size(), (int)btree.getTotalValues());
            for (Integer key : input) {
                value = (char[])btree.getValue((Object)key);
                BTreeTest.assertEquals((Object)key, (Object)(value.length / 1023));
            }
        }
        finally {
            file.close();
        }
    }

    private String createTestKey(int value, int entryCount) {
        int a = value % 3;
        int b = value / 3;
        switch (a) {
            case 0: {
                return String.valueOf(b);
            }
            case 1: {
                return String.valueOf(entryCount / 3 + b);
            }
        }
        return String.valueOf(entryCount / 3 * 2 + b);
    }

    public void testHugeNumberOfEntries() throws Exception {
        int ENTRY_COUNT = 999999;
        new File("./utest/btree.dat").delete();
        FileBTreeFile file = new FileBTreeFile("./utest/btree.dat");
        try {
            BTreeOption option = new BTreeOption();
            option.setHasValue(true);
            option.setFile((BTreeFile)file);
            option.setCacheSize(1024);
            BTree btree = new BTree(option);
            long start = System.currentTimeMillis();
            System.out.println("INSERT 1M entries....");
            int i = 0;
            while (i < ENTRY_COUNT) {
                String key = this.createTestKey(i, ENTRY_COUNT);
                btree.insert((Object)key, (Object)key);
                if (i % 10000 == 0) {
                    System.out.print('.');
                }
                ++i;
            }
            btree.close();
            long end = System.currentTimeMillis();
            System.out.println("FINISHED at " + (end - start) + "ms");
            start = System.currentTimeMillis();
            System.out.println("QURRY 1M entries....");
            btree = new BTree(option);
            BTreeTest.assertEquals((int)ENTRY_COUNT, (int)btree.getTotalKeys());
            BTreeTest.assertEquals((int)ENTRY_COUNT, (int)btree.getTotalValues());
            int i2 = 0;
            while (i2 < ENTRY_COUNT) {
                String key = String.valueOf(i2);
                String value = (String)btree.getValue((Object)key);
                BTreeTest.assertEquals((String)key, (String)value);
                if (i2 % 10000 == 0) {
                    System.out.print('.');
                }
                ++i2;
            }
            end = System.currentTimeMillis();
            System.out.println("FINISHED at " + (end - start) + "ms");
            btree.close();
        }
        finally {
            file.close();
        }
    }
}

