/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.btree;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import junit.framework.TestCase;
import org.eclipse.birt.core.btree.BTreeFile;
import org.eclipse.birt.core.btree.NodeFile;
import org.eclipse.birt.core.btree.NodeOutputStream;
import org.eclipse.birt.core.btree.RAMBTreeFile;

public class NodeOutputStreamTest
extends TestCase {
    public void testEmptyOutputStream() throws IOException {
        RAMBTreeFile file = new RAMBTreeFile();
        this.testOutputStream((BTreeFile)file, new NodeOutputStream((NodeFile)file));
    }

    protected void testOutputStream(BTreeFile file, NodeOutputStream o) throws IOException {
        DataOutputStream out = new DataOutputStream((OutputStream)o);
        int i = 0;
        while (i < 1022) {
            out.writeInt(i);
            ++i;
        }
        out.writeLong(1311768467139281697L);
        i = 0;
        while (i < 10) {
            out.writeUTF(String.valueOf(i));
            ++i;
        }
        o.close();
        int[] blocks = o.getUsedBlocks();
        NodeOutputStreamTest.assertEquals((int)2, (int)blocks.length);
        NodeOutputStreamTest.assertEquals((int)0, (int)blocks[0]);
        NodeOutputStreamTest.assertEquals((int)1, (int)blocks[1]);
        byte[] bytes = new byte[4096];
        file.readBlock(0, bytes);
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(bytes));
        NodeOutputStreamTest.assertEquals((int)1, (int)in.readInt());
        int i2 = 0;
        while (i2 < 1022) {
            NodeOutputStreamTest.assertEquals((int)i2, (int)in.readInt());
            ++i2;
        }
        NodeOutputStreamTest.assertEquals((int)305419896, (int)in.readInt());
        file.readBlock(1, bytes);
        in = new DataInputStream(new ByteArrayInputStream(bytes));
        NodeOutputStreamTest.assertEquals((int)-1, (int)in.readInt());
        NodeOutputStreamTest.assertEquals((int)-2023406815, (int)in.readInt());
        i2 = 0;
        while (i2 < 10) {
            NodeOutputStreamTest.assertEquals((String)String.valueOf(i2), (String)in.readUTF());
            ++i2;
        }
    }

    public void testIncreaseOutputStream() throws IOException {
        RAMBTreeFile file = new RAMBTreeFile();
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(4096);
        DataOutputStream out = new DataOutputStream(buffer);
        out.writeInt(-1);
        file.writeBlock(0, buffer.toByteArray());
        this.testOutputStream((BTreeFile)file, new NodeOutputStream((NodeFile)file, new int[1]));
    }

    public void testDecreaseOutputStream() throws IOException {
        RAMBTreeFile file = new RAMBTreeFile();
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(4096);
        DataOutputStream out = new DataOutputStream(buffer);
        out.writeInt(1);
        file.writeBlock(0, buffer.toByteArray());
        buffer.reset();
        out = new DataOutputStream(buffer);
        out.writeInt(2);
        file.writeBlock(1, buffer.toByteArray());
        buffer.reset();
        out = new DataOutputStream(buffer);
        out.writeInt(-1);
        out = new DataOutputStream(buffer);
        file.writeBlock(2, buffer.toByteArray());
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = 2;
        this.testOutputStream((BTreeFile)file, new NodeOutputStream((NodeFile)file, nArray));
    }
}

