/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.data;

import junit.framework.TestCase;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.data.IColumnBinding;
import org.eclipse.birt.core.data.Messages;
import org.eclipse.birt.core.exception.BirtException;

public class ExpressionUtilTest
extends TestCase {
    public void testToNewExpression() {
        String[] stringArray = new String[14];
        stringArray[1] = "   " + Messages.getString("ExpressionUtilTest.old.0");
        stringArray[2] = Messages.getString("ExpressionUtilTest.old.1");
        stringArray[3] = Messages.getString("ExpressionUtilTest.old.2");
        stringArray[4] = Messages.getString("ExpressionUtilTest.old.3");
        stringArray[5] = Messages.getString("ExpressionUtilTest.old.4");
        stringArray[6] = Messages.getString("ExpressionUtilTest.old.5");
        stringArray[7] = Messages.getString("ExpressionUtilTest.old.6");
        stringArray[8] = Messages.getString("ExpressionUtilTest.old.7");
        stringArray[9] = Messages.getString("ExpressionUtilTest.old.8");
        stringArray[10] = Messages.getString("ExpressionUtilTest.old.9");
        stringArray[11] = Messages.getString("ExpressionUtilTest.old.10");
        stringArray[12] = Messages.getString("ExpressionUtilTest.old.11");
        stringArray[13] = Messages.getString("ExpressionUtilTest.old.12");
        String[] oldExpressions = stringArray;
        String[] stringArray2 = new String[14];
        stringArray2[1] = "   " + Messages.getString("ExpressionUtilTest.new.0");
        stringArray2[2] = Messages.getString("ExpressionUtilTest.new.1");
        stringArray2[3] = Messages.getString("ExpressionUtilTest.new.2");
        stringArray2[4] = Messages.getString("ExpressionUtilTest.new.3");
        stringArray2[5] = Messages.getString("ExpressionUtilTest.new.4");
        stringArray2[6] = Messages.getString("ExpressionUtilTest.new.5");
        stringArray2[7] = Messages.getString("ExpressionUtilTest.new.6");
        stringArray2[8] = Messages.getString("ExpressionUtilTest.new.7");
        stringArray2[9] = Messages.getString("ExpressionUtilTest.new.8");
        stringArray2[10] = Messages.getString("ExpressionUtilTest.new.9");
        stringArray2[11] = Messages.getString("ExpressionUtilTest.new.10");
        stringArray2[12] = Messages.getString("ExpressionUtilTest.new.11");
        stringArray2[13] = Messages.getString("ExpressionUtilTest.new.12");
        String[] newExpressions = stringArray2;
        int i = 0;
        while (i < oldExpressions.length) {
            IColumnBinding icb = ExpressionUtil.getColumnBinding((String)oldExpressions[i]);
            ExpressionUtilTest.assertEquals((String)icb.getBoundExpression(), (String)newExpressions[i]);
            ExpressionUtilTest.assertEquals((String)icb.getResultSetColumnName(), (String)("COLUMN_" + (i + 1)));
            ++i;
        }
    }

    public void testreplaceRowsExpression() {
        String[] stringArray = new String[14];
        stringArray[1] = "   " + Messages.getString("ExpressionUtilTest.old.13");
        stringArray[2] = Messages.getString("ExpressionUtilTest.old.14");
        stringArray[3] = Messages.getString("ExpressionUtilTest.old.15");
        stringArray[4] = Messages.getString("ExpressionUtilTest.old.16");
        stringArray[5] = Messages.getString("ExpressionUtilTest.old.17");
        stringArray[6] = Messages.getString("ExpressionUtilTest.old.18");
        stringArray[7] = Messages.getString("ExpressionUtilTest.old.19");
        stringArray[8] = Messages.getString("ExpressionUtilTest.old.20");
        stringArray[9] = Messages.getString("ExpressionUtilTest.old.21");
        stringArray[10] = Messages.getString("ExpressionUtilTest.old.22");
        stringArray[11] = Messages.getString("ExpressionUtilTest.old.23");
        stringArray[12] = Messages.getString("ExpressionUtilTest.old.24");
        stringArray[13] = Messages.getString("ExpressionUtilTest.old.25");
        String[] oldExpressions = stringArray;
        String[] stringArray2 = new String[14];
        stringArray2[1] = "   " + Messages.getString("ExpressionUtilTest.new.13");
        stringArray2[2] = Messages.getString("ExpressionUtilTest.new.14");
        stringArray2[3] = Messages.getString("ExpressionUtilTest.new.15");
        stringArray2[4] = Messages.getString("ExpressionUtilTest.new.16");
        stringArray2[5] = Messages.getString("ExpressionUtilTest.new.17");
        stringArray2[6] = Messages.getString("ExpressionUtilTest.new.18");
        stringArray2[7] = Messages.getString("ExpressionUtilTest.new.19");
        stringArray2[8] = Messages.getString("ExpressionUtilTest.new.20");
        stringArray2[9] = Messages.getString("ExpressionUtilTest.new.21");
        stringArray2[10] = Messages.getString("ExpressionUtilTest.new.22");
        stringArray2[11] = Messages.getString("ExpressionUtilTest.new.23");
        stringArray2[12] = Messages.getString("ExpressionUtilTest.new.24");
        stringArray2[13] = Messages.getString("ExpressionUtilTest.new.25");
        String[] newExpressions = stringArray2;
        int i = 0;
        while (i < oldExpressions.length) {
            ExpressionUtilTest.assertEquals((String)ExpressionUtil.updateParentQueryReferenceExpression((String)oldExpressions[i], (boolean)false), (String)newExpressions[i]);
            ++i;
        }
        String paramBinding = "rows[0].abc";
        String result = "row.abc";
        ExpressionUtilTest.assertEquals((String)ExpressionUtil.updateParentQueryReferenceExpression((String)paramBinding, (boolean)true), (String)result);
    }

    public void testCreateExpression() {
        ExpressionUtilTest.assertEquals((String)"row[\"abc\"]", (String)ExpressionUtil.createRowExpression((String)"abc"));
        ExpressionUtilTest.assertEquals((String)"row[\"\"]", (String)ExpressionUtil.createRowExpression(null));
        ExpressionUtilTest.assertEquals((String)"dataSetRow[\"abc\"]", (String)ExpressionUtil.createDataSetRowExpression((String)"abc"));
        ExpressionUtilTest.assertEquals((String)"dataSetRow[\"\"]", (String)ExpressionUtil.createDataSetRowExpression(null));
    }

    public void testIsScalarParamReference() {
        ExpressionUtilTest.assertTrue((boolean)ExpressionUtil.isScalarParamReference((String)"params[\"aaa\"]"));
        ExpressionUtilTest.assertFalse((boolean)ExpressionUtil.isScalarParamReference((String)"params[\"\"]"));
        ExpressionUtilTest.assertFalse((boolean)ExpressionUtil.isScalarParamReference((String)"reparams[\"aaa\"]"));
        ExpressionUtilTest.assertFalse((boolean)ExpressionUtil.isScalarParamReference((String)"params[aaa]"));
    }

    public void testGetColumnBindingName() throws BirtException {
        ExpressionUtilTest.assertTrue((ExpressionUtil.getColumnBindingName((String)"100") == null ? 1 : 0) != 0);
        ExpressionUtilTest.assertTrue((boolean)ExpressionUtil.getColumnBindingName((String)"row[\"col1\"]").equals("col1"));
        ExpressionUtilTest.assertTrue((boolean)ExpressionUtil.getColumnBindingName((String)"row[\"col1\"+1]").equals("col11"));
        ExpressionUtilTest.assertTrue((ExpressionUtil.getColumnBindingName((String)"row[\"col1\"]+ \"abc\"") == null ? 1 : 0) != 0);
        ExpressionUtilTest.assertTrue((ExpressionUtil.getColumnBindingName((String)"row[0]") == null ? 1 : 0) != 0);
        ExpressionUtilTest.assertTrue((boolean)ExpressionUtil.getColumnBindingName((String)"row.col1").equals("col1"));
        ExpressionUtilTest.assertTrue((ExpressionUtil.getColumnBindingName((String)"100+row[\"col1\"]") == null ? 1 : 0) != 0);
        ExpressionUtilTest.assertTrue((ExpressionUtil.getColumnBindingName((String)"Total.sum( row[\"col1\"])") == null ? 1 : 0) != 0);
        ExpressionUtilTest.assertTrue((ExpressionUtil.getColumnBindingName((String)"row[\"col1\"]+ row[\"col2\"]") == null ? 1 : 0) != 0);
    }

    public void testCreateJSRowExpression() throws BirtException {
        ExpressionUtilTest.assertEquals((String)ExpressionUtil.createJSRowExpression((String)"abc"), (String)"row[\"abc\"]");
        ExpressionUtilTest.assertEquals((String)ExpressionUtil.createJSRowExpression(null), (String)"row[\"\"]");
    }

    public void testCreateJSDataSetRowExpression() throws BirtException {
        ExpressionUtilTest.assertEquals((String)ExpressionUtil.createJSDataSetRowExpression((String)"abc"), (String)"dataSetRow[\"abc\"]");
        ExpressionUtilTest.assertEquals((String)ExpressionUtil.createJSDataSetRowExpression(null), (String)"dataSetRow[\"\"]");
    }

    public void testCreateJSParameterExpression() throws BirtException {
        ExpressionUtilTest.assertEquals((String)ExpressionUtil.createJSParameterExpression((String)"abc"), (String)"params[\"abc\"]");
        ExpressionUtilTest.assertEquals((String)ExpressionUtil.createJSParameterExpression(null), (String)"params[\"\"]");
    }

    public void testCreateJSMeasureExpression() throws BirtException {
        ExpressionUtilTest.assertEquals((String)ExpressionUtil.createJSMeasureExpression((String)"abc"), (String)"measure[\"abc\"]");
        ExpressionUtilTest.assertEquals((String)ExpressionUtil.createJSMeasureExpression(null), (String)"measure[\"\"]");
    }

    public void testCreateJSDimensionExpression() throws BirtException {
        ExpressionUtilTest.assertEquals((String)ExpressionUtil.createJSDimensionExpression((String)"abc", (String)"def"), (String)"dimension[\"abc\"][\"def\"]");
        ExpressionUtilTest.assertEquals((String)ExpressionUtil.createJSDimensionExpression(null, null), (String)"dimension[\"\"][\"\"]");
        ExpressionUtilTest.assertEquals((String)ExpressionUtil.createJSDimensionExpression((String)"abc", (String)"def", (String)"ghi"), (String)"dimension[\"abc\"][\"def\"][\"ghi\"]");
    }
}

