/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.format;

import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.sql.Time;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import junit.framework.TestCase;
import org.eclipse.birt.core.format.DateFormatter;

public class DateFormatterTest
extends TestCase {
    public void testDateFormat() {
        String golden = "09/13/1998 08:01:44 PM";
        DateFormatter sample = new DateFormatter("MM/dd/yyyy hh:mm:ss a", ULocale.ENGLISH);
        Locale locDef = Locale.getDefault();
        Calendar dateCal = Calendar.getInstance(locDef);
        dateCal.set(1998, 8, 13, 20, 1, 44);
        Date date = dateCal.getTime();
        String fmtDate = sample.format(date);
        DateFormatterTest.assertEquals((String)golden, (String)fmtDate);
    }

    public void testDateFormatString() {
        DateFormatter sample = new DateFormatter("MM/dd/yyyy hh:mm:ss a");
        Locale locDef = Locale.getDefault();
        Calendar dateCal = Calendar.getInstance(locDef);
        dateCal.set(1998, 8, 13, 20, 1, 44);
        Date date = dateCal.getTime();
        SimpleDateFormat sampleJava = new SimpleDateFormat("MM/dd/yyyy hh:mm:ss a", locDef);
        DateFormatterTest.assertEquals((String)sampleJava.format(date), (String)sample.format(date));
    }

    public void testDateFormatStringStringCHN() {
        Locale locDef = Locale.getDefault();
        Calendar dateCal = Calendar.getInstance(locDef);
        dateCal.set(1998, 8, 13, 20, 1, 44);
        Date date = dateCal.getTime();
        DateFormatter sample = new DateFormatter("MM/dd/yyyy hh:mm:ss a", new ULocale("CHINESE"));
        SimpleDateFormat sampleJava = new SimpleDateFormat("MM/dd/yyyy hh:mm:ss a", new Locale("CHINESE"));
        DateFormatterTest.assertEquals((String)sampleJava.format(date), (String)sample.format(date));
        sample.applyPattern("MM/dd/yyyy hh:mm:ss a");
        DateFormatterTest.assertEquals((String)sampleJava.format(date), (String)sample.format(date));
    }

    public void testDateFormatLocale() {
        Locale locale = new Locale("en", "us");
        DateFormatter sample = new DateFormatter(ULocale.forLocale((Locale)locale));
        Locale locDef = Locale.getDefault();
        Calendar dateCal = Calendar.getInstance(locDef);
        dateCal.set(1998, 8, 13, 20, 1, 44);
        Date date = dateCal.getTime();
        locale = Locale.ITALY;
        sample = new DateFormatter(ULocale.forLocale((Locale)locale));
        new SimpleDateFormat("MM/dd/yy KK:mm aa", locale);
        sample.applyPattern("MM/dd/yy KK:mm aa");
        DateFormatterTest.assertEquals((String)"09/13/98 08:01 p.", (String)sample.format(date));
        sample = new DateFormatter("Long Date", ULocale.forLocale((Locale)locale));
        DateFormatterTest.assertEquals((String)"13 settembre 1998", (String)sample.format(date));
        DateFormatterTest.assertTrue((boolean)true);
    }

    public void testDateFormatStringLocale() {
        Locale locale = new Locale("en", "us");
        DateFormatter sample = new DateFormatter("MM/dd/yyyy hh:mm:ss a", ULocale.forLocale((Locale)locale));
        Locale locDef = Locale.getDefault();
        Calendar dateCal = Calendar.getInstance(locDef);
        dateCal.set(1998, 8, 13, 20, 1, 44);
        Date date = dateCal.getTime();
        DateFormatterTest.assertEquals((String)"09/13/1998 08:01:44 PM", (String)sample.format(date));
    }

    public void testGetPattern() {
        Locale locale = new Locale("en", "us");
        DateFormatter sample = new DateFormatter("MM/dd/yyyy hh:mm:ss a", ULocale.forLocale((Locale)locale));
        DateFormatterTest.assertEquals((String)"MM/dd/yyyy hh:mm:ss a", (String)sample.getPattern());
    }

    public void testApplyPattern() {
        Locale locDef = Locale.getDefault();
        Calendar dateCal = Calendar.getInstance(locDef);
        dateCal.set(1998, 8, 13, 20, 1, 44);
        Date date = dateCal.getTime();
        Locale locale = new Locale("en", "us");
        DateFormatter sample = new DateFormatter(ULocale.forLocale((Locale)locale));
        sample.applyPattern("Long Date");
        DateFormatterTest.assertEquals((String)"September 13, 1998", (String)sample.format(date));
        sample.applyPattern("D");
        DateFormatterTest.assertEquals((String)"September 13, 1998", (String)sample.format(date));
        sample.applyPattern("Medium Date");
        DateFormatterTest.assertEquals((String)"Sep 13, 1998", (String)sample.format(date));
        sample.applyPattern("Short Date");
        DateFormatterTest.assertEquals((String)"9/13/98", (String)sample.format(date));
        sample.applyPattern("d");
        DateFormatterTest.assertEquals((String)"9/13/98", (String)sample.format(date));
        sample.applyPattern("Long Time");
        DateFormatterTest.assertEquals((boolean)true, (boolean)sample.format(date).startsWith("8:01:44 PM GMT+"));
        sample.applyPattern("T");
        DateFormatterTest.assertEquals((boolean)true, (boolean)sample.format(date).startsWith("8:01:44 PM GMT+"));
        SimpleDateFormat javaSample = (SimpleDateFormat)DateFormat.getDateTimeInstance(1, 3, locale);
        sample.applyPattern("f");
        DateFormatterTest.assertEquals((String)javaSample.format(date), (String)sample.format(date));
        sample.applyPattern("General Date");
        DateFormatterTest.assertEquals((boolean)true, (boolean)sample.format(date).startsWith("September 13, 1998 8:01:44 PM GMT+"));
        sample.applyPattern("Short Time");
        DateFormatterTest.assertEquals((String)"20:01", (String)sample.format(date));
        sample.applyPattern("Medium Time");
        DateFormatterTest.assertEquals((String)"8:01:44 PM", (String)sample.format(date));
    }

    public void testIFormat() {
        Calendar dateCal = Calendar.getInstance(Locale.US);
        dateCal.set(1998, 8, 13, 20, 1, 44);
        Date dateTime = dateCal.getTime();
        java.sql.Date date = new java.sql.Date(dateTime.getTime());
        Time time = new Time(dateTime.getTime());
        DateFormatter format = new DateFormatter("i", ULocale.US);
        String strDateTime = format.format(dateTime);
        String strTime = format.format((Date)time);
        String strDate = format.format((Date)date);
        DateFormatterTest.assertEquals((String)"9/13/1998 8:01:44 PM", (String)strDateTime);
        DateFormatterTest.assertEquals((String)"9/13/1998", (String)strDate);
        DateFormatterTest.assertEquals((String)"8:01:44 PM", (String)strTime);
        try {
            Date date1 = format.parse(strDate);
            java.sql.Date date2 = new java.sql.Date(date1.getTime());
            DateFormatterTest.assertEquals((String)date.toString(), (String)date2.toString());
            Date time1 = format.parse(strTime);
            Time time2 = new Time(time1.getTime());
            DateFormatterTest.assertEquals((String)time.toString(), (String)time2.toString());
            Date dateTime1 = format.parse(strDateTime);
            DateFormatterTest.assertEquals((String)dateTime.toString(), (String)dateTime1.toString());
        }
        catch (ParseException parseException) {
            DateFormatterTest.assertTrue((boolean)false);
        }
        String tmpDate = "01/02/2003 3:";
        try {
            Date tmpD = format.parse(tmpDate);
            new java.sql.Date(tmpD.getTime());
        }
        catch (ParseException ex) {
            ex.printStackTrace();
        }
    }

    public void testTimeZone() {
        String result = null;
        DateFormatter df = null;
        Calendar dateCal = Calendar.getInstance();
        dateCal.set(1998, 8, 13, 20, 1, 44);
        Date dateTime = dateCal.getTime();
        Time sqlTime = new Time(dateTime.getTime());
        String utcDate = "13 Sep 1998 12:01";
        String utcTime = "20:01:44";
        TimeZone UTCTimeZone = TimeZone.getTimeZone((String)"UTC");
        df = new DateFormatter(ULocale.UK, UTCTimeZone);
        result = df.format(dateTime);
        DateFormatterTest.assertTrue((boolean)utcDate.equalsIgnoreCase(result));
        result = df.format((Date)sqlTime);
        DateFormatterTest.assertTrue((boolean)utcTime.equalsIgnoreCase(result));
        String japanDate = "1998/09/13 21:01";
        String japanTime = "20:01:44";
        TimeZone japanTimeZone = TimeZone.getTimeZone((String)"Japan");
        df = new DateFormatter(ULocale.JAPAN, japanTimeZone);
        result = df.format(dateTime);
        DateFormatterTest.assertTrue((boolean)japanDate.equalsIgnoreCase(result));
        result = df.format((Date)sqlTime);
        DateFormatterTest.assertTrue((boolean)japanTime.equalsIgnoreCase(result));
    }
}

