/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.format;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.eclipse.birt.core.format.NumberFormatter;

public class NumberFormatterTest
extends TestCase {
    public void testNumericFormat() {
        NumberFormatter numFormat = new NumberFormatter();
        NumberFormatterTest.assertNull((Object)numFormat.getPattern());
        NumberFormat number = NumberFormat.getInstance(Locale.getDefault());
        number.setGroupingUsed(false);
        NumberFormatterTest.assertEquals((String)number.format(1002.234), (String)numFormat.format(1002.234));
        NumberFormatterTest.assertEquals((String)"NaN", (String)numFormat.format(Double.NaN));
    }

    public void testApplyPattern() {
        NumberFormatter numFormat = new NumberFormatter();
        DecimalFormat dec = new DecimalFormat();
        numFormat.applyPattern("#");
        Assert.assertEquals((String)numFormat.format(1002.2), (String)"1002");
        numFormat.applyPattern("0");
        Assert.assertEquals((String)numFormat.format(1002.2), (String)"1002");
        numFormat.applyPattern("###,##0");
        Assert.assertEquals((String)numFormat.format(1002.2), (String)"1,002");
        numFormat.applyPattern("#.0#");
        Assert.assertEquals((String)numFormat.format(1002.2), (String)"1002.2");
        numFormat.applyPattern("###,##0.00 'm/s'");
        Assert.assertEquals((String)numFormat.format(1002.2), (String)"1,002.20 m/s");
        numFormat.applyPattern("#.##");
        Assert.assertEquals((String)numFormat.format(1002L), (String)"1002");
        numFormat.applyPattern("###.#';'");
        Assert.assertEquals((String)numFormat.format(1002.2), (String)"1002.2;");
        Assert.assertEquals((String)numFormat.format(-1002.2), (String)"-1002.2;");
        numFormat.applyPattern("###.#';';#");
        Assert.assertEquals((String)numFormat.format(1002.2), (String)"1002.2;");
        Assert.assertEquals((String)numFormat.format(-1002.2), (String)"1002.2");
        dec.applyPattern("#.00%");
        Assert.assertEquals((String)"1002200.00%", (String)dec.format(10022L));
        dec.applyPattern("0.00E00");
        dec.applyPattern("");
        numFormat.applyPattern("General Number");
        NumberFormat number = NumberFormat.getInstance(Locale.getDefault());
        number.setGroupingUsed(false);
        Assert.assertEquals((String)number.format(1002.2), (String)numFormat.format(1002.2));
        Assert.assertEquals((String)number.format(-1002.2), (String)numFormat.format(-1002.2));
        Assert.assertEquals((String)number.format(0.004), (String)numFormat.format(0.004));
        Assert.assertEquals((String)number.format(0.004123456), (String)numFormat.format(0.004123456));
        Assert.assertEquals((String)number.format(-0.004), (String)numFormat.format(-0.004));
        Assert.assertEquals((String)number.format(0L), (String)numFormat.format(0L));
        numFormat.applyPattern("C");
        number = NumberFormat.getCurrencyInstance(Locale.getDefault());
        NumberFormatterTest.assertEquals((String)number.format(1290.8889), (String)numFormat.format(1290.8889));
        numFormat.applyPattern("Fixed");
        Assert.assertEquals((String)"1002.20", (String)numFormat.format(1002.2));
        Assert.assertEquals((String)"-1002.20", (String)numFormat.format(-1002.2));
        Assert.assertEquals((String)"0.00", (String)numFormat.format(0.004));
        Assert.assertEquals((String)"3333333333.33", (String)numFormat.format(3.33333333333E9));
        Assert.assertEquals((String)"0.00", (String)numFormat.format(0L));
        numFormat.applyPattern("Standard");
        Assert.assertEquals((String)"1,002.20", (String)numFormat.format(1002.2));
        Assert.assertEquals((String)"-1,002.20", (String)numFormat.format(-1002.2));
        Assert.assertEquals((String)"0.00", (String)numFormat.format(0.004));
        Assert.assertEquals((String)"0.00", (String)numFormat.format(0.004123456));
        Assert.assertEquals((String)"0.00", (String)numFormat.format(-0.004));
        Assert.assertEquals((String)"3,333,333,333.33", (String)numFormat.format(3.33333333333E9));
        Assert.assertEquals((String)"0.00", (String)numFormat.format(0L));
        numFormat.applyPattern("Percent");
        Assert.assertEquals((String)"100220.00%", (String)numFormat.format(1002.2));
        Assert.assertEquals((String)"-100220.00%", (String)numFormat.format(-1002.2));
        Assert.assertEquals((String)"0.40%", (String)numFormat.format(0.004));
        Assert.assertEquals((String)"0.41%", (String)numFormat.format(0.004123456));
        Assert.assertEquals((String)"-0.40%", (String)numFormat.format(-0.004));
        Assert.assertEquals((String)"333333333333.00%", (String)numFormat.format(3.33333333333E9));
        Assert.assertEquals((String)"0.00%", (String)numFormat.format(0L));
        numFormat.applyPattern("P");
        Assert.assertEquals((String)"100,220.00 %", (String)numFormat.format(1002.2));
        Assert.assertEquals((String)"-100,220.00 %", (String)numFormat.format(-1002.2));
        Assert.assertEquals((String)"0.40 %", (String)numFormat.format(0.004));
        Assert.assertEquals((String)"0.41 %", (String)numFormat.format(0.004123456));
        Assert.assertEquals((String)"-0.40 %", (String)numFormat.format(-0.004));
        Assert.assertEquals((String)"333,333,333,333.00 %", (String)numFormat.format(3.33333333333E9));
        Assert.assertEquals((String)"0.00 %", (String)numFormat.format(0L));
        numFormat.applyPattern("Scientific");
        Assert.assertEquals((String)"1.00E03", (String)numFormat.format(1002.2));
        Assert.assertEquals((String)"-1.00E03", (String)numFormat.format(-1002.2));
        Assert.assertEquals((String)"4.00E-03", (String)numFormat.format(0.004));
        Assert.assertEquals((String)"4.12E-03", (String)numFormat.format(0.004123456));
        Assert.assertEquals((String)"-4.00E-03", (String)numFormat.format(-0.004));
        Assert.assertEquals((String)"3.33E09", (String)numFormat.format(3.33333333333E9));
        Assert.assertEquals((String)"0.00E00", (String)numFormat.format(0L));
        Assert.assertEquals((String)"1.00E00", (String)numFormat.format(1L));
        numFormat.applyPattern("e");
        Assert.assertEquals((String)"1.002200E03", (String)numFormat.format(1002.2));
        Assert.assertEquals((String)"-1.002200E03", (String)numFormat.format(-1002.2));
        Assert.assertEquals((String)"4.000000E-03", (String)numFormat.format(0.004));
        Assert.assertEquals((String)"4.123456E-03", (String)numFormat.format(0.004123456));
        Assert.assertEquals((String)"-4.000000E-03", (String)numFormat.format(-0.004));
        Assert.assertEquals((String)"3.333333E09", (String)numFormat.format(3.33333333333E9));
        Assert.assertEquals((String)"0.000000E00", (String)numFormat.format(0L));
        Assert.assertEquals((String)"1.000000E00", (String)numFormat.format(1L));
        numFormat.applyPattern("x");
        Assert.assertEquals((String)"3ea", (String)numFormat.format(1002L));
        Assert.assertEquals((String)"fffffffffffffc16", (String)numFormat.format(-1002L));
        Assert.assertEquals((String)"3ea", (String)numFormat.format(1002.22));
        numFormat.applyPattern("d");
        Assert.assertEquals((String)"1,002", (String)numFormat.format(1002L));
        Assert.assertEquals((String)"-1,002", (String)numFormat.format(-1002L));
        Assert.assertEquals((String)"1,002.009", (String)numFormat.format(1002.009));
        numFormat = new NumberFormatter("tttt");
        numFormat.applyPattern("zzz");
    }

    public void testGetPattern() {
        NumberFormatter numFormat = new NumberFormatter("$###,##0.00;'Negative'");
        Assert.assertEquals((String)numFormat.getPattern(), (String)"$###,##0.00;'Negative'");
    }

    public void testFormatBigDecimal() {
        NumberFormatter numFormat = new NumberFormatter("$###,##0.00;'Negative'");
        Assert.assertEquals((String)numFormat.format(new BigDecimal(2139.3)), (String)"$2,139.30");
        Assert.assertEquals((String)numFormat.format(new BigDecimal(2.139)), (String)"$2.14");
        Assert.assertEquals((String)numFormat.format(new BigDecimal(-2.13)), (String)"Negative2.13");
        Assert.assertEquals((String)numFormat.format(new BigDecimal(0.0)), (String)"$0.00");
        Assert.assertEquals((String)numFormat.format(new BigDecimal(2000)), (String)"$2,000.00");
        Assert.assertEquals((String)numFormat.format(new BigDecimal(20)), (String)"$20.00");
        Assert.assertEquals((String)numFormat.format(new BigDecimal(-2000)), (String)"Negative2,000.00");
        Assert.assertEquals((String)numFormat.format(new BigDecimal(0)), (String)"$0.00");
        numFormat.applyPattern("d");
        Assert.assertEquals((String)numFormat.format(new BigDecimal(2.139)), (String)"2.139");
    }

    public void testMinusZero() {
        NumberFormatter numFormat = new NumberFormatter();
        double[] smallValues = new double[]{-0.49, -0.049, -0.0049, -4.9E-4, -4.9E-7};
        double[] bigValues = new double[]{-0.51, -0.051, -0.0051, -5.1E-4, -5.1E-7};
        numFormat.applyPattern("#");
        Assert.assertEquals((String)numFormat.format(smallValues[0]), (String)"0");
        Assert.assertEquals((String)numFormat.format(bigValues[0]), (String)"-1");
        numFormat.applyPattern("0");
        Assert.assertEquals((String)numFormat.format(smallValues[0]), (String)"0");
        Assert.assertEquals((String)numFormat.format(bigValues[0]), (String)"-1");
        numFormat.applyPattern("###,##0");
        Assert.assertEquals((String)numFormat.format(smallValues[3]), (String)"0");
        Assert.assertEquals((String)numFormat.format(bigValues[3]), (String)"0");
        numFormat.applyPattern("#.0#");
        Assert.assertEquals((String)numFormat.format(smallValues[2]), (String)".0");
        Assert.assertEquals((String)numFormat.format(bigValues[2]), (String)"-.01");
        numFormat.applyPattern("###,##0.00 'm/s'");
        Assert.assertEquals((String)numFormat.format(smallValues[2]), (String)"0.00 m/s");
        Assert.assertEquals((String)numFormat.format(bigValues[2]), (String)"-0.01 m/s");
        numFormat.applyPattern("#.##");
        Assert.assertEquals((String)numFormat.format(smallValues[2]), (String)"0");
        Assert.assertEquals((String)numFormat.format(bigValues[2]), (String)"-0.01");
        numFormat.applyPattern("###.#';'");
        Assert.assertEquals((String)numFormat.format(smallValues[1]), (String)"0;");
        Assert.assertEquals((String)numFormat.format(bigValues[1]), (String)"-0.1;");
        numFormat.applyPattern("###.#';';#");
        Assert.assertEquals((String)numFormat.format(smallValues[1]), (String)"0;");
        Assert.assertEquals((String)numFormat.format(bigValues[1]), (String)"0.1");
        numFormat.applyPattern("#.00%");
        Assert.assertEquals((String)numFormat.format(smallValues[2]), (String)"-.49%");
        Assert.assertEquals((String)numFormat.format(bigValues[2]), (String)"-.51%");
        numFormat.applyPattern("Fixed");
        Assert.assertEquals((String)numFormat.format(smallValues[2]), (String)"0.00");
        Assert.assertEquals((String)numFormat.format(bigValues[2]), (String)"-0.01");
        numFormat.applyPattern("Standard");
        Assert.assertEquals((String)numFormat.format(smallValues[2]), (String)"0.00");
        Assert.assertEquals((String)numFormat.format(bigValues[2]), (String)"-0.01");
        numFormat.applyPattern("Percent");
        Assert.assertEquals((String)numFormat.format(smallValues[2]), (String)"-0.49%");
        Assert.assertEquals((String)numFormat.format(bigValues[2]), (String)"-0.51%");
        numFormat.applyPattern("P");
        Assert.assertEquals((String)numFormat.format(smallValues[2]), (String)"-0.49 %");
        Assert.assertEquals((String)numFormat.format(bigValues[2]), (String)"-0.51 %");
        numFormat.applyPattern("Scientific");
        Assert.assertEquals((String)numFormat.format(smallValues[2]), (String)"-4.90E-03");
        Assert.assertEquals((String)numFormat.format(bigValues[2]), (String)"-5.10E-03");
        numFormat.applyPattern("e");
        Assert.assertEquals((String)numFormat.format(smallValues[4]), (String)"-4.900000E-07");
        Assert.assertEquals((String)numFormat.format(bigValues[4]), (String)"-5.100000E-07");
    }
}

