/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.script;

import java.text.DateFormat;
import java.util.ArrayList;
import junit.framework.TestCase;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.ScriptContext;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class ScriptContextTest
extends TestCase {
    ScriptContext context;

    public void setUp() {
        this.context = new ScriptContext();
    }

    public void tearDown() {
        this.context.exit();
    }

    public void testScope() throws BirtException {
        this.context.registerBean("A", (Object)new Integer(10));
        this.context.enterScope();
        this.context.registerBean("B", (Object)new Integer(20));
        Object result = this.context.eval("A + B");
        ScriptContextTest.assertEquals((double)((Number)result).doubleValue(), (double)30.0, (double)Double.MIN_VALUE);
        this.context.exitScope();
        boolean hasException = false;
        try {
            result = this.context.eval("A + B");
        }
        catch (Exception exception) {
            hasException = true;
        }
        ScriptContextTest.assertTrue((!hasException ? 1 : 0) != 0);
        result = this.context.eval("A");
        ScriptContextTest.assertEquals((double)((Number)result).doubleValue(), (double)10.0, (double)Double.MIN_VALUE);
    }

    public void testJavaScope() throws BirtException {
        StringBuffer buffer = new StringBuffer();
        Scriptable javaScope = (Scriptable)Context.javaToJS((Object)buffer, (Scriptable)this.context.getScope());
        this.context.eval("function getText() { return 'TEXT'};");
        this.context.enterScope(javaScope);
        this.context.eval("append(getText());");
        this.context.eval("append('TEXT2');");
        this.context.exitScope();
        ScriptContextTest.assertEquals((String)"TEXTTEXT2", (String)buffer.toString());
        Object result = this.context.eval("getText()");
        ScriptContextTest.assertEquals((Object)"TEXT", (Object)result);
    }

    public void testCompiledScript() throws BirtException {
        this.context.enterScope();
        this.context.eval("function getText() { return 'A'}");
        ScriptContextTest.assertEquals((Object)"A", (Object)this.context.eval("getText()"));
        this.context.exitScope();
        this.context.enterScope();
        this.context.eval("function getText() { return 'B'}");
        ScriptContextTest.assertEquals((Object)"B", (Object)this.context.eval("getText()"));
        this.context.exitScope();
        boolean hasException = false;
        try {
            this.context.eval("getText()");
        }
        catch (Exception exception) {
            hasException = true;
        }
        ScriptContextTest.assertTrue((boolean)hasException);
    }

    public void testGlobal() throws BirtException {
        this.context.eval("importPackage(java.util)");
        this.context.eval("importClass(java.text.DateFormat)");
        Object list = this.context.eval("new ArrayList()");
        Object fmt = this.context.eval("DateFormat.getInstance()");
        ScriptContextTest.assertTrue((boolean)(list instanceof ArrayList));
        ScriptContextTest.assertTrue((boolean)(fmt instanceof DateFormat));
    }

    public void testRootScope() throws BirtException {
        Context context = Context.enter();
        ScriptableObject root = context.initStandardObjects();
        root.put("share", (Scriptable)root, (Object)"ABCDEFG");
        Context.exit();
        ScriptContext cx = new ScriptContext(root);
        Object result = cx.eval("share + 'c'");
        ScriptContextTest.assertEquals((String)"ABCDEFGc", (String)result.toString());
        cx.exit();
    }

    public void testThisObject() throws BirtException {
        this.context.registerBean("A", (Object)"ABCDE");
        Context cx = this.context.getContext();
        Scriptable scope = this.context.getScope();
        Scriptable obj = cx.newObject(scope);
        obj.put("a", obj, (Object)"VALUE");
        this.context.enterScope(obj);
        Object result = this.context.eval("this");
        ScriptContextTest.assertEquals((Object)obj, (Object)result);
        result = this.context.eval("a");
        ScriptContextTest.assertEquals((Object)"VALUE", (Object)result);
        result = this.context.eval("this.a");
        ScriptContextTest.assertEquals((Object)"VALUE", (Object)result);
        result = this.context.eval("A");
        ScriptContextTest.assertEquals((Object)"ABCDE", (Object)result);
        result = this.context.eval("this.A");
        ScriptContextTest.assertEquals(null, (Object)result);
        this.context.exit();
    }
}

