/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.script;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.ParameterAttribute;
import org.eclipse.birt.core.script.ScriptContext;
import org.eclipse.birt.core.script.ScriptableParameters;

public class ScriptableParametersTest
extends TestCase {
    ScriptContext context;
    Map params;

    public void setUp() {
        this.context = new ScriptContext();
        this.params = new HashMap();
        this.addParameter("string", "abc", "STRING VALUE");
        this.context.registerBean("params", (Object)new ScriptableParameters(this.params, this.context.getScope()));
    }

    private void addParameter(String name, Object value, String displayText) {
        this.params.put(name, new ParameterAttribute(value, displayText));
    }

    public void tearDown() {
        this.context.exit();
    }

    public void testAssign() throws BirtException {
        this.context.eval("params['string'] = 'abcd'");
        ScriptableParametersTest.assertEquals((Object)"abcd", (Object)this.context.eval("params['string']"));
        this.context.eval("params['string'].value = 'abcde'");
        ScriptableParametersTest.assertEquals((Object)"abcde", (Object)this.context.eval("params['string']"));
        this.context.eval("params['string'].displayText = 'display'");
        ScriptableParametersTest.assertEquals((Object)"display", (Object)this.context.eval("params['string'].displayText"));
        this.context.eval("params['new param'] = 'abc'");
        ScriptableParametersTest.assertEquals((Object)"abc", (Object)this.context.eval("params['new param']"));
        this.context.eval("params['date'] = new Date()");
        Object date = this.context.eval("params['date'].value");
        ScriptableParametersTest.assertTrue((boolean)(date instanceof Date));
        this.context.eval("params['number'] = new Number(3)");
        Object num = this.context.eval("params['number'].value");
        ScriptableParametersTest.assertTrue((boolean)(num instanceof Double));
    }

    public void testReterive() throws BirtException {
        try {
            this.context.eval("params['none exsit'] == null");
            ScriptableParametersTest.fail();
        }
        catch (BirtException birtException) {
            ScriptableParametersTest.assertTrue((boolean)true);
        }
        ScriptableParametersTest.assertEquals((Object)"abc", (Object)this.context.eval("params['string'].value"));
        ScriptableParametersTest.assertEquals((Object)"bbc", (Object)this.context.eval("params['string'].value.replace('a', 'b')"));
        ScriptableParametersTest.assertEquals((Object)"STRING VALUE", (Object)this.context.eval("params['string'].displayText"));
        ScriptableParametersTest.assertEquals((Object)"abc", (Object)this.context.eval("params['string']"));
        ScriptableParametersTest.assertEquals((Object)"bbc", (Object)this.context.eval("var value = params['string'];value.replace('a', 'b')"));
    }

    public void testEval() throws BirtException {
        this.addParameter("jsDate", "", "");
        this.context.eval("params['jsDate']=new Date();");
        ScriptableParametersTest.assertTrue((boolean)(this.context.eval("params['jsDate'].getFullYear()") instanceof Number));
        ScriptableParametersTest.assertTrue((boolean)(this.context.eval("params['jsDate'].value.getFullYear()") instanceof Number));
        this.addParameter("jsString", "", "");
        this.context.eval("params['jsString']='testString';");
        ScriptableParametersTest.assertEquals((Object)new Integer(10), (Object)this.context.eval("params['jsString'].length"));
        ScriptableParametersTest.assertEquals((Object)new Integer(10), (Object)this.context.eval("params['jsString'].value.length"));
        this.addParameter("javaDate", new Date(2008, 3, 5), "");
        ScriptableParametersTest.assertEquals((Object)new Integer(2008), (Object)this.context.eval("params['javaDate'].getYear()"));
        ScriptableParametersTest.assertEquals((Object)new Integer(2008), (Object)this.context.eval("params['javaDate'].value.getYear()"));
    }
}

