/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.script.bre;

import junit.framework.TestCase;
import org.eclipse.birt.core.script.CoreJavaScriptInitializer;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

public class BirtCompTest
extends TestCase {
    private Context cx;
    private Scriptable scope;

    public void setUp() throws Exception {
        this.cx = Context.enter();
        this.scope = this.cx.initStandardObjects();
        new CoreJavaScriptInitializer().initialize(this.cx, this.scope);
    }

    public void tearDown() {
        Context.exit();
    }

    public void testAnyOf() {
        String script2 = "BirtComp.anyOf(100,100,\"ABC\", \"1999-11-10\",null);";
        String script3 = "BirtComp.anyOf(null,100,\"ABC\", \"1999-11-10\",null)";
        String script4 = "BirtComp.anyOf(\"ABC\",100,\"ABC\", \"1999-11-10\",null)";
        String script5 = "BirtComp.anyOf(new Date(99,10,10),100,\"ABC\", \"1999-11-10\",null)";
        String script6 = "BirtComp.anyOf(\"1999-11-10\",100,\"ABC\", \"1999-11-10\",null)";
        String script7 = "BirtComp.anyOf(20,100,\"ABC\", \"1999-11-10\",null)";
        String script8 = "array = new Array(3);array[0]=0;array[1]=1;array[2]=2;BirtComp.anyOf(1,array);";
        String script9 = "array = new Array(3);array[0]=0;array[1]=1;array[2]=2;BirtComp.anyOf(4,array);";
        BirtCompTest.assertTrue((boolean)((Boolean)this.cx.evaluateString(this.scope, script2, "inline", 1, null)));
        BirtCompTest.assertTrue((boolean)((Boolean)this.cx.evaluateString(this.scope, script3, "inline", 1, null)));
        BirtCompTest.assertTrue((boolean)((Boolean)this.cx.evaluateString(this.scope, script4, "inline", 1, null)));
        BirtCompTest.assertTrue((boolean)((Boolean)this.cx.evaluateString(this.scope, script5, "inline", 1, null)));
        BirtCompTest.assertTrue((boolean)((Boolean)this.cx.evaluateString(this.scope, script6, "inline", 1, null)));
        BirtCompTest.assertFalse((boolean)((Boolean)this.cx.evaluateString(this.scope, script7, "inline", 1, null)));
        BirtCompTest.assertTrue((boolean)((Boolean)this.cx.evaluateString(this.scope, script8, "inline", 1, null)));
        BirtCompTest.assertFalse((boolean)((Boolean)this.cx.evaluateString(this.scope, script9, "inline", 1, null)));
    }

    public void testBetween() {
        String script1 = "BirtComp.between(\"1923-10-11\",new Date(10,11,11),new Date(33,11,11))";
        BirtCompTest.assertTrue((boolean)((Boolean)this.cx.evaluateString(this.scope, script1, "inline", 1, null)));
        String script2 = "BirtComp.between(100,101,102)";
        BirtCompTest.assertFalse((boolean)((Boolean)this.cx.evaluateString(this.scope, script2, "inline", 1, null)));
    }

    public void testNotBetween() {
        String script1 = "BirtComp.notBetween(\"1923-10-11\",new Date(10,11,11),new Date(33,11,11))";
        BirtCompTest.assertFalse((boolean)((Boolean)this.cx.evaluateString(this.scope, script1, "inline", 1, null)));
        String script2 = "BirtComp.notBetween(100,101,102)";
        BirtCompTest.assertTrue((boolean)((Boolean)this.cx.evaluateString(this.scope, script2, "inline", 1, null)));
    }

    public void testCompare() {
        String[] script = new String[]{"BirtComp.equalTo(100,100);", "BirtComp.equalTo(null,null)", "BirtComp.equalTo(\"ABC\",\"ABC\")", "BirtComp.equalTo(new Date(99,10,10),\"1999-11-10\")", "BirtComp.equalTo(\"1999-11-10\",new Date(99,10,10))", "BirtComp.equalTo(20,100)", "BirtComp.equalTo( new java.sql.Time(10,10,10), \"10:10:10.000\")", "BirtComp.equalTo( new java.sql.Date(80,9,9), \"1980-10-9 12:14:25\")", "BirtComp.notEqual(100,100);", "BirtComp.notEqual(null,null)", "BirtComp.notEqual(\"ABC\",\"ABC\")", "BirtComp.notEqual(new Date(99,10,10),\"1999-11-10\")", "BirtComp.notEqual(\"1999-11-10\",new Date(99,10,10))", "BirtComp.notEqual(20,100)", "BirtComp.greaterThan(100,10);", "BirtComp.greaterThan(null,null)", "BirtComp.greaterThan(\"aBC\",\"ABC\")", "BirtComp.greaterThan(new Date(99,9,10),\"1999-11-10\")", "BirtComp.greaterThan(\"1999-11-10\",new Date(99,9,10))", "BirtComp.greaterThan(20,100)", "BirtComp.greaterOrEqual(100,10);", "BirtComp.greaterOrEqual(null,null)", "BirtComp.greaterOrEqual(\"aBC\",\"ABC\")", "BirtComp.greaterOrEqual(new Date(99,9,10),\"1999-11-10\")", "BirtComp.greaterOrEqual(\"1999-11-10\",new Date(99,9,10))", "BirtComp.greaterOrEqual(20,100)", "BirtComp.lessThan(10,100);", "BirtComp.lessThan(null,null)", "BirtComp.lessThan(\"aBC\",\"ABC\")", "BirtComp.lessThan(new Date(99,9,10),\"1999-11-10\")", "BirtComp.lessThan(\"1999-11-10\",new Date(99,9,10))", "BirtComp.lessThan(20,100)", "BirtComp.lessOrEqual(100,10);", "BirtComp.lessOrEqual(null,null)", "BirtComp.lessOrEqual(\"aBC\",\"ABC\")", "BirtComp.lessOrEqual(new Date(99,9,10),\"1999-11-10\")", "BirtComp.lessOrEqual(\"1999-11-10\",new Date(99,9,10))", "BirtComp.lessOrEqual(100,100)"};
        boolean[] blArray = new boolean[38];
        blArray[0] = true;
        blArray[1] = true;
        blArray[2] = true;
        blArray[3] = true;
        blArray[4] = true;
        blArray[6] = true;
        blArray[7] = true;
        blArray[13] = true;
        blArray[14] = true;
        blArray[18] = true;
        blArray[20] = true;
        blArray[21] = true;
        blArray[24] = true;
        blArray[26] = true;
        blArray[28] = true;
        blArray[29] = true;
        blArray[31] = true;
        blArray[33] = true;
        blArray[34] = true;
        blArray[35] = true;
        blArray[37] = true;
        boolean[] result = blArray;
        int i = 0;
        while (i < script.length) {
            BirtCompTest.assertTrue(((Boolean)this.cx.evaluateString(this.scope, script[i], "inline", 1, null) == result[i] ? 1 : 0) != 0);
            ++i;
        }
    }

    public void testMatch() {
        String[] script = new String[]{"BirtComp.match(\"x 99:02:03\",\".*[0-9]*:[0-9]*:[0-9]*\");", "BirtComp.match(\"x 99::03\",\".*[0-9]*:[0-9]*:[0-9]*\");", "BirtComp.match(\"x 99:02:03\",\"x [0-9]*:[0-9]*:[0-9]*\");", "BirtComp.match(\"x 99:02:03\",\".*99*:[0-9]*:[0-9]*\");", "BirtComp.match(\"x 99:02:03\",\".*[0-9]*.[0-9]*:[0-9]*\");", "BirtComp.match(\"x 99:02:03\",\".*[0-9]*:[0-9]*:[0-9]*3.\");"};
        boolean[] blArray = new boolean[6];
        blArray[0] = true;
        blArray[1] = true;
        blArray[2] = true;
        blArray[3] = true;
        blArray[4] = true;
        boolean[] result = blArray;
        int i = 0;
        while (i < script.length) {
            BirtCompTest.assertTrue(((Boolean)this.cx.evaluateString(this.scope, script[i], "inline", 1, null) == result[i] ? 1 : 0) != 0);
            ++i;
        }
    }

    public void testLike() {
        String[] script = new String[]{"BirtComp.like(\"x 99:02:03\",\"%:0_:03\");", "BirtComp.like(\"x 99::003\",\"%9_::__3\");", "BirtComp.like(\"x 99:02:03\",\"%99:02_03\");", "BirtComp.like(\"x 99:02:03\",\"x 99%0_\");", "BirtComp.like(\"x 99:02:03\",\"_ 99%03\");", "BirtComp.like(\"x 99:02:03\",\"%:0_:__3\");", "BirtComp.like(\"x 99:02:03\",\"%:0\\\\_03\");", "BirtComp.like(\"x 99:02_03\",\"%:0\\\\_03\");", "BirtComp.like(\"x 99:02_03\",\"%:02\\\\_03\");", "BirtComp.like(\"x 99:02_03\",\"\\\\%:02\\\\_03\");", "BirtComp.like(\"x 99%:02_03\",\"%\\\\%:02\\\\_03\");", "BirtComp.like(\"x 99%:02_03\",\"\\\\\\\\%\\\\%:02\\\\_03\");", "BirtComp.like(\"x \\\\99%:02_03\",\"_ \\\\\\\\99\\\\%:02\\\\_03\");"};
        boolean[] blArray = new boolean[13];
        blArray[0] = true;
        blArray[1] = true;
        blArray[2] = true;
        blArray[3] = true;
        blArray[4] = true;
        blArray[8] = true;
        blArray[10] = true;
        blArray[12] = true;
        boolean[] result = blArray;
        int i = 0;
        while (i < script.length) {
            BirtCompTest.assertEquals((boolean)result[i], (boolean)((Boolean)this.cx.evaluateString(this.scope, script[i], "inline", 1, null)));
            ++i;
        }
    }

    public void testNotLike() {
        String[] script = new String[]{"BirtComp.notLike(\"x 99:02:03\",\"%:0_:03\");", "BirtComp.notLike(\"x 99::003\",\"%9_::__3\");", "BirtComp.notLike(\"x 99:02:03\",\"%99:02_03\");", "BirtComp.notLike(\"x 99:02:03\",\"x 99%0_\");", "BirtComp.notLike(\"x 99:02:03\",\"_ 99%03\");", "BirtComp.notLike(\"x 99:02:03\",\"%:0_:__3\");", "BirtComp.notLike(\"x 99:02:03\",\"%:0\\\\_03\");", "BirtComp.notLike(\"x 99:02_03\",\"%:0\\\\_03\");", "BirtComp.notLike(\"x 99:02_03\",\"%:02\\\\_03\");", "BirtComp.notLike(\"x 99:02_03\",\"\\\\%:02\\\\_03\");", "BirtComp.notLike(\"x 99%:02_03\",\"%\\\\%:02\\\\_03\");", "BirtComp.notLike(\"x 99%:02_03\",\"\\\\\\\\%\\\\%:02\\\\_03\");", "BirtComp.notLike(\"x \\\\99%:02_03\",\"_ \\\\\\\\99\\\\%:02\\\\_03\");"};
        boolean[] blArray = new boolean[13];
        blArray[5] = true;
        blArray[6] = true;
        blArray[7] = true;
        blArray[9] = true;
        blArray[11] = true;
        boolean[] result = blArray;
        int i = 0;
        while (i < script.length) {
            BirtCompTest.assertEquals((boolean)result[i], (boolean)((Boolean)this.cx.evaluateString(this.scope, script[i], "inline", 1, null)));
            ++i;
        }
    }

    public void testCompareString() {
        String[] script = new String[]{"BirtComp.compareString(null,null)", "BirtComp.compareString(null,\"abc\")", "BirtComp.compareString(\"abc\",null);", "BirtComp.compareString(\"ABC\",\"ABC\")", "BirtComp.compareString(\"abc\",\"ABC\")", "BirtComp.compareString(\"ABC\",\"DEF\")", "BirtComp.compareString(\"abc\",\"ABC\",true)", "BirtComp.compareString(\"abc \",\"ABC\",true)", "BirtComp.compareString(\"abc \",\"ABC\",true,true)", "BirtComp.compareString(\"abc \",\"ABC\",false,true)"};
        boolean[] blArray = new boolean[10];
        blArray[0] = true;
        blArray[3] = true;
        blArray[6] = true;
        blArray[8] = true;
        boolean[] result = blArray;
        int i = 0;
        while (i < script.length) {
            BirtCompTest.assertTrue(((Boolean)this.cx.evaluateString(this.scope, script[i], "inline", 1, null) == result[i] ? 1 : 0) != 0);
            System.out.println(i);
            ++i;
        }
    }
}

