/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.script.bre;

import junit.framework.TestCase;
import org.eclipse.birt.core.script.CoreJavaScriptInitializer;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

public class BirtStrTest
extends TestCase {
    String str = " I am a test    string";
    private Context cx;
    private Scriptable scope;

    public void setUp() throws Exception {
        this.cx = Context.enter();
        this.scope = this.cx.initStandardObjects();
        new CoreJavaScriptInitializer().initialize(this.cx, this.scope);
    }

    public void tearDown() {
        Context.exit();
    }

    public void testLeftStringInt() {
        String script1 = "BirtStr.left(\"" + this.str + "\",5)";
        BirtStrTest.assertEquals((String)((String)this.cx.evaluateString(this.scope, script1, "inline", 1, null)), (String)" I am");
    }

    public void testRightStringInt() {
        try {
            String script1 = "BirtStr.right(\"" + this.str + "\",0)";
            String script2 = "BirtStr.right(\"" + this.str + "\",5)";
            String script3 = "BirtStr.right(\"" + this.str + "\",50)";
            String script4 = "BirtStr.right(" + null + ",1)";
            String script5 = "BirtStr.right(\"" + this.str + "\",-2)";
            BirtStrTest.assertEquals((String)((String)this.cx.evaluateString(this.scope, script1, "inline", 1, null)), (String)"");
            BirtStrTest.assertEquals((String)((String)this.cx.evaluateString(this.scope, script2, "inline", 1, null)), (String)"tring");
            BirtStrTest.assertEquals((String)((String)this.cx.evaluateString(this.scope, script3, "inline", 1, null)), (String)this.str);
            BirtStrTest.assertEquals((String)((String)this.cx.evaluateString(this.scope, script4, "inline", 1, null)), null);
            this.cx.evaluateString(this.scope, script5, "inline", 1, null);
            BirtStrTest.fail((String)"it should be invalid");
        }
        catch (Exception e) {
            BirtStrTest.assertTrue((boolean)(e instanceof IllegalArgumentException));
        }
    }

    public void testToUpper() {
        String script1 = "BirtStr.toUpper(\"" + this.str + "\")";
        String script2 = "BirtStr.toUpper(" + null + ")";
        BirtStrTest.assertEquals((String)((String)this.cx.evaluateString(this.scope, script1, "inline", 1, null)), (String)" I AM A TEST    STRING");
        BirtStrTest.assertEquals((String)((String)this.cx.evaluateString(this.scope, script2, "inline", 1, null)), null);
    }

    public void testToLower() {
        String script1 = "BirtStr.toLower(\"" + this.str + "\")";
        String script2 = "BirtStr.toLower(" + null + ")";
        BirtStrTest.assertEquals((String)((String)this.cx.evaluateString(this.scope, script1, "inline", 1, null)), (String)" i am a test    string");
        BirtStrTest.assertEquals((String)((String)this.cx.evaluateString(this.scope, script2, "inline", 1, null)), null);
    }

    public void testTrim() {
        String script1 = "BirtStr.trim(\"" + this.str + "\")";
        String script2 = "BirtStr.trim(" + null + ")";
        BirtStrTest.assertEquals((String)((String)this.cx.evaluateString(this.scope, script1, "inline", 1, null)), (String)"I am a test string");
        BirtStrTest.assertEquals((String)((String)this.cx.evaluateString(this.scope, script2, "inline", 1, null)), null);
    }

    public void testTrimLeft() {
        String script1 = "BirtStr.trimLeft(\"" + this.str + "\")";
        String script2 = "BirtStr.trimLeft(" + null + ")";
        BirtStrTest.assertEquals((String)((String)this.cx.evaluateString(this.scope, script1, "inline", 1, null)), (String)"I am a test    string");
        BirtStrTest.assertEquals((String)((String)this.cx.evaluateString(this.scope, script2, "inline", 1, null)), null);
    }

    public void testTrimRight() {
        String script1 = "BirtStr.trimRight(\"" + this.str + "      \")";
        String script2 = "BirtStr.trimRight(" + null + ")";
        String script3 = "BirtStr.trimRight(\" \")";
        BirtStrTest.assertEquals((String)((String)this.cx.evaluateString(this.scope, script1, "inline", 1, null)), (String)" I am a test    string");
        BirtStrTest.assertEquals((String)((String)this.cx.evaluateString(this.scope, script2, "inline", 1, null)), null);
        BirtStrTest.assertEquals((String)((String)this.cx.evaluateString(this.scope, script3, "inline", 1, null)), (String)"");
    }

    public void testIndexOfStringStringInt() {
        String script1 = "BirtStr.indexOf(\"a\",\"" + this.str + "\",1)";
        String script2 = "BirtStr.indexOf(\"a\",\"" + this.str + "\",4)";
        BirtStrTest.assertEquals((Object)this.cx.evaluateString(this.scope, script1, "inline", 1, null), (Object)new Integer(3));
        BirtStrTest.assertEquals((Object)this.cx.evaluateString(this.scope, script2, "inline", 1, null), (Object)new Integer(6));
    }

    public void testSearchStringStringInt() {
        BirtStrTest.assertEquals((Object)((Integer)this.cx.evaluateString(this.scope, "BirtStr.search(\"a test\",\" I am a test    string\",0)", "inline", 1, null)), (Object)new Integer(6));
        BirtStrTest.assertEquals((Object)((Integer)this.cx.evaluateString(this.scope, "BirtStr.search(\"a*t\",\" I am a test    string\",4)", "inline", 1, null)), (Object)new Integer(6));
        BirtStrTest.assertEquals((Object)((Integer)this.cx.evaluateString(this.scope, "BirtStr.search(\"a?t\",\" I am a test    string\",0)", "inline", 1, null)), (Object)new Integer(6));
        BirtStrTest.assertEquals((Object)((Integer)this.cx.evaluateString(this.scope, "BirtStr.search(\"a*t\",\" I am a test    string\",9)", "inline", 1, null)), (Object)new Integer(-1));
        BirtStrTest.assertEquals((Object)((Integer)this.cx.evaluateString(this.scope, "BirtStr.search(\" I*a*t\",\" I am a test    string\",0)", "inline", 1, null)), (Object)new Integer(0));
        BirtStrTest.assertEquals((Object)((Integer)this.cx.evaluateString(this.scope, "BirtStr.search(\"g\",\" I am a test    string\",0)", "inline", 1, null)), (Object)new Integer(21));
        BirtStrTest.assertEquals((Object)((Integer)this.cx.evaluateString(this.scope, "BirtStr.search(\"am\",\"I am a test    string\",2)", "inline", 1, null)), (Object)new Integer(2));
        BirtStrTest.assertEquals((Object)((Integer)this.cx.evaluateString(this.scope, "BirtStr.search(\"A\",\"Actuate Shanghai\",0)", "inline", 1, null)), (Object)new Integer(0));
    }

    public void testSearchStringString() {
        BirtStrTest.assertEquals((Object)this.cx.evaluateString(this.scope, "BirtStr.search(\"a?t\",\" I am a test    string\")", "inline", 1, null), (Object)new Integer(6));
        BirtStrTest.assertEquals((Object)this.cx.evaluateString(this.scope, "BirtStr.search(\"a*t\",\" I am a test    string\")", "inline", 1, null), (Object)new Integer(3));
        BirtStrTest.assertEquals((Object)this.cx.evaluateString(this.scope, "BirtStr.search(\"a\\\\*t\",\" I am * test    string\")", "inline", 1, null), (Object)new Integer(-1));
        BirtStrTest.assertEquals((Object)this.cx.evaluateString(this.scope, "BirtStr.search(\"\\\\? *\",\" I am * test    string\")", "inline", 1, null), (Object)new Integer(-1));
        BirtStrTest.assertEquals((Object)this.cx.evaluateString(this.scope, "BirtStr.search(\"\\\\?\",\" I? am * test    string\")", "inline", 1, null), (Object)new Integer(2));
        BirtStrTest.assertEquals((Object)this.cx.evaluateString(this.scope, "BirtStr.search(\"\\\\? *\",\" I? am * test    string\")", "inline", 1, null), (Object)new Integer(2));
        BirtStrTest.assertEquals((Object)this.cx.evaluateString(this.scope, "BirtStr.search(\"? \\\\*\",\"abc *abc *abc\")", "inline", 1, null), (Object)new Integer(2));
        BirtStrTest.assertEquals((Object)this.cx.evaluateString(this.scope, "BirtStr.search(\"? \\\\*\",\"abc *abc *abc\", 6)", "inline", 1, null), (Object)new Integer(7));
    }

    public void testCharLength() {
    }
}

