/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.postscript;

import java.io.File;
import org.eclipse.birt.report.engine.api.HTMLRenderOption;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IRunAndRenderTask;
import org.eclipse.birt.report.engine.emitter.postscript.EngineCase;

public class PostScriptRenderTest
extends EngineCase {
    private String pictureFolder = "d:/__test$picture$tmp$/";

    protected void setUp() throws Exception {
        if (this.isOnWindows()) {
            super.setUp();
            String[] pictures = new String[]{"aa.bmp", "aa.gif", "aa.jpg", "aa.png", "actuate.tif", "affine.svg"};
            String pkg = "org/eclipse/birt/report/engine/emitter/postscript/picture/";
            int i = 0;
            while (i < pictures.length) {
                String file = pictures[i];
                this.copyResource(String.valueOf(pkg) + file, String.valueOf(this.pictureFolder) + file);
                ++i;
            }
        }
    }

    protected void tearDown() throws Exception {
        if (this.isOnWindows()) {
            this.removeFile(new File(this.pictureFolder));
            super.tearDown();
        }
    }

    public void testRenderReport() throws Exception {
        if (this.isOnWindows()) {
            String thePackage = "org/eclipse/birt/report/engine/emitter/postscript/";
            String[] designs = new String[]{"underline", "uriImages", "urlImages", "pageBreak", "embededImages", "svgImages", "pageBackgroundColor", "lableWithBorder", "pageBackgroundImage", "gridBackgroundImage", "pageBackgroundImageNoRepeat", "pageBackgroundImageRepeatX", "pageBackgroundImageRepeatY"};
            String suffix = ".rptdesign";
            HTMLRenderOption options = new HTMLRenderOption();
            options.setOutputFormat("postscript");
            String resultFolder = "testresult/";
            int i = 0;
            while (i < designs.length) {
                options.setOutputFileName(String.valueOf(resultFolder) + designs[i] + ".ps");
                String design = String.valueOf(thePackage) + designs[i] + suffix;
                IRunAndRenderTask runAndRenderTask = this.createRunAndRenderTask(design);
                runAndRenderTask.setRenderOption((IRenderOption)options);
                runAndRenderTask.run();
                runAndRenderTask.close();
                ++i;
            }
            System.out.println("please check result manually in folder : " + new File(resultFolder).getAbsolutePath());
        }
    }

    private boolean isOnWindows() {
        return System.getProperty("os.name").indexOf("Windows") >= 0;
    }
}

