/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive.compound;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.RandomAccessFile;
import junit.framework.TestCase;
import org.eclipse.birt.core.archive.compound.AllocEntry;
import org.eclipse.birt.core.archive.compound.AllocTableLoader;

public class AllocTableLoaderTest
extends TestCase {
    static String SOURCE_FILE = "org/eclipse/birt/core/archive/compound/sourceNodes.txt";
    static String TARGET_FILE = "org/eclipse/birt/core/archive/compound/targetNodes.txt";
    static String SOURCE = "./utest/sourceNodes.txt";
    static String TARGET = "./utest/targetNodes.txt";

    public void copyResource(String src, String tgt) {
        InputStream in;
        File parent = new File(tgt).getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
        AllocTableLoaderTest.assertTrue(((in = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(src)) != null ? 1 : 0) != 0);
        try {
            FileOutputStream fos = new FileOutputStream(tgt);
            byte[] fileData = new byte[5120];
            int readCount = -1;
            while ((readCount = in.read(fileData)) != -1) {
                fos.write(fileData, 0, readCount);
            }
            fos.close();
            in.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            AllocTableLoaderTest.fail();
        }
    }

    public void testMergeN() throws Exception {
        this.copyResource(SOURCE_FILE, SOURCE);
        this.copyResource(TARGET_FILE, TARGET);
        AllocTableLoader.Node nodes = this.loadNodes(SOURCE);
        AllocTableLoader.Node tagetNodes = this.loadNodes(TARGET);
        AllocTableLoader loader = new AllocTableLoader();
        loader.merge(nodes);
        this.compareNodes(nodes, tagetNodes);
    }

    public void testMergeR() throws Exception {
        this.copyResource(TARGET_FILE, SOURCE);
        this.copyResource(TARGET_FILE, TARGET);
        AllocTableLoader.Node nodes = this.loadNodes(SOURCE);
        AllocTableLoader.Node tagetNodes = this.loadNodes(TARGET);
        AllocTableLoader loader = new AllocTableLoader();
        loader.merge(nodes);
        this.compareNodes(nodes, tagetNodes);
    }

    void compareNodes(AllocTableLoader.Node nodes, AllocTableLoader.Node tagetNodes) {
        AllocTableLoader.Node entryNode = nodes;
        AllocTableLoader.Node compareNodes = tagetNodes;
        while (entryNode != null) {
            assert (compareNodes == null);
            AllocEntry entry = entryNode.entry;
            AllocEntry compareEntry = compareNodes.entry;
            if (entry != null) {
                assert (compareEntry == null);
                assert (compareEntry.getTotalBlocks() == entry.getTotalBlocks());
                int i = 0;
                while (i < entry.getTotalBlocks()) {
                    assert (compareEntry.getBlock(i) == entry.getBlock(i));
                    System.out.print("  " + entry.getBlock(i));
                    ++i;
                }
            }
            entryNode = entryNode.next;
            compareNodes = compareNodes.next;
        }
        System.out.println();
        assert (compareNodes == null);
    }

    AllocTableLoader.Node loadNodes(String fileName) throws Exception {
        File file = new File(fileName);
        if (file.exists()) {
            AllocTableLoader.Node nodes;
            RandomAccessFile fileReader = new RandomAccessFile(file, "r");
            String line = null;
            line = fileReader.readLine();
            AllocTableLoader.Node node = nodes = new AllocTableLoader.Node();
            while (line != null) {
                String[] values = line.split(",");
                if (values.length > 0) {
                    AllocEntry entry = new AllocEntry(Integer.parseInt(values[0]));
                    System.out.print(String.valueOf(values[0]) + ",");
                    int i = 1;
                    while (i < values.length) {
                        entry.appendBlock(Integer.parseInt(values[i]));
                        System.out.print(String.valueOf(values[i]) + ",");
                        ++i;
                    }
                    AllocTableLoader.Node newNode = new AllocTableLoader.Node();
                    newNode.entry = entry;
                    node.next = newNode;
                    node = newNode;
                }
                System.out.println();
                line = fileReader.readLine();
            }
            fileReader.close();
            return nodes;
        }
        return null;
    }
}

