/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.api;

import org.eclipse.birt.core.data.DataType;
import org.eclipse.birt.data.engine.api.APITestCase;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.IResultMetaData;
import org.eclipse.birt.data.engine.api.querydefn.Binding;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.core.DataException;
import testutil.ConfigText;

public class ClobAndBlobTest
extends APITestCase {
    private String[] beName;
    private IBaseExpression[] beArray;

    protected APITestCase.DataSourceInfo getDataSourceInfo() {
        return new APITestCase.DataSourceInfo(ConfigText.getString("Api.TestBlobAndClob.TableName"), ConfigText.getString("Api.TestBlobAndClob.TableSQL"), ConfigText.getString("Api.TestBlobAndClob.TestDataFileName"));
    }

    public void testClobAndBlob() throws Exception {
        QueryDefinition queryDefn = this.newReportQuery();
        this.prepareExpression(queryDefn);
        IResultIterator ri = this.executeQuery((IQueryDefinition)queryDefn);
        IResultMetaData md = ri.getResultMetaData();
        while (ri.next()) {
            String str = "";
            int i = 0;
            while (i < this.beArray.length) {
                str = md.getColumnTypeName(i + 1).equals(DataType.BINARY_TYPE_NAME) || md.getColumnTypeName(i + 1).equals(DataType.BLOB_TYPE_NAME) ? String.valueOf(str) + new String(ri.getBytes(this.beName[i])) : String.valueOf(str) + ri.getValue(this.beName[i]);
                if (i < this.beArray.length - 1) {
                    str = String.valueOf(str) + ", ";
                }
                ++i;
            }
            this.testPrintln(str);
        }
        this.checkOutputFile();
    }

    private void prepareExpression(QueryDefinition queryDefn) throws DataException {
        this.beName = new String[3];
        this.beArray = new ScriptExpression[3];
        this.beName[0] = "_ID";
        ScriptExpression se = new ScriptExpression("dataSetRow.ID");
        se.setDataType(2);
        this.beArray[0] = se;
        this.beName[1] = "_NAME";
        se = new ScriptExpression("dataSetRow.NAME");
        se.setDataType(5);
        this.beArray[1] = se;
        this.beName[2] = "_INFO";
        se = new ScriptExpression("dataSetRow.INFO");
        se.setDataType(7);
        this.beArray[2] = se;
        int i = 0;
        while (i < this.beName.length) {
            queryDefn.addBinding((IBinding)new Binding(this.beName[i], this.beArray[i]));
            ++i;
        }
    }
}

