/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.api;

import java.util.ArrayList;
import org.eclipse.birt.data.engine.api.APITestCase;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IParameterDefinition;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.querydefn.InputParameterBinding;
import org.eclipse.birt.data.engine.api.querydefn.OdaDataSetDesign;
import org.eclipse.birt.data.engine.api.querydefn.ParameterDefinition;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import testutil.ConfigText;
import testutil.JDBCDataSource;

public class StoredProcedureTest
extends APITestCase {
    protected void setUp() throws Exception {
        super.setUp();
        this.createTestProcedure();
    }

    protected APITestCase.DataSourceInfo getDataSourceInfo() {
        return new APITestCase.DataSourceInfo(ConfigText.getString("Api.TestBlobAndClob.TableName"), ConfigText.getString("Api.TestBlobAndClob.TableSQL"), ConfigText.getString("Api.TestBlobAndClob.TestDataFileName"));
    }

    protected void createTestProcedure() throws Exception {
        if (this.dataSourceInstance == null) {
            this.dataSourceInstance = JDBCDataSource.newInstance();
        }
        this.dataSourceInstance.createStoredProcedure(ConfigText.getString("Api.TestProcedure.ProcedureName"), ConfigText.getString("Api.TestProcedure.ProcedureSQL"), true);
    }

    public void test1() {
        try {
            OdaDataSetDesign baseDataset = this.newDataSet("newDataSet", this.getCallableSQL());
            baseDataset.setQueryText(this.getCallableSQL());
            ArrayList<ParameterDefinition> inputParamDefns = new ArrayList<ParameterDefinition>();
            ParameterDefinition inputParamDefn = new ParameterDefinition("param1", 2);
            inputParamDefn.setInputMode(true);
            inputParamDefn.setPosition(1);
            inputParamDefn.setDefaultInputValue("0");
            inputParamDefns.add(inputParamDefn);
            InputParameterBinding paramBinding = new InputParameterBinding("param1", (IBaseExpression)new ScriptExpression("100"));
            if (inputParamDefns != null) {
                for (ParameterDefinition paramDefn : inputParamDefns) {
                    if (!paramDefn.isInputMode()) continue;
                    baseDataset.addParameter((IParameterDefinition)paramDefn);
                }
            }
            QueryDefinition queryDefn = new QueryDefinition();
            queryDefn.setDataSetName(baseDataset.getName());
            queryDefn.addInputParamBinding(paramBinding);
            IPreparedQuery preparedQuery = this.dataEngine.prepare((IQueryDefinition)queryDefn);
            IQueryResults queryResults = preparedQuery.execute(null);
            queryResults.getResultIterator();
        }
        catch (Exception e) {
            StoredProcedureTest.fail((String)e.getMessage());
        }
    }

    protected OdaDataSetDesign newDataSet(String datasetName, String queryText) throws Exception {
        OdaDataSetDesign dset = new OdaDataSetDesign(datasetName);
        dset.setDataSource(this.dataSource.getName());
        dset.setQueryText(queryText);
        dset.setExtensionID("org.eclipse.birt.report.data.oda.jdbc.SPSelectDataSet");
        this.dataEngine.defineDataSet((IBaseDataSetDesign)dset);
        return dset;
    }

    protected String getCallableSQL() {
        return "call App.testProc(?) ";
    }

    public static void selectData(int inputParam) {
        assert (inputParam == 100);
    }
}

