/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.binding;

import java.util.ArrayList;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IComputedColumn;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.querydefn.ComputedColumn;
import org.eclipse.birt.data.engine.api.querydefn.ConditionalExpression;
import org.eclipse.birt.data.engine.api.querydefn.FilterDefinition;
import org.eclipse.birt.data.engine.api.querydefn.GroupDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.api.querydefn.SortDefinition;
import org.eclipse.birt.data.engine.binding.APITestCase;
import org.eclipse.birt.data.engine.core.DataException;
import testutil.ConfigText;

public class ComputedColumnTest
extends APITestCase {
    private IQueryDefinition queryDefinition;
    private String[] ccName;
    private String[] ccExpr;

    protected APITestCase.DataSourceInfo getDataSourceInfo() {
        return new APITestCase.DataSourceInfo(ConfigText.getString("Api.TestData1.TableName"), ConfigText.getString("Api.TestData1.TableSQL"), ConfigText.getString("Api.TestData1.TestDataFileName"));
    }

    public void testNameDuplicate() throws Exception {
        this.ccName = new String[]{"col0Addcol1", "col0Addcol1"};
        this.ccExpr = new String[]{"row.COL0+row.COL1", "row.COL0*row.COL1"};
        int i = 0;
        while (i < this.ccName.length) {
            ComputedColumn computedColumn = new ComputedColumn(this.ccName[i], this.ccExpr[i], 2);
            this.dataSet.addComputedColumn((IComputedColumn)computedColumn);
            ++i;
        }
        try {
            this.doTest();
            ComputedColumnTest.fail((String)"Expecting exception due to duplicate field names.");
        }
        catch (DataException dataException) {}
    }

    public void testNameEmpty1() throws Exception {
        String[] stringArray = new String[2];
        stringArray[1] = "col0Addcol2";
        this.ccName = stringArray;
        this.ccExpr = new String[]{"row.COL0+row.COL1", "row.COL0*row.COL1"};
        int i = 0;
        while (i < this.ccName.length) {
            ComputedColumn computedColumn = new ComputedColumn(this.ccName[i], this.ccExpr[i], 2);
            this.dataSet.addComputedColumn((IComputedColumn)computedColumn);
            ++i;
        }
        try {
            this.doTest();
            ComputedColumnTest.fail((String)"Custom field name must not be empty.");
        }
        catch (DataException dataException) {}
    }

    public void testNameEmpty2() throws Exception {
        this.ccName = new String[]{"col0Addcol", ""};
        this.ccExpr = new String[]{"row.COL0+row.COL1", "row.COL0*row.COL1"};
        int i = 0;
        while (i < this.ccName.length) {
            ComputedColumn computedColumn = new ComputedColumn(this.ccName[i], this.ccExpr[i], 2);
            this.dataSet.addComputedColumn((IComputedColumn)computedColumn);
            ++i;
        }
        try {
            this.doTest();
            ComputedColumnTest.fail((String)"Custom field name must not be empty.");
        }
        catch (DataException dataException) {}
    }

    public void testInvalidExpr1() throws Exception {
        this.ccName = new String[]{"col0Addcol1", "col0Addcol2"};
        this.ccExpr = new String[]{"row.COL00row.COL1", "row.COL0*row.COL1"};
        int i = 0;
        while (i < this.ccName.length) {
            ComputedColumn computedColumn = new ComputedColumn(this.ccName[i], this.ccExpr[i], 2);
            this.dataSet.addComputedColumn((IComputedColumn)computedColumn);
            ++i;
        }
        try {
            this.doTest();
            ComputedColumnTest.fail((String)"Invalid expr: dataSetRow.COL00dataSetRow.COL1");
        }
        catch (Exception exception) {}
    }

    public void testInvalidExpr2() throws Exception {
        this.ccName = new String[]{"col0Addcol1", "col0Addcol2"};
        this.ccExpr = new String[]{"row.COL++row.COL1", "row.COL0*row.COL1"};
        int i = 0;
        while (i < this.ccName.length) {
            ComputedColumn computedColumn = new ComputedColumn(this.ccName[i], this.ccExpr[i], 2);
            this.dataSet.addComputedColumn((IComputedColumn)computedColumn);
            ++i;
        }
        try {
            this.doTest();
            ComputedColumnTest.fail((String)"Invalid expr: dataSetRow.COL++dataSetRow.COL1");
        }
        catch (DataException dataException) {}
    }

    public void testInvalidExpr3() throws Exception {
        this.ccName = new String[]{"col"};
        this.ccExpr = new String[]{""};
        int i = 0;
        while (i < this.ccName.length) {
            ComputedColumn computedColumn = new ComputedColumn(this.ccName[i], this.ccExpr[i], 2);
            this.dataSet.addComputedColumn((IComputedColumn)computedColumn);
            ++i;
        }
        try {
            this.doTest();
            ComputedColumnTest.fail((String)"Invalid expr: ");
        }
        catch (DataException dataException) {}
    }

    public void testA() throws Exception {
        this.ccName = new String[]{"col"};
        this.ccExpr = new String[]{"new String(\"abc\")"};
        int i = 0;
        while (i < this.ccName.length) {
            ComputedColumn computedColumn = new ComputedColumn(this.ccName[i], this.ccExpr[i], 2);
            this.dataSet.addComputedColumn((IComputedColumn)computedColumn);
            ++i;
        }
        try {
            this.doTest();
            ComputedColumnTest.fail((String)"Invalid expr: ");
        }
        catch (DataException e) {
            e.printStackTrace();
        }
    }

    public void testSortOnComputedColumn() throws Exception {
        this.ccName = new String[]{"ccc", "ccc2"};
        this.ccExpr = new String[]{"row.COL0+row.COL1", "row.COL1+10"};
        int i = 0;
        while (i < this.ccName.length) {
            ComputedColumn computedColumn = new ComputedColumn(this.ccName[i], this.ccExpr[i], 2);
            this.dataSet.addComputedColumn((IComputedColumn)computedColumn);
            ++i;
        }
        String[] bindingNameSort = new String[]{"SORT_DEFINITION"};
        IBaseExpression[] bindingExprSort = new IBaseExpression[]{new ScriptExpression("dataSetRow.ccc/Total.ave(dataSetRow.ccc)")};
        SortDefinition[] sortDefn = new SortDefinition[]{new SortDefinition()};
        sortDefn[0].setExpression("row.SORT_DEFINITION");
        sortDefn[0].setSortDirection(1);
        String[] bindingNameRow = new String[]{"ROW_COL0", "ROW_COL1", "ROW_COL2", "ROW_COL3", "ROW_ccc", "ROW_ccc2"};
        ScriptExpression[] bindingExprRow = new ScriptExpression[]{new ScriptExpression("dataSetRow.COL0", 0), new ScriptExpression("dataSetRow.COL1", 0), new ScriptExpression("dataSetRow.COL2", 0), new ScriptExpression("dataSetRow.COL3", 0), new ScriptExpression("dataSetRow." + this.ccName[0], 0), new ScriptExpression("dataSetRow." + this.ccName[1], 0)};
        IResultIterator resultIt = this.executeQuery((IQueryDefinition)this.createQuery(null, null, null, bindingNameSort, bindingExprSort, sortDefn, null, null, null, bindingNameRow, (IBaseExpression[])bindingExprRow));
        this.printResult(resultIt, bindingNameRow, bindingExprRow);
        this.checkOutputFile();
    }

    public void testSortOnComputedColumn1() throws Exception {
        this.ccName = new String[]{"cc"};
        this.ccExpr = new String[]{"(row.COL0%2==0?1:2)"};
        int i = 0;
        while (i < this.ccName.length) {
            ComputedColumn computedColumn = new ComputedColumn(this.ccName[i], this.ccExpr[i], 0);
            this.dataSet.addComputedColumn((IComputedColumn)computedColumn);
            ++i;
        }
        String[] bindingNameSort = new String[]{"SORT_DEFINITION"};
        IBaseExpression[] bindingExprSort = new IBaseExpression[]{new ScriptExpression("dataSetRow.cc")};
        SortDefinition[] sortDefn = new SortDefinition[]{new SortDefinition()};
        sortDefn[0].setColumn("SORT_DEFINITION");
        sortDefn[0].setSortDirection(1);
        String[] bindingNameRow = new String[]{"ROW_COL0", "ROW_COL1", "ROW_COL2", "ROW_COL3", "ROW_cc"};
        ScriptExpression[] bindingExprRow = new ScriptExpression[]{new ScriptExpression("dataSetRow.COL0", 0), new ScriptExpression("dataSetRow.COL1", 0), new ScriptExpression("dataSetRow.COL2", 0), new ScriptExpression("dataSetRow.COL3", 0), new ScriptExpression("dataSetRow." + this.ccName[0], 0)};
        IResultIterator resultIt = this.executeQuery((IQueryDefinition)this.createQuery(null, null, null, bindingNameSort, bindingExprSort, sortDefn, null, null, null, bindingNameRow, (IBaseExpression[])bindingExprRow));
        this.printResult(resultIt, bindingNameRow, bindingExprRow);
        this.checkOutputFile();
    }

    public void testFilterOnComputedColumn() throws Exception {
        this.ccName = new String[]{"ccc", "ccc2"};
        this.ccExpr = new String[]{"row.COL0+row.COL1", "row.COL1+10"};
        int i = 0;
        while (i < this.ccName.length) {
            ComputedColumn computedColumn = new ComputedColumn(this.ccName[i], this.ccExpr[i], 0);
            this.dataSet.addComputedColumn((IComputedColumn)computedColumn);
            ++i;
        }
        String[] bindingNameFilter = new String[]{"FILTER_ccc"};
        IBaseExpression[] bindingExprFilter = new IBaseExpression[]{new ScriptExpression("dataSetRow.ccc")};
        FilterDefinition[] filterDefn = new FilterDefinition[]{new FilterDefinition((IBaseExpression)new ConditionalExpression("row.FILTER_ccc", 15, "6"))};
        String[] bindingNameRow = new String[]{"ROW_COL0", "ROW_COL1", "ROW_COL2", "ROW_COL3", "ROW_ccc", "ROW_ccc2"};
        ScriptExpression[] bindingExprRow = new ScriptExpression[]{new ScriptExpression("dataSetRow.COL0", 0), new ScriptExpression("dataSetRow.COL1", 0), new ScriptExpression("dataSetRow.COL2", 0), new ScriptExpression("dataSetRow.COL3", 0), new ScriptExpression("dataSetRow." + this.ccName[0], 0), new ScriptExpression("dataSetRow." + this.ccName[1], 0)};
        IResultIterator resultIt = this.executeQuery((IQueryDefinition)this.createQuery(null, null, null, null, null, null, bindingNameFilter, bindingExprFilter, filterDefn, bindingNameRow, (IBaseExpression[])bindingExprRow));
        this.printResult(resultIt, bindingNameRow, bindingExprRow);
        this.checkOutputFile();
    }

    public void testGroupOnComputedColumn() throws Exception {
        this.ccName = new String[]{"ccc", "ccc2"};
        this.ccExpr = new String[]{"row.COL0+row.COL1", "Total.sum(row.ccc,null,0)*(row.COL3+1)"};
        int i = 0;
        while (i < this.ccName.length) {
            ComputedColumn computedColumn = new ComputedColumn(this.ccName[i], this.ccExpr[i], 0);
            this.dataSet.addComputedColumn((IComputedColumn)computedColumn);
            ++i;
        }
        String[] bindingNameGroup = new String[]{"GROUP_GROUP1", "GROUP_GROUP2"};
        IBaseExpression[] bindingExprGroup = new IBaseExpression[]{new ScriptExpression("dataSetRow.ccc"), new ScriptExpression("Total.sum(dataSetRow.ccc,null,1)*(dataSetRow.COL3+1)")};
        GroupDefinition[] groupDefn = new GroupDefinition[]{new GroupDefinition("group1"), new GroupDefinition("group2")};
        groupDefn[0].setInterval(99);
        groupDefn[0].setKeyExpression("row.GROUP_GROUP1");
        groupDefn[0].setIntervalRange(2.0);
        groupDefn[1].setKeyExpression("row.GROUP_GROUP2");
        String[] bindingNameRow = new String[]{"ROW_COL0", "ROW_COL1", "ROW_COL2", "ROW_COL3", "ROW_ccc", "ROW_ccc2"};
        ScriptExpression[] bindingExprRow = new ScriptExpression[]{new ScriptExpression("dataSetRow.COL0", 0), new ScriptExpression("dataSetRow.COL1", 0), new ScriptExpression("dataSetRow.COL2", 0), new ScriptExpression("dataSetRow.COL3", 0), new ScriptExpression("dataSetRow." + this.ccName[0], 0), new ScriptExpression("dataSetRow." + this.ccName[1], 0)};
        IResultIterator resultIt = this.executeQuery((IQueryDefinition)this.createQuery(bindingNameGroup, bindingExprGroup, groupDefn, null, null, null, null, null, null, bindingNameRow, (IBaseExpression[])bindingExprRow));
        this.printResult(resultIt, bindingNameRow, bindingExprRow);
        this.checkOutputFile();
    }

    public void testNewAggregationOnComputedColumnWithFilter() throws Exception {
        this.ccName = new String[]{"cc1"};
        this.ccExpr = new String[]{"row.COL0"};
        ArrayList<ScriptExpression> argument = new ArrayList<ScriptExpression>();
        argument.add(new ScriptExpression("3"));
        ComputedColumn cc1 = new ComputedColumn("cc1", "row.COL0", 1, "ISTOPN", null, argument);
        this.dataSet.addComputedColumn((IComputedColumn)cc1);
        String[] bindingNameRow = new String[]{"ROW_COL0", "ROW_COL1", "ROW_COL2", "ROW_COL3", "ROW_cc1"};
        ScriptExpression[] bindingExprRow = new ScriptExpression[]{new ScriptExpression("dataSetRow.COL0", 0), new ScriptExpression("dataSetRow.COL1", 0), new ScriptExpression("dataSetRow.COL2", 0), new ScriptExpression("dataSetRow.COL3", 0), new ScriptExpression("dataSetRow." + this.ccName[0], 0)};
        FilterDefinition filter = new FilterDefinition((IBaseExpression)new ScriptExpression("row.cc1"));
        this.dataSet.addFilter((IFilterDefinition)filter);
        IResultIterator resultIt = this.executeQuery((IQueryDefinition)this.createQuery(null, null, null, null, null, null, null, null, null, bindingNameRow, (IBaseExpression[])bindingExprRow));
        this.printResult(resultIt, bindingNameRow, bindingExprRow);
        this.checkOutputFile();
    }

    public void testNewAggregationOnComputedColumnWithOtherComputedColumns() throws Exception {
        this.ccName = new String[]{"cc1", "cc2"};
        this.ccExpr = new String[]{"row.COL0", "row.COL1"};
        ComputedColumn cc1 = new ComputedColumn("cc1", "0", 2);
        ComputedColumn cc2 = new ComputedColumn("cc2", "row.COL0", 2, "COUNT", null, new ArrayList());
        this.dataSet.addComputedColumn((IComputedColumn)cc1);
        this.dataSet.addComputedColumn((IComputedColumn)cc2);
        String[] bindingNameRow = new String[]{"ROW_COL0", "ROW_COL1", "ROW_COL2", "ROW_COL3", "ROW_cc1", "ROW_cc2"};
        ScriptExpression[] bindingExprRow = new ScriptExpression[]{new ScriptExpression("dataSetRow.COL0", 0), new ScriptExpression("dataSetRow.COL1", 0), new ScriptExpression("dataSetRow.COL2", 0), new ScriptExpression("dataSetRow.COL3", 0), new ScriptExpression("dataSetRow." + this.ccName[0], 2), new ScriptExpression("dataSetRow." + this.ccName[1], 2)};
        this.dataSource.setBeforeOpenScript(" a = 0;");
        this.dataSet.setOnFetchScript("a++;row.cc1 = a;");
        IResultIterator resultIt = this.executeQuery((IQueryDefinition)this.createQuery(null, null, null, null, null, null, null, null, null, bindingNameRow, (IBaseExpression[])bindingExprRow));
        this.printResult(resultIt, bindingNameRow, bindingExprRow);
        this.checkOutputFile();
    }

    public void testAggregationOnComputedColumn() throws Exception {
        this.ccName = new String[]{"cc1", "cc2", "cc3", "cc4"};
        this.ccExpr = new String[]{"row.COL0+row.COL1", "Total.sum(row.COL1+row.cc1)", "Total.ave(row.cc1+row.COL2+row.COL3, null, 0)*81", "Total.sum(row.COL1+row.COL2+row.COL3+row.COL0)"};
        int i = 0;
        while (i < this.ccName.length) {
            ComputedColumn computedColumn = new ComputedColumn(this.ccName[i], this.ccExpr[i], 0);
            this.dataSet.addComputedColumn((IComputedColumn)computedColumn);
            ++i;
        }
        String[] bindingNameRow = new String[]{"ROW_COL0", "ROW_COL1", "ROW_COL2", "ROW_COL3", "ROW_cc1", "ROW_cc2", "ROW_cc3", "ROW_cc4"};
        ScriptExpression[] bindingExprRow = new ScriptExpression[]{new ScriptExpression("dataSetRow.COL0", 0), new ScriptExpression("dataSetRow.COL1", 0), new ScriptExpression("dataSetRow.COL2", 0), new ScriptExpression("dataSetRow.COL3", 0), new ScriptExpression("dataSetRow." + this.ccName[0], 0), new ScriptExpression("dataSetRow." + this.ccName[1], 0), new ScriptExpression("dataSetRow." + this.ccName[2], 0), new ScriptExpression("dataSetRow." + this.ccName[3], 0)};
        IResultIterator resultIt = this.executeQuery((IQueryDefinition)this.createQuery(null, null, null, null, null, null, null, null, null, bindingNameRow, (IBaseExpression[])bindingExprRow));
        this.printResult(resultIt, bindingNameRow, bindingExprRow);
        this.checkOutputFile();
    }

    public void testAggregationOnComputedColumn2() throws Exception {
        this.ccName = new String[]{"cc1", "cc2", "cc3"};
        this.ccExpr = new String[]{"row.COL0", "row.cc1", "row.cc2"};
        ComputedColumn computedColumn0 = new ComputedColumn(this.ccName[0], this.ccExpr[0], 2, "COUNT", null, new ArrayList());
        this.dataSet.addComputedColumn((IComputedColumn)computedColumn0);
        ComputedColumn computedColumn1 = new ComputedColumn(this.ccName[1], this.ccExpr[1], 2);
        this.dataSet.addComputedColumn((IComputedColumn)computedColumn1);
        ComputedColumn computedColumn2 = new ComputedColumn(this.ccName[2], this.ccExpr[2], 2);
        this.dataSet.addComputedColumn((IComputedColumn)computedColumn2);
        String[] bindingNameRow = new String[]{"ROW_COL0", "ROW_COL1", "ROW_COL2", "ROW_COL3", "ROW_cc1", "ROW_cc2", "ROW_cc3"};
        ScriptExpression[] bindingExprRow = new ScriptExpression[]{new ScriptExpression("dataSetRow.COL0", 0), new ScriptExpression("dataSetRow.COL1", 0), new ScriptExpression("dataSetRow.COL2", 0), new ScriptExpression("dataSetRow.COL3", 0), new ScriptExpression("dataSetRow." + this.ccName[0], 0), new ScriptExpression("dataSetRow." + this.ccName[1], 0), new ScriptExpression("dataSetRow." + this.ccName[2], 0)};
        IResultIterator resultIt = this.executeQuery((IQueryDefinition)this.createQuery(null, null, null, null, null, null, null, null, null, bindingNameRow, (IBaseExpression[])bindingExprRow));
        this.printResult(resultIt, bindingNameRow, bindingExprRow);
        this.checkOutputFile();
    }

    public void testNewAggregationOnComputedColumn() throws Exception {
        this.ccName = new String[]{"cc1", "cc2", "cc3", "cc4", "cc5"};
        this.ccExpr = new String[]{"row.COL0+row.COL1", "Total.sum(row.COL1+row.cc1)", "Total.ave(row.cc1+row.COL2+row.COL3, null, 0)*81", "Total.sum(row.COL1+row.COL2+row.COL3+row.COL0)"};
        ComputedColumn cc1 = new ComputedColumn("cc1", "row.COL0+row.COL1");
        ComputedColumn cc2 = new ComputedColumn("cc2", "row.COL1+row.cc1", 0, "SUM", null, new ArrayList());
        ComputedColumn cc31 = new ComputedColumn("cc31", "row.cc1+row.COL2+row.COL3", 0, "AVE", null, new ArrayList());
        ComputedColumn cc3 = new ComputedColumn("cc3", "row.cc31*81");
        ComputedColumn cc4 = new ComputedColumn("cc4", "row.COL1+row.COL2+row.COL3+row.COL0", 0, "SUM", null, new ArrayList());
        ComputedColumn cc5 = new ComputedColumn("cc5", "Total.sum(row.COL1+row.COL2+row.COL3+row.COL0)");
        this.dataSet.addComputedColumn((IComputedColumn)cc1);
        this.dataSet.addComputedColumn((IComputedColumn)cc2);
        this.dataSet.addComputedColumn((IComputedColumn)cc3);
        this.dataSet.addComputedColumn((IComputedColumn)cc31);
        this.dataSet.addComputedColumn((IComputedColumn)cc4);
        this.dataSet.addComputedColumn((IComputedColumn)cc5);
        String[] bindingNameRow = new String[]{"ROW_COL0", "ROW_COL1", "ROW_COL2", "ROW_COL3", "ROW_cc1", "ROW_cc2", "ROW_cc3", "ROW_cc4", "ROW_cc5"};
        ScriptExpression[] bindingExprRow = new ScriptExpression[]{new ScriptExpression("dataSetRow.COL0", 0), new ScriptExpression("dataSetRow.COL1", 0), new ScriptExpression("dataSetRow.COL2", 0), new ScriptExpression("dataSetRow.COL3", 0), new ScriptExpression("dataSetRow." + this.ccName[0], 0), new ScriptExpression("dataSetRow." + this.ccName[1], 0), new ScriptExpression("dataSetRow." + this.ccName[2], 0), new ScriptExpression("dataSetRow." + this.ccName[3], 0), new ScriptExpression("dataSetRow." + this.ccName[4], 0)};
        IResultIterator resultIt = this.executeQuery((IQueryDefinition)this.createQuery(null, null, null, null, null, null, null, null, null, bindingNameRow, (IBaseExpression[])bindingExprRow));
        this.printResult(resultIt, bindingNameRow, bindingExprRow);
        this.checkOutputFile();
    }

    public void testNestedAggregationOnComputedColumn() throws Exception {
        this.ccName = new String[]{"cc1", "cc2", "cc3"};
        this.ccExpr = new String[]{"row.COL0+row.COL1", "Total.runningSum(row.cc1/Total.sum(row.cc1))*100", "Total.runningSum(Total.sum(row.cc1/Total.sum(row.cc1)))"};
        int i = 0;
        while (i < this.ccName.length) {
            ComputedColumn computedColumn = new ComputedColumn(this.ccName[i], this.ccExpr[i], 0);
            this.dataSet.addComputedColumn((IComputedColumn)computedColumn);
            ++i;
        }
        String[] bindingNameRow = new String[]{"ROW_COL0", "ROW_COL1", "ROW_COL2", "ROW_COL3", "ROW_cc1", "ROW_cc2", "ROW_cc3"};
        ScriptExpression[] bindingExprRow = new ScriptExpression[]{new ScriptExpression("dataSetRow.COL0", 0), new ScriptExpression("dataSetRow.COL1", 0), new ScriptExpression("dataSetRow.COL2", 0), new ScriptExpression("dataSetRow.COL3", 0), new ScriptExpression("dataSetRow." + this.ccName[0], 0), new ScriptExpression("dataSetRow." + this.ccName[1], 0), new ScriptExpression("dataSetRow." + this.ccName[2], 0)};
        IResultIterator resultIt = this.executeQuery((IQueryDefinition)this.createQuery(null, null, null, null, null, null, null, null, null, bindingNameRow, (IBaseExpression[])bindingExprRow));
        this.printResult(resultIt, bindingNameRow, bindingExprRow);
        this.checkOutputFile();
    }

    public void testNestedComputedColumn() throws Exception {
        this.ccName = new String[]{"cc1", "cc2", "cc3"};
        this.ccExpr = new String[]{"row.COL0+row.COL1", "row.cc1*100", "Total.runningSum(row.cc1/Total.sum(row.cc1))*100"};
        int i = 0;
        while (i < this.ccName.length) {
            ComputedColumn computedColumn = new ComputedColumn(this.ccName[i], this.ccExpr[i], 0);
            this.dataSet.addComputedColumn((IComputedColumn)computedColumn);
            ++i;
        }
        String[] bindingNameRow = new String[]{"ROW_COL0", "ROW_COL1", "ROW_COL2", "ROW_COL3", "ROW_cc1", "ROW_cc2", "ROW_cc3"};
        ScriptExpression[] bindingExprRow = new ScriptExpression[]{new ScriptExpression("dataSetRow.COL0", 0), new ScriptExpression("dataSetRow.COL1", 0), new ScriptExpression("dataSetRow.COL2", 0), new ScriptExpression("dataSetRow.COL3", 0), new ScriptExpression("dataSetRow." + this.ccName[0], 0), new ScriptExpression("dataSetRow." + this.ccName[1], 0), new ScriptExpression("dataSetRow." + this.ccName[2], 0)};
        IResultIterator resultIt = this.executeQuery((IQueryDefinition)this.createQuery(null, null, null, null, null, null, null, null, null, bindingNameRow, (IBaseExpression[])bindingExprRow));
        this.printResult(resultIt, bindingNameRow, bindingExprRow);
        this.checkOutputFile();
    }

    public void testFilterOnAggregationColumn() throws Exception {
        this.ccName = new String[]{"cc1", "cc2", "cc3"};
        this.ccExpr = new String[]{"row.COL0+row.COL1", "Total.runningSum(row.cc1,row.COL0==0,0)", "Total.runningSum(row.cc1,row.COL0>0,0)"};
        int i = 0;
        while (i < this.ccName.length) {
            ComputedColumn computedColumn = new ComputedColumn(this.ccName[i], this.ccExpr[i], 0);
            this.dataSet.addComputedColumn((IComputedColumn)computedColumn);
            ++i;
        }
        String[] bindingNameRow = new String[]{"ROW_COL0", "ROW_COL1", "ROW_COL2", "ROW_COL3", "ROW_cc1", "ROW_cc2", "ROW_cc3"};
        ScriptExpression[] bindingExprRow = new ScriptExpression[]{new ScriptExpression("dataSetRow.COL0", 0), new ScriptExpression("dataSetRow.COL1", 0), new ScriptExpression("dataSetRow.COL2", 0), new ScriptExpression("dataSetRow.COL3", 0), new ScriptExpression("dataSetRow." + this.ccName[0], 0), new ScriptExpression("dataSetRow." + this.ccName[1], 0), new ScriptExpression("dataSetRow." + this.ccName[2], 0)};
        IResultIterator resultIt = this.executeQuery((IQueryDefinition)this.createQuery(null, null, null, null, null, null, null, null, null, bindingNameRow, (IBaseExpression[])bindingExprRow));
        this.printResult(resultIt, bindingNameRow, bindingExprRow);
        this.checkOutputFile();
    }

    public void testGroupFilterOnComputedColumnsWithAggregations() throws Exception {
        this.ccName = new String[]{"cc1", "cc2", "cc3", "cc4"};
        this.ccExpr = new String[]{"row.COL0+row.COL1", "Total.sum(row.COL1+row.cc1)", "Total.ave(row.cc1+row.COL2+row.COL3, null, 0)*81", "Total.sum(row.COL1+row.COL2+row.COL3+row.COL0)"};
        int i = 0;
        while (i < this.ccName.length) {
            ComputedColumn computedColumn = new ComputedColumn(this.ccName[i], this.ccExpr[i], 0);
            this.dataSet.addComputedColumn((IComputedColumn)computedColumn);
            ++i;
        }
        String[] bindingNameGroup = new String[]{"GROUP_GROUP1"};
        IBaseExpression[] bindingExprGroup = new IBaseExpression[]{new ScriptExpression("dataSetRow.cc1")};
        GroupDefinition[] groupDefn = new GroupDefinition[]{new GroupDefinition("group1")};
        groupDefn[0].setKeyExpression("row.GROUP_GROUP1");
        FilterDefinition filter = new FilterDefinition((IBaseExpression)new ScriptExpression("Total.sum(dataSetRow.COL0)>400"));
        groupDefn[0].addFilter((IFilterDefinition)filter);
        String[] bindingNameRow = new String[]{"ROW_COL0", "ROW_COL1", "ROW_COL2", "ROW_COL3", "ROW_cc1", "ROW_cc2", "ROW_cc3", "ROW_cc4"};
        ScriptExpression[] bindingExprRow = new ScriptExpression[]{new ScriptExpression("dataSetRow.COL0", 0), new ScriptExpression("dataSetRow.COL1", 0), new ScriptExpression("dataSetRow.COL2", 0), new ScriptExpression("dataSetRow.COL3", 0), new ScriptExpression("dataSetRow." + this.ccName[0], 0), new ScriptExpression("dataSetRow." + this.ccName[1], 0), new ScriptExpression("dataSetRow." + this.ccName[2], 0), new ScriptExpression("dataSetRow." + this.ccName[3], 0)};
        try {
            this.executeQuery((IQueryDefinition)this.createQuery(null, null, null, null, null, null, null, null, null, bindingNameRow, (IBaseExpression[])bindingExprRow));
        }
        catch (DataException dataException) {}
    }

    public void testWrongDataType() throws Exception {
        this.ccName = new String[]{"ccc", "ccc2"};
        this.ccExpr = new String[]{"'abc'+row.COL0+row.COL1+'abc'", "'a'+row.COL1+'abc'"};
        int i = 0;
        while (i < this.ccName.length) {
            ComputedColumn computedColumn = new ComputedColumn(this.ccName[i], this.ccExpr[i], 2);
            this.dataSet.addComputedColumn((IComputedColumn)computedColumn);
            ++i;
        }
        String[] bindingNameRow = new String[]{"ROW_COL0", "ROW_COL1", "ROW_COL2", "ROW_COL3", "ROW_ccc", "ROW_ccc2"};
        ScriptExpression[] bindingExprRow = new ScriptExpression[]{new ScriptExpression("dataSetRow.COL0", 0), new ScriptExpression("dataSetRow.COL1", 0), new ScriptExpression("dataSetRow.COL2", 0), new ScriptExpression("dataSetRow.COL3", 0), new ScriptExpression("dataSetRow." + this.ccName[0], 0), new ScriptExpression("dataSetRow." + this.ccName[1], 0)};
        try {
            IResultIterator o = this.executeQuery((IQueryDefinition)this.createQuery(null, null, null, null, null, null, null, null, null, bindingNameRow, (IBaseExpression[])bindingExprRow));
            System.out.println(o);
        }
        catch (DataException dataException) {
            return;
        }
        ComputedColumnTest.fail((String)"Should throw a DataException.");
    }

    public void testRowIndex() throws Exception {
        this.ccName = new String[]{"ccc"};
        this.ccExpr = new String[]{"row[0]"};
        int i = 0;
        while (i < this.ccName.length) {
            ComputedColumn computedColumn = new ComputedColumn(this.ccName[i], this.ccExpr[i], 0);
            this.dataSet.addComputedColumn((IComputedColumn)computedColumn);
            ++i;
        }
        String[] bindingNameRow = new String[]{"ROW_COL0", "ROW_COL1", "ROW_COL2", "ROW_COL3", "ROW_ccc"};
        ScriptExpression[] bindingExprRow = new ScriptExpression[]{new ScriptExpression("dataSetRow.COL0", 0), new ScriptExpression("dataSetRow.COL1", 0), new ScriptExpression("dataSetRow.COL2", 0), new ScriptExpression("dataSetRow.COL3", 0), new ScriptExpression("dataSetRow." + this.ccName[0], 0)};
        IResultIterator resultIt = this.executeQuery((IQueryDefinition)this.createQuery(null, null, null, null, null, null, null, null, null, bindingNameRow, (IBaseExpression[])bindingExprRow));
        this.printResult(resultIt, bindingNameRow, bindingExprRow);
        this.checkOutputFile();
    }

    public void testMultipass_Sort() throws Exception {
        this.ccName = new String[]{"cc1", "cc2"};
        this.ccExpr = new String[]{"Total.sum(row.COL1)", "Total.sum(row.cc1)"};
        int i = 0;
        while (i < this.ccName.length) {
            ComputedColumn computedColumn = new ComputedColumn(this.ccName[i], this.ccExpr[i], 2);
            this.dataSet.addComputedColumn((IComputedColumn)computedColumn);
            ++i;
        }
        String[] bindingNameSort = new String[]{"SORT_DEFINITION_1", "SORT_DEFINITION_2"};
        IBaseExpression[] bindingExprSort = new IBaseExpression[]{new ScriptExpression("dataSetRow.COL1/(Total.ave(dataSetRow.cc1)+dataSetRow.cc1)"), new ScriptExpression("dataSetRow.cc2-dataSetRow.COL2")};
        SortDefinition[] sortDefn = new SortDefinition[]{new SortDefinition(), new SortDefinition()};
        sortDefn[0].setColumn("SORT_DEFINITION_1");
        sortDefn[0].setSortDirection(1);
        sortDefn[1].setColumn("SORT_DEFINITION_2");
        sortDefn[1].setSortDirection(1);
        String[] bindingNameRow = new String[]{"ROW_COL0", "ROW_COL1", "ROW_COL2", "ROW_COL3", "ROW_cc1", "ROW_cc2"};
        ScriptExpression[] bindingExprRow = new ScriptExpression[]{new ScriptExpression("dataSetRow.COL0", 0), new ScriptExpression("dataSetRow.COL1", 0), new ScriptExpression("dataSetRow.COL2", 0), new ScriptExpression("dataSetRow.COL3", 0), new ScriptExpression("dataSetRow." + this.ccName[0], 0), new ScriptExpression("dataSetRow." + this.ccName[1], 0)};
        IResultIterator resultIt = this.executeQuery((IQueryDefinition)this.createQuery(null, null, null, bindingNameSort, bindingExprSort, sortDefn, null, null, null, bindingNameRow, (IBaseExpression[])bindingExprRow));
        this.printResult(resultIt, bindingNameRow, bindingExprRow);
        this.checkOutputFile();
    }

    public void testMultiPass_Group() throws Exception {
        this.ccName = new String[]{"cc1", "cc2"};
        this.ccExpr = new String[]{"row.COL0+row.COL1+row.COL2+row.COL3", "row.cc1+10"};
        int i = 0;
        while (i < this.ccName.length) {
            ComputedColumn computedColumn = new ComputedColumn(this.ccName[i], this.ccExpr[i], 0);
            this.dataSet.addComputedColumn((IComputedColumn)computedColumn);
            ++i;
        }
        String[] bindingNameGroup = new String[]{"GROUP_GROUP1", "GROUP_GROUP2"};
        IBaseExpression[] bindingExprGroup = new IBaseExpression[]{new ScriptExpression("dataSetRow.COL1"), new ScriptExpression("dataSetRow.cc2+Total.sum(dataSetRow.COL1,null,1)")};
        GroupDefinition[] groupDefn = new GroupDefinition[]{new GroupDefinition("group1"), new GroupDefinition("group2")};
        groupDefn[0].setKeyExpression("row.GROUP_GROUP1");
        groupDefn[1].setKeyExpression("row.GROUP_GROUP2");
        String[] bindingNameRow = new String[]{"ROW_COL0", "ROW_COL1", "ROW_COL2", "ROW_COL3", "ROW_cc1", "ROW_cc2"};
        ScriptExpression[] bindingExprRow = new ScriptExpression[]{new ScriptExpression("dataSetRow.COL0", 0), new ScriptExpression("dataSetRow.COL1", 0), new ScriptExpression("dataSetRow.COL2", 0), new ScriptExpression("dataSetRow.COL3", 0), new ScriptExpression("dataSetRow." + this.ccName[0], 0), new ScriptExpression("dataSetRow." + this.ccName[1], 0)};
        IResultIterator resultIt = this.executeQuery((IQueryDefinition)this.createQuery(bindingNameGroup, bindingExprGroup, groupDefn, null, null, null, null, null, null, bindingNameRow, (IBaseExpression[])bindingExprRow));
        this.printResult(resultIt, bindingNameRow, bindingExprRow);
        this.checkOutputFile();
    }

    public void testWrongColumnName() throws Exception {
        this.ccName = new String[]{"ccc", "ccc2"};
        this.ccExpr = new String[]{"row.COL0+row.COL1", "row.COL1+10"};
        int i = 0;
        while (i < this.ccName.length) {
            ComputedColumn computedColumn = new ComputedColumn(this.ccName[i], this.ccExpr[i], 0);
            this.dataSet.addComputedColumn((IComputedColumn)computedColumn);
            ++i;
        }
        String[] bindingNameSort = new String[]{"SORT_DEFINITION"};
        IBaseExpression[] bindingExprSort = new IBaseExpression[]{new ScriptExpression("dataSetRow.ccc/Total.ave(dataSetRow.ccc)")};
        SortDefinition[] sortDefn = new SortDefinition[]{new SortDefinition()};
        sortDefn[0].setColumn("SORT_DEFINITION");
        sortDefn[0].setSortDirection(1);
        String[] bindingNameRow = new String[]{"ROW_COL0", "ROW_COL1", "ROW_COL2", "ROW_COL3", "ROW_cc1", "ROW_cc2"};
        ScriptExpression[] bindingExprRow = new ScriptExpression[]{new ScriptExpression("dataSetRow.COL0", 0), new ScriptExpression("dataSetRow.COL1", 0), new ScriptExpression("dataSetRow.COL2", 0), new ScriptExpression("dataSetRow.COL3", 0), new ScriptExpression("dataSetRow.cc2", 0), new ScriptExpression("dataSetRow." + this.ccName[1], 0)};
        try {
            IResultIterator resultIt = this.executeQuery((IQueryDefinition)this.createQuery(null, null, null, bindingNameSort, bindingExprSort, sortDefn, null, null, null, bindingNameRow, (IBaseExpression[])bindingExprRow));
            this.printResult(resultIt, bindingNameRow, bindingExprRow);
            ComputedColumnTest.fail((String)"should throw exception");
        }
        catch (DataException dataException) {}
    }

    private void printResult(IResultIterator resultIt, String[] bindingNameRow, ScriptExpression[] bindingExprRow) throws Exception {
        String str = "";
        int i = 0;
        while (i < bindingNameRow.length) {
            str = String.valueOf(str) + bindingExprRow[i].getText().replaceAll("dataSetRow\\Q.\\E", "");
            str = String.valueOf(str) + "  ";
            ++i;
        }
        this.testPrintln(str);
        while (resultIt.next()) {
            str = "";
            i = 0;
            while (i < bindingNameRow.length) {
                str = String.valueOf(str) + " ";
                str = resultIt.getValue(bindingNameRow[i]) == null ? String.valueOf(str) + "<null>" : String.valueOf(str) + (resultIt.getValue(bindingNameRow[i]) instanceof Double ? Integer.valueOf((int)Double.parseDouble(resultIt.getValue(bindingNameRow[i]).toString())) : resultIt.getValue(bindingNameRow[i]));
                str = String.valueOf(str) + "    ";
                ++i;
            }
            this.testPrintln(str);
        }
    }

    private IResultIterator doTest() throws Exception {
        this.queryDefinition = this.getDefaultQueryDefn(this.dataSet.getName());
        return this.executeQuery(this.queryDefinition);
    }
}

