/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.binding;

import org.eclipse.birt.core.script.ScriptContext;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.IParameterDefinition;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.querydefn.BaseDataSetDesign;
import org.eclipse.birt.data.engine.api.querydefn.ConditionalExpression;
import org.eclipse.birt.data.engine.api.querydefn.FilterDefinition;
import org.eclipse.birt.data.engine.api.querydefn.GroupDefinition;
import org.eclipse.birt.data.engine.api.querydefn.InputParameterBinding;
import org.eclipse.birt.data.engine.api.querydefn.OdaDataSetDesign;
import org.eclipse.birt.data.engine.api.querydefn.ParameterDefinition;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.api.querydefn.SortDefinition;
import org.eclipse.birt.data.engine.binding.APITestCase;
import testutil.ConfigText;

public class NestedQueryTest
extends APITestCase {
    private String callsTableName;
    private String[] bindingNameCustomer;
    private ScriptExpression[] expressionsCustomer;
    private QueryDefinition queryDefnCustomer;
    private String[] bindingNameCall;
    private ScriptExpression[] expressionsCall;
    private IBaseDataSetDesign datasetCall;
    private QueryDefinition queryDefnCall;

    protected void setUp() throws Exception {
        super.setUp();
        this.prepareDataSet(new APITestCase.DataSourceInfo(ConfigText.getString("Api.TestDataCalls.TableName"), ConfigText.getString("Api.TestDataCalls.TableSQL"), ConfigText.getString("Api.TestDataCalls.TestDataFileName")));
        this.callsTableName = ConfigText.getString("Api.TestDataCalls.TableName");
    }

    protected APITestCase.DataSourceInfo getDataSourceInfo() {
        return new APITestCase.DataSourceInfo(ConfigText.getString("Api.TestDataCustomer.TableName"), ConfigText.getString("Api.TestDataCustomer.TableSQL"), ConfigText.getString("Api.TestDataCustomer.TestDataFileName"));
    }

    public void test1() throws Exception {
        this.queryDefnCustomer = this.createCustomerQueryDefn();
        this.datasetCall = this.newDataSet("data set calls", " SELECT * FROM " + this.callsTableName + " WHERE CustomerID = ?");
        this.queryDefnCall = this.createCallQueryDefn();
        this.addParameterToQueryCall(this.expressionsCall[5]);
        this.runNestedQuery();
    }

    public void test2() throws Exception {
        this.queryDefnCustomer = this.createCustomerQueryDefn();
        this.datasetCall = this.newDataSet("data set calls", " SELECT * FROM " + this.callsTableName + " WHERE CustomerID = ?");
        this.queryDefnCall = this.createCallQueryDefn();
        this.addParameterToQueryCall(this.expressionsCustomer[0]);
        this.runNestedQuery();
    }

    public void test3() throws Exception {
        this.queryDefnCustomer = this.createCustomerQueryDefn();
        this.datasetCall = this.newDataSet("data set calls", " SELECT * FROM " + this.callsTableName + " WHERE CustomerID = ?");
        this.queryDefnCall = this.createCallQueryDefn();
        this.addParameterToQueryCall(new ScriptExpression("rows[0].CUSTOMERID", 0));
        this.runNestedQuery();
    }

    public void test4() throws Exception {
        this.queryDefnCustomer = this.createCustomerQueryDefn();
        this.datasetCall = this.newDataSet("data set calls", " SELECT * FROM " + this.callsTableName);
        this.queryDefnCall = this.createCallQueryDefn();
        String[] bindingNameFilter = new String[]{"FILTER_CUSTOMERID"};
        IBaseExpression[] bindingExprFilter = new IBaseExpression[]{new ScriptExpression("dataSetRow.CU")};
        FilterDefinition filterDefn = new FilterDefinition((IBaseExpression)new ConditionalExpression("row[\"ROW_CUSTOMERID\"]", 1, "rows[0].CUSTOMERID"));
        this.queryDefnCall.addFilter((IFilterDefinition)filterDefn);
        this.runNestedQuery();
    }

    public void test5() throws Exception {
        this.queryDefnCustomer = this.createCustomerQueryDefn();
        this.datasetCall = this.newDataSet("data set calls", " SELECT * FROM " + this.callsTableName);
        this.queryDefnCall = this.createCallQueryDefn();
        String[] bindingNameFilter = new String[]{"FILTER_CUSTOMERID"};
        IBaseExpression[] bindingExprFilter = new IBaseExpression[]{new ScriptExpression("dataSetRow.CU")};
        FilterDefinition filterDefn = new FilterDefinition((IBaseExpression)new ConditionalExpression("row._outer[\"ROW_CUSTOMERID\"]", 1, "2"));
        FilterDefinition filterDefn1 = new FilterDefinition((IBaseExpression)new ConditionalExpression("row[\"ROW_CUSTOMERID\"]", 1, "row._outer[\"ROW_CUSTOMERID\"]"));
        this.queryDefnCall.addFilter((IFilterDefinition)filterDefn);
        this.queryDefnCall.addFilter((IFilterDefinition)filterDefn1);
        this.runNestedQuery();
    }

    public void test6() throws Exception {
        this.queryDefnCustomer = this.createCustomerQueryDefn();
        this.datasetCall = this.newDataSet("data set calls", " SELECT * FROM " + this.callsTableName);
        this.queryDefnCall = this.createCallQueryDefn();
        GroupDefinition gd = new GroupDefinition("group1");
        gd.setKeyColumn("ROW_OUTER_GROUPKEY");
        this.queryDefnCall.addGroup(gd);
        this.runNestedQuery();
    }

    public void test7() throws Exception {
        this.queryDefnCustomer = this.createCustomerQueryDefn();
        this.datasetCall = this.newDataSet("data set calls", " SELECT * FROM " + this.callsTableName);
        this.queryDefnCall = this.createCallQueryDefn();
        String[] bindingNameFilter = new String[]{"FILTER_CUSTOMERID"};
        IBaseExpression[] bindingExprFilter = new IBaseExpression[]{new ScriptExpression("dataSetRow.CU")};
        FilterDefinition filterDefn = new FilterDefinition((IBaseExpression)new ConditionalExpression("Total.isTopN(row[\"ROW_DURATION\"],5)", 11));
        this.queryDefnCall.addFilter((IFilterDefinition)filterDefn);
        this.runNestedQuery();
    }

    public void test8() throws Exception {
        this.queryDefnCustomer = this.createCustomerQueryDefn();
        this.queryDefnCustomer.getGroups().clear();
        this.queryDefnCustomer.getSorts().clear();
        this.datasetCall = this.newDataSet("data set calls", " SELECT * FROM " + this.callsTableName + " WHERE CustomerID = ?");
        this.queryDefnCall = this.createCallQueryDefn();
        this.addParameterToQueryCall(this.expressionsCustomer[0]);
        this.runNestedQuery();
    }

    private QueryDefinition createCustomerQueryDefn() throws Exception {
        String[] bindingNameGroup = new String[]{"GROUP_CUSTOMERID", "GROUP_NAME"};
        IBaseExpression[] bindingExprGroup = new IBaseExpression[]{new ScriptExpression("dataSetRow.CUSTOMERID"), new ScriptExpression("dataSetRow.NAME")};
        GroupDefinition[] groupDefn = new GroupDefinition[]{new GroupDefinition("group0"), new GroupDefinition("group1")};
        groupDefn[0].setKeyExpression("row.GROUP_CUSTOMERID");
        groupDefn[1].setKeyExpression("row.GROUP_NAME");
        String[] bindingNameSort = new String[]{"SORT_CUSTOMERID"};
        IBaseExpression[] bindingExprSort = new IBaseExpression[]{new ScriptExpression("dataSetRow.CUSTOMERID")};
        SortDefinition[] sortDefn = new SortDefinition[]{new SortDefinition()};
        sortDefn[0].setColumn("SORT_CUSTOMERID");
        sortDefn[0].setSortDirection(1);
        this.bindingNameCustomer = new String[4];
        this.bindingNameCustomer[0] = "ROW_CUSTOMERID";
        this.bindingNameCustomer[1] = "ROW_NAME";
        this.bindingNameCustomer[2] = "ROW_ADDRESS";
        this.bindingNameCustomer[3] = "ROW_CURRENTBALANCE";
        this.expressionsCustomer = new ScriptExpression[]{new ScriptExpression("dataSetRow.CUSTOMERID", 0), new ScriptExpression("dataSetRow.NAME", 0), new ScriptExpression("dataSetRow.ADDRESS", 0), new ScriptExpression("dataSetRow.CURRENTBALANCE", 0)};
        return this.createQuery(bindingNameGroup, bindingExprGroup, groupDefn, bindingNameSort, bindingExprSort, sortDefn, null, null, null, this.bindingNameCustomer, (IBaseExpression[])this.expressionsCustomer);
    }

    private QueryDefinition createCallQueryDefn() throws Exception {
        this.bindingNameCall = new String[9];
        this.bindingNameCall[0] = "ROW_CUSTOMERID";
        this.bindingNameCall[1] = "ROW_CALLTIME";
        this.bindingNameCall[2] = "ROW_TONUMBER";
        this.bindingNameCall[3] = "ROW_DURATION";
        this.bindingNameCall[4] = "ROW_CHARGE";
        this.bindingNameCall[5] = "ROW_[0]_CUSTOMERID";
        this.bindingNameCall[6] = "ROW_OUTER_CUSTOMERID";
        this.bindingNameCall[7] = "ROW_OUTER_TONUMBER";
        this.bindingNameCall[8] = "ROW_OUTER_GROUPKEY";
        this.expressionsCall = new ScriptExpression[]{new ScriptExpression("dataSetRow.CUSTOMERID", 0), new ScriptExpression("dataSetRow.CALLTIME", 0), new ScriptExpression("dataSetRow.TONUMBER", 0), new ScriptExpression("dataSetRow.DURATION", 0), new ScriptExpression("dataSetRow.CHARGE", 0), new ScriptExpression("rows[0].CUSTOMERID", 0), new ScriptExpression("row._outer[\"ROW_CUSTOMERID\"]"), new ScriptExpression("row._outer[\"ROW_CURRENTBALANCE\"]"), new ScriptExpression("row._outer[\"ROW_CUSTOMERID\"] == row[\"ROW_CUSTOMERID\"]?true:false;")};
        this.dataSet = (BaseDataSetDesign)this.datasetCall;
        return this.createQuery(null, null, null, null, null, null, null, null, null, this.bindingNameCall, (IBaseExpression[])this.expressionsCall);
    }

    private void addParameterToQueryCall(ScriptExpression expression) {
        ParameterDefinition inputParamDefn = new ParameterDefinition("param1", 2, true, false);
        inputParamDefn.setPosition(1);
        inputParamDefn.setDefaultInputValue("0");
        ((OdaDataSetDesign)this.datasetCall).addParameter((IParameterDefinition)inputParamDefn);
        InputParameterBinding inputParamBinding = new InputParameterBinding(1, (IBaseExpression)expression);
        this.queryDefnCall.addInputParamBinding(inputParamBinding);
    }

    private void runNestedQuery() throws Exception {
        IPreparedQuery preparedQueryCustomer = this.dataEngine.prepare((IQueryDefinition)this.queryDefnCustomer, this.getAppContext());
        IPreparedQuery preparedQueryCall = this.dataEngine.prepare((IQueryDefinition)this.queryDefnCall, this.getAppContext());
        ScriptContext scriptContext = new ScriptContext();
        IQueryResults queryResultsCustomer = preparedQueryCustomer.execute(scriptContext.getScope());
        IResultIterator resultItCustomer = queryResultsCustomer.getResultIterator();
        this.testPrintln("*****A new Report Start!*****");
        while (resultItCustomer.next()) {
            resultItCustomer.getStartingGroupLevel();
            resultItCustomer.getEndingGroupLevel();
            this.testPrint("Customer Name:");
            this.testPrint(this.evalAsString(this.bindingNameCustomer[1], resultItCustomer));
            this.testPrint("  Address:");
            this.testPrint(this.evalAsString(this.bindingNameCustomer[2], resultItCustomer));
            this.testPrintln("");
            this.testPrint("Starting Balance: $");
            this.testPrint(this.evalAsString(this.bindingNameCustomer[3], resultItCustomer));
            this.testPrintln("");
            scriptContext.enterScope();
            IQueryResults queryResultsCalls = preparedQueryCall.execute(queryResultsCustomer, scriptContext.getScope());
            IResultIterator resultItCalls = queryResultsCalls.getResultIterator();
            while (resultItCalls.next()) {
                int i = 1;
                while (i < this.expressionsCall.length) {
                    this.testPrint(this.evalAsString(this.bindingNameCall[i], resultItCalls));
                    this.testPrint(" ");
                    ++i;
                }
                this.testPrintln("");
            }
            scriptContext.exitScope();
            this.testPrintln("");
        }
        scriptContext.exit();
        this.checkOutputFile();
    }
}

