/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.binding;

import org.eclipse.birt.data.engine.api.APITestCase;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.querydefn.FilterDefinition;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import testutil.ConfigText;

public class QueryCacheTest
extends APITestCase {
    protected APITestCase.DataSourceInfo getDataSourceInfo() {
        return new APITestCase.DataSourceInfo(ConfigText.getString("Binding.TestData.TableName"), ConfigText.getString("Binding.TestData.TableSQL"), ConfigText.getString("Binding.TestData.TestDataFileName"));
    }

    public void testBasicCache() throws Exception {
        QueryDefinition query = new QueryDefinition();
        query.setDataSetName(this.dataSet.getName());
        query.setAutoBinding(true);
        query.setCacheQueryResults(true);
        IQueryResults queryResults = this.dataEngine.prepare((IQueryDefinition)query).execute(null);
        String id = queryResults.getID();
        IResultIterator it = queryResults.getResultIterator();
        it.close();
        IQueryResults result = this.dataEngine.getQueryResults(id);
        it = result.getResultIterator();
        this.outputQueryResult(it, new String[]{"CITY", "AMOUNT"});
        this.checkOutputFile();
    }

    public void testBasicCache1() throws Exception {
        QueryDefinition query = new QueryDefinition();
        query.setDataSetName(this.dataSet.getName());
        query.setAutoBinding(true);
        query.setCacheQueryResults(true);
        IQueryResults queryResults = this.dataEngine.prepare((IQueryDefinition)query).execute(null);
        String id = queryResults.getID();
        IResultIterator it = queryResults.getResultIterator();
        it.close();
        IQueryResults result = this.dataEngine.getQueryResults(id);
        it = result.getResultIterator();
        QueryCacheTest.assertEquals((Object)it.getValue("CITY"), (Object)"Beijing");
        QueryCacheTest.assertEquals((Object)it.getValue("AMOUNT"), (Object)7000);
        it.next();
        QueryCacheTest.assertEquals((Object)it.getValue("CITY"), (Object)"Beijing");
        QueryCacheTest.assertEquals((Object)it.getValue("AMOUNT"), (Object)7000);
        it.next();
        QueryCacheTest.assertEquals((Object)it.getValue("CITY"), (Object)"New York");
        QueryCacheTest.assertEquals((Object)it.getValue("AMOUNT"), (Object)100);
    }

    public void testCacheEmptyResultSet() throws Exception {
        QueryDefinition query = new QueryDefinition();
        query.setDataSetName(this.dataSet.getName());
        query.setAutoBinding(true);
        query.setCacheQueryResults(true);
        query.addFilter((IFilterDefinition)new FilterDefinition((IBaseExpression)new ScriptExpression("false")));
        IQueryResults queryResults = this.dataEngine.prepare((IQueryDefinition)query).execute(null);
        queryResults.getResultIterator().close();
    }

    public void testCacheEmptyResultSet1() throws Exception {
        QueryDefinition query = new QueryDefinition();
        query.setDataSetName(this.dataSet.getName());
        query.setAutoBinding(true);
        query.setCacheQueryResults(true);
        query.addFilter((IFilterDefinition)new FilterDefinition((IBaseExpression)new ScriptExpression("false")));
        IQueryResults queryResults = this.dataEngine.prepare((IQueryDefinition)query).execute(null);
        String id = queryResults.getID();
        IResultIterator it = queryResults.getResultIterator();
        it.close();
        IQueryResults result = this.dataEngine.getQueryResults(id);
        it = result.getResultIterator();
        QueryCacheTest.assertEquals((Object)it.getValue("CITY"), null);
        QueryCacheTest.assertEquals((Object)it.getValue("AMOUNT"), null);
        QueryCacheTest.assertEquals((boolean)it.next(), (boolean)false);
    }

    public void testUseDetailsCache() throws Exception {
        QueryDefinition query = new QueryDefinition();
        query.setDataSetName(this.dataSet.getName());
        query.setAutoBinding(true);
        query.setCacheQueryResults(true);
        query.setUsesDetails(false);
        IQueryResults queryResults = this.dataEngine.prepare((IQueryDefinition)query).execute(null);
        String id = queryResults.getID();
        IResultIterator it = queryResults.getResultIterator();
        it.close();
        IQueryResults result = this.dataEngine.getQueryResults(id);
        it = result.getResultIterator();
        this.outputQueryResult(it, new String[]{"CITY", "AMOUNT"});
        this.checkOutputFile();
    }
}

