/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.binding;

import com.ibm.icu.util.Calendar;
import org.eclipse.birt.data.engine.api.APITestCase;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.querydefn.Binding;
import org.eclipse.birt.data.engine.api.querydefn.FilterDefinition;
import org.eclipse.birt.data.engine.api.querydefn.GroupDefinition;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.api.querydefn.SortDefinition;
import testutil.ConfigText;

public class AggregationTest
extends APITestCase {
    protected APITestCase.DataSourceInfo getDataSourceInfo() {
        return new APITestCase.DataSourceInfo(ConfigText.getString("Impl.TestData2.TableName"), ConfigText.getString("Impl.TestData2.TableSQL"), ConfigText.getString("Impl.TestData2.TestDataFileName"));
    }

    public void test1() throws Exception {
        QueryDefinition query = this.newReportQuery();
        Calendar c = Calendar.getInstance();
        c.clear();
        GroupDefinition g1 = new GroupDefinition("G1");
        g1.setKeyExpression("row.e1");
        query.addGroup(g1);
        GroupDefinition g2 = new GroupDefinition("G2");
        g2.setKeyExpression("row.e2");
        query.addGroup(g2);
        GroupDefinition g3 = new GroupDefinition("G3");
        g3.setKeyExpression("row.e3");
        g3.setInterval(2);
        g3.setIntervalRange(1.0);
        c.set(2004, 9, 1);
        g3.setIntervalStart((Object)c.getTime());
        query.addGroup(g3);
        SortDefinition sort = new SortDefinition();
        sort.setExpression("row.e3");
        sort.setSortDirection(0);
        query.addSort(sort);
        query.addBinding((IBinding)new Binding("e1", (IBaseExpression)new ScriptExpression("dataSetRow.CITY")));
        query.addBinding((IBinding)new Binding("e2", (IBaseExpression)new ScriptExpression("dataSetRow.STORE")));
        query.addBinding((IBinding)new Binding("e3", (IBaseExpression)new ScriptExpression("dataSetRow.SALE_DATE")));
        query.addBinding((IBinding)new Binding("e4", (IBaseExpression)new ScriptExpression("dataSetRow.SKU")));
        query.addBinding((IBinding)new Binding("e10", (IBaseExpression)new ScriptExpression("dataSetRow.PRICE")));
        query.addBinding((IBinding)new Binding("e11", (IBaseExpression)new ScriptExpression("dataSetRow.QUANTITY")));
        Binding e5 = new Binding("e5");
        e5.setAggrFunction("COUNT");
        e5.addAggregateOn("G1");
        query.addBinding((IBinding)e5);
        Binding e6 = new Binding("e6");
        e6.setAggrFunction("COUNT");
        e6.addAggregateOn("G1");
        query.addBinding((IBinding)e6);
        Binding e7 = new Binding("e7", (IBaseExpression)new ScriptExpression("dataSetRow.PRICE*dataSetRow.QUANTITY"));
        e7.setAggrFunction("SUM");
        e7.addAggregateOn("G3");
        query.addBinding((IBinding)e7);
        Binding e81 = new Binding("e81", (IBaseExpression)new ScriptExpression("dataSetRow.PRICE*dataSetRow.QUANTITY"));
        e81.setAggrFunction("SUM");
        query.addBinding((IBinding)e81);
        Binding e8 = new Binding("e8", (IBaseExpression)new ScriptExpression("dataSetRow.PRICE * dataSetRow.QUANTITY / row.e81"));
        query.addBinding((IBinding)e8);
        Binding e9 = new Binding("e9", (IBaseExpression)new ScriptExpression("dataSetRow.PRICE"));
        e9.setAggrFunction("MOVINGAVE");
        e9.setFilter((IBaseExpression)new ScriptExpression("dataSetRow.QUANTITY>1"));
        e9.addArgument((IBaseExpression)new ScriptExpression("3"));
        query.addBinding((IBinding)e9);
        String[] exprs = new String[]{"e1", "e2", "e3", "e4", "e10", "e11", "e5", "e6", "e7", "e8", "e9"};
        this.outputQueryResult(this.executeQuery((IQueryDefinition)query), exprs);
        this.checkOutputFile();
    }

    public void test11() throws Exception {
        QueryDefinition query = this.newReportQuery();
        Calendar c = Calendar.getInstance();
        c.clear();
        GroupDefinition g1 = new GroupDefinition("G1");
        g1.setKeyExpression("row.e1");
        SortDefinition sortDefn = new SortDefinition();
        sortDefn.setExpression("row.e5");
        sortDefn.setSortDirection(1);
        g1.addSort(sortDefn);
        FilterDefinition filter = new FilterDefinition((IBaseExpression)new ScriptExpression("row.e7 > 100"));
        g1.addFilter((IFilterDefinition)filter);
        query.addGroup(g1);
        GroupDefinition g2 = new GroupDefinition("G2");
        g2.setKeyExpression("row.e2");
        query.addGroup(g2);
        GroupDefinition g3 = new GroupDefinition("G3");
        g3.setKeyExpression("row.e3");
        g3.setInterval(2);
        g3.setIntervalRange(1.0);
        c.set(2004, 9, 1);
        g3.setIntervalStart((Object)c.getTime());
        query.addGroup(g3);
        SortDefinition sort = new SortDefinition();
        sort.setExpression("row.e3");
        sort.setSortDirection(0);
        query.addSort(sort);
        query.addBinding((IBinding)new Binding("e1", (IBaseExpression)new ScriptExpression("dataSetRow.CITY")));
        query.addBinding((IBinding)new Binding("e2", (IBaseExpression)new ScriptExpression("dataSetRow.STORE")));
        query.addBinding((IBinding)new Binding("e3", (IBaseExpression)new ScriptExpression("dataSetRow.SALE_DATE")));
        query.addBinding((IBinding)new Binding("e4", (IBaseExpression)new ScriptExpression("dataSetRow.SKU")));
        query.addBinding((IBinding)new Binding("e10", (IBaseExpression)new ScriptExpression("dataSetRow.PRICE")));
        query.addBinding((IBinding)new Binding("e11", (IBaseExpression)new ScriptExpression("dataSetRow.QUANTITY")));
        Binding e5 = new Binding("e5");
        e5.setAggrFunction("COUNT");
        e5.addAggregateOn("G1");
        query.addBinding((IBinding)e5);
        Binding e6 = new Binding("e6");
        e6.setAggrFunction("COUNT");
        e6.addAggregateOn("G1");
        query.addBinding((IBinding)e6);
        Binding e7 = new Binding("e7", (IBaseExpression)new ScriptExpression("dataSetRow.PRICE*dataSetRow.QUANTITY"));
        e7.setAggrFunction("SUM");
        e7.addAggregateOn("G3");
        query.addBinding((IBinding)e7);
        Binding e81 = new Binding("e81", (IBaseExpression)new ScriptExpression("dataSetRow.PRICE*dataSetRow.QUANTITY"));
        e81.setAggrFunction("SUM");
        query.addBinding((IBinding)e81);
        Binding e8 = new Binding("e8", (IBaseExpression)new ScriptExpression("dataSetRow.PRICE * dataSetRow.QUANTITY / row.e81"));
        query.addBinding((IBinding)e8);
        Binding e9 = new Binding("e9", (IBaseExpression)new ScriptExpression("dataSetRow.PRICE"));
        e9.setAggrFunction("MOVINGAVE");
        e9.setFilter((IBaseExpression)new ScriptExpression("dataSetRow.QUANTITY>1"));
        e9.addArgument((IBaseExpression)new ScriptExpression("3"));
        query.addBinding((IBinding)e9);
        String[] exprs = new String[]{"e1", "e2", "e3", "e4", "e10", "e11", "e5", "e6", "e7", "e8", "e9"};
        this.outputQueryResult(this.executeQuery((IQueryDefinition)query), exprs);
        this.checkOutputFile();
    }

    public void test3() throws Exception {
        QueryDefinition query = this.newReportQuery();
        query.addFilter((IFilterDefinition)new FilterDefinition((IBaseExpression)new ScriptExpression("false")));
        GroupDefinition g1 = new GroupDefinition("G1");
        g1.setKeyExpression("row.e1");
        query.addGroup(g1);
        query.addBinding((IBinding)new Binding("e1", (IBaseExpression)new ScriptExpression("dataSetRow.CITY")));
        Binding e2 = new Binding("e2");
        e2.addAggregateOn("G1");
        e2.setAggrFunction("COUNT");
        query.addBinding((IBinding)e2);
        IResultIterator resultIt = this.executeQuery((IQueryDefinition)query);
        AggregationTest.assertFalse((boolean)resultIt.next());
        AggregationTest.assertEquals((Object)new Integer(0), (Object)resultIt.getValue("e2"));
    }

    public void test5() throws Exception {
        QueryDefinition query = this.newReportQuery();
        GroupDefinition g1 = new GroupDefinition("G1");
        g1.setKeyExpression("row.e0");
        query.addGroup(g1);
        query.addBinding((IBinding)new Binding("e0", (IBaseExpression)new ScriptExpression("dataSetRow.CITY")));
        Binding e1 = new Binding("e1", (IBaseExpression)new ScriptExpression("dataSetRow.PRICE"));
        e1.setAggrFunction("RUNNINGSUM");
        e1.addAggregateOn("G1");
        e1.addArgument((IBaseExpression)new ScriptExpression("abc"));
        query.addBinding((IBinding)e1);
        Binding e2 = new Binding("e2", (IBaseExpression)new ScriptExpression("dataSetRow.PRICE"));
        e2.setAggrFunction("SUM");
        e2.addAggregateOn("G1");
        query.addBinding((IBinding)e2);
        Binding e3 = new Binding("e3", (IBaseExpression)new ScriptExpression("dataSetRow.PRICE"));
        e3.setAggrFunction("RANK");
        e3.addArgument((IBaseExpression)new ScriptExpression("true"));
        e3.addAggregateOn("G1");
        query.addBinding((IBinding)e3);
        Binding e4 = new Binding("e4", (IBaseExpression)new ScriptExpression("dataSetRow.PRICE"));
        e4.setAggrFunction("SUM");
        e4.addArgument((IBaseExpression)new ScriptExpression("a"));
        e4.addAggregateOn("G1");
        query.addBinding((IBinding)e4);
        Binding e5 = new Binding("e5", (IBaseExpression)new ScriptExpression("dataSetRow.PRICE"));
        e5.setAggrFunction("RUNNINGSUM");
        e5.addAggregateOn("G1");
        query.addBinding((IBinding)e5);
        IResultIterator resultIt = this.executeQuery((IQueryDefinition)query);
        String[] exprs = new String[]{"e0", "e1", "e2", "e3", "e4", "e5"};
        this.outputQueryResult(resultIt, exprs);
        this.checkOutputFile();
    }
}

