/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.rd;

import java.io.IOException;
import org.eclipse.birt.core.archive.FileArchiveReader;
import org.eclipse.birt.core.archive.FileArchiveWriter;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.APITestCase;
import org.eclipse.birt.data.engine.api.DataEngine;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IBaseDataSourceDesign;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.querydefn.BaseQueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.GroupDefinition;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import testutil.ConfigText;

public class ReportDocumentTest2
extends APITestCase {
    private FileArchiveWriter archiveWriter;
    private FileArchiveReader archiveReader;
    private String[] rowExprName;
    private String[] totalExprName;
    private String queryResultID;
    private DataEngine myGenDataEngine;
    private DataEngine myPreDataEngine;

    protected APITestCase.DataSourceInfo getDataSourceInfo() {
        return new APITestCase.DataSourceInfo(ConfigText.getString("Api.TestData.TableName"), ConfigText.getString("Api.TestData.TableSQL"), ConfigText.getString("Api.TestData.TestDataFileName"));
    }

    public void testBasic() throws Exception {
        String fileName = ReportDocumentTest2.getOutputFolder() + "testData";
        DataEngineContext deContext1 = this.newContext(1, fileName);
        deContext1.setTmpdir(ReportDocumentTest2.getTempDir());
        this.myGenDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext1);
        this.myGenDataEngine.defineDataSource((IBaseDataSourceDesign)this.dataSource);
        this.myGenDataEngine.defineDataSet((IBaseDataSetDesign)this.dataSet);
        this.genBasic();
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(2, fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        this.preBasic();
        this.closeArchiveReader();
    }

    public void testHasGapRowInResultSet() throws Exception {
        String fileName = ReportDocumentTest2.getOutputFolder() + "testData";
        DataEngineContext deContext1 = this.newContext(1, fileName);
        this.myGenDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext1);
        this.myGenDataEngine.defineDataSource((IBaseDataSourceDesign)this.dataSource);
        this.myGenDataEngine.defineDataSet((IBaseDataSetDesign)this.dataSet);
        this.genHasGapRs();
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(2, fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        this.preBasic();
    }

    private void genHasGapRs() throws BirtException {
        Context context = Context.enter();
        ScriptableObject scope = context.initStandardObjects();
        Context.exit();
        QueryDefinition qd = this.newReportQuery();
        IBaseExpression[] rowBeArray = this.getRowExpr();
        IBaseExpression[] totalBeArray = this.getAggrExpr();
        this.prepareExprNameAndQuery(rowBeArray, totalBeArray, (BaseQueryDefinition)qd);
        IQueryResults qr = this.myGenDataEngine.prepare((IQueryDefinition)qd).execute((Scriptable)scope);
        this.queryResultID = qr.getID();
        IResultIterator ri = qr.getResultIterator();
        ri.next();
        ri.moveTo(3);
        ri.close();
        qr.close();
        this.myGenDataEngine.shutdown();
    }

    public void testSkipToEndWhenUsingDetail() throws Exception {
        String fileName = ReportDocumentTest2.getOutputFolder() + "testData";
        DataEngineContext deContext1 = this.newContext(1, fileName);
        this.myGenDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext1);
        this.myGenDataEngine.defineDataSource((IBaseDataSourceDesign)this.dataSource);
        this.myGenDataEngine.defineDataSet((IBaseDataSetDesign)this.dataSet);
        this.genSkipToEnd(true);
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(2, fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        this.preBasic();
    }

    private void genSkipToEnd(boolean useDetails) throws BirtException {
        Context context = Context.enter();
        ScriptableObject scope = context.initStandardObjects();
        Context.exit();
        QueryDefinition qd = this.newReportQuery();
        qd.setUsesDetails(useDetails);
        GroupDefinition gd = new GroupDefinition();
        String columnBindingNameGroup = "COUNTRY";
        ScriptExpression columnBindingExprGroup = new ScriptExpression("dataSetRow.COUNTRY");
        gd.setKeyColumn("COUNTRY");
        qd.addResultSetExpression(columnBindingNameGroup, (IBaseExpression)columnBindingExprGroup);
        qd.addGroup(gd);
        IBaseExpression[] rowBeArray = this.getRowExpr();
        IBaseExpression[] totalBeArray = this.getAggrExpr();
        this.prepareExprNameAndQuery(rowBeArray, totalBeArray, (BaseQueryDefinition)qd);
        IQueryResults qr = this.myGenDataEngine.prepare((IQueryDefinition)qd).execute((Scriptable)scope);
        this.queryResultID = qr.getID();
        IResultIterator ri = qr.getResultIterator();
        ri.next();
        ri.moveTo(4);
        ri.skipToEnd(1);
        ri.close();
        qr.close();
        this.myGenDataEngine.shutdown();
    }

    private void genBasic() throws Exception {
        Context context = Context.enter();
        ScriptableObject scope = context.initStandardObjects();
        Context.exit();
        QueryDefinition qd = this.newReportQuery();
        IBaseExpression[] rowBeArray = this.getRowExpr();
        IBaseExpression[] totalBeArray = this.getAggrExpr();
        this.prepareExprNameAndQuery(rowBeArray, totalBeArray, (BaseQueryDefinition)qd);
        IQueryResults qr = this.myGenDataEngine.prepare((IQueryDefinition)qd).execute((Scriptable)scope);
        this.queryResultID = qr.getID();
        IResultIterator ri = qr.getResultIterator();
        while (ri.next()) {
            ri.getValue(this.rowExprName[0]);
            ri.getValue(this.totalExprName[0]);
        }
        ri.close();
        qr.close();
        this.myGenDataEngine.shutdown();
    }

    /*
     * Unable to fully structure code
     */
    private void preBasic() throws Exception {
        qr = this.myPreDataEngine.getQueryResults(this.queryResultID);
        if (!ReportDocumentTest2.$assertionsDisabled && qr.getResultMetaData() == null) {
            throw new AssertionError();
        }
        ri = qr.getResultIterator();
        if (ReportDocumentTest2.$assertionsDisabled || ri.getResultMetaData() != null) ** GOTO lbl24
        throw new AssertionError();
lbl-1000:
        // 1 sources

        {
            str = "";
            i = 0;
            while (i < this.rowExprName.length) {
                ob2 = ri.getValue(this.rowExprName[i]);
                if (i != 0) {
                    str = String.valueOf(str) + " ";
                }
                str = String.valueOf(str) + ob2.toString();
                ++i;
            }
            if (this.totalExprName != null) {
                i = 0;
                while (i < this.totalExprName.length) {
                    ob2 = ri.getValue(this.totalExprName[i]);
                    str = String.valueOf(str) + " " + ob2.toString();
                    ++i;
                }
            }
            this.testPrintln(str);
lbl24:
            // 2 sources

            ** while (ri.next())
        }
lbl25:
        // 1 sources

        ri.close();
        this.myPreDataEngine.shutdown();
        this.checkOutputFile();
    }

    private IBaseExpression[] getRowExpr() {
        int num = 4;
        IBaseExpression[] rowBeArray = new IBaseExpression[num];
        rowBeArray[0] = new ScriptExpression("dataSetRow.COUNTRY");
        rowBeArray[1] = new ScriptExpression("dataSetRow.CITY");
        rowBeArray[2] = new ScriptExpression("dataSetRow.SALE_DATE");
        rowBeArray[3] = new ScriptExpression("dataSetRow.AMOUNT");
        this.rowExprName = new String[rowBeArray.length];
        this.rowExprName[0] = "COUNTRY_1";
        this.rowExprName[1] = "CITY_1";
        this.rowExprName[2] = "SALE_NAME_1";
        this.rowExprName[3] = "AMOUNT_1";
        return rowBeArray;
    }

    private IBaseExpression[] getAggrExpr() {
        int num2 = 2;
        IBaseExpression[] totalBeArray = new IBaseExpression[num2];
        totalBeArray[0] = new ScriptExpression("Total.Count( )");
        totalBeArray[1] = new ScriptExpression("Total.Sum( dataSetRow.AMOUNT )");
        this.totalExprName = new String[totalBeArray.length];
        this.totalExprName[0] = "TOTAL_COUNT_1";
        this.totalExprName[1] = "TOTAL_AMOUNT_1";
        return totalBeArray;
    }

    private void prepareExprNameAndQuery(IBaseExpression[] rowBeArray, IBaseExpression[] totalBeArray, BaseQueryDefinition qd) {
        int num = rowBeArray.length;
        int i = 0;
        while (i < num) {
            qd.addResultSetExpression(this.rowExprName[i], rowBeArray[i]);
            ++i;
        }
        if (totalBeArray != null) {
            int num2 = totalBeArray.length;
            int i2 = 0;
            while (i2 < num2) {
                qd.addResultSetExpression(this.totalExprName[i2], totalBeArray[i2]);
                ++i2;
            }
        }
    }

    private DataEngineContext newContext(int type, String fileName) throws BirtException {
        switch (type) {
            case 1: {
                try {
                    this.archiveWriter = new FileArchiveWriter(fileName);
                    this.archiveWriter.initialize();
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(e.getMessage());
                }
                return DataEngineContext.newInstance((int)1, null, null, (IDocArchiveWriter)this.archiveWriter);
            }
            case 2: {
                try {
                    this.archiveReader = new FileArchiveReader(fileName);
                    this.archiveReader.open();
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(e.getMessage());
                }
                return DataEngineContext.newInstance((int)2, null, (IDocArchiveReader)this.archiveReader, null);
            }
        }
        throw new IllegalArgumentException("" + type);
    }

    private void closeArchiveWriter() throws DataException {
        if (this.archiveWriter != null) {
            try {
                this.archiveWriter.finish();
            }
            catch (IOException e) {
                throw new DataException("error", (Throwable)e);
            }
        }
    }

    private void closeArchiveReader() throws DataException {
        if (this.archiveReader != null) {
            try {
                this.archiveReader.close();
            }
            catch (IOException e) {
                throw new DataException("error", (Throwable)e);
            }
        }
    }
}

