/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.odaconsumer;

import java.sql.Date;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.odaconsumer.ParameterHint;
import org.eclipse.birt.data.engine.odaconsumer.PreparedStatement;
import org.eclipse.birt.data.engine.odaconsumer.testutil.OdaTestDriverCase;

public class ParameterInNativeNameTest
extends OdaTestDriverCase {
    public void testSetParameterByNativeName() throws Exception {
        PreparedStatement hostStmt = null;
        try {
            hostStmt = this.getOpenedConnection().prepareStatement(null, "2");
            ParameterInNativeNameTest.assertTrue((hostStmt != null ? 1 : 0) != 0);
            hostStmt.setParameterValue("myParamNativeName1", (Object)"stringValue");
            hostStmt.setParameterValue("myParamNativeName2", (Object)Date.valueOf("2005-11-13"));
            hostStmt.setParameterValue("myParamNativeName3", (Object)Boolean.valueOf("true"));
            boolean execStatus = hostStmt.execute();
            ParameterInNativeNameTest.assertTrue((boolean)execStatus);
        }
        catch (DataException e1) {
            ParameterInNativeNameTest.fail((String)("testSetParameterByNativeName failed: " + e1.toString()));
        }
    }

    public void testSetParameterWithNameInHints() throws Exception {
        PreparedStatement hostStmt = null;
        try {
            hostStmt = this.getOpenedConnection().prepareStatement(null, "2");
            ParameterInNativeNameTest.assertTrue((hostStmt != null ? 1 : 0) != 0);
            ParameterHint hint = new ParameterHint("ParamName1", true, false);
            hint.setNativeName("myParamNativeName1");
            hostStmt.addParameterHint(hint);
            hint = new ParameterHint("ParamName2", true, false);
            hint.setNativeName("myParamNativeName2");
            hostStmt.addParameterHint(hint);
            hint = new ParameterHint("ParamName3", true, false);
            hint.setNativeName("myParamNativeName3");
            hostStmt.addParameterHint(hint);
            hostStmt.setParameterValue("ParamName1", (Object)"stringValue");
            hostStmt.setParameterValue("ParamName2", (Object)Date.valueOf("2005-11-13"));
            hostStmt.setParameterValue("ParamName3", (Object)Boolean.valueOf("true"));
            boolean execStatus = hostStmt.execute();
            ParameterInNativeNameTest.assertTrue((boolean)execStatus);
        }
        catch (DataException e1) {
            ParameterInNativeNameTest.fail((String)("testSetParameterWithNameInHints failed: " + e1.toString()));
        }
    }

    public void testSetParameterWithPositionInHints() throws Exception {
        PreparedStatement hostStmt = null;
        try {
            hostStmt = this.getOpenedConnection().prepareStatement(null, "2");
            ParameterInNativeNameTest.assertTrue((hostStmt != null ? 1 : 0) != 0);
            ParameterHint hint = new ParameterHint("ParamName3", true, false);
            hint.setPosition(3);
            hint.setNativeName("myParamNativeName3");
            hostStmt.addParameterHint(hint);
            hostStmt.setParameterValue("ParamName3", (Object)Boolean.valueOf("true"));
            boolean execStatus = hostStmt.execute();
            ParameterInNativeNameTest.assertTrue((boolean)execStatus);
        }
        catch (DataException e1) {
            ParameterInNativeNameTest.fail((String)("testSetParameterWithPositionInHints failed: " + e1.toString()));
        }
    }
}

