/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.odaconsumer;

import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.odaconsumer.ConnectionTest;
import org.eclipse.birt.data.engine.odaconsumer.PreparedStatement;
import org.eclipse.birt.data.engine.odaconsumer.ResultSet;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.datatools.connectivity.oda.SortSpec;

public class QueryTest
extends ConnectionTest {
    private PreparedStatement m_statement;

    PreparedStatement getStatement() {
        return this.m_statement;
    }

    protected void setUp() throws Exception {
        super.setUp();
        String command = "select * from \"testtable\"";
        this.m_statement = this.getConnection().prepareStatement(command, "org.eclipse.birt.report.data.oda.jdbc.JdbcSelectDataSet");
    }

    protected void tearDown() throws Exception {
        this.m_statement.close();
        super.tearDown();
    }

    public final void testSortSpecMessages() {
        try {
            new SortSpec(100);
            QueryTest.fail();
        }
        catch (IllegalArgumentException ex) {
            QueryTest.assertEquals((String)"Invalid sort mode specified: 100.", (String)ex.getMessage());
        }
    }

    public final void testSetProperty() throws DataException {
        try {
            this.m_statement.setProperty("bad_prop_123", "propValue");
            QueryTest.assertTrue((boolean)false);
        }
        catch (DataException ex) {
            QueryTest.assertTrue((ex.getCause().getMessage().indexOf("bad_prop_123") >= 0 ? 1 : 0) != 0);
        }
    }

    public final void testSetSortSpec() throws DataException {
        try {
            this.m_statement.setSortSpec(null);
            QueryTest.assertTrue((boolean)false);
        }
        catch (DataException ex) {
            QueryTest.assertEquals((String)ex.getErrorCode(), (String)"odaconsumer.CannotSetSortSpec");
            QueryTest.assertEquals((String)"setSortSpec is not supported.", (String)ex.getCause().getMessage());
        }
    }

    private void doTestSetMaxRows(int max, int expected, boolean setMax) throws DataException {
        if (setMax) {
            this.m_statement.setMaxRows(max);
        }
        QueryTest.assertTrue((boolean)this.m_statement.execute());
        ResultSet result = this.m_statement.getResultSet();
        QueryTest.assertNotNull((Object)result);
        int count = 0;
        while (result.fetch() != null) {
            ++count;
        }
        QueryTest.assertEquals((int)expected, (int)count);
    }

    public final void testSetMaxRows0() throws DataException {
        this.doTestSetMaxRows(0, 5, false);
    }

    public final void testSetMaxRows1() throws DataException {
        this.doTestSetMaxRows(2, 2, true);
    }

    public final void testSetMaxRows2() throws DataException {
        this.doTestSetMaxRows(0, 5, true);
    }

    public final void testSetMaxRows3() throws DataException {
        this.doTestSetMaxRows(10, 5, true);
    }

    public final void testGetRSMetaData() throws DataException {
        IResultClass metadata = this.m_statement.getMetaData();
        QueryTest.assertNotNull((Object)metadata);
    }

    public final void testGetMetaDataString() throws DataException {
        try {
            this.m_statement.getMetaData("someResultName");
            QueryTest.assertTrue((boolean)false);
        }
        catch (DataException ex) {
            QueryTest.assertEquals((String)ex.getErrorCode(), (String)"odaconsumer.NamedResultSetsUnsupported");
            QueryTest.assertTrue((boolean)(ex.getCause() instanceof UnsupportedOperationException));
        }
    }

    public final void testExecute0() throws DataException {
        QueryTest.assertTrue((boolean)this.m_statement.execute());
    }

    public final void testExecute1() {
        try {
            String command = "select * from \"testtable\" where \"intColumn\" = ?";
            PreparedStatement stmt = this.getConnection().prepareStatement(command, "org.eclipse.birt.report.data.oda.jdbc.JdbcSelectDataSet");
            stmt.execute();
            QueryTest.assertTrue((boolean)false);
        }
        catch (DataException ex) {
            QueryTest.assertEquals((String)ex.getErrorCode(), (String)"odaconsumer.CannotExecuteStatement");
        }
    }

    public final void testExecute2() throws DataException {
        this.m_statement.execute();
        ResultSet result = this.m_statement.getResultSet();
        QueryTest.assertNotNull((Object)result);
        IResultClass metadata = this.m_statement.getMetaData();
        QueryTest.assertNotNull((Object)metadata);
        IResultClass metadata1 = result.getMetaData();
        QueryTest.assertSame((Object)metadata, (Object)metadata1);
        int count = 0;
        while (result.fetch() != null) {
            ++count;
        }
        QueryTest.assertEquals((int)5, (int)count);
    }

    public final void testGetResultSet() throws DataException {
        QueryTest.assertTrue((boolean)this.m_statement.execute());
        ResultSet result = this.m_statement.getResultSet();
        QueryTest.assertNotNull((Object)result);
    }

    public final void testGetResultSetString() throws DataException {
        try {
            this.m_statement.execute();
            this.m_statement.getResultSet("someResultName");
            QueryTest.assertTrue((boolean)false);
        }
        catch (DataException ex) {
            QueryTest.assertEquals((String)ex.getErrorCode(), (String)"odaconsumer.NamedResultSetsUnsupported");
            QueryTest.assertTrue((boolean)(ex.getCause() instanceof UnsupportedOperationException));
        }
    }

    public final void testFindOutParameter() throws DataException {
        try {
            this.m_statement.findOutParameter("someParamName");
            QueryTest.assertTrue((boolean)false);
        }
        catch (DataException ex) {
            QueryTest.assertEquals((String)ex.getErrorCode(), (String)"odaconsumer.OutputParameterUnsupported");
            QueryTest.assertTrue((boolean)(ex.getCause() instanceof UnsupportedOperationException));
        }
    }

    public final void testGetParameterTypeInt() {
        try {
            this.m_statement.getParameterType(1);
        }
        catch (DataException ex) {
            QueryTest.assertEquals((String)"odaconsumer.CannotGetParameterMetaData", (String)ex.getErrorCode());
        }
    }

    public final void testGetParameterTypeString() throws DataException {
        boolean hasException = false;
        try {
            this.m_statement.getParameterType("someParamName");
        }
        catch (DataException ex) {
            QueryTest.assertEquals((String)ex.getErrorCode(), (String)"odaconsumer.CannotGetParameterType");
            hasException = true;
        }
        QueryTest.assertTrue((boolean)hasException);
    }

    public final void testGetParameterValueInt() throws DataException {
        try {
            QueryTest.assertTrue((boolean)this.m_statement.execute());
            this.m_statement.getParameterValue(1);
            QueryTest.assertTrue((boolean)false);
        }
        catch (DataException ex) {
            QueryTest.assertEquals((String)ex.getErrorCode(), (String)"odaconsumer.OutputParameterUnsupported");
            QueryTest.assertTrue((boolean)(ex.getCause() instanceof UnsupportedOperationException));
        }
    }

    public final void testGetParameterValueString() throws DataException {
        try {
            QueryTest.assertTrue((boolean)this.m_statement.execute());
            this.m_statement.getParameterValue("someParamName");
            QueryTest.assertTrue((boolean)false);
        }
        catch (DataException ex) {
            QueryTest.assertEquals((String)ex.getErrorCode(), (String)"odaconsumer.OutputParameterUnsupported");
            QueryTest.assertTrue((boolean)(ex.getCause() instanceof UnsupportedOperationException));
        }
    }

    public final void testQueryClose() throws DataException {
        this.m_statement.close();
    }
}

